<id>
COPPA Compliance for YaBB 2.5
</id>

<version>
0.1
</version>

<mod info>
Description
-----------
This Mod will allow you to check the age of users on registration and either enable COPPA Compliance or reject registration to users under 13 years old.

Installation
------------
1) Modify YaBB files using BoardMod or manually.
2) Upload modified files to your server in ASCII mode.
3) Upload Coppa.pl, Privacy.pl and privacy.policy to their relevant directories in ASCII mode.

Files to edit
-------------
AdminIndex.pl
Admin/AdminEdit.pl
Admin/AdminSubList.pl
Admin/ManageTemplates.pl
Admin/ModList.pl
Admin/ModuleChecker.pl
Admin/NewSettings.pl
Admin/Settings_Main.pl
Languages/English/Admin.lng
Languages/English/Error.lng
Languages/English/GModPrivileges.lng
Languages/English/Main.lng
Languages/English/Profile.lng
Languages/English/Register.lng
Sources/Profile.pl
Sources/Register.pl
Sources/SubList.pl
Sources/Subs.pl
Sources/System.pl
Templates/default/default.html
Templates/yabb21/yabb21.html

Version History
---------------
V0.1 - First release - 11th April 2012
</mod info>

<author>
Derek Barnstorm
</author>

<homepage>
http://www.boardmod.org
</homepage>

<edit file>
AdminIndex.pl
</edit file>

<search for>
	"modagreement|$admintxt{'a2_sub4'}|$admintxt{'a2_label4'}|",
</search for>

<add after>
	"privacy_policy|$admintxt{'a2_sub6'}|$admintxt{'a2_label6'}|",
</add after>

<edit file>
Admin/AdminEdit.pl
</edit file>

<search for>
sub GmodSettings2 {
</search for>

<add before>
sub ModifyPolicy {
    &is_admin_or_gmod;

    opendir(LNGDIR, $langdir);
    my @lfilesanddirs = readdir(LNGDIR);
    close(LNGDIR);

    my $policylanguage = $FORM{'policylanguage'} || $INFO{'policylanguage'} || $lang;
    foreach my $fld (sort {lc($a) cmp lc($b)} @lfilesanddirs) {
        if (-d "$langdir/$fld" && $fld =~ m^\A[0-9a-zA-Z_\#\%\-\:\+\?\$\&\~\,\@/]+\Z^ && -e "$langdir/$fld/Main.lng") {
            if ($policylanguage eq $fld) { $drawnldirs .= qq~<option value="$fld" selected="selected">$fld</option>~; }
            else { $drawnldirs .= qq~<option value="$fld">$fld</option>~; }
        }
    }

    my ($privacy_policy, $line);
    fopen(POLICY, "$langdir/$policylanguage/privacy.policy");
    while ($line = <POLICY>) {
        $line =~ tr/[\r\n]//d;
        &FromHTML($line);
        $privacy_policy .= qq~$line\n~;
    }
    fclose(POLICY);
    $yymain .= qq~

<div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
<table width="100%" cellspacing="1" cellpadding="4">
  <tr>
    <td align="left" class="titlebg"><img src="$imagesdir/xx.gif" alt="" border="0" /> <b>$admin_txt{'edit_policy'}</b></td>
  </tr>
  <tr>
    <td align="left" class="windowbg2">
      <label for="policy">
      <p>$admin_txt{'edit_policy_1'}</p>
      <p>$admin_txt{'edit_policy_2'}</p>
      <p>
        <ul>
          <li>{forum_url} - $admin_txt{'forum_url'}</li>
          <li>{forum_email} - $admin_txt{'355'}</li>
          <li>{forum_name} - $admin_txt{'350'}</li>
        </ul>
      </p>
      </label>
    </td>
  </tr>
  <tr valign="middle">
    <td align="left" class="windowbg2"><br />
      <form action="$adminurl?action=privacy_policy" method="post" enctype="application/x-www-form-urlencoded">
        <select name="policylanguage" id="policylanguage" size="1">
          $drawnldirs
        </select>
        <input type="submit" value="$admin_txt{'462'}" class="button" />
      </form>
    </td>
  </tr>
  <tr valign="middle">
    <td align="center" class="windowbg2"><br />
      <form action="$adminurl?action=privacy_policy2" method="post" enctype="application/x-www-form-urlencoded">
        <input type="hidden" name="destination" value="$INFO{'destination'}" />
        <input type="hidden" name="policylanguage" value="$policylanguage" />
        <textarea rows="35" cols="95" name="policy" id="policy" style="width:95%">$privacy_policy</textarea><br /><br />
    </td>
  </tr>
  <tr valign="middle">
    <td align="center" class="catbg"><input type="submit" value="$admin_txt{'10'} $policylanguage" class="button" /></td>
  </tr>
      </form>
</table>
</div>
~;
    $yytitle     = "$admin_txt{'edit_policy'}";
    $action_area = "privacy_policy";
    &AdminTemplate;
}

sub ModifyPolicy2 {
    &is_admin_or_gmod;

    if ($FORM{'policylanguage'}) { $policylanguage = $FORM{'policylanguage'}; }
    else { $policylanguage = $lang; }
    $FORM{'policy'} =~ tr/\r//d;
    $FORM{'policy'} =~ s~\A\n+~~;
    $FORM{'policy'} =~ s~\n+\Z~~;
    fopen(POLICY, ">$langdir/$policylanguage/privacy.policy");
    print POLICY $FORM{'policy'};
    fclose(POLICY);

    $FORM{'policy'} =~ s/\n/<br \/>\n/g;

    $yySetLocation = $FORM{'destination'} ? qq~$adminurl?action=$FORM{'destination'}~ : qq~$adminurl?action=privacy_policy;policylanguage=$FORM{'policylanguage'}~;
    &redirectexit;
}

</add before>

<search for>
'modagreement',"$FORM{'modagreement'}",
</search for>

<add after>
'privacy_policy',"$FORM{'privacy_policy'}",
</add after>

<search for>
modagreement2 => "$FORM{'modagreement'}",
</search for>

<add after>
privacy_policy2 => "$FORM{'privacy_policy'}",
</add after>

<edit file>
Admin/AdminSubList.pl
</edit file>

<search for>
'newsettings2',"NewSettings.pl&settings2",
</search for>

<add after>
'privacy_policy',"AdminEdit.pl&ModifyPolicy",
'privacy_policy2',"AdminEdit.pl&ModifyPolicy2",
</add after>

<edit file>
Admin/ManageTemplates.pl
</edit file>

<search for>
	$fulltemplate =~ s/({|<)yabb addtab(}|>)//g;
</search for>

<add after>
	$fulltemplate =~ s/({|<)yabb footer_links(}|>)//g;
</add after>

<edit file>
Admin/ModList.pl
</edit file>

<search for>
### END BOARDMOD ANCHOR ###
</search for>

<add before>
	$coppacompliance_mod = "COPPA Compliance|Derek Barnstorm|This Mod will allow you to check the age of users on registration and either enable COPPA Compliance or reject registration to users under 13 years old.|0.1|11th April 2012";
	push (@installed_mods, "$coppacompliance_mod");
	
</add before>

<edit file>
Admin/ModuleChecker.pl
</edit file>

<search for>
	'integer' => 'Used to send emails via "YaBB SMTP Engine".<br />This module is only needed if you want to send your emails via the "YaBB SMTP Engine". Otherwise you do not need this module.',
</search for>

<add after>
	'Date::Calc' => 'Used for age restrictions on registration.<br />This module is only needed if you enable Coppa Compliance or don\'t allow users under the age of 13 to register. Otherwise you do not need this module.',
</add after>

<search for>
foreach $module qw(Digest::MD5 Time::HiRes Time::Local File::Find CGI Net::SMTP Net::SMTP::TLS Compress::Zlib Compress::Bzip2 Archive::Tar Archive::Zip MIME::Lite LWP::UserAgent HTTP::Request::Common Crypt::SSLeay IO::Socket::INET Digest::HMAC_MD5 Carp bytes integer) {
</search for>

<replace>
foreach $module qw(Digest::MD5 Time::HiRes Time::Local File::Find CGI Net::SMTP Net::SMTP::TLS Compress::Zlib Compress::Bzip2 Archive::Tar Archive::Zip MIME::Lite LWP::UserAgent HTTP::Request::Common Crypt::SSLeay IO::Socket::INET Digest::HMAC_MD5 Carp bytes integer Date::Calc) {
</replace>

<edit file>
Admin/NewSettings.pl
</edit file>

<search for>
							# 2: ask for the birthday, input required
</search for>

<add after>
							# 3: Enable Coppa Compliance
							# 4: Reject registration if under 13 years old
\$coppa_fax = "\Q$coppa_fax\E";	            # Set the fax number for the COPPA compliance form
\$coppa_address = "\Q$coppa_address\E";	    # Set the mailing address for the COPPA compliance form
\$age_cookie = "\Q$age_cookie\E";	        # Set the cookie name for registration age restriction
</add after>

<search for>
\$MenuType = $MenuType;					# 1 for text menu or anything else for images menu
</search for>

<add after>
\$show_policy = $show_policy;			# Set to 1 to show the privacy policy link in footer
\$show_agreement = $show_agreement;		# Set to 1 to show the user agreement link in footer
</add after>

<search for>
\$allow_hide_email = $allow_hide_email;			# Allow users to hide their email from public. Set 0 to disable
</search for>

<add after>
\$allow_hide_age = $allow_hide_age;			    # Allow users to hide their age from public. Set 0 to disable
\$disable_edit_age = $disable_edit_age;			# Set to 1 to disable the ability for users to edit their age after after it has been entered
</add after>

<edit file>
Admin/Settings_Main.pl
</edit file>

<search for>
$imtext =~ s~<br />~\n~g;
</search for>

<add after>
$coppa_address =~ s~<br />~\n~g;
</add after>

<search for>
		{
			header => $settings_txt{'showhide'},
		},
</search for>

<add after>
		{
			description => qq~<label for="show_policy">$admin_txt{'show_policy'}</label>~,
			input_html => qq~<input type="checkbox" name="show_policy" id="show_policy" value="1"${ischecked($show_policy)} />~,
			name => 'show_policy',
			validate => 'boolean',
		},
		{
			description => qq~<label for="show_agreement">$admin_txt{'show_agreement'}</label>~,
			input_html => qq~<input type="checkbox" name="show_agreement" id="show_agreement" value="1"${ischecked($show_agreement)} />~,
			name => 'show_agreement',
			validate => 'boolean',
		},
</add after>

<search for>
			name => 'allow_hide_email',
			validate => 'boolean',
		},
</search for>

<add after>
		{
			description => qq~<label for="allow_hide_age">$admin_txt{'allow_hide_age'}</label>~,
			input_html => qq~<input type="checkbox" name="allow_hide_age" id="allow_hide_age" value="1" ${ischecked($allow_hide_age)}/>~,
			name => 'allow_hide_age',
			validate => 'boolean',
		},
		{
			description => qq~<label for="disable_edit_age">$admin_txt{'disable_edit_age'}</label>~,
			input_html => qq~<input type="checkbox" name="disable_edit_age" id="disable_edit_age" value="1" ${ischecked($disable_edit_age)}/>~,
			name => 'disable_edit_age',
			validate => 'boolean',
		},
</add after>

<search for>
			  <option value="2"${isselected($birthday_on_reg == 2)}>$register_txt{'773'}</option>
</search for>

<add after>
			  <option value="3"${isselected($birthday_on_reg == 3)}>$register_txt{'774'}</option>
			  <option value="4"${isselected($birthday_on_reg == 4)}>$register_txt{'775'}</option>
</add after>

<search for>
			name => 'birthday_on_reg',
			validate => 'number,null',
		},
</search for>

<add after>
		{
			description => qq~<label for="coppa_fax">$register_txt{'coppa_fax'}</label>~,
			input_html => qq~<input type="text" name="coppa_fax" id="coppa_fax" size="20" value="$coppa_fax" />~,
			name => 'coppa_fax',
			validate => 'text,null',
			depends_on => ['birthday_on_reg==3'],
		},
		{
			description => qq~<label for="coppa_address">$register_txt{'coppa_address'}</label>~,
			input_html => qq~<textarea name="coppa_address" id="coppa_address" cols="35" rows="5">$coppa_address</textarea>~,
			name => 'coppa_address',
			validate => 'fulltext,null',
			depends_on => ['birthday_on_reg==3'],
		},
		{
			description => qq~<label for="age_cookie">$register_txt{'age_cookie'}</label>~,
			input_html => qq~<input type="text" name="age_cookie" id="age_cookie" size="20" value="$age_cookie" />~,
			name => 'age_cookie',
			validate => 'text,null',
			depends_on => ['birthday_on_reg==3||', 'birthday_on_reg==4'],
		},
</add after>

<search for>
	my %settings = @_;
</search for>

<add after>

	if ($settings{'birthday_on_reg'} == 3 && (!$settings{'coppa_fax'} && !$settings{'coppa_address'})) {
		&LoadLanguage('Error');
		&admin_fatal_error("coppa_fields_missing");
	}
	
	$settings{'coppa_address'} =~ s~[\n\r]{1,2}~<br />~g;
</add after>

<edit file>
Languages/English/Admin.lng
</edit file>

<search for>
);

%floodtxt = (
</search for>

<add before>
'edit_policy' => 'Edit Privacy Policy',
'edit_policy_1' => 'Here you can edit your forum privacy policy. It is important to note that this is just a template for your convenience, and should be edited as needed to reflect your own website, country\'s laws and forum settings.',
'edit_policy_2' => 'HTML is allowed and you can use the following tags:',
'show_policy' => "Show link to Privacy Policy in footer?<br /><span class=\"small\">Note that you will need to modify the privacy policy to reflect your own website: <a href=\"$adminurl?action=privacy_policy\">Privacy Policy</a></span>",
'show_agreement' => 'Show link to User Agreement in footer?',
'forum_url' => 'Forum URL',
'allow_hide_age' => 'Allow users to hide their age and birthday from public view (except from Administrators)?<br /><span class="small"></span>',
'disable_edit_age' => 'Don\'t allow users to edit their date of birth and change their age after the first time it has been entered?<br /><span class="small"></span>',
</add before>

<search for>
'a2_label5' => 'Edit Global Moderator Access',
</search for>

<add after>
'a2_sub6' => 'Privacy Policy',
'a2_label6' => 'Edit Privacy Policy',
</add after>

<search for>
);

%settings_txt = (
</search for>

<add before>
'Date::Calc' => 'Used for age restrictions on registration.<br />This module is only needed if you enable Coppa Compliance or don\'t allow users under the age of 13 to register. Otherwise you do not need this module.',
</add before>

<edit file>
Languages/English/Error.lng
</edit file>

<search for>
'corrupt_member_file'		=> "The member data file is corrupt. Please notify the administrator of this error!",
</search for>

<add after>
'coppa_fields_missing'		=> "You must enter a fax number or mailing address if COPPA Compliance is enabled.",
</add after>

<search for>
'invalid_birthdate'		=> "Invalid input in one or more of the Birthdate fields.",
</search for>

<add after>
'not_allowed_birthdate_change'	=> "You are not allowed to change your date of birth.",
</add after>

<search for>
'no_reg_reason'			=> "Without giving a reason for applying for membership we cannot process your application.",
</search for>

<add after>
'dob_compliance'      => "Sorry, you must be aged 13 years or above to register on this forum.",
</add after>

<edit file>
Languages/English/GModPrivileges.lng
</edit file>

<search for>
'modagreement' => 'Allow to edit Registration Agreement',
</search for>

<add after>
'privacy_policy' => 'Allow to edit Privacy Policy',
</add after>

<edit file>
Languages/English/Main.lng
</edit file>

<search for>
);

%load_txt = (
</search for>

<add before>
'policy' => 'Privacy Policy',
'agreement' => 'User Agreement',
</add before>

<edit file>
Languages/English/Profile.lng
</edit file>

<search for>
);

%mycenter_profile_txt = (
</search for>

<add before>
'hide_age' => 'Hide your age and birthday from the public?',
'dob_edit' => 'Note that you cannot change your date of birth after it has been entered.',
</add before>

<edit file>
Languages/English/Register.lng
</edit file>

<search for>
'771' => 'don\'t ask',
'772' => 'ask for birthday but input isn\'t required',
'773' => 'ask for birthday and input is required',
</search for>

<replace>
'771' => 'Don\'t ask',
'772' => 'Ask for birthday and input is optional',
'773' => 'Ask for birthday and input is required',
'774' => 'Ask for birthday and enable COPPA Compliance',
'775' => 'Ask for birthday and don\'t allow registration if under 13 years old',
'coppa_fax' => 'Enter your fax number here for the COPPA Compliance form to be sent to:<br /><span class="small">If you have COPPA Compliance selected above, you will need to either enter a fax number here or a mailing address below (or both).</span>',
'coppa_address' => 'Enter your mailing address here for the COPPA Compliance form to be sent to:<br /><span class="small">If you have COPPA Compliance selected above, you will need to either enter a mailing address here or a fax number above (or both).</span>',
'age_cookie' => 'Age Cookie Name:<br /><span class="small">If you enable COPPA Compliance or don\'t allow users to register who are under the age of 13, you can enter a cookie name here to set a cookie if users fail the age check. This will stop users from going back and changing their date of birth.</span>',
'dob' => 'Date of birth',
'dob_enter' => 'Please enter your date of birth',
'dob_edit' => 'Note that you cannot change your date of birth after it has been entered.',
'dob_hide' => 'Check this box if you would like to hide your age and birthday from public view.',
</replace>

<search for>
'wrong_char' => 'This character in the Password is invalid',
</search for>

<add after>
'continue' => 'Continue Registration',
</add after>

<search for>
'error_gender' => 'You must select your gender.',
);
</search for>

<add after>

%coppa_txt = (
'coppa' => 'COPPA Compliance',
'coppa_form' => 'COPPA Compliance Form',
'fax' => 'Fax:',
'address' => 'Address:',
'header_1' => 'Instructions for the Parent or Legal Guardian',
'header_2' => 'Account Details',
'header_3' => 'Parent or Legal Guardian Details',
'header_4' => 'Agreement',
'header_info_1' => 'Please print this form, complete it and return it to us ',
'header_info_1a' => 'by using either the fax number or mailing address below.',
'header_info_1b' => 'by using the fax the number below.',
'header_info_1c' => 'by using the mailing address below.',
'header_info_2' => "These are the registration details for the childs account on $mbname.<br />Once we have received this form we will create the account and notify you at the email address privided here.",
'header_info_2a' => 'Note that the display name should be different from the username.',
'header_info_3' => 'Please fill in the required information and sign the form below.',
'header_info_4' => "By signing this form I confirm that I have read the website Privacy Policy ($scripturl?action=privacy) and I consent to $mbname collecting the necessary information for my child to participate in the community. I have reviewed the information my child has supplied and confirm that is is correct. I understand that the profile information can be changed by logging in with the username and password entered on this form and that I can ask for my child's information to be removed at any time.",
'username' => 'Username:',
'display_name' => 'Display name:',
'email' => 'Email Address:',
'parent_name' => 'Full Name:',
'parent_relation' => 'Relation to child:',
'parent_email' => 'Email Address:',
'parent_number' => 'Phone Number:',
'signature' => 'Signature:',
'date' => 'Date:',
'admin_note' => "Note to the $mbname Administrator: Please remember to create the user account with the above information on receiving this form and notify the user at the email address provided that their account is ready to use.",
'coppa_message_1' => "Sorry, in order to comply with <a href=\"http://www.coppa.org\" target=\"_blank\">COPPA (Children's Online Privacy Protection Act)</a>, users under the age of 13 must get permission off a parent or legal guardian before they can be registered on this forum. Please ask a parent or legal guardian to complete a copy of our <a href=\"$scripturl?action=coppa\" target=\"_blank\">COPPA Compliance Form</a> and return it to us. After recieving the form we will create your account for you and notify you by email at the email address provided when your account is ready to use.",
'coppa_message_2' => 'Click here to print a copy our Coppa Compliance Form',
'coppa_message_3' => 'If you require further information, please contact the',
'coppa_message_4' => 'Thank you,',
'coppa_message_5' => "The $mbname Team",
'coppa_error'  => "Please ask a parent or legal guardian to complete a copy of our <a href=\"$scripturl?action=coppa\" target=\"_blank\">COPPA Compliance form</a> and return it to us.",
'admin_email' => 'Forum Administrator',
'cancel' => 'Cancel',
);
</add after>

<edit file>
Sources/Profile.pl
</edit file>

<search for>
	&CalcAge($user, "parse");
	$dayormonthm = qq~<label for="bday1">$profile_txt{'564'}</label><input type="text" name="bday1" id="bday1" size="2" maxlength="2" value="$umonth" /> ~; 
	$dayormonthd = qq~<label for="bday2">$profile_txt{'565'}</label><input type="text" name="bday2" id="bday2" size="2" maxlength="2" value="$uday" /> ~; 
</search for>

<replace>
	my $disable_age = '';
	my $edit_age_txt = '';
	if (${$uid.$user}{'bday'} && $disable_edit_age && !$iamadmin && (!$iamgmod || !$allow_gmod_profile)) { $disable_age = qq~ style="cursor: not-allowed;" readonly="readonly"~; }
	if ($disable_edit_age && !$iamadmin && (!$iamgmod || !$allow_gmod_profile)) { $edit_age_txt = qq~<br /><span class="small">$profile_txt{'dob_edit'}</span>~; }

	&CalcAge($user, "parse");
	$dayormonthm = qq~<label for="bday1">$profile_txt{'564'}</label><input type="text" name="bday1" id="bday1" size="2" maxlength="2" value="$umonth"$disable_age /> ~; 
	$dayormonthd = qq~<label for="bday2">$profile_txt{'565'}</label><input type="text" name="bday2" id="bday2" size="2" maxlength="2" value="$uday"$disable_age /> ~;
</replace>

<search for>
		<td width="220" align="left"><label for="birthday"><b>$profile_txt{'563'}: </b></label></td>
		<td align="left"><span class="small">$dayormonth<label for="bday3">$profile_txt{'566'}</label><input type="text" name="bday3" id="bday3" size="4" maxlength="4" value="$uyear" /></span></td>
	</tr>
</search for>

<replace>
		<td width="220" align="left"><label for="birthday"><b>$profile_txt{'563'}: </b>$edit_age_txt</label></td>
	    <td align="left"><span class="small">$dayormonth<label for="bday3">$profile_txt{'566'}</label><input type="text" name="bday3" id="bday3" size="4" maxlength="4" value="$uyear"$disable_age /></span></td>
	</tr>~;
    if ($allow_hide_age) {
		my $checked = '';
		if (${$uid.$user}{'hideage'}) { $checked = ' checked="checked"'; }
		$showProfile .= qq~
	<tr class="windowbg">
		<td width="320" align="left"><label for="hide_age"><b>$profile_txt{'hide_age'}</b></label></td>
		<td align="left"><input type="checkbox" name="hide_age" id="hide_age" value="1"$checked /></td>
	</tr>~;
	}
	$showProfile .= qq~
</replace>

<search for>
			&fatal_error("password_is_userid") if ($member{'username'} eq $member{'passwrd1'});
		}
</search for>

<add after>

        if (${$uid.$user}{'bday'} && $disable_edit_age && !$iamadmin && (!$iamgmod || !$allow_gmod_profile)) {
           ($user_birth_month, $user_birth_day, $user_birth_year) = split(/\//, ${$uid.$user}{'bday'});
            &fatal_error("not_allowed_birthdate_change") if ($member{'bday1'} != $user_birth_month || $member{'bday2'} != $user_birth_day || $member{'bday3'} != $user_birth_year);
        }
</add after>

<search for>
		${$uid.$user}{'bday'} = $member{'bday'};
</search for>

<add after>
		${$uid.$user}{'hideage'} = $member{'hide_age'} ? 1 : 0;
</add after>

<search for>
	if ($age) {
</search for>

<replace>
	if ($age && (!${$uid.$user}{'hideage'} || $iamadmin || !$allow_hide_age)) {
</replace>

<edit file>
Sources/Register.pl
</edit file>

<search for>
sub Register {
</search for>

<add before>
sub AgeCheck {

    use Date::Calc qw( Today leap_year Delta_Days );
    
    $user_birth_year  = $FORM{'birth_year'};
    $user_birth_month = $FORM{'birth_month'};
    $user_birth_day   = $FORM{'birth_day'};
    
    $user_birth_month =~ s/\D//g;
    $user_birth_day   =~ s/\D//g;
    $user_birth_year  =~ s/\D//g;
    
    &timetostring($date);
    
    &fatal_error("",$register_txt{'error_birth_month'}) if length($user_birth_month) < 2 || $user_birth_month < 1 || $user_birth_month > 12;
    &fatal_error("",$register_txt{'error_birth_day'}) if length($user_birth_day) < 2 || $user_birth_day < 1 || $user_birth_day > 31;
    &fatal_error("",$register_txt{'error_birth_year'}) if length($user_birth_year) < 4;
    &fatal_error("",$register_txt{'error_birth_year_real'}) if $user_birth_year < ($year - 120) || $user_birth_year > $year;
    
    ($this_year,$this_month,$this_day) = Today([$gmt]);
    
    if (($user_birth_day == 29) && ($user_birth_month == 2) && !leap_year($this_year)) { $user_birth_day--; }
	
    if ((($this_year - $user_birth_year) >  13) || ((($this_year - $user_birth_year) == 13) && (Delta_Days($this_year,$user_birth_month,$user_birth_day, $this_year,$this_month,$this_day) >= 0))) {
        return;
    } else {
        if ($age_cookie ne '') {
            $yySetCookies1 = &write_cookie(
                -name    => $age_cookie,
                -value   => 'age-check',
                -expires => '+43200m');
        }
        if ($birthday_on_reg == 3) {
            $yytitle = qq~$register_txt{'97'} - $coppa_txt{'coppa'}~;
            $yynavigation = qq~&rsaquo; $register_txt{'97'}~;
            $admin_email = &enc_eMail($coppa_txt{'admin_email'},$webmaster_email,$coppa_txt{'coppa'},'');
            $yymain .= qq~
<table border="0" width="100%" cellpadding="4" cellspacing="1" class="bordercolor" style="margin: 0 auto;">
  <tr>
    <td class="titlebg">
      <img src="$imagesdir/xx.gif" alt="" border="0" style="vertical-align: middle;"/> $coppa_txt{'coppa'}
    </td>
  </tr>
  <tr>
    <td class="windowbg">
      <p>$coppa_txt{'coppa_message_1'}</p>
      <p><a style="font-weight: bold;" href="$scripturl?action=coppa" target=_blank">$coppa_txt{'coppa_message_2'}</a></p>
      <p>$coppa_txt{'coppa_message_3'} $admin_email.</p>
      <p>$coppa_txt{'coppa_message_4'}</p>
      <p>$coppa_txt{'coppa_message_5'}</p>
    </td>
  </tr>
  <tr>
    <td class="windowbg2" style="text-align: center;">
      <input type="button" class="button" value="$coppa_txt{'cancel'}" onclick="location.href='$scripturl';" />
    </td>
  </tr>
</table>~;
            &template;
            exit;		
        } elsif ($birthday_on_reg == 4) { 
            $yynavigation = qq~&rsaquo; $register_txt{'97'}~;
            &fatal_error("dob_compliance"); 
        }
    }

}

</add before>

<search for>
	if ($regtype == 0 && $iamguest) { &fatal_error("registration_disabled"); }
</search for>

<add after>
	if (!$iamguest) { &fatal_error("no_registration_logged_in"); }
	if (($birthday_on_reg == 3 || $birthday_on_reg == 4) && $FORM{'dob_compliance'}) { &AgeCheck; }
	if ($FORM{'regnoagree'}) { 
	    $yySetLocation = qq~$scripturl~;
	    &redirectexit;
	}
	if ($age_cookie && $yyCookies{$age_cookie} eq 'age-check') { 
	    if ($birthday_on_reg == 3) { &fatal_error("dob_compliance",$coppa_txt{'coppa_error'}); }
	    elsif ($birthday_on_reg == 4) { &fatal_error("dob_compliance"); }
    }
	if (($birthday_on_reg == 3 || $birthday_on_reg == 4) && !$FORM{'dob_compliance'} && (!$RegAgree || ($RegAgree && !$FORM{'regagree'}))) {
        $yytitle = qq~$register_txt{'97'} - $register_txt{'dob'}~;
	    $yynavigation = qq~&rsaquo; $register_txt{'97'}~;
		&timetostring($date);
		$edit_age_txt = '';
		if ($disable_edit_age) { $edit_age_txt = qq~<br />$register_txt{'dob_edit'}~; }
		$yymain .= qq~
<form action="$scripturl?action=register" method="post" name="birth_date" onsubmit="return CheckAgeFields();">
<table border="0" width="100%" cellpadding="4" cellspacing="1" class="bordercolor" style="margin: 0 auto;">
  <tr>
    <td class="titlebg">
      <img src="$imagesdir/xx.gif" alt="" border="0" style="vertical-align: middle;" /> $register_txt{'dob'}
    </td>
  </tr>
  <tr>
    <td class="windowbg">
      <table border="0" cellpadding="4" cellspacing="1" class="bordercolor" style="margin: 0 auto; width: 400px;">
        <tr>
          <td class="windowbg" valign="top">~;
    if ($timeselected =~ /[145]/) {
        $age_focus = qq~document.birth_date.birth_month.focus();~;
        $yymain .= qq~
            <label for="birth_month"><b>$register_txt{'dob_enter'}:</b></label>
          </td>
        </tr>
        <tr>
          <td class="windowbg2" align="left" valign="top">
            <input type="text" name="birth_month" id="birth_month" size="2" maxlength="2" onkeypress="jumpatnext('document.birth_date.birth_month','document.birth_date.birth_day',2)" /> <input type="text" name="birth_day" id="birth_day" size="2" maxlength="2" onkeypress="jumpatnext('document.birth_date.birth_day','document.birth_date.birth_year',2)" /> <input type="text" name="birth_year" id="birth_year" size="4" maxlength="4" />~ . ($birthday_on_reg == 2 ? ' *' : '') . qq~ <span class="small">$register_txt{'birthday_a'}$edit_age_txt</span>
          </td>
        </tr>~;
    } else {
        $age_focus = qq~document.birth_date.birth_day.focus();~;
        $yymain .= qq~
            <label for="birth_day"><b>$register_txt{'dob_enter'}:</b></label>
          </td>
        </tr>
        <tr>
          <td class="windowbg2 small" align="left" valign="top">
            <input type="text" name="birth_day" id="birth_day" size="2" maxlength="2" onkeypress="jumpatnext('document.birth_date.birth_day','document.birth_date.birth_month',2)" /> <input type="text" name="birth_month" id="birth_month" size="2" maxlength="2" onkeypress="jumpatnext('document.birth_date.birth_month','document.birth_date.birth_year',2)" /> <input type="text" name="birth_year" id="birth_year" size="4" maxlength="4" />~ . ($birthday_on_reg == 2 ? ' *' : '') . qq~ <span class="small">$register_txt{'birthday_b'}$edit_age_txt</span>
          </td>
        </tr>~;	
    }
    if ($allow_hide_age) {
        $yymain .= qq~
        <tr>
          <td class="windowbg2 small">
            <input type="checkbox" name="hide_age" id="hide_age" value="1" /> <label for="hide_age">$register_txt{'dob_hide'}</label>
          </td>
        </tr>~;
    }
    $yymain .= qq~
        <tr>
          <td class="windowbg2" align="center">
            <input type="submit" value="$register_txt{'continue'}" name="dob_compliance" class="button" />
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
</form>
<script type="text/javascript" language="JavaScript">
<!--

    $age_focus
 
    function CheckAgeFields() {
        if ((document.birth_date.birth_day.value.length < 2 || document.birth_date.birth_day.value < 1 || document.birth_date.birth_day.value > 31 || /\\D/.test(document.birth_date.birth_day.value))) {
            alert("$register_txt{'error_birth_day'}");
            document.birth_date.birth_day.focus();
            return false;
        } 
        if ((document.birth_date.birth_month.value.length < 2 || document.birth_date.birth_month.value < 1 || document.birth_date.birth_month.value > 12 || /\\D/.test(document.birth_date.birth_month.value))) {
            alert("$register_txt{'error_birth_month'}");
            document.birth_date.birth_month.focus();
            return false;
        }
        if ((document.birth_date.birth_year.value.length < 4 || /\\D/.test(document.birth_date.birth_year.value))) {
            alert("$register_txt{'error_birth_year'}");
            document.birth_date.birth_year.focus();
            return false;
        }
        if ((document.birth_date.birth_year.value < ($year - 120) || document.birth_date.birth_year.value > $year)) {
            alert("$register_txt{'error_birth_year_real'}");
            document.birth_date.birth_year.focus();
            return false;
        }
        return true;
    }
    
    function jumpatnext(from,to,length) {
        window.setTimeout('if (' + from + '.value.length == ' + length + ') ' + to + '.focus();', 1);
    }
	
//-->
</script>~;
	
    &template;
    exit;
    }	
	
    if ($RegAgree && !$FORM{'regagree'}) {
        $yytitle = qq~$register_txt{'97'} - $register_txt{'764a'}~;
        $yynavigation = qq~&rsaquo; $register_txt{'97'}~;
        if (($birthday_on_reg == 3 || $birthday_on_reg == 4) && $FORM{'dob_compliance'}) {
            $birthday_fields = qq~<input type="hidden" name="birth_day" value="$FORM{'birth_day'}" />
      <input type="hidden" name="birth_month" value="$FORM{'birth_month'}" />
      <input type="hidden" name="birth_year" value="$FORM{'birth_year'}" />~;
        } else {
            $birthday_fields = '';
        }
        if ($allow_hide_age) { $hide_age_field = qq~<input type="hidden" name="hide_age" value="$FORM{'hide_age'}" />~; }
        else { $hide_age_field = ''; }
        if ($language) {
            fopen(AGREE, "$langdir/$language/agreement.txt");
        } else {
            fopen(AGREE, "$langdir/$lang/agreement.txt");
        }
        @agreement = <AGREE>;
        fclose(AGREE);
        $fullagree = join("", @agreement);
        $fullagree =~ s/\n/<br \/>/g;
        $yymain .= qq~
<form action="$scripturl?action=register" method="post">
<table border="0" width="100%" cellpadding="4" cellspacing="1" class="bordercolor" style="margin: 0 auto;">
  <tr>
    <td class="titlebg">
      <img src="$imagesdir/xx.gif" alt="" border="0" style="vertical-align: middle;" /> $register_txt{'764a'}
    </td>
  </tr>
  <tr>
    <td class="windowbg">
      $fullagree
    </td>
  </tr>
  <tr>
    <td class="windowbg2" style="text-align: center;">
      <input type="submit" value="$register_txt{'585'}" name="regagree" class="button" />&nbsp;&nbsp;<input type="submit" value="$register_txt{'586'}" name="regnoagree" class="button" />
      $birthday_fields
      $hide_age_field
    </td>
  </tr>
</table>
</form>~;
    &template;
    exit;
    }
</add after>

<search for>
	if (!$langopt) { &guestLangSel; }

	if (!$iamguest) { &fatal_error("no_registration_logged_in"); }
</search for>

<replace>
	if (!$langopt) { &guestLangSel; }

	# if (!$iamguest) { &fatal_error("no_registration_logged_in"); } Moved by the COPPA Compliance Mod
</replace>

<search for>
	$yytitle = $register_txt{'97'};
</search for>

<replace>
	$yytitle = qq~$register_txt{'97'} - $register_txt{'517'}~;
</replace>

<search for>
<form action="$scripturl?action=register2" method="post" name="creator" onsubmit="return CheckRegFields();">
</search for>

<replace>
<form action="$scripturl?action=register2" method="post" name="creator" onsubmit="return CheckRegFields();">~;
    if ($birthday_on_reg == 3 || $birthday_on_reg == 4) {
        $yymain .= qq~
  <input type="hidden" name="birth_day" value="$FORM{'birth_day'}" />
  <input type="hidden" name="birth_month" value="$FORM{'birth_month'}" />
  <input type="hidden" name="birth_year" value="$FORM{'birth_year'}" />~;
    } 
    if ($allow_hide_age) { 
        $yymain .= qq~
  <input type="hidden" name="hide_age" value="$FORM{'hide_age'}" />~; 
    }
    if ($RegAgree && $FORM{'regagree'}) {
        $yymain .= qq~
  <input type="hidden" name="regagree" value="yes" />~;
    }
        $yymain .= qq~
</replace>

<search for>
			<img src="$imagesdir/register.gif" alt="$register_txt{'97'}" title="$register_txt{'97'}" border="0" />
			<span class="text1"><b>$register_txt{'97'}</b> $register_txt{'517'}</span>
</search for>

<replace>
			<img src="$imagesdir/register.gif" alt="$register_txt{'97'}" title="$register_txt{'97'}" border="0" style="vertical-align: middle;" /> $register_txt{'517'}
</replace>

<search for>
	if ($birthday_on_reg) {
		&timetostring($date);
</search for>

<replace>
	if ($birthday_on_reg == 1 || $birthday_on_reg == 2) {
		&timetostring($date);
        $edit_age_txt = '';
        if ($disable_edit_age) { $edit_age_txt = qq~<br />$register_txt{'dob_edit'}~; }
</replace>

<search for>
		<td class="windowbg2" align="left" valign="top"><input type="text" name="birth_month" id="birth_month" size="2" value="$birthdate[1]" maxlength="2" onkeypress="jumpatnext('document.creator.birth_month','document.creator.birth_day',2)" /> <input type="text" name="birth_day" id="birth_day" size="2" value="$birthdate[0]" maxlength="2" onkeypress="jumpatnext('document.creator.birth_day','document.creator.birth_year',2)" /> <input type="text" name="birth_year" id="birth_year" size="4" value="$birthdate[2]" maxlength="4" />~ . ($birthday_on_reg == 2 ? ' *' : '') . qq~ <span class="small">$register_txt{'birthday_a'}</span>~;
</search for>

<replace>
		<td class="windowbg2" align="left" valign="top"><input type="text" name="birth_month" id="birth_month" size="2" value="$birthdate[1]" maxlength="2" onkeypress="jumpatnext('document.creator.birth_month','document.creator.birth_day',2)" /> <input type="text" name="birth_day" id="birth_day" size="2" value="$birthdate[0]" maxlength="2" onkeypress="jumpatnext('document.creator.birth_day','document.creator.birth_year',2)" /> <input type="text" name="birth_year" id="birth_year" size="4" value="$birthdate[2]" maxlength="4" />~ . ($birthday_on_reg == 2 ? ' *' : '') . qq~ <span class="small">$register_txt{'birthday_a'}$edit_age_txt</span>~;
</replace>

<search for>
		<td class="windowbg2" align="left" valign="top"><input type="text" name="birth_day" id="birth_day" size="2" value="$birthdate[0]" maxlength="2" onkeypress="jumpatnext('document.creator.birth_day','document.creator.birth_month',2)" /> <input type="text" name="birth_month" id="birth_month" size="2" value="$birthdate[1]" maxlength="2" onkeypress="jumpatnext('document.creator.birth_month','document.creator.birth_year',2)" /> <input type="text" name="birth_year" id="birth_year" size="4" value="$birthdate[2]" maxlength="4" />~ . ($birthday_on_reg == 2 ? ' *' : '') . qq~ <span class="small">$register_txt{'birthday_b'}</span>~;
</search for>

<replace>
		<td class="windowbg2" align="left" valign="top"><input type="text" name="birth_day" id="birth_day" size="2" value="$birthdate[0]" maxlength="2" onkeypress="jumpatnext('document.creator.birth_day','document.creator.birth_month',2)" /> <input type="text" name="birth_month" id="birth_month" size="2" value="$birthdate[1]" maxlength="2" onkeypress="jumpatnext('document.creator.birth_month','document.creator.birth_year',2)" /> <input type="text" name="birth_year" id="birth_year" size="4" value="$birthdate[2]" maxlength="4" />~ . ($birthday_on_reg == 2 ? ' *' : '') . qq~ <span class="small">$register_txt{'birthday_b'}$edit_age_txt</span>~;
</replace>

<search for>
	if ($RegAgree) {
		if ($language) {
			fopen(AGREE, "$langdir/$language/agreement.txt");
		} else {
			fopen(AGREE, "$langdir/$lang/agreement.txt");
		}
		@agreement = <AGREE>;
		fclose(AGREE);
		$fullagree = join("", @agreement);
		$fullagree =~ s/\n/<br \/>/g;
		$yymain .= qq~
	<tr>
		<td colspan="2" class="titlebg">
			<img src="$imagesdir/xx.gif" alt="$register_txt{'764a'}" title="$register_txt{'764a'}" border="0" /> <b>$register_txt{'764a'}</b>
		</td>
	</tr>
	<tr>
		<td colspan="2" class="windowbg">
			<label for="regagree"><span style="float: left; padding: 5px;">$fullagree</span></label>
		</td>
	</tr>
	<tr>
		<td colspan="2" class="windowbg2" align="center">
			<label for="regagree"><b>$register_txt{'585'}</b></label> <input type="radio" name="regagree" id="regagree" value="yes" /> * &nbsp;&nbsp; <label for="regnoagree"><b>$register_txt{'586'}</b></label> <input type="radio" name="regagree" id="regnoagree" value="no" />
		</td>
	</tr>~;
	}
</search for>

<replace>
    # Reg Agreement moved by the COPPA Compliance Mod
    
</replace>

<search for>
		($birthday_on_reg ? qq~
</search for>

<replace>
		($birthday_on_reg == 1 || $birthday_on_reg == 2 ? qq~
</replace>

<search for>
			${$uid.$reguser}{'bday'} = "$member{'birth_month'}/$member{'birth_day'}/$member{'birth_year'}";
		}
</search for>

<replace>
			${$uid.$reguser}{'bday'} = "$member{'birth_month'}/$member{'birth_day'}/$member{'birth_year'}";
		} elsif ($birthday_on_reg == 3 || $birthday_on_reg == 4) {
		    &AgeCheck;
		    ${$uid.$reguser}{'bday'} = "$member{'birth_month'}/$member{'birth_day'}/$member{'birth_year'}";
		}
</replace>

<search for>
	${$uid.$reguser}{'pageindex'} = qq~1|1|1|1~;
</search for>

<add after>
	${$uid.$reguser}{'hideage'} = $member{'hide_age'} ? 1 : 0;
</add after>

<edit file>
Sources/SubList.pl
</edit file>

<search for>
'addtab2',"AdvancedTabs.pl&AddNewTab2",
</search for>

<add after>
'agreement',"Privacy.pl&UserAgreement",
</add after>

<search for>
'collapse_cat',"BoardIndex.pl&Collapse_Cat",
</search for>

<add after>
'coppa',"Coppa.pl&Coppa",
</add after>

<search for>
'print',"Printpage.pl&Print",
</search for>

<add after>
'privacy',"Privacy.pl&Policy",
</add after>

<edit file>
Sources/Subs.pl
</edit file>

<search for>
<script language="JavaScript1.2" type="text/javascript" src="$yyhtml_root/YaBB.js"></script>
~;
</search for>

<add after>

    $yyfooter_links = '';
    if ($show_policy || $show_agreement) { $yyfooter_links .= qq~<br />~; }
    if ($show_policy) { $yyfooter_links .= qq~<a href="$scripturl?action=privacy">$maintxt{'policy'}</a>~; }
    if ($show_policy && $show_agreement) { $yyfooter_links .= qq~ | ~; }
    if ($show_agreement) { $yyfooter_links .= qq~<a href="$scripturl?action=agreement">$maintxt{'agreement'}</a>~; }
</add after>

<edit file>
Sources/System.pl
</edit file>

<search for>
	if ($extendedprofiles) {
		require "$sourcedir/ExtendedProfiles.pl";
		push(@tags, &ext_get_fields_array());
	}
</search for>

<add before>
	push(@tags, "hideage");
</add before>

<edit file>
Templates/default/default.html
</edit file>

<search for>
{yabb copyright}<br />{yabb freespace}<br />
</search for>

<replace>
{yabb copyright}<span class="small">{yabb footer_links}</span><br />{yabb freespace}<br />
</replace>

<edit file>
Templates/yabb21/yabb21.html
</edit file>

<search for>
<yabb copyright><br /><yabb freespace><br />
</search for>

<replace>
<yabb copyright><span class="small"><yabb footer_links></span><br /><yabb freespace><br />
</replace>




