###############################################################################
# Coppa.pl                                                                    #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.5 Anniversary Edition                                #
# Packaged:       July 04, 2010                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2010 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$coppaplver = 'YaBB 2.5 AE $Revision: 0.1 $';
if ($action eq 'detailedversion') { return 1; }

&LoadLanguage('Register');

sub Coppa {

    &fatal_error("not_allowed") if $birthday_on_reg != 3;

    if ($coppa_fax) { $coppa_contact = qq~<div class="contact-details">$coppa_txt{'fax'}</div>\n        <div class="fax">$coppa_fax</div>\n~; }
    if ($coppa_address) { $coppa_contact .= qq~        <div class="contact-details">$coppa_txt{'address'}</div>\n        <address>$coppa_address</address>~; }
    if ($name_cannot_be_userid) { $name_text = qq~<br />$coppa_txt{'header_info_2a'}~; }
    $mailing_txt = qq~$coppa_txt{'header_info_1'}~;
    if ($coppa_fax && $coppa_address) { $mailing_txt .= qq~$coppa_txt{'header_info_1a'}~; }
    elsif ($coppa_fax) { $mailing_txt .= qq~$coppa_txt{'header_info_1b'}~; }
    elsif ($coppa_address) { $mailing_txt .= qq~$coppa_txt{'header_info_1c'}~; }
    
	$output = qq~<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>$mbname - $coppa_txt{'coppa_form'}</title>
<meta http-equiv="Content-Type" content="text/html; charset=$yycharset" />
<style type="text/css">
    body { font-family: Verdana, Arial, sans-serif; font-size: 11px; }
    body p { font-size: 9px; }
    h1, h2, h3 { margin: 0px; }
    h1 { font-size: 25px; }
    h2 { color: #ccc; }
    h3 { font-size: 16px; text-decoration: underline; }
    label, input, address, .fax, .contact-details { margin: 5px 0px 10px 0px; }
    input { border: 0px; border-bottom: 1px solid #000; width: 350px; background-color: #fff; }
    address, label, .fax, .contact-details { float: left; }
    label, .contact-details { font-weight: bold; width: 140px; }
    .details, hr, label, .contact-details { clear: left; }
    .details p { font-size: 10px; text-align: justify; margin: 5px 0px 5px 0px; }
    .details div { white-space: nowrap; }
</style>
</head>
<body>
    <h1>$mbname</h1>
    <h2>$coppa_txt{'coppa_form'}</h2>
    <span class="small" style="font-weight: bold;">$scripturl</span>
    <hr />
    <div class="details">
        <h3>$coppa_txt{'header_1'}</h3>
        <p>$mailing_txt</p>
        $coppa_contact
        <hr />
        <h3>$coppa_txt{'header_2'}</h3>
        <p>$coppa_txt{'header_info_2'}$name_text</p>
        <div>
            <label>$coppa_txt{'username'}</label> <input type="text" disabled="disabled" /><br />
            <label>$coppa_txt{'display_name'}</label> <input type="text" disabled="disabled" /><br />
            <label>$coppa_txt{'email'}</label> <input type="text" disabled="disabled" />
        </div>
        <hr />
        <h3>$coppa_txt{'header_3'}</h3>
        <p>$coppa_txt{'header_info_3'}</p>
        <div>
            <label>$coppa_txt{'parent_name'}</label> <input type="text" disabled="disabled" /><br />
            <label>$coppa_txt{'parent_relation'}</label> <input type="text" disabled="disabled" /><br />
            <label>$coppa_txt{'email'}</label> <input type="text" disabled="disabled" /><br />
            <label>$coppa_txt{'parent_number'}</label> <input type="text" disabled="disabled" />
        </div>
        <hr />
        <h3>$coppa_txt{'header_4'}</h3>
        <p>$coppa_txt{'header_info_4'}</p>
        <div>
            <label>$coppa_txt{'signature'}</label> <input type="text" disabled="disabled" /><br />
            <label>$coppa_txt{'date'}</label> <input type="text" disabled="disabled" />
        </div>
    </div>
    <hr /> 
    <p>$coppa_txt{'admin_note'}</p>
</body>
</html>~;

	&print_output_header;
	&print_HTML_output_and_finish;
	
}

1;