###############################################################################
# ThreadCounter.pl                                                            #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Software Version: YaBB 1 Gold - SP1.3.1                                     #
# Released: January 2004                                                      #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
#-----------------------------------------------------------------------------#
#	ThreadCounter Script by Daniel Alm										  #
#	Daniel.Alm@ForumD.net		   											  #
###############################################################################

$ThreadCounterplver = "SP 1.3.1 - 1.0";

sub DisableCounter {
	&is_admin;
		
	$forum = $INFO{'forum'};
	fopen(FILE, ">$boardsdir/$forum.cou");
	fclose(FILE);
	require "$sourcedir/ManageBoards.pl";
	&ManageBoards;
}

sub EnableCounter {
	&is_admin;
		
	$forum = $INFO{'forum'};
	unlink("$boardsdir/$forum.cou");
	require "$sourcedir/ManageBoards.pl";
	&ManageBoards;
}

sub RecountMemberThreads {
	&is_admin;

	&RemoveMemberCountLogByHand;
	fopen(FILE, "$memberdir/memberlist.txt") || &fatal_error("$boardcount{'1'}: memberlist.txt");
	@memberlist = <FILE>;
	fclose(FILE);
	foreach $currentmemname (@memberlist) {
		$currentmemname =~ s/[\n\r]//g;
		if ($currentmemname ne "") {
			fopen(FILE, "$memberdir/$currentmemname.dat") || &fatal_error("$boardcount{'1'}: $currentmemname.dat");
			@userprofile = <FILE>;
			fclose(FILE);
			chomp $userprofile[6];
			$userprofile[6]= "0";
			$userprofile[6] .= "\n";
			fopen(FILE, ">$memberdir/$currentmemname.dat", 1);
			print FILE @userprofile;
			fclose(FILE);
		}
	}

	# Open the file with all categories
	fopen(FILE, "$vardir/cat.txt");
	@categories = <FILE>;
	fclose(FILE);
	foreach $curcat (@categories) {
		chomp $curcat;
		fopen(FILE, "$boardsdir/$curcat.cat") || &fatal_error("$boardcount{'1'}: $curcat.cat");
		@catboards = <FILE>;
		fclose(FILE);
			foreach $curboard (@catboards) {
				$curboard =~ s/[\n\r]//g;
				if ( $curboard ne "") {
					if (-e("$boardsdir/$curboard.txt") && !-e("$boardsdir/$curboard.cou")) {
						fopen(FILE, "$boardsdir/$curboard.txt") || &fatal_error("$boardcount{'1'}: $curboard.txt");
						@threadlist = <FILE>;
						fclose(FILE);
							foreach( @threadlist ) {
								($mnum, $msub, $mname, $memail, $mdate, $mreplies, $musername, $micon, $mstate) = split( /\|/, $_ );
								if ( $mnum ne "") {
									fopen (FILE, "$datadir/$mnum.txt") || &fatal_error("$boardcount{'1'}: $mnum.txt");
									@messages= <FILE>;
									fclose(FILE);
									foreach $message (@messages) {
										($msub2, $m1name, $memail2, $mdate2, $musername2, $micon2, $mattach, $mip, $postmessage, $ns, $mlm, $mlmb) = split(/[\|]/, $message);
										$musername2 =~ s/[\n\r]//g;	
										if (-e("$memberdir/$musername2.dat")) {
												$logfile2 .= qq~$mnum|$curcat|$curboard|$musername2\n~;
										}
									}
								}
							}
					}
				}
			}
	}
	fopen(LOGFILE, ">$vardir/ReCountLog.txt", 1);
	print LOGFILE qq~$logfile2~;
	fclose(LOGFILE);
	
	fopen(LOGFILE, "$vardir/ReCountLog.txt");
	@loggedcounts = <LOGFILE>;
	fclose(LOGFILE);
	
	foreach $loggedcount (@loggedcounts) {
		($threadid, $cat, $board, $user) = split(/\|/, $loggedcount);
		$user =~ s/[\n\r]//g;
		fopen(FILE, "$memberdir/$user.dat") || &fatal_error("$boardcount{'1'}: $user.dat");
		@userprofile2 = <FILE>;
		fclose(FILE);
		chomp $userprofile2[6];
		++$userprofile2[6];
		$userprofile2[6] .= "\n";
		fopen(FILE, ">$memberdir/$user.dat", 1);
		print FILE @userprofile2;
		fclose(FILE);
	}
	
	require "$sourcedir/Admin.pl";
	&Admin;
}

sub ShowMemberCountLog {
	&is_admin;
	
	$logtotal = "0";
	
	fopen(LOGFILE, "$vardir/ReCountLog.txt");
	@loggedcounts = <LOGFILE>;
	fclose(LOGFILE);
	
	$yymain= qq~
	
	<table border="0" width="90%" cellpadding="0" cellspacing="0" align="CENTER">
		<tr>
			<td class="catbg" bgcolor="#40454C"><font size=2>$boardcount{'5'}</font></td>
			<td class="catbg" bgcolor="#40454C"><font size=2>$boardcount{'6'}</font></td>
			<td class="catbg" bgcolor="#40454C"><font size=2>$boardcount{'7'}</font></td>
			<td class="catbg" bgcolor="#40454C"><font size=2>$boardcount{'8'}</font></td>
		</tr>
~;
	
	foreach $loggedcount (@loggedcounts) {
		($threadid, $cat, $board, $user) = split(/\|/, $loggedcount);
		
		$yymain .= qq~
		
		<tr>
			<td class="windowbg2" bgcolor="#444444"><font size=2>$threadid</font></td>
			<td class="windowbg" bgcolor="#272A2F"><font size=2>$cat</font></td>
			<td class="windowbg2" bgcolor="#444444"><font size=2>$board</font></td>
			<td class="windowbg" bgcolor="#272A2F"><font size=2>$user</font></td>
		</tr>
~;
		++$logtotal;
	}
		
	$yymain .= qq~
	
		<tr>
			<td class="windowbg2" bgcolor="#444444"><font size=2>$boardcount{'11'}: $logtotal</font></td>
		</tr>
	</table>
~;
	
	$yytitle = "$boardcount{'9'}";
	
	&template;
	exit;
}

sub RemoveMemberCountLog {
	&is_admin;
	
	fopen(LOGFILE, ">$vardir/ReCountLog.txt", 1);
	print LOGFILE '';
	fclose(LOGFILE);
	require "$sourcedir/Admin.pl";
	&Admin;
}

sub RemoveMemberCountLogByHand {
	&is_admin;
	
	fopen(LOGFILE, ">$vardir/ReCountLog.txt", 1);
	print LOGFILE '';
	fclose(LOGFILE);
}
