###############################################################################
# CalEventSet.pl                                                              #
# By XTC: http://www.yabbserver.com                                           #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.0                                                    #
# Released:       September 29, 2005                                          #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2005 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$caleventsetplver = "beta5.0"; #Date: 16. Nov. 2005
if ($action eq 'detailedversion') { return 1; }

&LoadLanguage("EventCal");

if(!-e("$vardir/eventcalset.txt"))  {
	&EventCalSet2;
}

## Calendar Setting ##

require "$vardir/eventcalset.txt";

sub EventCalSet {
	&is_admin_or_gmod;
	my ($oneventchecked, $oneventbuttonchecked, $onbirthchecked, $caleventprivatechecked);

	# figure out what to print

	if    ($Show_EventCal || $Show_EventCal eq "") { $oneventchecked = "checked" }
	if    ($Show_EventButton) { $oneventbuttonchecked = "checked" }
	if    ($Show_EventBirthdays) { $onbirthchecked = "checked" }
	if    ($Show_BirthdaysList) { $onbirthlistchecked = "checked" }
	if    ($Show_MiniCalIcons) { $onminiiconchecked = "checked" }
	if    ($ShowSunday) { $onsundaychecked = "checked" }
	if    ($ShowCalendarGuest) { $oncalguestchecked = "checked" }
	if    ($CalEventPrivate) { $caleventprivatechecked = "checked" }
	if    ($DisplayCalEvents) { $dcaleventschecked = "checked" }
	if    ($Show_ColorLinks) { $oncolorlinkschecked = "checked" }
	if    (!$Event_TodayColor) { $Event_TodayColor = "ff0000"; }
	if    ($Scroll_Events == 0)   { $aevt1                   = ' selected="selected"'; }
	elsif ($Scroll_Events == 1)   { $aevt2                   = ' selected="selected"'; }
	elsif ($Scroll_Events == 2)   { $aevt3                   = ' selected="selected"'; }
	if    ($CalEventNoName == 0)  { $noname1                 = ' selected="selected"'; }
	elsif ($CalEventNoName == 1)  { $noname2                 = ' selected="selected"'; }
	elsif ($CalEventNoName == 2)  { $noname3                 = ' selected="selected"'; }
	require "$admindir/ManageBoards.pl";
	$caleventperms = $CalEventPerms;
	$caleventperms =~ s/,/, /g;
	$caleventperms = &DrawPerms($caleventperms);


	$yymain .= qq~
<form action="$adminurl?action=eventcal_set2" method="post">
<div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="titlebg">
		 <img src="$imagesdir/preferences.gif" alt="" border="0" /><b>$event_cal{'1'} <a name=EventCal></b> <span class="small">$modtxt{'1'} $event_cal{'2'}</span>
	   </td>
     </tr>
     <tr align="center" valign="middle">
       <td align="left" class="catbg"><span class="small">$event_cal{'21'}</span>
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2"><br />
		 <div class="setting_cell">
			$event_cal{'3'}
		 </div>
		 <div class="setting_cell2">
			<input type=checkbox name="showeventcal" $oneventchecked />
		 </div>
	   	 <br />
		 <div class="setting_cell">
			$event_cal{'38'}
		 </div>
		 <div class="setting_cell2">
			<input type=checkbox name="showcalendarguest" $oncalguestchecked />
		 </div>
	   	 <br />
		 <div class="setting_cell">
			$event_cal{'4'}
		 </div>
		 <div class="setting_cell2">
			<input type=checkbox name="showeventbutton" $oneventbuttonchecked />
		 </div>
	   	 <br />
		 <div class="setting_cell">
			$event_cal{'5'}
		 </div>
		 <div class="setting_cell2">
			<input type=checkbox name="showeventbirthdays" $onbirthchecked />
		 </div>
	   	 <br />
		 <div class="setting_cell">
			$event_cal{'42'}
		 </div>
		 <div class="setting_cell2">
			<input type=checkbox name="showbirthdayslist" $onbirthlistchecked />
		 </div>
	   	 <br />
		 <div class="setting_cell">
			$event_cal{'43'}
		 </div>
		 <div class="setting_cell2">
			<input type=checkbox name="showminicalicons" $onminiiconchecked />
		 </div>
	   	 <br />
		 <div class="setting_cell">
			$event_cal{'36'}<br /><span class="small">$event_cal{'37'}</span>
		 </div>
		 <div class="setting_cell2">
			<input type=checkbox name="showsunday" $onsundaychecked />
		 </div>
	   	 <br />
		 <div class="setting_cell">
			$event_cal{'44'}<br /><span class="small">$event_cal{'45'}</span>
		 </div>
		 <div class="setting_cell2">
			<input type=checkbox name="showcolorlinks" $oncolorlinkschecked />
		 </div>
	   	 <br />
		 <div class="setting_cell">
			$event_cal{'8'}
		 </div>
		 <div class="setting_cell2">
			<input type=text name="eventtodaycolor" size="5" value="$Event_TodayColor" />
		 </div>
	   </td>
     </tr>
     <tr align="center" valign="middle">
       <td align="left" class="catbg"><span class="small">$event_cal{'22'}</span>
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2"><br />
		 <div class="setting_cell">
			$event_cal{'9'}<br /><span class="small">$event_cal{'10'}</span>
		 </div>
		 <div class="setting_cell2">
			<select name="scrollevents" size="1">
			<option value="0"$aevt1>$event_cal{'11'}</option>
			<option value="1"$aevt2>$event_cal{'12'}</option>
			<option value="2"$aevt3>$event_cal{'13'}</option>
			</select>
		 </div>
	   	 <br />
		 <div class="setting_cell">
			$event_cal{'34'}<br /><span class="small">$event_cal{'35'}</span>
		 </div>
		 <div class="setting_cell2">
			<input type=text name="displayevents" size="5" value="$DisplayEvents" />
		 </div>
	   	 <br />
		 <div class="setting_cell">
			$event_cal{'20'}
		 </div>
		 <div class="setting_cell2">
			<input type=checkbox name="displaycalevents" $dcaleventschecked />
		 </div>
	   	 <br />
		 <div class="setting_cell">
			$event_cal{'6'}<br /><span class="small">$event_cal{'7'}</span>
		 </div>
		 <div class="setting_cell2">
			<input type=text name="calshortevent" size="5" value="$CalShortEvent" />
		 </div>
		 <br />
	   </td>
     </tr>
     <tr align="center" valign="middle">
       <td align="left" class="catbg"><span class="small">$event_cal{'23'}</span>
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2"><br />
		 <div class="setting_cell">
			$event_cal{'14'}<br /><span class="small">$event_cal{'15'}</span>
		 </div>
		 <div class="setting_cell2">
			<select multiple="multiple" name="caleventperms" size="5">$caleventperms
		 </div>
	   	 <br />
		 <div class="setting_cell">
			$event_cal{'16'}<br /><span class="small">$event_cal{'17'}</span>
		 </div>
		 <div class="setting_cell2">
			<input type=text name="caleventmods" size="35" value="$CalEventMods" />
		 </div>
		 <br />
		 <div class="setting_cell">
			$event_cal{'18'}<br /><span class="small">$event_cal{'19'}</span>
		 </div>
		 <div class="setting_cell2">
			<input type=checkbox name="caleventprivate" $caleventprivatechecked />
		 </div>
		 <br />
		 <div class="setting_cell">
			$event_cal{'24'}<br /><span class="small">$event_cal{'25'}</span>
		 </div>
		 <div class="setting_cell2">
			<select name="caleventnoname" size="1">
			<option value="0"$noname1>$event_cal{'39'}</option>
			<option value="1"$noname2>$event_cal{'40'}</option>
			<option value="2"$noname3>$event_cal{'41'}</option>
			</select><br /><br />
		 </div>
		 <br />
	   </td>
     </tr>
   </table>
 </div>

<br />

 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="center" class="catbg">
		 <input type="submit" value="$event_cal{'31'}" />
	   </td>
     </tr>
   </table>
 </div>
</form>
<br /><br />
~;

## Calendar Event-Icon Setting ##

if (!-e("$vardir/eventcalIcon.txt"))  {
fopen(FILE, ">>$vardir/eventcalIcon.txt");
print FILE "1;";
close(FILE);
}
require "$vardir/eventcalIcon.txt";


$yymain .= qq~
    <form action="$adminurl?action=eventcal_set3" method="post">
<div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td  colspan="5" align="left" class="titlebg">
		 <img src="$imagesdir/preferences.gif" alt="" border="0" /><b>$event_cal{'26'}</b>
       </td>
     </tr>
     <tr valign="middle">
       <td  colspan="5" align="left" class="windowbg2">
		 <br />$event_cal{'33'}<br /><br />
       </td>
     </tr>
     <tr align="center" valign="middle">
	<td class="catbg" width="24%" align=center><b>$event_cal{'27'}</b></td>
	<td class="catbg" width="24%" align=center><b>$event_cal{'28'}</b></td>
	<td class="catbg" width="10%" align=center><b>$event_cal{'29'}</b></td>
	<td class="catbg" width="6%" align=center><b>$var_cal{'caldel'}</b></td>
     </tr>~;


	$i=0;
	while($CalIconURL[$i]) {
		$yymain .= qq~<TR><td class='windowbg' width='24%' align=center><input type=text name=caliimg[$i] value=$CalIconURL[$i]></TD><td class='windowbg' width='24%' align=center><input type=text name=calidescr[$i] value='$CalIDescription[$i]'></TD><td class='windowbg' width='10%' align='center'><img src="$modimgurl/EventCal/EventIcons/$CalIconURL[$i].gif"></td><td class='windowbg' width='6%' align=center><input type=checkbox name=calidelbox[$i] value=1></TD></tr>~;
		$i++
		}
$yymain .= qq~
     <tr valign="middle">
       <td  colspan="6" align="left" class="titlebg">
		 <img src="$imagesdir/preferences.gif" alt="" border="0" /><b>$event_cal{'30'}</b>
	   </td>
     </tr>
~;
$inew=0;
while($inew <= "3") {
$yymain .= qq~<tr><td class='windowbg' width='24%' align=center><input type=text name=caliimg[$i]></TD><td class='windowbg' width='24%' align=center><input type=text name=calidescr[$i]></TD><td class='windowbg' width='10%' align='center' colspan=2></TD></tr>~;
$i++;
$inew++;
}

$yymain .= qq~
   </table>
 </div>
<br />

 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="center" class="catbg">
		 <input type="submit" value="$event_cal{'32'}" />
	   </td>
     </tr>
   </table>
 </div>
</form>
~;

	$yytitle     = $event_cal{'1'};
	$action_area = "eventcalset";
	&AdminTemplate;
	exit;
}

## Save Calendar Setting ##

sub EventCalSet2 {
	&is_admin_or_gmod;

	my @onoff = qw/showeventcal showeventbutton showeventbirthdays showbirthdayslist showminicalicons caleventprivate displaycalevents showsunday showcolorlinks showcalendarguest/;


	# Set as 0 or 1 if box was checked or not
	my $fi;
	map { $fi = lc $_; ${$_} = $FORM{$fi} eq 'on' ? 1 : 0; } @onoff;


	# If empty fields are submitted, set them to default-values to save yabb from crashing

	$displayevents = $FORM{'displayevents'}		|| 0;
	$scrollevents = $FORM{'scrollevents'}		|| 0;
	$caleventnoname = $FORM{'caleventnoname'}	|| 0;
	$eventtodaycolor = $FORM{'eventtodaycolor'}	|| "ff0000";
	$eventtodaycolor =~ s/#//g;
	$calshortevent = $FORM{'calshortevent'}	|| 0;
	$calshortevent =~ s~[^\d]~~g;
	$caleventperms = $FORM{'caleventperms'}		|| "";
	$caleventperms =~ s~\A\s?,\s?~~;
	$caleventperms =~ s~,\s~,~g;
	$caleventmods = $FORM{'caleventmods'}		|| "";
	$caleventmods =~ s~\A\s?,\s?~~;
	$caleventmods =~ s~,\s~,~g;

	my $filler  = q~                                                                               ~;
	my $setfile = << "EOF";
###############################################################################
# CalEventSet.txt                                                             #
###############################################################################

\$Show_EventCal = $showeventcal;
\$Show_EventButton = $showeventbutton;
\$Show_EventBirthdays = $showeventbirthdays;
\$Show_BirthdaysList = $showbirthdayslist;
\$Show_MiniCalIcons = $showminicalicons;
\$ShowSunday = $showsunday;
\$ShowCalendarGuest = $showcalendarguest;
\$Show_ColorLinks = $showcolorlinks;
\$Event_TodayColor = "$eventtodaycolor";
\$CalShortEvent = "$calshortevent";
\$CalEventPerms = qq~$caleventperms~;
\$CalEventMods = qq~$caleventmods~;
\$CalEventPrivate = $caleventprivate;
\$CalEventNoName = $caleventnoname;
\$Scroll_Events = $scrollevents;
\$DisplayCalEvents = $displaycalevents;
\$DisplayEvents = $displayevents;

1;
EOF

	$setfile =~ s~(.+\;)\s+(\#.+$)~$1 . substr( $filler, 0, (70-(length $1)) ) . $2 ~gem;
	$setfile =~ s~(.{64,}\;)\s+(\#.+$)~$1 . "\n   " . $2~gem;
	$setfile =~ s~^\s\s\s+(\#.+$)~substr( $filler, 0, 70 ) . $1~gem;

	fopen(FILE, ">$vardir/eventcalset.txt");
	print FILE $setfile;
	fclose(FILE);

	$yySetLocation = qq~$adminurl?action=eventcal_set~;
	&redirectexit;
}

## Save Calendar Event-Icon Setting ##

sub EventCalSet3 {
	&is_admin_or_gmod;
	$count=0;
	$tempA=0;
	fopen(FILE, ">$vardir/eventcalIcon.txt");
	while($FORM{"caliimg[$tempA]"}) {
		$delcheck = $FORM{"calidelbox[$tempA]"};
		$var1 = $FORM{"caliimg[$tempA]"};
		$var3 = $FORM{"calidescr[$tempA]"};
		$imgcali = qq(\$CalIconURL[$count] = "$var1";);
		$sdrcali = qq(\$CalIDescription[$count] = "$var3";);

		if ($delcheck ne "1") {
		print FILE "$imgcali\n";
		print FILE "$sdrcali\n\n";
		++$count;
		}
		++$tempA;
		}
		print FILE "1;";
		fclose(FILE);

	$yySetLocation = qq~$adminurl?action=eventcal_set~;
	&redirectexit;
}


1;
