###############################################################################
# Subs.pl                                                                     #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.1                                                    #
# Released:       November 8, 2005                                            #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2005 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

# BEGIN {} block to pass "perl -c" (at least from the directory above Sources)
BEGIN {
	push(@INC, "./Modules");
	push(@INC, "./Modules/Upload");
	push(@INC, "./Modules/Digest");
}

$subsplver = 'YaBB 2.1 $Revision: 1.15 $';

use subs 'exit';
$yymain = "";
$CGITempFile::TMPDIRECTORY = "$uploaddir";

# set line wrap limit in Display.
$linewrap = 80;

# get the current date/time
$date = int(time + $timecorrection);

# parse the query string
&readform;                                   

$uid = substr($date, length($date) - 3, 3);
$session_id = $cookiesession_name;

$user_ip = $ENV{'REMOTE_ADDR'};

if ($user_ip eq "127.0.0.1") {
	if    ($ENV{'HTTP_CLIENT_IP'}       && $ENV{'HTTP_CLIENT_IP'}       ne "127.0.0.1") { $user_ip = $ENV{'HTTP_CLIENT_IP'}; }
	elsif ($ENV{'X_CLIENT_IP'}          && $ENV{'X_CLIENT_IP'}          ne "127.0.0.1") { $user_ip = $ENV{'X_CLIENT_IP'}; }
	elsif ($ENV{'HTTP_X_FORWARDED_FOR'} && $ENV{'HTTP_X_FORWARDED_FOR'} ne "127.0.0.1") { $user_ip = $ENV{'HTTP_X_FORWARDED_FOR'}; }
}

$masterseed = substr($date, length($date) - 4, length($date));
$formsession = &encode_session($mbname, $masterseed);
$formsession .= $masterseed;

if (-e ("YaBB.cgi")) { $yyext = "cgi"; }
else { $yyext = "pl"; }
if (-e ("AdminIndex.cgi")) { $yyaext = "cgi"; }
else { $yyaext = "pl"; }

sub concurrent {
	my($what,$con_num) = @_;
	if (!$current_con){ $current_con = 0; }
	if (!$max_conn){ $max_conn = 500; }
	if($what ne ""){
		if($what eq "read"){
			fopen(DB, "$vardir/concurrent.db");
			$current_con = <DB>;
			fclose (DB);
		} elsif($what eq "add" && $current_con <= $max_conn){
			$current_con++;
		} elsif($what eq "remove" && $current_con > 0){
			$current_con--;
		} elsif($what eq "fix" && $con_num >= 0){
			$current_con = $con_num;
		}
		unless ($what eq "read"){
			fopen(DB, ">$vardir/concurrent.db");
			print DB "$current_con\n";
			fclose (DB);
		}
	}
	if ($current_con > $max_conn){
		&LoadLanguage("Concurrent");
		print header(-status  => '200 OK',
			-charset => $yycharset);
		print "<html>\n<head>\n</head>\n</body><center><font face=\"Arial\" size=\"5\"><br /><br /><br /><br />\n";
		print "<br /><br />\n";
		print "$conn_txt{'error'}<br /><br />\n";
		print "</font></center></body>\n</html>\n\n";
		if($current_con > 0){
			$current_con--;
		}
		fopen(DB, ">$vardir/concurrent.db");
		print DB "$current_con\n";
		fclose (DB);
		exit;
	}
}


LoadLanguage("yamms");
require "$vardir/YammsSettings.txt";

sub getnewid {
	my $newid = int(time);
	while (-e "$datadir/$newid.txt") { ++$newid; }
	return $newid;
}

sub undupe {
	@in  = @_;
	@out = ();
	foreach $check (@in) {
		$duped = 0;
		foreach $checkout (@out) {
			if ($checkout eq $check) { $duped = 1; }
		}
		if ($duped == 0) {
			push(@out, $check);
		}
	}
	return @out;
}

sub exit {
	local $| = 1;
	local $\ = '';
	print '';
	CORE::exit($_[0] || 0);
}

sub header {
	my %params = @_;
	my $ret    = "";
	if ($params{'-status'}) {
		if ($yyIIS) {
			$ret .= "HTTP/1.0 $params{'-status'}\n";
		} else {
			$ret .= "Status: $params{'-status'}\n";
		}
	}
	if (!$cachebehaviour || $cachebehaviour == 0) {
		$ret .= qq~Cache-Control: no-cache, must-revalidate\n~;
		$ret .= qq~Pragma: no-cache\n~;
	}
	if ($params{'-cookie'}) {
		my (@cookie) = ref($params{'-cookie'}) && ref($params{'-cookie'}) eq 'ARRAY' ? @{ $params{'-cookie'} } : $params{'-cookie'};
		foreach (@cookie) {
			$ret .= "Set-Cookie: $_\n";
		}
	}
	if ($params{'-location'}) {
		$ret .= "Location: $params{'-location'}\n";
	}
	$params{'-charset'} = "; charset=$params{'-charset'}" if $params{'-charset'};
	$params{'Content-Encoding'} = "Content-Encoding: $params{'Content-Encoding'}\n" if $params{'Content-Encoding'};
	$ret .= "$params{'Content-Encoding'}Content-Type: text/html$params{'-charset'}\r\n\r\n";
	return $ret;
}

sub cookie {
	my %params = @_;

	if ($params{'-expires'} =~ /\+(\d+)m/) {
		my ($sec, $min, $hour, $mday, $mon, $year, $wday) = gmtime(time + $1 * 60);

		$year += 1900;
		my @mos = ("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
		my @dys = ("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat");
		$mon  = $mos[$mon];
		$wday = $dys[$wday];

		$params{'-expires'} = sprintf("%s, %02i-%s-%04i %02i:%02i:%02i GMT", $wday, $mday, $mon, $year, $hour, $min, $sec);
	}

	$params{'-path'}    = " path=$params{'-path'};"       if $params{'-path'};
	$params{'-expires'} = " expires=$params{'-expires'};" if $params{'-expires'};

	return "$params{'-name'}=$params{'-value'};$params{'-path'}$params{'-expires'}";
}

sub redirectexit {
	if ($gzcomp && $gzaccept) {
		if ($yySetCookies1 || $yySetCookies2 || $yySetCookies3) {
			print header(-status            => '302 Moved Temporarily',
				'Content-Encoding' => 'gzip',
				-cookie   => [$yySetCookies1, $yySetCookies2, $yySetCookies3],
				-location => $yySetLocation);
		} else {
			print header(-status            => '302 Moved Temporarily',
				'Content-Encoding' => 'gzip',
				-location          => $yySetLocation);
		}
	} else {
		if ($yySetCookies1 || $yySetCookies2 || $yySetCookies3) {
			$cookiewritten = "Cookie Set";
			print header(-status => '302 Moved Temporarily',
				-cookie   => [$yySetCookies1, $yySetCookies2, $yySetCookies3],
				-location => $yySetLocation);
		} else {
			print header(-status   => '302 Moved Temporarily',
				-location => $yySetLocation);
		}
	}
	exit;
}

sub redirectinternal {
	if ($currentboard) {
		if ($INFO{'num'}) { require "$sourcedir/Display.pl"; &Display; }
		else { require "$sourcedir/MessageIndex.pl"; &MessageIndex; }
	} else {
		require "$sourcedir/BoardIndex.pl";
		&BoardIndex;
	}
	exit;
}

sub ImgLoc {
	if (!-e "$forumstylesdir/$useimages/$_[0]") { $thisimgloc = qq~img src="$forumstylesurl/default/$_[0]"~; }
	else { $thisimgloc = qq~img src="$imagesdir/$_[0]"~; }
	return $thisimgloc;
}

sub SaveMembMood {
	$moodtime = $date;
	$slidepos = ($INFO{'slidpos'} * 8) + 8;
	${$uid.$username}{'moodtoday'} = qq~$INFO{'themood'}|$moodtime|$slidepos~;
	&UserAccount($username, "update");
	if($INFO{'desttype'}) {
		$yySetLocation = qq~$scripturl?$INFO{'desttype'}=$INFO{'mooddest'}~;
	}
	else {
		$yySetLocation = qq~$scripturl~;
	}
	&redirectexit;
}

sub template {
	my $gzaccept = $ENV{'HTTP_ACCEPT_ENCODING'} =~ /\bgzip\b/ || $gzforce;

	#print header
	if ($gzcomp && $gzaccept) {
		if ($yySetCookies1 || $yySetCookies2 || $yySetCookies3) {
			$cookiewritten = "Cookie Set";
			print header(-status            => '200 OK',
				'Content-Encoding' => 'gzip',
				-cookie  => [$yySetCookies1, $yySetCookies2, $yySetCookies3],
				-charset => $yycharset);
		} else {
			print header(-status            => '200 OK',
				'Content-Encoding' => 'gzip',
				-charset           => $yycharset);
		}
	} else {
		if ($yySetCookies1 || $yySetCookies2 || $yySetCookies3) {
			$cookiewritten = "Cookie Set";
			print header(-status => '200 OK',
				-cookie  => [$yySetCookies1, $yySetCookies2, $yySetCookies3],
				-charset => $yycharset);
		} else {
			print header(-status  => '200 OK',
				-charset => $yycharset);
		}
	}

	$yyposition = $yytitle;
	$yytitle    = "$mbname - $yytitle";

	if (!$iamguest) {
		$moodtime = &timeformat($date, 1);
		LoadLanguage("mood");

		$thistime = $date;
		$knappos = 4;
		if(${$uid.$username}{'moodtoday'}) {
			@mimood = split(/\|/, ${$uid.$username}{'moodtoday'});
			if(($thistime-$mimood[1]) < 86400) {
				$moodgif = $mimood[0];
				$knappos = $mimood[2];
			}
			else {
				$moodgif = "100_glad";
			}
		}
		else { $moodgif = "100_glad"; }
		$knappos .= "px";

		my $mooddestination = "";
		if($INFO{'board'}) { $mooddestination = qq~;desttype=board;mooddest=$INFO{'board'}~; }
		elsif($INFO{'num'}) { $mooddestination = qq~;desttype=num;mooddest=$INFO{'num'}~; }

		$yymood = qq~

		<script language="JavaScript1.2" type="text/javascript">
		<!--

		img1 = new Image(); img1.src = "$modimgurl/mood/100_glad.gif";
		img2 = new Image(); img2.src = "$modimgurl/mood/110_tilfreds.gif";
		img3 = new Image(); img3.src = "$modimgurl/mood/120_sej.gif";
		img4 = new Image(); img4.src = "$modimgurl/mood/130_normal.gif";
		img5 = new Image(); img5.src = "$modimgurl/mood/140_fjoget.gif";
		img6 = new Image(); img6.src = "$modimgurl/mood/150_svimmel.gif";
		img7 = new Image(); img7.src = "$modimgurl/mood/160_flov.gif";
		img8 = new Image(); img8.src = "$modimgurl/mood/170_bekymret.gif";
		img9 = new Image(); img9.src = "$modimgurl/mood/180_bedrovet.gif";
		img10 = new Image(); img10.src = "$modimgurl/mood/190_vred.gif";

		var delEnh=80, totEnh=80;

		var Imgs = ["100_glad", "110_tilfreds", "120_sej", "130_normal", "140_fjoget", "150_svimmel", "160_flov", "170_bekymret", "180_bedrovet", "190_vred"]

		var eleNum = Imgs.length, theNum = Imgs.length, ele

		function showImg() {
			eleDiv = totEnh/eleNum;
			ele = Math.round(delEnh/eleDiv);
			if (ele < 0) ele = 0;
			if (ele >= eleNum) ele = eleNum-1;
			if (knapObj.id == "knapImg" && ele != theNum) {
				document.images.imag.src="$modimgurl/mood/"+Imgs[ele]+".gif";
				theNum = ele;
			}
		}

		function saveImg() {
			skydNu=false;
			location.href="$scripturl?action=savemembmood$mooddestination;themood="+Imgs[ele]+";slidpos="+ele;
		}

		var op = ( navigator.userAgent.indexOf( 'Opera' ) != -1 );
		var ns6 = ( document.getElementById && !document.all );
		var ie = ( document.all && !op );

		var skydNu=false
		var x, knapObj, retning

		function flytKnap(e) {
			if (skydNu) {
				glX = parseInt(knapObj.style.left+0);
				if(ns6) nyX = temp2 + e.clientX - x; else nyX = temp2 + event.clientX - x;
				knapObj.style.left = parseInt(nyX+0) + 'px';
				if (nyX > glX) retning = "vn"; else retning = "hj";
				if (nyX < 4 && retning == "hj") { knapObj.style.left = 4 + 'px'; retning = "vn"; }
				if (nyX > 84 && retning == "vn") { knapObj.style.left = 84 + 'px'; retning = "hj"; }
				delEnh = parseInt(knapObj.style.left+0)-8;
				showImg();
				document.onmouseup = saveImg;
				return false;
			}
		}

		function skydeKnap(e){
			if (ns6) flytobj = e.target; else flytobj = event.srcElement;
			if (flytobj.className == "skyd"){
				skydNu = true;
				knapObj = flytobj;
				temp2 = parseInt(knapObj.style.left+0);
				if(ns6) x = e.clientX; else x = event.clientX;
				document.onmousemove = flytKnap;
				return false;
			}
		}

		document.onmousedown=skydeKnap

		// -->
		</script>

		<div style="float: left; width: 65px;">
		<img src="$modimgurl/mood/$moodgif.gif" name="imag" height="60" width="60" border="0" />
		</div>
		<div style="float: left; padding-top: 5px;">
		<b>$moodtime<br />$moodtxt{'01'} ${$uid.$username}{'realname'}?</b><br />
		<div style="position: relative; z-index: 1; width: 102px; height: 18px; left: 0px; top: 4px; border-width: 1px; border-style: outset; background-color: #AAAAAA;">
		<img src="$modimgurl/mood/knapbagr.gif" style="position: absolute; z-index: 2; width: 100px; height: 16px; left: 0px; top: 0px;" />
		<img id="knapImg" src="$modimgurl/mood/knap.gif" class="skyd" style="position: absolute; cursor: pointer; cursor: hand; z-index: 3; width: 13px; height: 15px; left: $knappos; top: 1px;" />
		</div>
		</div>
		~;
	}
	else {
		$yymood = &timeformat($date, 1);
	}

####### Who Direct Message Begin ######
# Go through the private messages file, get messages for the current user and keep
# only messages which haven't expired.

	open(MSG, "$vardir/whomessage.txt");
	my @whomessages = <MSG>;
	close(MSG);
	open(MSG, ">$vardir/whomessage.txt");
	foreach $whofile (@whomessages) {
		chomp $whofile;
		my ($who_to_user, $who_from_user, $whotime, $who_message, $who_read) = split(/\|/, $whofile);
		$who_time = &timetostring( $whotime );
		$who_time = "($who_time)";
		if (($who_read == 1) && ($who_to_user =~ $username)) {
			$whomessages = 1;
			push(@msgwholines, "alert('$load_txt{'471'} $maintxt{'525'} $who_from_user\\n$who_time:\\n_______________________________________________ \\n\\n $who_message\\n_______________________________________________');");
		} else {
			print MSG qq~$who_to_user|$who_from_user|$whotime|$who_message|1\n~;
		}
	}
	close(MSG);

if ($whomessages ==1) {
			$yymain .= qq~
	<SCRIPT LANGUAGE="JavaScript"><!--
		@msgwholines
	//--></SCRIPT>
		~;
}
####### Who Direct Message End #######

	# remove search from menu if disabled by the admin 
	$yymenu = qq~<a href="$scripturl">$img{'home'}</a>$menusep<a href="$scripturl?action=help" style="cursor:help;">$img{'help'}</a>~;
####### Added for ChatIRC Mod begin #######
	if ((-e ("$vardir/ChatIRC.txt")) && (!$ChatIRC_Load)) { require "$vardir/ChatIRC.txt"; $ChatIRC_Load = 1; }
	unless ($iamguest && $enable_guestchat == 0) {
	if ($irc_popupmode == 1){
		$height = 570; 
		$width = 840; 
		$yymain .= qq~
		<script language="JavaScript1.2" type="text/javascript">
		<!--
		function chatwin() {
		window.open("$scripturl?action=chatirc", 'list', 'width=$width,height=$height, scrollbars=yes');
		}
		//-->
		</script>~;
		$yymenu .= qq~$menusep<a href=javascript:chatwin()>$img{'chatirc'}</a>~;
	} else {
		$yymenu .= qq~$menusep<a href="$scipturl?action=chatirc">$img{'chatirc'}</a>~;
	}
	}
####### Added for ChatIRC Mod end #######
	if ($maxsearchdisplay > -1) {
		$yymenu .= qq~$menusep<a href="$scripturl?action=search">$img{'search'}</a>~;
	}
	if($mapinmenu) {
		if (!$iamguest || $mapguests) {
			$yymenu .= qq~$menusep<a href="$scripturl?action=membermap;username=$username">$img{'membermap'}</a>~;
		}
	}
	if (!$iamguest) {
		$yymenu .= qq~$menusep<a href="$scripturl?action=ml">$img{'memberlist'}</a>~;
		if (${$uid.$username}{'favorites'}) {
			$yymenu .= qq~$menusep<a href="$scripturl?action=favorites">$img{'favorites'}</a>~;
		}
	}

        $yymenu .= qq~$menusep<a href="$scripturl?action=quiz">$img{'quiz'}</a>~;
	if ($iamadmin) { $yymenu .= qq~$menusep<a href="$boardurl/AdminIndex.$yyaext">$img{'admin'}</a>~; }
	if ($iamgmod) {
		if (-e ("$vardir/gmodsettings.txt")) {
			require "$vardir/gmodsettings.txt";
		}
		if ($allow_gmod_admin) { $yymenu .= qq~$menusep<a href="$boardurl/AdminIndex.$yyaext">$img{'admin'}</a>~; }
	}
	if ($sessionvalid == 0 && !$iamguest) { $yymenu .= qq~$menusep<a href="$scripturl?action=revalidatesession">$img{'sessreval'}</a>~; }
	if(-e("$vardir/RatingConf.txt"))  { require "$vardir/RatingConf.txt"; }
## EventCal Begin ##
	if(-e("$vardir/eventcalset.txt"))  { require "$vardir/eventcalset.txt"; }
	if ($Show_EventButton && $EventCal_Active) {
	unless ($iamguest && ($Show_EventButton == 1 || $ShowCalendarGuest == 1)) {
	$yymenu .= qq~$menusep<a href="$scripturl?action=get_cal;calshow=1">$img{'eventcal'}</a>~;
	}
	}
	if ($Show_BirthdayButton && $BirthdayList_Active) {
	unless ($iamguest && ($Show_BirthdayButton == 1)) {
	$yymenu .= qq~$menusep<a href="$scripturl?action=cal_birthdaylist">$img{'birthdaylist'}</a>~;
	}
	}
## EventCal End ##
	if ($iamguest) {
		if ($enable_ratings && $en_ratingsmenu == 2) { $yymenu .= qq~$menusep<a href="$scripturl?action=rateshow;editmode=new;start=0">$img{'rating'}</a>~; }
		$yymenu .= qq~$menusep<a href="$scripturl?action=login">$img{'login'}</a>~;
		if (!$regdisable) { $yymenu .= qq~$menusep<a href="$scripturl?action=register">$img{'register'}</a>~; }
	} else {
		$yymenu .= qq~$menusep<a href="$scripturl?action=viewprofile;username=$username">$img{'profile'}</a>~;
		if ($enable_ratings && $en_ratingsmenu) { $yymenu .= qq~$menusep<a href="$scripturl?action=rateshow;editmode=new;start=0">$img{'rating'}</a>~; }
		if($enable_downloads) { $yymenu .= qq~$menusep<a href="$scripturl?action=downloadview">$img{'downloads'}</a>~; }
		if ($enable_notification) { $yymenu .= qq~$menusep<a href="$scripturl?action=shownotify">$img{'notification'}</a>~; }
	if($Show_WhosOn && $username ne 'Guest') { $yymenu .= qq~$menusep<a href="$scripturl?action=who">$img{'whoson'}</a>~; }
		$yymenu .= qq~$menusep<a href="$scripturl?action=logout">$img{'logout'}</a>~;
	}

	$yyimages        = $imagesdir;
	$yydefaultimages = $defaultimagesdir;
	$yystyle         = qq~<link rel="stylesheet" href="$forumstylesurl/$usestyle.css" type="text/css" />~;
	$yystylesheet    = qq~<link rel="stylesheet" href="$forumstylesurl/$usestyle.css" type="text/css" />~;
	$yystyle      =~ s~$usestyle\/~~g;
	$yystylesheet =~ s~$usestyle\/~~g;

	# This is for the Help Center and anywhere else that wants to add inline CSS.
	$yystyle      .= $yyinlinestyle;
	$yystylesheet .= $yyinlinestyle;

	if (!$usehead) { $usehead = qq~default~; }
	$yytemplate = "$templatesdir/$usehead/$usehead.html";
	fopen(TEMPLATE, "$yytemplate") || die("$maintxt{'23'}: $testfile");
	@yytemplate = <TEMPLATE>;
	fclose(TEMPLATE);
	$newsloaded = 0;

	my $output = '';
	$yyboardname = "$mbname";
	$yytime      = &timeformat($date, 1);

	if ($regdisable) {
        require "$sourcedir/greetplus.pl";
        &greet_reg_disable;
	} else {
        require "$sourcedir/greetplus.pl";
        &greet_reg_enable;
	}
	if ($enable_news) {
		fopen(NEWS, "$vardir/news.txt");
		@newsmessages = <NEWS>;
		fclose(NEWS);
	}
	if ($debug == 1) {
		$time_running = time - $START_TIME;
		if ($START_TIME = 0 || $time_running > 1000) {
			$yytimeclock = "Your server probably does not have Time::Hires installed or does not support the local module for it";
		} else {
			$time_running = sprintf("%.4f", $time_running);
			$yytimeclock = "Page completed in $time_running seconds, Loaded $loadedboards Boards";
		}
		$yyfileactions = "Opened $file_open files and Closed $file_close files. (should be equal numbers)";
		$openfiles =~ s~\+\<~~g;
		$yyfilenames = $openfiles;
		$openfiles_name =~ s~\+\<~~g;
		$openclosefiles	=~ s~\+\<~~g;	
		$yydebug = qq~
		<br />
		<table align="center" cellpadding="4" cellspacing="1" border="0">
			<tr>
			  <td align="center"><br /><u>Debugging Information</u><br /><br /><u>benchmarking</u><br />$yytimeclock<br /><br /><u>Your IP address is</u><br />$user_ip<br /><br /><u>Your Browser Agent:</u><br />$ENV{'HTTP_USER_AGENT'}<br /><br /><u>File Check on Open/Close</u><br />$yyfileactions<br /><br /></td>
			</tr>
		~;
		if($iamadmin) {
		$yydebug .= qq~
			<tr>
			  <td align="center">
		<table align="center" cellpadding="4" cellspacing="1" border="0">
			<tr>
			  <td align="right"><u>Filehandle open:</u></td>
			  <td align="center"><u>Filename:</u></td>
			  <td align="left"><u>Filehandle close:</u></td>
			</tr><tr>
			  <td align="right">$openfiles</td>
			  <td align="center"><p align="center">$openfiles_name</td>
			  <td align="left">$openclosefiles</td>
			</tr>
		</table>
			  </td>
			</tr>
		~;
		}
		$yydebug .= qq~</table>~;
	}
	for (my $i = 0; $i <= $#yytemplate; $i++) {
		$curline = $yytemplate[$i];
		if (!$yycopyin && $curline =~ m~<yabb copyright>~) { $yycopyin = 1; }
		$yysearchbox = "";
		unless ($iamguest && $guestaccess == 0) {
			if ($curline =~ m~<yabb searchbox>~ && $maxsearchdisplay > -1) {
				$checklist = "";
				unless ($mloaded == 1) { require "$boardsdir/forum.master"; }
				foreach $catid (@categoryorder) {
					if ($INFO{'catselect'} ne $catid && $INFO{'catselect'}) { next; }
					$boardlist = $cat{$catid};
					(@bdlist) = split(/\,/, $boardlist);
					my ($catname, $catperms, $catallowcol) = split(/\|/, $catinfo{"$catid"});
					my $access = &CatAccess($catperms);
					if (!$access) { next; }
					foreach $curboard (@bdlist) {
						chomp $curboard;
						$cat_boardcnt{$catid}++;
						my ($boardname, $boardperms, $boardview) = split(/\|/, $board{"$curboard"});
						my $access = &AccessCheck($curboard, '', $boardperms);
						if (!$iamadmin && $access ne "granted") { next; }
						$checklist .= qq~$curboard, ~;
					}
				}
				$checklist =~ s/, \Z//;
				$yysearchbox = qq~
			<script language="JavaScript1.2" src="$ubbcjspath" type="text/javascript"></script>
			<form action="$scripturl?action=search2" method="post" onsubmit="return submitproc()">
			<input type="hidden" name="searchtype" value="allwords" />
			<input type="hidden" name="userkind" value="any" />
			<input type="hidden" name="subfield" value="on" />
			<input type="hidden" name="msgfield" value="on" />
			<input type="hidden" name="age" value="31" />
			<input type="hidden" name="numberreturned" value="$maxsearchdisplay" />
			<input type="hidden" name="oneperthread" value="1" />
			<input type="hidden" name="action" value="dosearch" />
			<input type="hidden" name="searchboards" value="$checklist" />
			<input type="text" name="search" size="16" style="font-size: 11px; vertical-align: middle;" />
			<input type="image" src="$imagesdir/search.gif" style="border: 0; background-color: transparent; margin-right: 5px; vertical-align: middle;" />
			</form>
			~;
			}
		}
		if ($curline =~ m~<yabb newstitle>~ && $enable_news) {
			$yynewstitle = qq~<b>$maintxt{'102'}:</b> ~;
		}
		if ($curline =~ m~<yabb news>~ && $enable_news && $newsloaded == 0) {
			srand;
			if ($shownewsfader == 1) {
				$fadedelay = ($maxsteps * $stepdelay);
				$yynews .= qq~
				<script language="JavaScript1.2" type="text/javascript">
					<!--
						var maxsteps = "$maxsteps";
						var stepdelay = "$stepdelay";
						var fadelinks = $fadelinks;
						var delay = "$fadedelay";
						var bcolor = "$color{'faderbg'}";
						var tcolor = "$color{'fadertext'}";
						var fcontent = new Array();
						var begintag = "";~;
				fopen(NEWS, "$vardir/news.txt");
				@newsmessages = <NEWS>;
				fclose(NEWS);
				$newsloaded = 1;
				for (my $j = 0; $j < @newsmessages; $j++) {
					$newsmessages[$j] =~ s/\n|\r//g;
					if ($newsmessages[$j] eq '') { next; }
					if ($i != 0) { $yymain .= qq~\n~; }
					$message = $newsmessages[$j];
					if ($enable_ubbc) {
						if (!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; }
						&DoUBBC;
					}
					$message =~ s/\"/\\\"/g;    # "
					$yynews .= qq~
						fcontent[$j] = "$message";\n~;
				}
				$yynews .= qq~
						var closetag = '';
						//window.onload = fade;
					// -->
				</script>
				<script language="JavaScript1.2" type="text/javascript" src="$faderpath"></script>
				~;
			} else {
				$message = $newsmessages[int rand(@newsmessages)];
				if ($enable_ubbc) {
					if (!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; }
					&DoUBBC;
				}
				$ubbcnews = $message;
				$yynews   = qq~$ubbcnews~;
			}
		}
		$yyurl      = $scripturl;
		$addsession = qq~<input type="hidden" name="formsession" value="$formsession" /></form>~;
		$curline =~ s~<yabb\s+(\w+)>~${"yy$1"}~g;
		$curline =~ s~<includefile="(\S+)">~${\(IncludeFile($1))}~g;
		$curline =~ s~(a href\=\S+?action\=viewprofile\;username\=.+?)(\>)~$1 rel=\"nofollow\"$2~isg;
		$curline =~ s~img src\=\"$imagesdir\/(.+?)\"~&ImgLoc($1)~eisg;
		$curline =~ s~(img src\=\"$imagesdir\/.+?)title\=\"(.*?)\"(.*? \/\>)~$1$3~ig;
		$curline =~ s~alt\=\"(.*?)\"~alt\=\"$1\" title\=\"$1\"~ig;
		$curline =~ s~</form>~$addsession~g;
		$output .= $curline;
	}
	if ($yycopyin == 0) {
		$output = q~<center><h1><b>Sorry, the copyright tag <yabb copyright> must be in the template.<br />Please notify this forum's administrator that this site is using an ILLEGAL copy of YaBB!</b></h1></center>~;
	}

	# do output
	if ($gzcomp && $gzaccept) {
		if ($gzcomp == 1) {
			$| = 1;
			open(GZIP, "| gzip -f");
			print GZIP $output;
			close(GZIP);
		} else {
			require Compress::Zlib;
			binmode STDOUT;
			print Compress::Zlib::memGzip($output);
		}
	} else {
		print $output;
	}
	## decrease concurrent counter as output is complete ##
	&concurrent("remove");
}

# One should never criticize his own work except in a fresh and hopeful mood.
# The self-criticism of a tired mind is suicide.
# - Charles Horton Cooley

sub IncludeFile {
	my $fname = shift;
	my $file;
	$fname =~ s/([\&;\`'\|\"*\?\~\^\(\)\[\]\{\}\$\n\r])//g;
	fopen(INCLUDE, $fname) || return '[an error occured while processing this directive]';
	my @file = <INCLUDE>;
	fclose(INCLUDE);
	$file = join('', @file);
	return $file;
}

sub fatal_error_logging {
	my $tmperror = $_[0];
	$tmperror =~ s/\n//ig;
	fopen(ERRORLOG, "+<$vardir/errorlog.txt");
	seek ERRORLOG, 0, 0;
	my @errorlog = <ERRORLOG>;
	truncate ERRORLOG, 0;
	seek ERRORLOG, 0, 0;
	chomp @errorlog;
	$errorcount = $#errorlog + 1;

	if ($elrotate) {
		while ($errorcount >= $elmax) {
			my $void = shift @errorlog;
			$errorcount = $#errorlog + 1;
		}
	}
	if ($iamguest) {
		push @errorlog, time() . "\|$date\|$user_ip\|$tmperror\|$action\|$INFO{'num'}\|$currentboard\|$FORM{'username'}\|$FORM{'passwrd'}";
	} else {
		push @errorlog, time() . "\|$date\|$user_ip\|$tmperror\|$action\|$INFO{'num'}\|$currentboard\|$username\|$FORM{'passwrd'}";
	}
	foreach (@errorlog) {
		chomp;
		if ($_ ne "") {
			print ERRORLOG $_ . "\n";
		}
	}
	fclose(ERRORLOG);

	undef($tmperror);
}

# The error message is the Truth.  The error message is God.
# - File Of Good Advice.

sub fatal_error {
	my $e = $_[0];
	my $v = $_[1];    # Verbose puts . $! with the error message
	$e .= "\n";
	if ($v) { $e .= $! . "\n"; }

	if ($elenable) {
		&fatal_error_logging($e);
	}
	&LoadIMs;
	$yymain .= qq~
<table border="0" width="80%" cellspacing="1" class="bordercolor" align="center" cellpadding="4">
  <tr>
    <td class="titlebg"><span class="text1"><b>$maintxt{'106'}</b></span></td>
  </tr><tr>
    <td class="windowbg"><br /><span class="text1">$e</span><br /><br /></td>
  </tr>
</table>
<center><br /><a href="javascript:history.go(-1)">$maintxt{'193'}</a></center>
~;
	$yytitle = "$maintxt{'106'}";
	&template;
	exit;

}

sub admin_fatal_error {
	my $e = $_[0];
	my $v = $_[1];    #verbose puts . $! with the error message
	$e .= "\n";
	if ($v) { $e .= $! . "\n"; }

	if ($elenable) {
		&fatal_error_logging($e);
	}
	$yymain .= qq~
<table border="0" width="80%" cellspacing="1" class="bordercolor" align="center" cellpadding="4">
  <tr>
    <td class="titlebg"><span class="text1"><b>$admin_txt{'106'}</b></span></td>
  </tr><tr>
    <td class="windowbg"><br /><span class="text1">$e</span><br /><br /></td>
  </tr>
</table>
<center><br /><a href="javascript:history.go(-1)">$admin_txt{'193'}</a></center>
~;
	$yytitle = "$maintxt{'106'}";
	&AdminTemplate;
	exit;
}

sub readform {
	my (@pairs, $pair, $name, $value);
	if ($ENV{QUERY_STRING} =~ m/action\=dereferer/) {
		$INFO{'action'} = "dereferer";
		$urlstart = index($ENV{QUERY_STRING}, "url=");
		$INFO{'url'} = substr($ENV{QUERY_STRING}, $urlstart + 4, length($ENV{QUERY_STRING}) - $urlstart + 3);
		$INFO{'url'} =~ s/\;anch\=/#/g;
		$testenv = "";
	} else {
		$testenv = $ENV{QUERY_STRING};
		$testenv =~ s/\&/\;/g;
	}

	# URL encoding for web.de http://www.blooberry.com/indexdot/html/topics/urlencoding.htm
	$testenv =~ s/\%3B/;/g;
	$testenv =~ s/\%26/&/g;

	sub split_string {
		my ($string, $hash, $altdelim) = @_;

		if ($altdelim && $$string =~ m~;~) { @pairs = split(/;/, $$string); }
		else { @pairs = split(/&/, $$string); }
		foreach $pair (@pairs) {
			($name, $value) = split(/=/, $pair);
			$name  =~ tr/+/ /;
			$name  =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
			$value =~ tr/+/ /;
			$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

			if (exists($hash->{$name})) {
				$hash->{$name} .= ", $value";
			} else {
				$hash->{$name} = $value;
			}
		}
	}

	split_string(\$testenv, \%INFO, 1);
	if ($ENV{REQUEST_METHOD} eq 'POST') {
		if ($ENV{CONTENT_TYPE} =~ /multipart\/form-data/) {
			use Upload::CGI;
			import Upload::CGI qw(:standard);
			my $query = new CGI;
			my (@keylist) = sort($query->param());
			foreach $key (@keylist) {
				# may be dealing with multiple values; need to join with comma
				$value = join(', ', $query->param($key));
				$FORM{$key} = $value;
				$postsize += length($value);
				$postsize += length($key) + 1;
			}
			if ($query->param('file')) {
				$filename = $query->param('file');
				$tmpfile  = $query->tmpFileName($filename);
				$postsize -= length('file') + 1;
			}
		} else {
			read(STDIN, my $input, $ENV{CONTENT_LENGTH});
			split_string(\$input, \%FORM);
		}
	}
	$action = $INFO{'action'} || $FORM{'action'};

	if ($action eq 'search2') { &FromHTML($FORM{'search'}); }
	&ToHTML($INFO{'title'});
	&ToHTML($FORM{'title'});
	&ToHTML($INFO{'subject'});
	&ToHTML($FORM{'subject'});
}

sub getlog {
	if ($iamguest || $max_log_days_old == 0 || !(-e "$memberdir/$username.log")) { return; }
	my (@entries) = @_;
	unless (defined %yyuserlog) {
		%yyuserlog = ();
		my ($entry, $logentry, $name, $value, $thistime, $adate, $atime, $amonth, $aday, $ayear, $ahour, $amin, $asec);
		my $mintime = $date - ($max_log_days_old * 86400);
		fopen(GETLOG, "$memberdir/$username.log");
		my @logentries = <GETLOG>;
		fclose(GETLOG);
		foreach $entry (@entries) {
			chomp $entry;
			foreach $logentry (@logentries) {
				chomp $logentry;
				($name, $value, $thistime) = split(/\|/, $logentry);
				unless ($name)  { next; }
				if     ($value) {
					$thistime = $value;
				}
				$yyuserlog{$name} = $thistime;
			}
		}
	}
}

sub modlog {
	if ($iamguest || $max_log_days_old == 0) { return; }
	unless (defined %yyuserlog) { &getlog; }
	my ($entry, $dumbtime, $thistime) = @_;
	if ($dumbtime) {
		$thistime = $dumbtime;
	}
	unless ($thistime) {
		$thistime = $date;
	}
	$yyuserlog{$entry} = $thistime;
}

sub dumplog {
	if ($iamguest || $max_log_days_old == 0) { return; }
	if (@_) { &modlog(@_); }
	if (defined %yyuserlog) {
		fopen(DUMPLOG, ">$memberdir/$username.log");
		while ($_ = each(%yyuserlog)) {
			unless ($_) { next; }
			print DUMPLOG qq~$_||$yyuserlog{$_}\n~;
		}
		fclose(DUMPLOG);
	}
}

sub realboardnewpostset {
	if ($iamguest || $max_log_days_old == 0) { return; }
	my ($setboard, $settime) = @_;
	my $edited = 0;

	fopen(REALLOG, "+<$memberdir/$username.log");
	@entries = <REALLOG>;
	for ( $i=0; $i<@entries; $i++ ) {
		if ($entries[$i] =~ m/\A$setboard/) {
			$entries[$i] = "$setboard||$settime\n";
 			$edited = 1;
 			last;
 		}
	}
	if ($edited) {
		seek REALLOG, 0, 0;
		truncate REALLOG, 0;
		print REALLOG @entries;
	}
	fclose(REALLOG);
}

sub jumpto {
	my (@masterdata, $category, @data, $found, $tmp, @memgroups, @newcatdata, $boardname);
	$selecthtml = qq~
<form method="post" action="$scripturl" name="jump" style="display: inline;">
<select name="values" onchange="if(this.options[this.selectedIndex].value) window.location.href='$scripturl' + this.options[this.selectedIndex].value;">
    <option value="">$maintxt{'251'}:</option>
~;
	unless ($mloaded == 1) { require "$boardsdir/forum.master"; }
	foreach $catid (@categoryorder) {
		$boardlist = $cat{$catid};
		(@bdlist) = split(/\,/, $boardlist);
		($catname, $catperms) = split(/\|/, $catinfo{"$catid"});

		$cataccess = &CatAccess($catperms);
		if (!$cataccess) { next; }

		$selecthtml .= qq~    <option value="">-----------------------------</option>
    <option value="?catselect=$catid">$catname</option>
    <option value="">-----------------------------</option>~;
		foreach $board (@bdlist) {
			($boardname, $boardperms, $boardview) = split(/\|/, $board{"$board"});
			&ToChars($boardname);
			my $access = &AccessCheck($board, '', $boardperms);
			if (!$iamadmin && $access ne "granted" && $boardview != 1) { next; }

			if ($board eq $currentboard) { $selecthtml .= "<option selected=\"selected\" value=\"?board=$board\">=> $boardname</option>\n"; }
			else { $selecthtml .= "<option value=\"?board=$board\">&nbsp; - $boardname</option>\n"; }
		}
	}
	$selecthtml .= qq~</select>
    <input type="button" value="$maintxt{'32'}" onclick="if (values.options[values.selectedIndex].value) window.location.href='$scripturl' + values.options[values.selectedIndex].value;" />
</form>~;
}

sub moveto {
	my ($category, $boardname);
	unless ($mloaded == 1) { require "$boardsdir/forum.master"; }
	foreach $catid (@categoryorder) {
		$brdlist = $cat{$catid};
		if(!$brdlist) { next; }
		(@bdlist) = split(/\,/, $brdlist);
		($catname, $catperms) = split(/\|/, $catinfo{"$catid"});

		$cataccess = &CatAccess($catperms);
		if (!$cataccess) { next; }

		$boardlist .= qq~<optgroup label="$catname">~;
		foreach $board (@bdlist) {
			($boardname, $boardperms, $boardview) = split(/\|/, $board{"$board"});
			&ToChars($boardname);
			my $access = &AccessCheck($board, '', $boardperms);
			if (!$iamadmin && $access ne "granted") { next; }
			if ($board ne $currentboard) {
				$boardlist .= qq~<option value="$board">$boardname</option>\n~;
			}
		}
		$boardlist .= qq~</optgroup>~;
	}
}


sub sendmail {
	&LoadLanguage("Smtp");
	($to, $subject, $message, $from) = @_;

	# Do a FromHTML here for $to, and for $mbname
	# Just in case has special chars like & in addresses
	&FromHTML($to);
	&FromHTML($mbname);

	# Change commas to HTML entity - ToHTML doesn't catch this
	# It's only a problem when sending emails, so no change to ToHTML.
	$mbname =~ s/,/&#44;/ig;

	$fromheader = $from ? "$from" : "$mbname <$webmaster_email>";
	$toheader   = $to   ? "$to"   : "$mbname $smtp_txt{'555'} <$webmaster_email>";
	unless ($from) { $from = $webmaster_email; }
	if ($mailtype == 1) { use Socket; }
	$to              =~ s/[ \t]+/, /g;
	$webmaster_email =~ s/.*<([^\s]*?)>/$1/;
	$message         =~ s/^\./\.\./gm;
	$message         =~ s/\r\n/\n/g;
	$message         =~ s/\n/\r\n/g;
	$message         =~ s/<\/*b>//g;
	$smtp_server     =~ s/^\s+//g;
	$smtp_server     =~ s/\s+$//g;
	if (!$to) { return; }

	# Thanks to Graham J for your contribution to this routine
	if ($mailtype == 1) {
		require "$sourcedir/Smtp.pl";
		&use_smtp;
	}
	if ($mailtype == 2) {
		eval q^
			use Net::SMTP;
			my $smtp = Net::SMTP->new($smtp_server, Debug => 0) || die "unable to create Net::SMTP object $smtp_server.";
			$smtp->mail($from); 
			foreach (split(/, /, $to)) {
				$smtp->to($_);
			}
			$smtp->data(); 
			$smtp->datasend("To: $toheader\r\n"); 
			$smtp->datasend("From: $fromheader\r\n"); 
			$smtp->datasend("X-Mailer: YaBB Net::SMTP\r\n"); 
			$smtp->datasend("Subject: $subject\r\n");
			$smtp->datasend("\r\n");
			$smtp->datasend($message);
			$smtp->dataend();
			$smtp->quit();
		^;
		if ($@) {
			&fatal_error("\n<br />Net::SMTP fatal error: $@\n<br />");
			return -77;
		}
		return 1;
	}
	if ($mailtype == 0) {
		$to =~ s/,//g;
		open(MAIL, "| $mailprog  $to");
		print MAIL "To: $toheader\n";
		print MAIL "From: $fromheader\n";
		print MAIL "X-Mailer: YaBB Sendmail\n";
		print MAIL "Subject: $subject\n\n";
		$message =~ s/\r\n/\n/g;
		print MAIL "$message\n";
		close(MAIL);
		return (1);
	}
}

sub spam_protection {

	# Always look on the bright side of life
	# - Monty Python

	unless ($timeout) { return; }
	my ($time, $flood_ip, $flood_time, $flood, @floodcontrol);

	if (-e "$vardir/flood.txt") {
		fopen(FLOOD, "$vardir/flood.txt");
		push(@floodcontrol, "$user_ip|$date\n");
		while (<FLOOD>) {
			chomp($_);
			($flood_ip, $flood_time) = split(/\|/, $_);
			if ($user_ip eq $flood_ip && $date - $flood_time <= $timeout) { $flood = 1; }
			elsif ($date - $flood_time < $timeout) { push(@floodcontrol, "$_\n"); }
		}
		fclose(FLOOD);
	}
	if ($flood && !$iamadmin && $action eq 'post2') { &Preview("$maintxt{'409'} $timeout $maintxt{'410'}"); }
	if ($flood) {
		&fatal_error("$maintxt{'409'} $timeout $maintxt{'410'}");
	}
	fopen(FLOOD, ">$vardir/flood.txt", 1);
	print FLOOD @floodcontrol;
	fclose(FLOOD);
}

sub CountChars {
	$cliped = 0;
	$convertstr =~ s/(\[ch\d{3,}?\])/ $1/ig;
	while ($convertstr =~ m~\<.+?\>~g) { $convertstr =~ s/\s/&#32;/g; }
	$convertstr =~ s/(\<.+?\>)/ $1 /ig;
	my @cwords = split(/\s/, $convertstr);
	$convertstr = "";
	my $curword;
	foreach $curword (@cwords) {
		$curword =~ s/&#32;/ /g;
		$convertstr .= "$curword ";
		if ($curword =~ m~\[ch\d{3,}?\]~ || $curword =~ m~\<.+?\>~) {
			$convertcut += length($curword);
			if (length($convertstr) > $convertcut) {
				$clipdiff = length($curword) - (length($convertstr) - $convertcut);
				$convertcut += $clipdiff;
				$cliped = 1;
				last;
			}
		}
		if (length($convertstr) > $convertcut) {
			$cliped = 1;
			last;
		}
	}
	$convertstr =~ s/ (\<.+?\>) /$1/ig;
	$convertstr =~ s/ (\[ch\d{3,}?\])/$1/ig;
	$convertstr = substr($convertstr, 0, $convertcut);
	$convertstr =~ s/ \Z//;
}

sub WrapChars {
	$wrapstr =~ s/(\&\#\d{3,}?\;)/ $1/ig;
	$wrapstr =~ s~(\S{$wrapcut})~$1 ~gi;
	$tmpwrapcut = $wrapcut;
	my @wwords = split(/\s/, $wrapstr);
	$tmpwrapstr = "";
	$wrapstr    = "";
	my $curword;
	foreach $curword (@wwords) {

		if ($curword =~ m~\&\#\d{3,}?\;~) {
			$tmpwrapcut += length($curword);
		}
		if ((length($tmpwrapstr) + length($curword)) > $tmpwrapcut) {
			$wrapstr .= qq~$tmpwrapstr<br />~;
			$tmpwrapstr = "$curword ";
			$tmpwrapcut = $wrapcut;
		} else {
			$tmpwrapstr .= "$curword ";
		}
	}
	$wrapstr .= qq~$tmpwrapstr~;
	$wrapstr =~ s/ (\&\#\d{3,}?\;)/$1/ig;
	$wrapstr =~ s/ \Z//;
}

sub convFromChars {
	$fcharno = $_[0];
	if ($fcharno > 255) {
		$tcharno = qq~\[ch$fcharno\]~;
	} else {
		$tcharno = qq~\&\#$fcharno\;~;
	}
	return $tcharno;
}

sub convToChars {
	$fcharno = $_[0];
	if ($fcharno > 255) {
		$tcharno = qq~\&\#$fcharno\;~;
	}
	return $tcharno;
}

sub FromChars {
	$_[0] =~ s/&#(\d{3,}?)\;/&convFromChars($1)/eisg;
}

sub ToChars {
	$_[0] =~ s/\[ch(\d{3,}?)\]/&convToChars($1)/eisg;
}

sub ToHTML {
	$_[0] =~ s/&/&amp;/g;
	$_[0] =~ s/"/&quot;/g;
	$_[0] =~ s/  / \&nbsp;/g;
	$_[0] =~ s/</&lt;/g;
	$_[0] =~ s/>/&gt;/g;
	$_[0] =~ s/\|/\&#124;/g;
}

sub FromHTML {
	$_[0] =~ s/&quot;/"/g;
	$_[0] =~ s/&nbsp;/ /g;
	$_[0] =~ s/&lt;/</g;
	$_[0] =~ s/&gt;/>/g;
	$_[0] =~ s/&#124;/\|/g;
	$_[0] =~ s/&amp;/&/g;
}

sub dopre {
	$_ = $_[0];
	$_ =~ s~<br \/>~\n~g;
	$_ =~ s~<br>~\n~g;
	return $_;
}

sub elimnests {
	$_ = $_[0];
	$_ =~ s~\[/*shadow([^\]]*)\]~~ig;
	$_ =~ s~\[/*glow([^\]]*)\]~~ig;
	return $_;
}

sub unwrap {
	$unwrapped = $_[0];
	$unwrapped =~ s~<yabbwrap>~~g;
	$unwrapped = qq~\[code\]$unwrapped\[\/code\]~;
	return $unwrapped;
}

sub wrap {
	$message =~ s~ &nbsp; &nbsp; &nbsp;~\[tab\]~ig;
	$message =~ s~<br \/>~\n~g;
	$message =~ s~<br>~\n~g;
	$message =~ s/((\[ch\d{3,}?\]){$linewrap})/$1\n/ig;

	&FromHTML($message);
	$message =~ s~[\n\r]~ <yabbbr> ~g;
	my @words = split(/\s/, $message);
	$message = "";
	foreach $cur (@words) {
		if ($cur !~ m~www\.(\S+?)\.~ && $cur !~ m~[ht|f]tp://~ && $cur !~ m~\[\S*\]~ && $cur !~ m~\[\S*\s?\S*?\]~ && $cur !~ m~\[\/\S*\]~) { $cur =~ s~(\S{$linewrap})~$1\n~gi; }
		if ($cur !~ m~\[table(\S*)\](\S*)\[\/table\]~ && $cur !~ m~\[url(\S*)\](\S*)\[\/url\]~ && $cur !~ m~\[flash(\S*)\](\S*)\[\/flash\]~ && $cur !~ m~\[img(\S*)\](\S*)\[\/img\]~) {
			$cur =~ s~(\[\S*?\])~ $1 ~g;
			@splitword = split(/\s/, $cur);
			$cur = "";
			foreach $splitcur (@splitword) {
				if ($splitcur !~ m~www\.(\S+?)\.~ && $splitcur !~ m~[ht|f]tp://~ && $splitcur !~ m~\[\S*\]~) { $splitcur =~ s~(\S{$linewrap})~$1<yabbwrap>~gi; }
				$cur .= $splitcur;
			}
		}
		$message .= "$cur ";
	}
	$message =~ s~\[code\](.*?)\[\/code\]~&unwrap($1)~eisg;
	$message =~ s~<yabbbr>~\n~g;
	$message =~ s~<yabbwrap>~\n~g;

	&ToHTML($message);
	$message =~ s~\[tab\]~ &nbsp; &nbsp; &nbsp;~ig;
	$message =~ s~\n~<br />~g;
}

sub wrap2 {
	$message =~ s~<a href=("?)(\S*)("?)(\starget="_blank")?>(\S{$linewrap})(\S*)</a>~<a href=$1$2$3$4>$5\n$6</a>~gi;
}

sub BoardCountTotals {
	my $cntboard = $_[0];
	unless ($cntboard) { return undef; }
	my (@threads, $threadcount, $messagecount, $i, $threadline);

	fopen(BOARD, "$boardsdir/$cntboard.txt");
	@threads = <BOARD>;
	fclose(BOARD);
	$threadcount  = @threads;
	$messagecount = $threadcount;
	if ($threadcount) {
		for ($i = 0; $i < @threads; $i++) {
			@threadline = split(/\|/, $threads[$i]);
			$messagecount += $threadline[5];
		}
	}
	&BoardTotals("load", $cntboard);
	${$uid.$cntboard}{'threadcount'}  = $threadcount;
	${$uid.$cntboard}{'messagecount'} = $messagecount;
	&BoardTotals("update", $cntboard);
	&BoardSetLastInfo($cntboard);
}

sub BoardSetLastInfo {
	my $setboard = $_[0];
	unless ($setboard) { return undef; }
	my ($lastthread, $lastthreadid, @lastthreadmessages, @lastmessage, $lastmessage);

	fopen(BOARD, "$boardsdir/$setboard.txt");
	$lastthread = <BOARD>;
	fclose(BOARD);
	chomp $lastthread;
	if ($lastthread) {
		($lastthreadid, $dummy) = split(/\|/, $lastthread);
		fopen(FILE, "$datadir/$lastthreadid.txt") || &fatal_error("$maintxt{'23'} $lastthreadid.txt", 1);
		@lastthreadmessages = <FILE>;
		fclose(FILE);
		@lastmessage = split(/\|/, $lastthreadmessages[$#lastthreadmessages]);
		&MessageTotals("load", $lastthreadid);
	}
	&BoardTotals("load", $setboard);
	${$uid.$setboard}{'lastposttime'} = $lastthread ? $lastmessage[3]                : 'N/A';
	${$uid.$setboard}{'lastposter'}   = $lastthread ? ${$lastthreadid}{'lastposter'} : 'N/A';
	${$uid.$setboard}{'lastpostid'}   = $lastthread ? $lastthreadid                  : '';
	${$uid.$setboard}{'lastreply'}    = $lastthread ? ${$lastthreadid}{'replies'}    : '';
	${$uid.$setboard}{'lastsubject'}  = $lastthread ? $lastmessage[0]                : '';
	${$uid.$setboard}{'lasticon'}     = $lastthread ? $lastmessage[5]                : '';
	&BoardTotals("update", $setboard);
}

sub RemoveThreadFiles {
	my $removethread = $_[0];
	if ($removethread) {
		if(-e("$vardir/RatingConf.txt"))  { require "$vardir/RatingConf.txt"; }
		if(-e ("$RatesDir/$removethread.rate")) {
			fopen(FILE, "$vardir/rateitlist.txt");
			@ratelist = <FILE>;
			fclose(FILE);
			fopen(FILE, ">$vardir/rateitlist.txt", 1);
			foreach $currate (@ratelist) {
				chomp $currate;
				($thiscurrate, undef, undef, undef) = split(/\|/, $currate);
				if($thiscurrate ne $removethread) { print FILE "$currate\n"; }
			}
			fclose(FILE);
			unlink("$RatesDir/$removethread.rate");
		}
		unlink("$datadir/$removethread.txt");
		unlink("$datadir/$removethread.ctb");
		unlink("$datadir/$removethread.mail");
		unlink("$datadir/$removethread.head");
		unlink("$datadir/$removethread.poll");
		unlink("$datadir/$removethread.polled");
	}
}

sub MembershipGet {
	if (fopen(FILEMEMGET, "$memberdir/members.ttl")) {
		$_ = <FILEMEMGET>;
		chomp;
		fclose(FILEMEMGET);
		return split(/\|/, $_);
	} else {
		my @ttlatest = &MembershipCountTotal;
		return @ttlatest;
	}
}

use Fcntl qw/:DEFAULT/;
unless (defined $LOCK_SH) { $LOCK_SH = 1; }

{
	my %yyOpenMode = (
		'+>>' => 5,
		'+>'  => 4,
		'+<'  => 3,
		'>>'  => 2,
		'>'   => 1,
		'<'   => 0,
		''    => 0);

	# fopen: opens a file. Allows for file locking and better error-handling.
	sub fopen ($$;$) {
		$file_open++;
		my ($filehandle, $filename, $usetmp) = @_;
		if ($debug) { $openfiles .= qq~$filehandle -><br />~; $openfiles_name .= qq~$filename<br />~; }
		my ($flockCorrected, $cmdResult, $openMode, $openSig);

		$serveros = "$^O";
		if ($serveros =~ m/Win/ && substr($filename, 1, 1) eq ":") {
			$filename =~ s~\\~\\\\~g;    # Translate windows-style \ slashes to windows-style \\ escaped slashes.
			$filename =~ s~/~\\\\~g;     # Translate unix-style / slashes to windows-style \\ escaped slashes.
		} else {
			$filename =~ tr~\\~/~;       # Translate windows-style \ slashes to unix-style / slashes.
		}
		$LOCK_EX     = 2;                # You can probably keep this as it is set now.
		$LOCK_UN     = 8;                # You can probably keep this as it is set now.
		$LOCK_SH     = 1;                # You can probably keep this as it is set now.
		$usetempfile = 0;                # Write to a temporary file when updating large files.

		# Check whether we want write, append, or read.
		$filename =~ m~\A([<>+]*)(.+)~;
		$openSig  = $1                    || '';
		$filename = $2                    || $filename;
		$openMode = $yyOpenMode{$openSig} || 0;

		$filename =~ s~[^/\\0-9A-Za-z#%+\,\-\ \.\:@^_]~~g;    # Remove all inappropriate characters.

		if ($filename =~ m~/\.\./~) { &fatal_error("$maintxt{'23'} $filename. $maintxt{'609'}"); }

		# If the file doesn't exist, but a backup does, rename the backup to the filename
		if (!-e $filename && -e "$filename.bak") { rename("$filename.bak", "$filename"); }
		$testfile = $filename;
		if ($use_flock == 2 && $openMode) {
			my $count;
			while ($count < 15) {
				if (-e $filehandle) { sleep 2; }
				else { last; }
				++$count;
			}
			unlink($filehandle) if ($count == 15);
			local *LFH;
			CORE::open(LFH, ">$filehandle");
			$yyLckFile{$filehandle} = *LFH;
		}

		if ($use_flock && $openMode == 1 && $usetmp && $usetempfile && -e $filename) {
			$yyTmpFile{$filehandle} = $filename;
			$filename .= '.tmp';
		}

		if ($openMode > 2) {
			if ($openMode == 5) { $cmdResult = CORE::open($filehandle, "+>>$filename"); }
			elsif ($use_flock == 1) {
				if ($openMode == 4) {
					if (-e $filename) {

						# We are opening for output and file locking is enabled...
						# read-open() the file rather than write-open()ing it.
						# This is to prevent open() from clobbering the file before
						# checking if it is locked.
						$flockCorrected = 1;
						$cmdResult = CORE::open($filehandle, "+<$filename");
					} else {
						$cmdResult = CORE::open($filehandle, "+>$filename");
					}
				} else {
					$cmdResult = CORE::open($filehandle, "+<$filename");
				}
			} elsif ($openMode == 4) {
				$cmdResult = CORE::open($filehandle, "+>$filename");
			} else {
				$cmdResult = CORE::open($filehandle, "+<$filename");
			}
		} elsif ($openMode == 1 && $use_flock == 1) {
			if (-e $filename) {

				# We are opening for output and file locking is enabled...
				# read-open() the file rather than write-open()ing it.
				# This is to prevent open() from clobbering the file before
				# checking if it is locked.
				$flockCorrected = 1;
				$cmdResult = CORE::open($filehandle, "+<$filename");
			} else {
				$cmdResult = CORE::open($filehandle, ">$filename");
			}
		} elsif ($openMode == 1) {
			$cmdResult = CORE::open($filehandle, ">$filename");    # Open the file for writing
		} elsif ($openMode == 2) {
			$cmdResult = CORE::open($filehandle, ">>$filename");    # Open the file for append
		} elsif ($openMode == 0) {
			$cmdResult = CORE::open($filehandle, $filename);        # Open the file for input
		}
		unless ($cmdResult)      { return 0; }
		if     ($flockCorrected) {

			# The file was read-open()ed earlier, and we have now verified an exclusive lock.
			# We shall now clobber it.
			flock($filehandle, $LOCK_EX);
			if ($faketruncation) {
				CORE::open(OFH, ">$filename");
				unless ($cmdResult) { return 0; }
				print OFH '';
				CORE::close(OFH);
			} else {
				truncate(*$filehandle, 0) || &fatal_error("$maintxt{'631'}: $filename");
			}
			seek($filehandle, 0, 0);
		} elsif ($use_flock == 1) {
			if ($openMode) { flock($filehandle, $LOCK_EX); }
			else { flock($filehandle, $LOCK_SH); }
		}
		return 1;
	}

	# fclose: closes a file, using Windows 95/98/ME-style file locking if necessary.
	sub fclose ($) {
		$file_close++;
		$file_open_xtc++;
		my $filehandle = $_[0];
		my $closehandle = $filehandle;
		if ($debug){
			if ($file_open != $file_open_xtc) { $closehandle = "<font color=\"#FF0000\">!!! File not Closed !!!</font><br />"; $closehandle .= "<- $filehandle"; $file_open_xtc = $file_open_xtc+1; } else { $closehandle = "$filehandle"; }
		$openclosefiles .= qq~<- $closehandle<br />~;
		}
		CORE::close($filehandle);
		if ($use_flock == 2) {
			if (exists $yyLckFile{$filehandle} && -e $filehandle) {
				CORE::close($yyLckFile{$filehandle});
				unlink($filehandle);
				delete $yyLckFile{$filehandle};
			}
		}
		if ($yyTmpFile{$filehandle}) {
			my $bakfile = $yyTmpFile{$filehandle};
			if ($use_flock == 1) {

				# Obtain an exclusive lock on the file.
				# ie: wait for other processes to finish...
				local *FH;
				CORE::open(FH, $bakfile);
				flock(FH, $LOCK_EX);
				CORE::close(FH);
			}

			# Switch the temporary file with the original.
			unlink("$bakfile.bak") if (-e "$bakfile.bak");
			rename($bakfile, "$bakfile.bak");
			rename("$bakfile.tmp", $bakfile);
			delete $yyTmpFile{$filehandle};
			if (-e $bakfile) {
				unlink("$bakfile.bak");    # Delete the original file to save space.
			}
		}
		return 1;
	}

}    #/ my %yyOpenMode

sub KickGuest {
	require "$sourcedir/LogInOut.pl";
	$sharedLogin_title = "$maintxt{'633'}";
	$sharedLogin_text  = qq~<br />$maintxt{'634'}<br />$maintxt{'635'} <a href="$scripturl?action=register">$maintxt{'636'}</a> $maintxt{'637'}<br /><br />~;
	$yymain .= qq~<div class="bordercolor" style="width: 400px; margin-bottom: 8px; margin-left: auto; margin-right: auto;">~;
	$yymain .= &sharedLogin;
	$yymain .= qq~</div>~;
	$yytitle = "$maintxt{'34'}";
	&template;
	exit;
}

sub WriteLog {
	require "$sourcedir/Yamms.pl"; &WriteLastIps;
	my ($curentry, $name);
	my $field = $username;
	if ($field eq "Guest") { $field = "$user_ip"; }

	fopen(LOG, "+<$vardir/log.txt");
	seek LOG, 0, 0;
	my @online = <LOG>;
	truncate LOG, 0;
	seek LOG, 0, 0;
## WHOSON MOD START ##
	$who_action = $action;
	$who_thread_num = $INFO{'num'} || $INFO{'thread'};
	if ($currentboard && !$who_action && $INFO{'num'}) { $who_action = "display"; }
	$who_currentboard = $INFO{'board'} || $currentboard;
	print LOG "$field|$date|$user_ip|$username|$who_currentboard|$who_action|$INFO{'username'}|$who_thread_num\n";
	foreach $curentry (@online) {
		$curentry =~ s/\n//g;
		($name, $date1, $orig_ip, $who_username, $who_board, $who_action1, $who_infouser, $who_thread ) = split(/\|/, $curentry);
## WHOSON MOD END ##
		# Case insensitive name-checking, so that you can't be listed twice online
		if (lc($field) eq lc($name)) { next; }
		$date2 = $date;
		chomp $date1;
		chomp $date2;
		&calctime;
		if ($name ne $field && $user_ip ne $name && $result <= ($OnlineLogTime * 60) && $result >= 0) {
			print LOG "$curentry\n";
		}

#		# This check needs to be present to prevent thrashing of the user.vars file
#		if ($result > ($OnlineLogTime * 60)) {
#			if (!${$uid.$name}{'password'}) { &LoadUser($name); }
#			&UserAccount($name, "update", "lastonline");
#		}
	}
	fclose(LOG);
	# rewrite own last online time - per minute
	if (!$iamguest && ${$uid.$username}{'lastonline'} < $date-60) { &UserAccount($username,"update","lastonline");}  

	if ($action eq '' && $enableclicklog == 1) {
		fopen(LOG, "+<$vardir/clicklog.txt", 1);
		my @entries = <LOG>;
		seek LOG, 0, 0;
		truncate LOG, 0;
		if ($ENV{'HTTP_REFERER'} =~ m~$boardurl~i) { $thereferer = ""; }
		else { $thereferer = $ENV{'HTTP_REFERER'}; }
		print LOG "$field|$date|$ENV{'REQUEST_URI'}|$thereferer|$ENV{'HTTP_USER_AGENT'}\n";
		foreach $curentry (@entries) {
			$curentry =~ s/\n//g;
			chomp $curentry;
			($name, $date1, $dummy, $dummy, $dummy) = split(/\|/, $curentry);
			$date2 = $date;
			chomp $date1;
			chomp $date2;
			&calctime;
			$ClickAge = int($result / 60);
			if ($ClickAge <= $ClickLogTime && $ClickAge >= 0) { print LOG "$curentry\n"; }
		}
		fclose(LOG);
	}
}

sub encode_session {
	my ($input, $seed) = @_;
	my ($output, $ascii, $key, $hex, $hexkey, $x);
	$key = substr($seed, length($seed) - 2, 2);
	$hexkey = uc(unpack("H2", pack("I", $key)));
	$x = 0;
	for ($n = 0; $n < length $input; $n++) {
		$ascii = substr($input, $n, 1);
		$ascii = ord($ascii) + $key - $n;
		$hex   = uc(unpack("H2", pack("I", $ascii)));
		$output .= $hex;
		$x++;
		if ($x > 32) { $x = 0; }
	}
	$output .= $hexkey;
	return $output;
}

sub encode_password {
	my $eol = "";
	$eol = $_[0];
	chomp $eol;
	if (eval "require Digest::MD5") {
		use Digest::MD5 qw(md5_base64);
	}

	my $mypass = md5_base64 $eol;
	return $mypass;
}

sub encode_smtp64 {
    if ($] >= 5.006) {
	require bytes;
	if (bytes::length($_[0]) > length($_[0]) ||
	    ($] >= 5.008 && $_[0] =~ /[^\0-\xFF]/))
	{
	    require Carp;
	    Carp::croak("The Base64 encoding is only defined for bytes");
	}
    }
    use integer;
    my $eol = $_[1];
    $eol = "\n" unless defined $eol;

    my $res = pack("u", $_[0]);
    # Remove first character of each line, remove newlines
    $res =~ s/^.//mg;
    $res =~ s/\n//g;
    $res =~ tr|` -_|AA-Za-z0-9+/|;               # `# help emacs
    # fix padding at the end
    my $padding = (3 - length($_[0]) % 3) % 3;
    $res =~ s/.{$padding}$/'=' x $padding/e if $padding;
    # break encoded string into lines of no more than 76 characters each
    if (length $eol) {
	$res =~ s/(.{1,76})/$1$eol/g;
    }
    chomp $res;
    return $res;
}

sub decode_smtp64 ($)
{
    local($^W) = 0; # unpack("u",...) gives bogus warning in 5.00[123]
    use integer;

    my $str = shift;
    $str =~ tr|A-Za-z0-9+=/||cd;            # remove non-base64 chars
    if (length($str) % 4) {
	require Carp;
	Carp::carp("Length of base64 data not a multiple of 4")
    }
    $str =~ s/=+$//;                        # remove padding
    $str =~ tr|A-Za-z0-9+/| -_|;            # convert to uuencoded format
    return "" unless length $str;

    ## I guess this could be written as
    #return unpack("u", join('', map( chr(32 + length($_)*3/4) . $_,
    #			$str =~ /(.{1,60})/gs) ) );
    ## but I do not like that...
    my $uustr = '';
    my ($i, $l);
    $l = length($str) - 60;
    for ($i = 0; $i <= $l; $i += 60) {
	$uustr .= "M" . substr($str, $i, 60);
    }
    $str = substr($str, $i);
    # and any leftover chars
    if ($str ne "") {
	$uustr .= chr(32 + length($str)*3/4) . $str;
    }
    return unpack ("u", $uustr);
}

sub Censor {
	my $string = $_[0];
	foreach $censor (@censored) {
		my ($tmpa,$tmpb,$tmpc) = @{$censor};
		$pattern = q((?:_|&nbsp\;|&lt\;|&gt\;|&amp\;|&quot\;|&#124\;|<br />|\W)*(?!br />));
		$tmpa =~ s/.(?!$)/$&$pattern/gi;
		if ($tmpc) {
			$string =~ s~(^|\W|_)$tmpa(?=$|\W|_)~$1$tmpb~gi;
		} else {
			$string =~ s~$tmpa~$tmpb~gi;
		}
	}
	return $string;
}

sub CheckCensor {
	my $string = $_[0];
	foreach $censor (@censored) {
		my ($tmpa, $tmpb, $tmpc) = @{$censor};
		if ($string =~ m/(\Q$tmpa\E)/i) {
			$found_word .= "$1 ";
		}
	}
	return $found_word;
}

sub YaBBsort {
	my $field = (shift || 0) + 1;    # 0-based field
	my $type = shift || 0;           # 0=numeric; 1=text
	my $case = shift || 0;           # 0=case sensitive; 1=ignore case
	my $dir  = shift || 0;           # 0=increasing; 1=decreasing

	if ($type == 0) {
		if ($dir == 0) {
			$a->[$field] <=> $b->[$field];
		} else {
			$b->[$field] <=> $a->[$field];
		}
	} else {
		if ($case == 0) {
			if ($dir == 0) {
				$a->[$field] cmp $b->[$field];
			} else {
				$b->[$field] cmp $a->[$field];
			}
		} else {
			if ($dir == 0) {
				uc $a->[$field] cmp uc $b->[$field];
			} else {
				uc $b->[$field] cmp uc $a->[$field];
			}
		}
	}
}

sub validation_code {
	require "$sourcedir/Decoder.pl";

	srand();
	# set the max length of the shown verification code
	if (!$codemaxchars || $codemaxchars < 3) { $codemaxchars = 3; }
	$regdate   = int(time);
	$randtime1 = substr($regdate, (length $regdate) - 5, 2);
	$randtime2 = substr($regdate, (length $regdate) - 4, 2);
	$randtime3 = substr($regdate, (length $regdate) - 6, 2);
	$checknum  = int(rand(100));
	$checknum =~ tr/0123456789/ymifxupbck/;
	$_ = int(rand(78));
	$_ =~ tr/0123456789/q8dv7w4jm3/;
	$checknum .= $_;
	$_ = int(rand(99));
	$_ =~ tr/0123456789/7v4sq3dam3/;
	$checknum .= $_;
	$_ = int(rand($randtime1));
	$_ =~ tr/0123456789/poiuyt5ewq/;
	$checknum .= $_;
	$_ = int(rand($randtime2));
	$_ =~ tr/0123456789/2qrt7go0ws/;
	$checknum .= $_;
	$_ = int(rand($randtime2));
	$_ =~ tr/0123456789/lk9hgfdaut/;
	$checknum .= $_;
	$checknum = substr($checknum, 0, $codemaxchars);
	# making a mess of the validation code

	$scramble = &encode_password($regdate);
	for ($n = 0; $n < 9; $n++) {
		$scramble .= &encode_password($scramble);
	}
	$scramble =~ s/\//y/g;
	$scramble =~ s/\+/x/g;
	$scramble =~ s/\-/Z/g;
	$scramble =~ s/\:/Q/g;

	$positioner = $regdate;
	$positioner .= $regdate;
	$regdate   = substr($positioner, 0, length $checknum);
	@position  = ();
	@character = ();
	$sessionid = "";
	$showcheck = "";
	$lastvalue = 13;
	for ($n = 0; $n < length $checknum; $n++) {
		$letter = substr($checknum, $n, 1);
		$value = (substr($regdate, $n, 1)) + $lastvalue + 1;
		$lastvalue = $value;
		substr($scramble, $value, 1) = $letter;
	}
	$sessionid = $scramble;
	$showcheck = qq~<img src="$scripturl?action=validate\;_session_id_=$sessionid\;regdate=$regdate" border="0" alt="" />~;
	return $sessionid;
	return $showcheck;
	return $regdate;
}

sub referer_check {
	$referencedomain = substr($boardurl, 7, (index($boardurl, "/", 7)) - 7);
	$refererdomain = substr($ENV{HTTP_REFERER}, 7, (index($ENV{HTTP_REFERER}, "/", 7)) - 7);
	if ($refererdomain !~ /$referencedomain/ && $ENV{QUERY_STRING} ne "" && length($refererdomain) > 0) {
		$goodaction = 0;
		fopen(ALLOWED, "$vardir/allowed.txt");
		@allowed = <ALLOWED>;
		fclose(ALLOWED);
		foreach $allow (@allowed) {
			chomp $allow;
			if ($action ne "" && $action eq $allow) { $goodaction = 1; last; }
		}
		if ($goodaction == 0 && $action ne "") { &fatal_error("$reftxt{'5'} $action<br />$reftxt{'7'} $referencedomain<br />$reftxt{'6'} $refererdomain"); }
	}
}

sub Dereferer {
	print "Content-Type: text/html\n\n";
	$refresh = qq~<html>\n<head>\n</head>\n<body Onload = document.location="$INFO{'url'}" target="_top">\n<font face="Arial" size="2">$dereftxt{'1'}</font>\n</body></html>\n~;
	print $refresh;
	exit;
}

sub MailTo {
	if ($iamguest) { &fatal_error("$ml_txt{'223'}"); }
	my $mailusername = $INFO{'user'};
	my $mailcrypted  = $INFO{'mail_id'};
	&LoadUser($mailusername);    # If user is not in memory, s/he must be loaded.
	if (${$uid.$mailusername}{'email'} && (${$uid.$mailusername}{'hidemail'} ne "checked" || $iamadmin) && $mailusername ne "Guest") {
		$truemail = ${$uid.$mailusername}{'email'};
	} elsif ($mailusername eq "Guest") {
		$truemail = &descramble($mailcrypted, $mailusername);
	} else {
		fatal_error("$ml_txt{'801'}");
	}
	print "Content-Type: text/html\n\n";
	$refresh = qq~<html>\n<head>\n
	<script>
		var tik=0
		function timer() {
		  	window.setTimeout("timer()", 2000)
			tik=tik+1
			if(tik==2){
				window.close()
			}
		}
	</script>
	</head>\n
	<body Onload = document.location="mailto:$truemail">\n
	<font face="Arial" size="2">$dereftxt{'3'}</font>\n
	<script language="JavaScript1.2" type="text/javascript">\n
	timer();
	</script>
	</body></html>\n~;
	print $refresh;
}

sub LoadLanguage {
	my $what_to_load = $_[0];
	my $use_lang     = $language ? $language : $lang;

	if (-e "$langdir/$use_lang/$what_to_load.lng") {
		require "$langdir/$use_lang/$what_to_load.lng";
	} elsif (-e "$langdir/$lang/$what_to_load.lng") {
		require "$langdir/$lang/$what_to_load.lng";
	} elsif (-e "$langdir/English/$what_to_load.lng") {
		require "$langdir/English/$what_to_load.lng";
	} else {
		&fatal_error("$use_lang/$what_to_load.lng - $maintxt{'775'}");
	}
}

sub Recent_Load {
	my $who_to_load = $_[0];
	if (-e "$memberdir/$who_to_load.wlog") {
		require "$memberdir/$who_to_load.wlog";
		&Recent_Save($who_to_load);
		unlink "$memberdir/$who_to_load.wlog";
	}
	if (-e "$memberdir/$who_to_load.rlog") {
		fopen(RLOG, "$memberdir/$who_to_load.rlog");
		%recent = map /(.*)\t(.*)/, <RLOG>;
		fclose(RLOG);
	}
}

sub Recent_Write {
	my ($todo, $recentthread, $recentuser) = @_;
	&Recent_Load($recentuser);
	if($todo eq "incr") {
		unless (exists($recent{$recentthread})) { $recent{$recentthread} = 0; }
		$recent{$recentthread}++;
	}
	if($todo eq "decr") {
		$recent{$recentthread}--;
		if ($recent{$recentthread} < 1) { delete $recent{$recentthread}; }
	}
	&Recent_Save($recentuser);
}

sub Recent_Save {
	my $who_to_save = $_[0];
	fopen(RLOG, ">$memberdir/$who_to_save.rlog");
	print RLOG map "$_\t$recent{$_}\n", keys %recent;
	fclose(RLOG);
	undef %recent;
	if (!-s "$memberdir/$who_to_save.rlog") { unlink("$memberdir/$who_to_save.rlog"); }
}

sub Write_ForumMaster {
	fopen(FORUMMASTER, ">$boardsdir/forum.master", 1);
	print FORUMMASTER qq~\$mloaded = 1;\n~;
	@catorder = &undupe(@categoryorder);
	print FORUMMASTER qq~\@categoryorder = qw(@catorder);\n~;
	while (($key, $value) = each(%cat)) {

		# Escape membergroups with a $ in them
		$value =~ s~\$~\\\$~g;
		# Strip membergroups with a ~ from them
		$value =~ s/\~//g;
		print FORUMMASTER qq~\$cat{'$key'} = qq\~$value\~;\n~;
	}
	while (($key, $value) = each(%catinfo)) {

		# Escape membergroups with a $ in them
		$value =~ s~\$~\\\$~g;
		# Strip membergroups with a ~ from them
		$value =~ s/\~//g;
		print FORUMMASTER qq~\$catinfo{'$key'} = qq\~$value\~;\n~;
	}
	while (($key, $value) = each(%board)) {

		# Escape membergroups with a $ in them
		$value =~ s~\$~\\\$~g;
		# Strip membergroups with a ~ from them
		$value =~ s/\~//g;
		print FORUMMASTER qq~\$board{'$key'} = qq\~$value\~;\n~;
	}
	print FORUMMASTER qq~\n1;~;
	fclose(FORUMMASTER);
}

sub memparse {
	foreach $line (@_) {
		$line =~ s~(.*?)\t(.*?)~$1~isg;
	}
	return @_;
}

sub scramble {
	my ($input, $user) = @_;

	# creating a codekey based on userid
	$carrier = "";
	for ($n = 0; $n < length $user; $n++) {
		$ascii = substr($user, $n, 1);
		$ascii = ord($ascii);
		$carrier .= $ascii;
	}
	while (length($carrier) < length($input)) { $carrier .= $carrier; }
	$carrier = substr($carrier, 0, length($input));
	my $scramble = &encode_password($user);
	for ($n = 0; $n < 9; $n++) {
		$scramble .= &encode_password($scramble);
	}
	$scramble =~ s/\//y/g;
	$scramble =~ s/\+/x/g;
	$scramble =~ s/\-/Z/g;
	$scramble =~ s/\:/Q/g;

	# making a mess of the input
	$lastvalue = 3;
	for ($n = 0; $n < length $input; $n++) {
		$letter = substr($input, $n, 1);
		$value = (substr($carrier, $n, 1)) + $lastvalue + 1;
		$lastvalue = $value;
		substr($scramble, $value, 1) = $letter;
	}

	# adding code length to code
	my $len = length($input) + 65;
	$scramble .= chr($len);
	return $scramble;
}

sub descramble {
	my ($input, $user) = @_;

	# creating a codekey based on userid
	$carrier = "";
	for ($n = 0; $n < length($user); $n++) {
		$ascii = substr($user, $n, 1);
		$ascii = ord($ascii);
		$carrier .= $ascii;
	}
	my $orgcode   = substr($input, length($input) - 1, 1);
	my $orglength = ord($orgcode);

	while (length($carrier) < $orglength - 65) { $carrier .= $carrier; }
	$carrier = substr($carrier, 0, length($input));

	$lastvalue  = 3;
	$descramble = "";

	# getting code length from encrypted input
	for ($n = 0; $n < $orglength - 65; $n++) {
		$value = (substr($carrier, $n, 1)) + $lastvalue + 1;
		$letter = substr($input, $value, 1);
		$lastvalue = $value;
		$descramble .= qq~$letter~;
	}
	return $descramble;
}

sub dirstats {
	use File::Find;
	my ($size, $used_space, $free_space) = 0;
	&find(sub { $dirsize += -s }, $uploaddir);
	$used_space  = int($dirsize / 1024);
	$spaceleft   = ($mydirlimit - $dirsize);
	$kbspaceleft = ($dirlimit - $used_space);
}

sub clear_temp {
	if ($filename) {
		close($filename);
	}
	if (-e $tmpfile && $tmpfile ne '') {
		close($tmpfile);
		unlink $tmpfile || &fatal_error("Error deleting tempfile '$tmpfile': $!\n");
	}
}

sub write_error {
	my $e = $_[0];
	&clear_temp;
	&LoadIMs;    # Load IM's
	$yymain .= qq~
<table border="0" width="80%" cellspacing="1" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center" cellpadding="4">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}"><font size="2" class="text1" color="$color{'titletext'}"><b>$maintxt{'106'}</b></font></td>
  </tr><tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}"><br /><font size="2">$e</font><br /><br /></td>
  </tr>
</table>
<center><br /><a href="javascript:history.go(-1)">$txt{'250'}</a></center>
~;
	$yytitle = "$txt{'106'}";
	&template;
	exit;

}

sub MemberPageindex {
	my ($msindx, $trindx, $mbindx);
	($msindx, $trindx, $mbindx) = split(/\|/, ${$uid.$username}{'pageindex'});
	if ($INFO{'action'} eq "memberpagedrop") {
		${$uid.$username}{'pageindex'} = qq~$msindx|$trindx|0~;
	}
	if ($INFO{'action'} eq "memberpagetext") {
		${$uid.$username}{'pageindex'} = qq~$msindx|$trindx|1~;
	}
	&UserAccount($username, "update");
	$yySetLocation = qq~$scripturl?action=ml;sort=$INFO{'sort'};letter=$INFO{'letter'};start=$INFO{'start'}~;
	&redirectexit;
}

sub check_existence {
	my ($dir, $filename) = @_;
	my ($exists, $barename, $filenumb, $filext, $origname);
	my $numdelim = "_";

	opendir(DIR, "$dir");
	@existingfiles = readdir(DIR);
	closedir(DIR);

	$origname = $filename;
	$origname =~ s/(\S+?)(\.\S+$)/$1/i;
	$filext = $2;
	foreach $exists (sort @existingfiles) {
		if ($exists eq $filename) {
			$barename = $filename;
			$barename =~ s/(\S+?)(\.\S+$)/$1/i;
			$barename =~ s/($origname)$numdelim(\d+$)/$1/i;
			$filenumb = $2 || 0;
			$filenumb++;
			$filenumb = sprintf("%03d", $filenumb);
			$filename = qq~$barename$numdelim$filenumb$filext~;
		}
	}
	return ($filename);
}

sub ManageMemberlist {
	my $todo    = $_[0];
	my $user    = $_[1];
	my $userreg = $_[2];
	if ($todo eq "load" || $todo eq "update" || $todo eq "delete" || $todo eq "add") {
		fopen(MEMBLIST, "$memberdir/memberlist.txt");
		%memberlist = map /(.*)\t(.*)/, <MEMBLIST>;
		fclose(MEMBLIST);
	}
	if ($todo eq "add") {
		$memberlist{$user} = "$userreg";
	}
	if ($todo eq "update") {
		$memregtime = $memberlist{$user};
		if ($userreg) { $memregtime = qq~$userreg~; }
		$memberlist{$user} = "$memregtime";
	}
	if ($todo eq "delete") {
		require "$sourcedir/UsersAvatars.pl";
		&UsersAvatarsDEL($user);
		&UsersAvatarsLOG($user,0,0);
		delete($memberlist{$user});
		unlink("$vardir/eventcalbday.db"); ## EventCal Mod ##
	}
	if ($todo eq "save" || $todo eq "update" || $todo eq "delete" || $todo eq "add") {
		fopen(MEMBLIST, ">$memberdir/memberlist.txt");
		print MEMBLIST map "$_\t$memberlist{$_}\n", sort { lc $memberlist{$a} cmp lc $memberlist{$b} } keys %memberlist;
		fclose(MEMBLIST);
		undef %memberlist;
	}
}

sub ManageMemberinfo {
	my $todo       = $_[0];
	my $user       = $_[1];
	my $userdisp   = $_[2];
	my $usermail   = $_[3];
	my $usergrp    = $_[4];
	my $usercnt    = $_[5];
	my $useraddgrp = $_[6];
	my $userrepa = $_[7];
	if ($todo eq "load" || $todo eq "update" || $todo eq "delete" || $todo eq "add") {
		fopen(MEMBINFO, "$memberdir/memberinfo.txt");
		%memberinf = map /(.*)\t(.*)/, <MEMBINFO>;
		fclose(MEMBINFO);
	}
	if ($todo eq "add") {
	      $memberinf{$user} = "$userdisp|$usermail|$usergrp|$usercnt|$useraddgrp|$userrepa";
	}
	if ($todo eq "update") {
		($memrealname, $mememail, $memposition, $memposts, $memaddgrp, $memrepa) = split(/\|/, $memberinf{$user});
		if ($userdisp)   { $memrealname = qq~$userdisp~; }
		if ($usermail)   { $mememail    = qq~$usermail~; }
		if ($usergrp)    { $memposition = qq~$usergrp~; }
		if ($usercnt)    { $memposts    = $usercnt; }
		if ($useraddgrp) { $memaddgrp   = $useraddgrp; }
		if ($userrepa) { $memrepa   = $userrepa; }
		$memberinf{$user} = "$memrealname|$mememail|$memposition|$memposts|$memaddgrp|$memrepa";
	}
	if ($todo eq "delete") {
		require "$sourcedir/UsersAvatars.pl";
		&UsersAvatarsDEL($user);
		&UsersAvatarsLOG($user,0,0);
		delete($memberinf{$user});
	}
	if ($todo eq "save" || $todo eq "update" || $todo eq "delete" || $todo eq "add") {
		fopen(MEMBINFO, ">$memberdir/memberinfo.txt");
		print MEMBINFO map "$_\t$memberinf{$_}\n", keys %memberinf;
		fclose(MEMBINFO);
		undef %memberinf;
	}
}

sub Collapse_Load {
	my (@userhide, $hidden);
	$colbutton = 1;
	my $i = 0;
	@userhide = split(/\,/, ${$uid.$username}{'cathide'});
	foreach my $key (@categoryorder) {
		my ($catname, $catperms, $catallowcol) = split(/\|/, $catinfo{$key});
		$access = &CatAccess($catperms);
		if ($catallowcol == 1 && $access) { $i++; }
		$catcol{$key} = 1;
		foreach $hidden (@userhide) {
			chomp $hidden;
			if ($catallowcol == 1 && $key eq $hidden) { $catcol{$key} = 0; }
		}
	}
	if ($i == @userhide) { $colbutton = 0; }
	$colloaded = 1;
}

sub getMailFiles {
	opendir(BOARDNOT, "$boardsdir");
	@bmaildir = grep { /\.mail$/ } readdir(BOARDNOT);
	closedir(BOARDNOT);
	opendir(THREADNOT, "$datadir");
	@tmaildir = grep { /\.mail$/ } readdir(THREADNOT);
	closedir(THREADNOT);
}

sub MailList {
	&is_admin_or_gmod;
	my ($ntime, $nsubject, $ntext, $nsender, $delmailline);
	if (!$INFO{'delmail'}) {
		$mailline = $_[0];
		$mailline =~ s~\r~~g;
		$mailline =~ s~\n~<br />~g;
		($ntime, $nsubject, $ntext, $nsender) = split(/\|/, $mailline);
	} else {
		$delmailline = $INFO{'delmail'};
	}
	if (-e ("$vardir/maillist.dat")) {
		fopen(FILE, "$vardir/maillist.dat");
		@maillist = <FILE>;
		fclose(FILE);
		fopen(FILE, ">$vardir/maillist.dat");
		if (!$INFO{'delmail'}) {
			print FILE "$mailline\n";
		}
		foreach $curmail (@maillist) {
			chomp $curmail;
			($otime, $osubject, $otext, $osender) = split(/\|/, $curmail);
			if ($FORM{'reused'} != $otime && $otime ne $delmailline) {
				print FILE "$curmail\n";
			}
		}
		fclose(FILE);
	} else {
		fopen(FILE, ">$vardir/maillist.dat");
		print FILE "$mailline\n";
		fclose(FILE);
	}
	if ($INFO{'delmail'}) {
		$yySetLocation = qq~$adminurl?action=mailing~;
		&redirectexit;
	}
}


sub SetNewsFaderColors {

	if (-e("$vardir/NewsFaderColors.txt"))  {
		require "$vardir/NewsFaderColors.txt";
	}
	if($newsfadertemplate_all ne 1) {
		$templatefix = $template;
		$templatefix =~ s~ ~_~g;
		$templatefix =~ s~\-~_minus_~g;
		$templatefix =~ s~\+~_plus_~g;
		$color{'fadertext'} = $fadertext{$templatefix};
		$color{'faderbg'} = $faderbg{$templatefix};
	} else {
		$default_templatefix = $default_template;
		$default_templatefix =~ s~ ~_~g;
		$default_templatefix =~ s~\-~_minus_~g;
		$default_templatefix =~ s~\+~_plus_~g;
		$color{'fadertext'} = $fadertext{$default_templatefix};
		$color{'faderbg'} = $faderbg{$default_templatefix};		
	}
}

sub SetSpoilerColors {

	if (-e("$vardir/SimpleSpoiler.txt"))  {
		require "$vardir/SimpleSpoiler.txt";
	}
	if($template_all ne 1) {
		$templatefix = $template;
		$templatefix =~ s~ ~_~g;
		$color{'spoilerbackground'} = $background{$templatefix};
		$color{'spoilerborder'} = $border{$templatefix};
	} else {
		$default_templatefix = $default_template;
		$default_templatefix =~ s~ ~_~g;
		$color{'spoilerbackground'} = $background{$default_templatefix};
		$color{'spoilerborder'} = $border{$default_templatefix};		
	}
}

1;
