#!/usr/bin/perl --

push(@INC, "./Modules");

if ($ENV{'SERVER_SOFTWARE'} =~ /IIS/) {
	$yyIIS = 1;
	$0 =~ m~(.*)(\\|/)~;
	$yypath = $1;
	$yypath =~ s~\\~/~g;
	chdir($yypath);
	push(@INC, $yypath);
}

$script_root = $ENV{'SCRIPT_FILENAME'};
$script_root =~ s/\/YaBB\.(pl|cgi)//ig;

$rebuild = 0;

if (-e "Paths.pl") { require "Paths.pl"; }
elsif (-e "$script_root/Paths.pl") { require "$script_root/Paths.pl"; }

if(-e "$vardir/Settings.pl") { require "$vardir/Settings.pl"; }
elsif(-e "Settings.pl") { require "Settings.pl"; }
require "$sourcedir/Subs.pl";
require "$sourcedir/System.pl";
require "$sourcedir/Load.pl";
require "$sourcedir/DateTime.pl";
&LoadLanguage("Main");
&ConvertLocation;
&output;
exit;


sub ConvertLocation {
	$mapconvertdir = qq~./Convert/Members~;
	if(-e ("$vardir/mmlist.txt")) {
		fopen(MMLIST, "$vardir/mmlist.txt");
		@mmlist = <MMLIST>;
		fclose(MMLIST);
	}
	foreach $mapmember (@mmlist) {
		chomp $mapmember;
		if (-e "$mapconvertdir/$mapmember.vars") {
			fopen(OLDMAP, "$mapconvertdir/$mapmember.vars");
			%oldmapped = map /'(.*)'\,"(.*)"/, <OLDMAP>;
			fclose(OLDMAP);

			&LoadUser($mapmember);

			${$uid.$mapmember}{'location'} = "$oldmapped{'location'}";
			${$uid.$mapmember}{'country'} = "$oldmapped{'country'}";
			${$uid.$mapmember}{'state'} = "$oldmapped{'state'}";
			${$uid.$mapmember}{'map'} = "$oldmapped{'map'}";
			${$uid.$mapmember}{'xcoord'} = "$oldmapped{'xcoord'}";
			${$uid.$mapmember}{'ycoord'} = "$oldmapped{'ycoord'}";
			undef %oldmapped;
			&UserAccount($mapmember,"update");
			$rebuild++;
			$converted .= qq~<tr><td>&nbsp;$mapmember</td><td>&nbsp;${$uid.$mapmember}{'location'}</td><td>&nbsp;${$uid.$mapmember}{'state'}</td><td>&nbsp;${$uid.$mapmember}{'country'}</td><td>&nbsp;${$uid.$mapmember}{'map'}</td></tr>~;
		}
	}
}

sub output {
	print qq~
	<!DOCTYPE html PUBLIC "-//W3C//DTD Xhtml 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	<head>
	<title>$yytitle</title>
	<meta http-equiv="Content-Type" content="text/html; charset=$yycharset" />
	</head>
	<body style="font-family: verdana; font-size: 10px;">
	<table cellspacing="0" cellpadding="3" border="1" align="center" bordercolor="#000000">
	<tr><td colspan="5" style="color: #ffffff; background-color: #000000;"><b>Member Map location rebuild completed! Members rebuild: $rebuild</b></td></tr>
	<tr><td align="center"><b>User</b></td><td align="center"><b>Location</b></td><td align="center"><b>State/Region</b></td><td align="center"><b>Country</b></td><td align="center"><b>Map</b></td></tr>
	$converted
	</table>
	</body>
	</html>~;
exit;
}

1;