###############################################################################
#                                                                             #
# MemberMap.pm    by XTC                                                      #
# Version:        Beta 2				                      #
# Date:           01 / 2015                                                   #
# Distributed by: http://www.xonder.com/cgi-bin/yabb26/YaBB.pl                #
#                                                                             #
# =========================================================================== #
#                                                                             #
# NOTE: Goggle Maps is a registered trademark of Google Inc.                  #
#       The author declines every responsability about this software          #
#                                                                             #
# =========================================================================== #
#                                                                             #
# Copyright (c) 2015 ..::X.T.C::....M.o.d.s::.. - All Rights Reserved.        #
#       The author declines every responsability about this software          #
#                                                                             #
###############################################################################
###############################################################################
#       #           #            ##############           ##############      #
#        #         #                    #                 #                   #
#         #       #                     #                 #                   #
#          #     #                      #                 #                   #
#           #   #                       #                 #                   #
#            # #                        #                 #                   #
#             #                         #                 #                   #
#            # #                        #                 #                   #
#           #   #                       #                 #                   #
#          #     #                      #                 #                   #
#         #       #                     #                 #                   #
#        #         #                    #                 #                   #
#       #           #                   #                 ##############      #
###############################################################################

$membermappmver = 'MemberMap YaBB 2.6.11 Beta 2';
if ( $action eq 'detailedversion' ) { return 1; }

LoadLanguage("MemberMap");
LoadLanguage('MemberMapCountry');

#<----------------------------------------------->#
# MAIN PROGRAM
#<----------------------------------------------->#

$pic_membermap = qq~<img src="$modimgurl/MemberMap/mapIcons/google-maps-icon.png" alt="" />~;
$pic_pin = qq~<img src="$modimgurl/MemberMap/mapIcons/pin.png" alt="" />~;
$pic_search = qq~<img src="$imagesdir/search.png" alt="" />~;
$pic_male = qq~<img src="$modimgurl/MemberMap/mapIcons/marker_blue.png" width="9" height="16" alt="$load_txt{'male'}" title="$load_txt{'male'}" />~;
$pic_female = qq~<img src="$modimgurl/MemberMap/mapIcons/marker_red.png" width="9" height="16" alt="$load_txt{'female'}" title="$load_txt{'female'}" />~;
$pic_na = qq~<img src="$modimgurl/MemberMap/mapIcons/marker_green.png" width="9" height="16" alt="$maintxt{'470'}" title="$load_txt{'female'}" />~;




if ( $MarkerAnimation == 1 ) {
    $AniStyle_a       = qq~          marker.setAnimation(google.maps.Animation.BOUNCE);~;
    $AniStyle_b       = qq~          marker.setAnimation(null);~;
    $AniStyle_Sidebar = qq~          side_bar_html += '<a href="javascript:myclick(' + marker_num + ')" onmouseover="gmarkers['+marker_num+'].setAnimation(google.maps.Animation.BOUNCE)" onmouseout="gmarkers['+marker_num+'].setAnimation(null)">' + name + '<\/a><br \/>';~;
} else {
    $AniStyle_a       = qq~          marker.setIcon(gicons["yellow"]);~;
    $AniStyle_b       = qq~          marker.setIcon(gicons[color]);~;
    $AniStyle_Sidebar = qq~          side_bar_html += '<a href="javascript:myclick(' + marker_num + ')" onmouseover="gmarkers['+marker_num+'].setIcon(gicons.yellow)" onmouseout="gmarkers['+marker_num+'].setIcon(gicons.' + color + ')">' + name + '<\/a><br \/>';~;
}

if ($ZoomControlStyle) { $Zoom_ControlStyle = qq~	zoomControlOptions: {      style: google.maps.ZoomControlStyle.SMALL    },~; }

    ManageMemberinfo('load');
    fopen( USERMAP, "$vardir/membermap.db" );
    my @membersmap = <USERMAP>;
    fclose(USERMAP);
    @sortmap = sort{lc($a) cmp lc($b)} (@membersmap);
    $mapentry_f = 0;
    $mapentry_m = 0;
    $mapentry_n = 0;

    foreach my $user_mapname (@sortmap) {
        chomp $user_mapname;
        ( $user_mname, $user_lat, $user_long, $user_zoom, $user_hide, $user_flag )
          = split /\|/xsm, $user_mapname;

        unless ( $user_lat eq q{} || $user_long eq q{} ) { 
        $memmaprealname = ( split /\|/xsm, $memberinf{$user_mname}, 2 )[0];

                if ($Map_ColorLinks) {
                    LoadUser($user_mname);
                    $user_linkprofile = $link{$user_mname};
                }
                else {
                    $user_linkname = $memmaprealname;
                    LoadUser($user_mname);
                    if ( $iamguest ) {
                        $user_linkprofile = qq~$format_unbold{$user_mname}~;
                    }
                    else {
                        $user_linkprofile =
qq~<a href="$scripturl?action=viewprofile;username=$useraccount{$user_mname}" rel="nofollow">$format_unbold{$user_mname}</a>~;
                    }
                }

            $mapuserOnline   = userOnLineStatus($user_mname);
            $mapuserOnlinea  = "$mapuserOnline<br />";
            $mapuserOnline   =~ s/$maintxt{'60'}/&nbsp;/gsm;
            $mapuserOnline   =~ s/$maintxt{'61'}/&nbsp;/gsm;
            $mapuserInfoname  = "$map_txt{'name'}:";
            
            if ( ${ $uid . $user_mname }{'location'} ) {
                $userlocation =
                    qq~<br />$map_txt{'location'}: ~
                  . ${ $uid . $user_mname }{'location'}
                  . q~<br />~;
            }
            if ( $user_flag ) {
                $userflag =
                    qq~$map_country{$user_flag}<br /><div class="f16"><i class="flag $user_flag"></i></div>~;
            } else { $userflag = q{}; }

            if ( ${ $uid . $user_mname }{'gender'} eq 'Female' ) {
                $usergender = "red";        $mapentry_f++;
            } elsif ( ${ $uid . $user_mname }{'gender'} eq 'Male' ) {
                $usergender = "blue";       $mapentry_m++;
            } else { $usergender = "green"; $mapentry_n++; }

$makerJS .= qq~['$user_lat','$user_long','$mapuserOnlinea <span class="small">$mapuserInfoname $user_linkprofile $userlocation $userflag</span>','$mapuserOnline $format_unbold{$user_mname}','$memmaprealname','$usergender'],\n~;

	$mapentry++;
        }
    }
    undef %memberinf;

#<----------------------------------------------->#
# MemberMap JS
#<----------------------------------------------->#

$mapJS = qq~
<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false&language=$abbr_lang"></script> 
<script type="text/javascript" src="$modimgurl/MemberMap/js/markerclusterer.js"></script>
<link href="$modimgurl/MemberMap/css/flags16.css" rel="stylesheet" type="text/css" />
<script type="text/javascript">
    var locations = [
$makerJS
    ];
      var side_bar_html = "$map_txt{'members'}<br \/><hr class='hr' \/>"; 
      var gmarkers = []; 
      var gicons = [];
      var markers = [];
      var map=null;
      var geocoder = null;

function getMarkerImage(iconColor) {
   if ((typeof(iconColor)=="undefined") || (iconColor==null)) { 
      iconColor = "green"; 
   }
   if (!gicons[iconColor]) {
      gicons[iconColor] = new google.maps.MarkerImage("$modimgurl/MemberMap/mapIcons/marker_"+ iconColor +".png",
          new google.maps.Size(20, 34),
          new google.maps.Point(0,0),
          new google.maps.Point(9, 34)
      );
   } 
   return gicons[iconColor];

}

      gicons["red"] = getMarkerImage("red");
      gicons["blue"] = getMarkerImage("blue");
      gicons["green"] = getMarkerImage("green");
      gicons["yellow"] = getMarkerImage("yellow");
// Create the marker and set up the event window function 
function createMarker(latlng,name,html,title,color) {
    var contentString = html;
    var marker = new google.maps.Marker({
        position: latlng,
        icon: gicons[color],
        map: map,
        title: title,
        zIndex: Math.round(latlng.lat()*-100000)<<5
        });

    google.maps.event.addListener(marker, 'click', function() {
        infowindow.setContent(contentString); 
        infowindow.open(map,marker);
	map.setCenter(marker.getPosition());
	map.setZoom(7);
        });
        // Switch icon on marker mouseover and mouseout
        google.maps.event.addListener(marker, "mouseover", function() {
          $AniStyle_a
        });
        google.maps.event.addListener(marker, "mouseout", function() {
          $AniStyle_b
        });
        gmarkers.push(marker);
// Add a line to the side_bar html
    var marker_num = gmarkers.length-1;
    $AniStyle_Sidebar
}

// Pick up the click and opens the corresponding info window
function myclick(i) {
    google.maps.event.trigger(gmarkers[i], "click");
}

// Zoom out Button function
function myclickout(i) {
    var center = new google.maps.LatLng(0, 0);
    var zoom = 2;
	map.setCenter(center);
	map.setZoom(zoom);
	infowindow.close();
}

// Create the google map
function initialize() {
        geocoder = new google.maps.Geocoder();
    var myOptions = {
        zoom: 2,
        center: new google.maps.LatLng(0,0),
        mapTypeControl: true,
        mapTypeControlOptions: {style: google.maps.MapTypeControlStyle.$MapTypeControlStyle},
        navigationControl: true,
	$Zoom_ControlStyle
        mapTypeId: google.maps.MapTypeId.$MapTypeId
  }
    map = new google.maps.Map(document.getElementById("map_canvas"),
                                myOptions);
    google.maps.event.addListener(map, 'click', function() {
        infowindow.close();
        });

// Read user location data
    for (i = 0; i < locations.length; i++) {
        var lat = locations[i][0];
        var lng = locations[i][1];
        var html = locations[i][2];
        var label = locations[i][3];
        var title = locations[i][4];
        var gender = locations[i][5];
        var point = new google.maps.LatLng(lat,lng);
// create the marker
        var marker = createMarker(point,label,html,title,gender);
    }
// Put the side_bar_html contents into the side_bar div
        document.getElementById("side_bar").innerHTML = side_bar_html;
~;

if ($MarkerClusterer){
$mapJS .= qq~
// MarkerClusterer function
    var mcOptions = {
	minimumClusterSize: $minClusterSize,
	gridSize: $gridSize
    };
    var mc = new MarkerClusterer(map, gmarkers, mcOptions);
~;
}

$mapJS .= qq~
}

// Function Dropdown Menu Select continent or country 
function findAddress(address) {
    if (!address) 
    var address=document.getElementById("countryselect").value;
    if ((address != '') && geocoder) {
      geocoder.geocode( { 'address': address}, function(results, status) {
        google.maps.event.addListenerOnce(map, 'center_changed', centerChanged);
        google.maps.event.addListenerOnce(map, 'bounds_changed', centerChanged);
        if (status == google.maps.GeocoderStatus.OK) {
          if (status != google.maps.GeocoderStatus.ZERO_RESULTS) {
           if ((results && results[0] && results[0].formatted_address) && (results[0].formatted_address == "Antarctica"))  {
             map.setCenter(new google.maps.LatLng(-75,0));
             map.setZoom(3);
           } else if (results && results[0] && results[0].geometry && results[0].geometry.viewport)  {
             map.fitBounds(results[0].geometry.viewport);
	     var htmlStr = results[0].formatted_address+"<br>";
             htmlStr += "viewport="+results[0].geometry.viewport.toUrlValue(6)+"<br>";
             htmlStr += "bounds="+results[0].geometry.bounds.toUrlValue(6)+"<br>";
             document.getElementById('info').innerHTML = htmlStr;
           } else if (results && results[0] && results[0].geometry && results[0].geometry.bounds) {

             map.fitBounds(results[0].geometry.bounds);
	     var htmlStr = results[0].formatted_address+"<br>";
             htmlStr += "bounds="+results[0].geometry.bounds.toUrlValue(6)+"<br>";
             document.getElementById('info').innerHTML = htmlStr;
           } else {
	     var htmlStr = results[0].formatted_address+""<br>"";
             document.getElementById('info').innerHTML = htmlStr;
           }

          } else {
            alert("$map_txt{'noresults'}");
          }
        } else {
          alert("$map_txt{'geocode'} " + status);
        }
      });
    }
}
function centerChanged() {
    document.getElementById('info').innerHTML += "<br>center="+map.getCenter().toUrlValue(6)+"<br>map.getBounds="+map.getBounds().toUrlValue(6);
        google.maps.event.addListenerOnce(map,'center_changed', function() {
        	document.getElementById('info').innerHTML += "<br>center="+map.getCenter().toUrlValue(6)+"<br>map.getBounds="+map.getBounds().toUrlValue(6);
        });
    if (map.getCenter().lat() < -85) {
        google.maps.event.addListenerOnce(map,'center_changed', function() {
            map.setZoom(3);
        });
       map.setCenter(new google.maps.LatLng(-75,0));
    } else if (map.getCenter().lat() > 85) {
        google.maps.event.addListenerOnce(map,'center_changed', function() {
            map.setZoom(3);
        });
       map.setCenter(new google.maps.LatLng(75,0));
    }
}
    var infowindow = new google.maps.InfoWindow(
      { 
       size: new google.maps.Size(150,50)
      });
    google.maps.event.addDomListener(window, "load", initialize);
</script>
~;

$yyinlinestyle .= qq~
$mapJS
~;

#<----------------------------------------------->#
# Member Map access check
#<----------------------------------------------->#

    if ( !$Show_MemberMap && !$iamadmin && !$iamgmod ) { fatal_error('no_access');     }
    if ( $iamguest && $Show_MemberMap == 1 )           { fatal_error('members_only'); }

#<----------------------------------------------->#
# Get the country iso2 code @ MemberMapCountry.lng
#<----------------------------------------------->#

    fopen( FILE, "$langdir/$language/MemberMapCountry.lng" );
    @countrylines = <FILE>;
    fclose(FILE);

    foreach my $scriptline (@countrylines) {
        chomp $scriptline;
        if ( substr( $scriptline, 0, 1 ) eq q{'} ) {    #';
            if ( $scriptline =~ /\'(.*?)\'/xsm ) {
                $actionfound = $1;
        $map_country{$actionfound} =~ s/"/'/gxsm;    # '" XHTML Validation
                $countstring = "$map_country{$actionfound}\n";
        push @countrylines1, $countstring;
            }
        }
    }
    foreach my $cline ( sort { lc($a) cmp lc $b } @countrylines1 ) {
        chomp $cline;
        $countrymenu .=
qq~<option value="$cline">$cline</option>\n~;
    }

#<----------------------------------------------->#
# MemberMap Overview
#<----------------------------------------------->#

sub MemberMap {


	$yymain .= qq~
	<table class="tabtitle pad_3px">
		<tr>
		 <td style="padding-left:1%">$pic_membermap $map_txt{'membermap'} </td>
		 <td class="right" style="padding-right:1%">
		    <select id="countryselect" name="countryselect" class="textfeld" onchange="findAddress();return false" onfocus="">
			<option value=''>$map_txt{'countryb'}</option>
			<option value=''>-----------</option>
			$countrymenu
		    </select> $pic_search
		 </td>
		</tr>
	</table>
	<table class="bordercolor pad_3px cs_thin" >
		<tr>
		 <td class="windowbg2 left">
			<table>
			  <tr>
			    <td>
				<div id="map_canvas" style="position: relative; height: 550px; width: 100%"></div>
				<input type="hidden" id="info">
			    </td>
			    <td class="vtop" width="206">
				<div id="side_bar" class="small nav" style="float: right; width: 205px; height: 395px; overflow: auto; border: 2px dashed #B0C4DE; padding: 3px;"></div><br />
				<div class="small nav" style="float: right; width: 205px; height: 115px; border: 2px dashed #B0C4DE; padding: 3px;">$map_txt{'continent'}<br /><img border="0" src="$modimgurl/MemberMap/mapIcons/continents.png" usemap="#FPMap0" width="200" height="101"></div><br />
				<input style="width: 215px;" type="button" value="$map_txt{'zoomout'}"  onclick="myclickout();return false"  onchange="myclickout();return false" onfocus="">
			    </td>
			  </tr>
			</table>	
			<map name="FPMap0">
				<area title="$map_txt{'continent0'}" href="javascript:findAddress('Africa')" shape="polygon" coords="90, 28, 83, 38, 89, 51, 100, 54, 101, 69, 104, 72, 111, 66, 123, 67, 118, 58, 120, 49, 121, 44, 113, 30">
				<area title="$map_txt{'continent1'}" href="javascript:findAddress('Antarctica')" shape="polygon" coords="69, 88, 84, 91, 142, 87, 162, 92, 153, 100, 35, 100, 32, 95">
				<area title="$map_txt{'continent2'}" href="javascript:findAddress('Asia')" shape="polygon" coords="127, 43, 164, 55, 177, 4, 139, 0, 124, 3, 124, 24, 112, 28, 121, 44">
				<area title="$map_txt{'continent3'}" href="javascript:findAddress('Australia')" shape="polygon" coords="151, 64, 152, 71, 159, 73, 173, 76, 177, 70, 184, 63, 172, 49">
				<area title="$map_txt{'continent4'}" href="javascript:findAddress('Europe')" shape="polygon" coords="121, 6, 96, 7, 86, 26, 138, 36, 104, 29, 120, 21, 117, 13">
				<area title="$map_txt{'continent5'}" href="javascript:findAddress('NorthAmerika')" shape="polygon" coords="31, 44, 92, 0, 61, 2, 29, 3, 14, 13, 23, 14, 23, 29">
				<area title="$map_txt{'continent6'}" href="javascript:findAddress('SouthAmerika')" shape="polygon" coords="49, 45, 46, 52, 52, 62, 54, 69, 56, 77, 62, 83, 69, 72, 80, 55, 53, 40">
			</map>
		 </td>
		</tr>
	</table>
        <table class="tabtitle-bottom pad_3px">
            <tr>
                <td class="small">
                    <div style="float: left; width: 40%; text-align: left; padding-left:1%">$map_txt{'members'} $map_txt{'mapinfo1'} $mapentry $map_txt{'mapinfo2'}</div>
                    <div style="float: left; width: 57%; text-align: right; padding-right:1%"><span style="padding-right:60px">$pic_male $load_txt{'male'} ($mapentry_m) $pic_female $load_txt{'female'} ($mapentry_f) $pic_na $maintxt{'470'} ($mapentry_n)</span><span class="useronline"></span>$maintxt{'60'} <span class="useroffline"></span>$maintxt{'61'} <span class="useraway"></span>$maintxt{'away'}</div>
                </td>
            </tr>
        </table>
	~;

	$yynavigation = qq~&rsaquo; $map_txt{'membermap'} $pic_pin~;
	$yytitle = "$map_txt{'membermap'}";
	template();
	exit;
}

#<----------------------------------------------->#
# The Happy End :)
#<----------------------------------------------->#

1;
