<id>
Member Moods for YaBB 2.6.11
</id>

<version>
0.2
</version>

<mod info>
Description
-----------
Allows Members to select their Mood

Installation
------------
1) Modify YaBB files using BoardMod or manually.
2) Upload modified files to your server in ASCII mode.
3) Upload Mood.lng to Languages/English/Mods
4) Upload ChangeMood.pm to Sources/Mods.
5) Upload Mood.template to Templates/default/Mods.
6) Upload the Mood images folder to the ModImages directory in Binary mode.
7) Upload mood.css to yabbfiles/Templates/Forum

Files to edit
-------------
Admin/ModList.pm
Admin/NewSettings.pm
Admin/Settings_Main.pm
Sources/Display.pm
Sources/Load.pm
Sources/MemberList.pm
Sources/MyCenter.pm
Sources/Profile.pm
Sources/Subs.pm
Sources/SubList.pm
Sources/System.pm
Templates/default/Display.template
Templates/default/MyCenter.template
Templates/default/MyProfile.template

Version History
---------------
1.0 - First release by Derek Barnstorm - 5th August 2008
1.1 - Made new images, aligned text and image better, added more moods and added preview image in User CP - 1st October 2008
1.2 - Updated for YaBB 2.3 - 14th October 2008
1.3 - Updated for YaBB 2.3.1 - 4th January 2009
1.4 - Updated for YaBB 2.4 and added ability to change mood by clicking on the image (Martin_W) - 4th May 2009
1.5 - Added to Member List and fixed issue with some users receiving Form Spoofing message - 6th July 2009
1.6 - Updated for YaBB 2.5 - 13th January 2011
1.7 - Updated for YaBB 2.6.0 by Dandello - 13 July, 2014
1.7a - fixed typos.
1.8 - Updated for YaBB 2.6.1 by Dandello - 6 Sept, 2014
2.1 - Updated for YaBB 2.6.1 by Dandello (new css file) 21 Oct, 2014
2.6.11 v0.1 - Updated for YaBB 2.6.1 Dec 31, 2014
0.2 - bug fixes - Jan 21, 2014
</mod info>

<author>
Derek Barnstorm and Martin_W
</author>

<homepage>
http://www.yabbforumsoftware,com
</homepage>

<edit file>
Admin/ModList.pm
</edit file>

<search for>
### END BOARDMOD ANCHOR ###
</search for>

<add before>
    $mod_mood = q~Member Moods|Derek Barnstorm and Martin_W, updated for 2.6.11 by Dandello|Allows Members to select their Mood|0.2|Jan 21, 2015~;
    push @installed_mods, $mod_mood;
</add before>

<edit file>
Admin/NewSettings.pm
</edit file>

<search for>
1;
EOF
</search for>

<add before>
\$showmoodimage = $showmoodimage;           # Set to 1 to display each members mood in the message view
\$showmood = $showmood;                     # Set to 1 to display each members mood in profile
\$showmoodml = $showmoodml;                 # Set to 1 to display each members mood in the member list
\$showmoodicon = $showmoodicon;                 # Set to 1 to display each members mood as an icon only
\$allowselectmood = $allowselectmood;       # Set to 1 to allow members to select mood
</add before>

<edit file>
Admin/Settings_Main.pm
</edit file>

<search for>
LoadLanguage('Register');
</search for>

<add after>
LoadLanguage('Mods/Mood');
</add after>

<search for>
            name => 'showgenderimage',
            validate => 'boolean',
        },
</search for>

<add after>
        {
            description => qq~<label for="showmoodimage">$mood_txt{'04'}</label>~,
            input_html => qq~<input type="checkbox" name="showmoodimage" id="showmoodimage" value="1"${ischecked($showmoodimage)} />~,
            name => 'showmoodimage',
            validate => 'boolean',
        },
        {
            description => qq~<label for="showmood">$mood_txt{'05'}</label>~,
            input_html => qq~<input type="checkbox" name="showmood" id="showmood" value="1"${ischecked($showmood)} />~,
            name => 'showmood',
            validate => 'boolean',
        },
        {
            description => qq~<label for="showmoodml">$mood_txt{'05a'}</label>~,
            input_html => qq~<input type="checkbox" name="showmoodml" id="showmoodml" value="1"${ischecked($showmoodml)} />~,
            name => 'showmoodml',
            validate => 'boolean',
        },
        {
            description => qq~<label for="showmoodicon">$mood_txt{'05b'}</label>~,
            input_html => qq~<input type="checkbox" name="showmoodicon" id="showmoodicon" value="1"${ischecked($showmoodicon)} />~,
            name => 'showmoodicon',
            validate => 'boolean',
        },
</add after>

<search for>
        {
            description => qq~<label for="allowpics">$admin_txt{'746'}</label>~,
</search for>

<add before>
        {
            description => qq~<label for="allowselectmood">$mood_txt{'03'}</label>~,
            input_html => qq~<input type="checkbox" name="allowselectmood" id="allowselectmood" value="1"${ischecked($allowselectmood)} />~,
            name => 'allowselectmood',
            validate => 'boolean',
        },
</add before>

<edit file>
Sources/Display.pm
</edit file>

<search for>
        $outblock =~ s/{yabb gender}/${$uid.$musername}{'gender'}/gsm;
</search for>

<add after>
        $outblock =~ s/{yabb mood}/${$uid.$musername}{'mood'}/gsm;
</add after>

<edit file>
Sources/Load.pm
</edit file>

<search for>
    }
    else {
        ${ $uid . $user }{'gender'} = q{};
    }
</search for>

<add after>

    if ($showmoodimage && $allowselectmood && ${ $uid . $user }{'mood'} ne 'NoMood') {
        LoadLanguage('Mods/Mood');
        my $moodtxt = ${ $uid . $user }{'mood'};
        my $moodicon = $moodimg{$moodtxt};
        if ( $showmoodicon ) {
            $moodicon = qq~<img src="$modimgurl/Mood/$moodtxt$moodext" title="$moodlist{$moodtxt}" />~;
        }
        if ($username eq $user) {
            $moodlinkjavascript = qq~
            <script type="text/javascript">
            function Moodlink() {
            window.open('$scripturl?action=changemood', '', 'menubar=no,toolbar=no,top=50,left=50,scrollbars=yes,resizable=yes,width=450,height=300');
            }
            </script>~;
            ${ $uid . $user }{'mood'} = ${ $uid . $user }{'mood'} ? qq~<div style="padding-top:5px"><span style="vertical-align: middle;">$mood_txt{'01'}:</span> $moodlinkjavascript<a href="javascript:void(0);" onclick="Moodlink()" style="color:#000">$moodicon</a></div>~ : q{};
        }
        elsif ($username ne $user) {
            ${ $uid . $user }{'mood'} = ${ $uid . $user }{'mood'} ? qq~<div style="padding-top:5px"><span style="margin-top:1em"><span style="vertical-align: top;">$mood_txt{'01'}:</span> $moodicon</span></div>~ : q{};
        }
    }
    else {
        ${ $uid . $user }{'mood'} = q{};
    }
</add after>

<edit file>
Sources/MemberList.pm
</edit file>

<search for>
                $dr_warning =
qq~$ml_txt{'dr_warning'} <a href="$boardurl/AdminIndex.$yyaext?action=newsettings;page=main">$ml_txt{'dr_warnurl'}</a>~;
            }
        }
</search for>

<add after>

        if ($showmoodml && $allowselectmood && ${ $uid . $user }{'mood'} ne 'NoMood') {
            LoadLanguage('Mods/Mood');
            my $moodtxt = ${ $uid . $user }{'mood'};
            my $moodicon = $moodimg{$moodtxt};
            if ( $showmoodicon ) {
                $moodicon = qq~<img src="$modimgurl/Mood/$moodtxt$moodext" title="$moodlist{$moodtxt}" />~;
            }
            if ($username eq $user) {
                $moodlinkjavascript = qq~
            <script type="text/javascript">
            function Moodlink() {
            window.open('$scripturl?action=changemood', '', 'menubar=no,toolbar=no,top=50,left=50,scrollbars=yes,resizable=yes,width=450,height=300');
            }
            </script>~;
                $mood = ${ $uid . $user}{'mood'} ? qq~<div style="padding-top:5px"><span class="small" style="vertical-align: top;">$mood_txt{'01'}:</span> $moodlinkjavascript<a href="javascript:void(0);" onclick="Moodlink()" style="color:#000">$moodicon</a></div>~ : q{};
            }
            elsif ($username ne $user) {
                $mood = ${ $uid . $user }{'mood'} ? qq~<div style="padding-top:5px"><span class="small" style="vertical-align: top;">$mood_txt{'01'}:</span> $moodicon</div>~ : q{};
            }
        }
        else { $mood = q{};}
</add after>

<search for>
        $yymain =~ s/{yabb userlink}/$link{$user}/sm;
</search for>

<replace>
        $yymain =~ s/{yabb userlink}/$link{$user}$mood/sm;
</replace>

<edit file>
Sources/MyCenter.pm
</edit file>

<search for>
        $myprofileblock =~
          s/{yabb gender}/${$uid.$username}{'gender'}/gsm;
</search for>

<add after>
        $myprofileblock =~ s/{yabb mood}/${$uid.$username}{'mood'}/gsm;
</add after>

<edit file>
Sources/Profile.pm
</edit file>

<search for>
    if ($extendedprofiles) {
        require Sources::ExtendedProfiles;
        my $show_ext_prof = ext_editprofile( $user, 'edit' );
        $my_show_ext_prof = $show_ext_prof;
    }
</search for>

<add after>

    my $sel_mood = q{};
    if ($allowselectmood) {
        LoadLanguage('Mods/Mood');
        if (${$uid.$user}{'mood'} eq $NoMood) { $NoMood = 'NoMood'; }
        else { $NoMood = ${$uid.$user}{'mood'}; }
        my @moodlist = sort { lc $moodlist{$a} cmp lc $moodlist{$b} } keys %moodlist;
        my $my_mood_opt = q{};
        for ( @moodlist ) {
            $sel = q{};
            if ( $NoMood eq $_ ) { $sel = ' selected="selected" ';}
            $my_mood_opt .= qq~        <option value="$_"$sel>$moodlist{$_}</option>\n~
        }

        my $moodclass= qq~class='mood bold $NoMood'~;
        if ($NoMood eq 'NoMood' ) {
            $moodclass= q~class='bold'~;
        }
        my $moodicon = qq~<span id="moodspan" $moodclass><img src='$modimgurl/Mood/$NoMood$moodext' id='moodicons' alt='' /> <span id="moodtxt">$moodlist{$NoMood}</span> </span>~;
        if ( $showmoodicon ) {
            $moodicon = qq~<img src='$modimgurl/Mood/$NoMood$moodext' id='moodicons' title='$moodlist{$NoMood}' />~;
        }

        $sel_mood = $myprofile_mood;
        $sel_mood =~ s/{yabb mood01}/$mood_txt{'01'}/sm;
        $sel_mood =~ s/{yabb lang}/${ $uid . $user}{'language'}/gsm;
        $sel_mood =~ s/{yabb nomood}/$NoMood/gsm;
        $sel_mood =~ s/{yabb moodext}/$moodext/gsm;
        $sel_mood =~ s/{yabb my_mood_opt}/$my_mood_opt/gsm;
        $sel_mood =~ s/{yabb showmoodicon}/$moodicon/gsm;
        $sel_mood =~ s/{yabb showmoodcol1}/$mymoodcol1/gsm;
    }
</add after>

<search for>
    $showProfile =~ s/{yabb editAgeTxt}/$editAgeTxt/sm;
</search for>

<add after>
    $showProfile =~ s/{yabb my_mood}/$sel_mood/sm;
</add after>

<search for>
        ToHTML( $member{'gender'} );
</search for>

<add after>
        ToHTML( $member{'mood'} );
</add after>

<search for>
        ${ $uid . $user }{'gender'}   = $member{'gender'};
</search for>

<add after>
        ${ $uid . $user}{'mood'}      = $member{'mood'};
</add after>

<search for>
        $row_addgrp .= qq~$showaddgr<br />~;
    }
</search for>

<add after>

    if ($showmood && $allowselectmood && ${$uid.$user}{'mood'} ne 'NoMood' && ${$uid.$user}{'mood'} ne q{}) {
        LoadLanguage('Mods/Mood');
        my $moodtxt = ${ $uid . $user }{'mood'};
        my $moodicon = $moodimg{$moodtxt};
        if ( $showmoodicon ) {
            $moodicon = qq~<img src="$modimgurl/Mood/$moodtxt$moodext" title="$moodlist{$moodtxt}" />~;
        }
        if ($username eq $user) {
            $moodlinkjavascript = qq~
            <script type="text/javascript">
            function Moodlink() {
            window.open('$scripturl?action=changemood', '', 'menubar=no,toolbar=no,top=50,left=50,scrollbars=yes,resizable=yes,width=450,height=300');
            }
            </script>~;
            $row_mood .= qq~<div style="padding-top:5px"><span style="vertical-align: top;">$mood_txt{'01'}:</span> $moodlinkjavascript<a href="javascript:void(0);" onclick="Moodlink()" style="color:#000">$moodicon</a></div>~;
        }
        else {
            $row_mood .= qq~<div style="padding-top:5px"><span class="small" style="vertical-align: top;">$mood_txt{'01'}:</span> $moodicon</div>~;
        }
    }
</add after>

<search for>
    $showProfile =~ s/{yabb my_online}/$my_online/sm;
</search for>

<add after>
    $showProfile =~ s/{yabb mood}/$row_mood/sm;
</add after>

<edit file>
Sources/Subs.pm
</edit file>

<search for>
    $yystyle =
qq~<link rel="stylesheet" href="$yyhtml_root/Templates/Forum/$usestyle.css" type="text/css" />\n~;
</search for>

<add after>
    if ( $action eq 'myprofile' || $action eq 'mycenter' || ( $showmoodimage && $INFO{'num'} ) || ( $showmoodml && $action eq 'ml' ) || ( $showmood && $action eq 'viewprofile' ) ) {
        $yystyle .= qq~<link rel="stylesheet" href="$yyhtml_root/Templates/Forum/mood.css" type="text/css" />\n~;
    }
</add after>

<edit file>
Sources/SubList.pm
</edit file>

<search for>
1;
</search for>

<add before>
$director{'changemood'} = 'Mods/ChangeMood.pm&changemood';
$director{'changemood2'} = 'Mods/ChangeMood.pm&changemood2';
</add before>

<edit file>
Sources/System.pm
</edit file>

<search for>
   ## Mod hook ##
</search for>

<add before>
    push @tags, 'mood';
</add before>

<edit file>
Templates/default/Display.template
</edit file>

<search for>
                        {yabb gender}
</search for>

<add after>
                        {yabb mood}
</add after>

<edit file>
Templates/default/MyCenter.template
</edit file>

<search for>
        {yabb gender}
</search for>

<add after>
        {yabb mood}
</add after>

<edit file>
Templates/default/MyProfile.template
</edit file>

<search for>
            </select>{yabb genderField}
        </td>
    </tr>
</search for>

<add after>
{yabb my_mood}
</add after>

<search for>
{yabb my_online}
            <br />
</search for>

<add after>
{yabb mood}
</add after>

<search for>
1;
</search for>

<add before>
$myprofile_mood = qq~<tr class="windowbg">
    <td><label for="mood"><b>{yabb mood01}: </b></label></td>
    <td>
        <script type="text/javascript">
            function showmoodimage() {
                if (!document.images) return;
                var mymood = mood.options[mood.selectedIndex].value;
                var mymoodt = mymoodcol1[ mymood ][ "mtitle" ] ;
                document.images.moodicons.src = "$modimgurl/Mood/" + mymood + "{yabb moodext}";
                document.images.moodicons.title = mymoodt;~;
    if (!$showmoodicon) {
        $myprofile_mood .= q~
                moodtxt.textContent = mymoodt;
             if ( mymood == "NoMood" ) {
                moodspan.setAttribute("class", "bold");
            }
            else {
                moodspan.setAttribute("class", "mood bold " + mymood);
            }~;
    }
$myprofile_mood .= q~            }
         </script>
   <span style="vertical-align: middle;">
    <select name="mood" id="mood" size="1" onchange="showmoodimage();">
{yabb my_mood_opt}
   </select>
   </span>&nbsp;&nbsp; {yabb showmoodicon}
   {yabb showmoodcol1}
   </td>
 </tr>~;
 
</add before>
