###############################################################################
# ChangeMood.pm                                                               #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.6.11                                                 #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2014 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
###############################################################################

$changemoodpmver = 'YaBB 2.6.11 $Revision: 0.1 $';
if ($action eq 'detailedversion') { return 1; }

LoadLanguage('Mods/Mood');

if ($iamguest) { fatal_error('no_access'); }

sub changemood {

    if (${$uid.$username}{'mood'} eq $NoMood) { $NoMood = 'NoMood'; }
    else { $NoMood = ${$uid.$username}{'mood'}; }
    my @moodlist = sort { lc $moodlist{$a} cmp lc $moodlist{$b} } keys %moodlist;
    $mood_out = q{};
    for ( @moodlist ) {
    $sel = q{};
    if ( $NoMood eq $_ ) { $sel = ' selected="selected" ';}
        $mood_out .= qq~        <option value="$_"$sel>$moodlist{$_}</option>\n~
    }
    get_template('Mods/Mood');
    if ( $showmoodicon == 1 ) {
        $my_showmoodicon = q~
                            document.images.moodicons.title = mymoodt;~;
    }
    else { 
        $my_showmoodicon = q~
                                moodtxt.textContent = mymoodt;
                            if ( mymood == "NoMood" ) {
                                moodspan.setAttribute("class", "bold");
                            }
                            else {
                                moodspan.setAttribute("class", "mood bold " + mymood);
                            }~;
    }
    my $moodicon = qq~<span id='moodspan' class='mood bold $NoMood'><img src='$modimgurl/Mood/$NoMood$moodext' id='moodicons' alt='' /> <span id='moodtxt'>$moodlist{$NoMood}</span> </span>~;
    if ( $showmoodicon ) {
        $moodicon = qq~<img src='$modimgurl/Mood/$NoMood$moodext' id='moodicons' title='$moodlist{$NoMood}' />~;
    }
    $output = $mymood;
    $output =~ s/{yabb moodicon}/$moodicon/gsm;
    $output =~ s/{yabb my_showmoodicon}/$my_showmoodicon/gsm;
    $output =~ s/{yabb mymoodout}/$mymoodout/gsm;
    $output =~ s/{yabb mymoodcol1}/$mymoodcol1/gsm;
    $output =~ s/{yabb moodext}/$moodext/gsm;
    $output =~ s/{yabb mood_out}/$mood_out/gsm;

    print_output_header();
    print_HTML_output_and_finish();
}

sub changemood2 {

    if ($iamguest || !$FORM{'mood'}) { fatal_error('no_access'); }

    ${$uid.$username}{'mood'} = $FORM{'mood'};
    UserAccount($username, 'update');

    get_template('Mods/Mood');
    $output = $mymood_2;

    print_output_header();
    print_HTML_output_and_finish();
}

1;