###############################################################################
# NewsIndex.pl                                                                #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        0.4 beta (YaBB 2.0/2.1)                                     #
# Released:       August 10, 2006                                             #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2005 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$newsindexplver = 'YaBB 2.1 $Revision: 0.3 $';
if ($action eq 'detailedversion') { return 1; }

LoadLanguage("NewsIndex");
if (-e "$vardir/newsvars.txt") { require "$vardir/newsvars.txt"; }

sub NewsIndex {
	$enable_ubbc = 1;
	
	if($INFO{'newsboard'}) {
		$newsboard = $INFO{'newsboard'};
	}
	if($INFO{'temp'}) {
		$temp = $INFO{'temp'};
	}
	else {
		$temp = "newsTemplate";
	}

	fopen(BRDTXT, "$boardsdir/$newsboard.txt")|| &fatal_error("300 $txt{'106'}: $txt{'23'} $newsboard.txt", 1);
	@threadlist = <BRDTXT>;
	fclose(BRDTXT);
	$threadcount = $#threadlist;
	$threadcount = $threadcount + 1;

	$start = $newsitems;

	chomp @threadlist;

	@threadnums = ();

	foreach(@threadlist) {
		($mnum,$mextra) = split(/\|/,$_);
		push(@threadnums, $mnum);
	}
	
	@threadnums = sort{$b <=> $a}(@threadnums);

	@threadnums = splice(@threadnums, 0, $start);

	$counter = 0;

	foreach(@threadnums) {
		
		@windowbgs = ("windowbg", "windowbg2");
		$windownum = scalar @windowbgs;

		$yywindowbg = $windowbgs[($counter % $windownum)];

		$mnum = $_;
		if($mnum == "") { next; }
		
		fopen(THRDTXT, "$datadir/$mnum.txt") || &fatal_error("300 $txt{'106'}: $txt{'23'} $mnum.txt", 1);
		@postlist = <THRDTXT>;
		fclose(THRDTXT);
		$replycount = $#postlist;
		@postlist = splice(@postlist,0,1);
		chomp @postlist;
		foreach(@postlist) {
			($msub2,$mname2,$memail2,$mnum2,$musername2,$micon2,$mstate2,$mip2,$mtext2,$mi,$mj,$mk,$ml) = split(/\|/,$_);
			$mtext = $mtext2;
			$mname = $mname2;
			$msub = $msub2;
			$msub =~ s/\A\[m\]/$maintxt{'758'}/;
			$muser = $musername2;
		}
		
		fopen(LOADUSER, "$memberdir/$muser.vars");
		my @settings = <LOADUSER>;
		fclose(LOADUSER);
		foreach $setting (@settings) {
			chomp $setting;
			unless (length($setting) == 0) {
				$setting =~ s/\'(.*?)\'\,\"(.*?)\"//ig;
				my $tag   = $1;
				my $value = $2;
				$$tag = $value;
			}
		}
		
		$memail = $hidemail;
		
		# Censor the subject and message.
		$mtext = &Censor($mtext);
		$msub        = &Censor($msub);
		&ToChars($msub);

		# Run UBBC interpreter on the message.
		$message = $mtext;
		&wrap;
		if ($enable_ubbc) {
			if (!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; }
			&DoUBBC;
		}
		&wrap2;
		&ToChars($message);


		$mdate = &timeformat($mnum);

		if($replycount > 0) {
			$mlink = "$mnum/1#1";
		}
		else {
			$mlink = "$mnum";
		}
			
		if($topiclink == 1) {
			$yynewsSub = qq~<a href='$scripturl?num=$mnum'>$msub</a>~;
		}
		else {
			$yynewsSub = $msub;
		}			

		$yynewsDate = $mdate;
		$yynewsMessage = $message;
		
		$yynewsposter_txt = $news_txt{'12'};
		$yynewscomment_txt = $news_txt{'13'};

		if($posterlink == 1 && $memail ne "checked") {
			$yynewsPoster = qq~<a href='$scripturl?action=mailto;user=$muser'>$mname</a>~;
		}
		elsif($posterlink == 2) {
			$yynewsPoster = qq~<a href='$scripturl?action=viewprofile;username=$muser'>$mname</a>~;
		}
		else {
			$yynewsPoster = $mname;
		}
		
		if($commentlink == 1) {
			$yynewsComments = qq~<a href='$scripturl?num=$mlink'>$replycount</a>~;
		}
		elsif($commentlink == 2) {
			$yynewsComments = qq~<a href='$scripturl?num=$mnum/new'>$replycount</a>~;
		}
		elsif($commentlink == 3) {
			$yynewsComments = qq~<a href='$scripturl?num=$mnum/$replycount#$replycount'>$replycount</a>~;
		}
		else {
			$yynewsComments = $replycount;
		}
		
		&NewsStyle($temp);

		$counter++;

	}
	
	&NewsTemplate;

	exit;
	
}

sub NewsTemplate {

	my $gzaccept = $ENV{'HTTP_ACCEPT_ENCODING'} =~ /\bgzip\b/ || $gzforce;

	#print header
	if ($gzcomp && $gzaccept) {
		if ($yySetCookies1 || $yySetCookies2 || $yySetCookies3) {
			$cookiewritten = "Cookie Set";
			print header(-status            => '200 OK',
				'Content-Encoding' => 'gzip',
				-cookie  => [$yySetCookies1, $yySetCookies2, $yySetCookies3],
				-charset => $yycharset);
		} else {
			print header(-status            => '200 OK',
				'Content-Encoding' => 'gzip',
				-charset           => $yycharset);
		}
	} else {
		if ($yySetCookies1 || $yySetCookies2 || $yySetCookies3) {
			$cookiewritten = "Cookie Set";
			print header(-status => '200 OK',
				-cookie  => [$yySetCookies1, $yySetCookies2, $yySetCookies3],
				-charset => $yycharset);
		} else {
			print header(-status  => '200 OK',
				-charset => $yycharset);
		}
	}

	if($INFO{'type'} eq "java") {
		$yynewsmain =~ s/\'/\"/g;
		$yynewsmain =~ s/\n//g;
		$output = qq~
		document.write('$yynewsmain');
		~;
	}
	else {
		$output = $yynewsmain;
	}
	
	# do output
	if ($gzcomp && $gzaccept) {
		if ($gzcomp == 1) {
			$| = 1;
			open(GZIP, "| gzip -f");
			print GZIP $output;
			close(GZIP);
		} else {
			require Compress::Zlib;
			binmode STDOUT;
			print Compress::Zlib::memGzip($output);
		}
	} else {
		print $output;
	}
}

sub NewsStyle {
	$newstemplate = $_;
	if (!$usehead) { $usehead = qq~default~; }
	$yytemplate = "$templatesdir/$usehead/$temp.html";
	fopen(TEMPLATE, "$yytemplate") || die("$maintxt{'23'}: $testfile");
	@yytemplate = <TEMPLATE>;
	fclose(TEMPLATE);
	$newsloaded = 0;

	my $output = '';
	$yyboardname = "$mbname";
	$yytime      = &timeformat($date, 1);

	for (my $i = 0; $i <= $#yytemplate; $i++) {
		$curline = $yytemplate[$i];

		$curline =~ s~<yabb\s+(\w+)>~${"yy$1"}~g;
		$curline =~ s~<includefile="(\S+)">~${\(IncludeFile($1))}~g;
		$curline =~ s~(a href\=\S+?action\=viewprofile\;username\=.+?)(\>)~$1 rel=\"nofollow\"$2~isg;
		$curline =~ s~img src\=\"$imagesdir\/(.+?)\"~&ImgLoc($1)~eisg;
		$curline =~ s~(img src\=\"$imagesdir\/.+?)title\=\"(.*?)\"(.*? \/\>)~$1$3~ig;
		$curline =~ s~alt\=\"(.*?)\"~alt\=\"$1\" title\=\"$1\"~ig;
		$curline =~ s~</form>~$addsession~g;
		$output .= $curline;
	}

	$yynewsmain .= $output;
}

1;