<id>
Personal Notepad for YaBB 2.6.11
</id>

<version>
0.9
</version>

<mod info>
Description
-----------
Adds a Personal Notepad to the User CP

Installation
------------
1) Modify YaBB files using BoardMod or manually.
2) Upload personal_notepad.template to yabb2/Templates/default/Mods.
3) Upload modified files to your server in ASCII mode.
4) Go to 'Admin Center - Forum Settings - Members - Profile' to enable this feature.

Files to edit
-------------
Admin/ModList.pm
Admin/NewSettings.pm
Admin/Settings_Main.pm
Languages/English/Admin.lng
Languages/English/Profile.lng
Sources/MyCenter.pm
Sources/PostBox.pm
Sources/Profile.pm
Sources/SubList.pm
Sources/System.pm
Templates/default/MyCenter.template

Version History
---------------
V0.1 - First release - 23rd November 2009
V0.2 - Added Spell Checking (if enabled) - 24th November 2009
V0.3 - Tidied up textarea - 25th November 2009
V0.4 - Added auto-focus if textarea is empty - 14th December 2009
V0.5 - Updated for YaBB 2.5 and made changes so that notes can only be viewed by the user - 16th July 2010
V0.6 - Updated for YaBB 2.6.0 by Dandello - 9th July, 2014
V0.7 - Updated for YaBB 2.6.1 by Dandello - 4th Sept, 2014
V0.8 - Updated for YaBB 2.6.11 by Dandello - 5th Jan, 2015
V0.9 - Template code put into personal_notepad.template, reuse PostBox spellcheck code - 13th Jan, 2015
</mod info>

<author>
Derek Barnstorm
</author>

<homepage>
http://www.yabbforumsoftware.com
</homepage>

<edit file>
Admin/ModList.pm
</edit file>

<search for>
### END BOARDMOD ANCHOR ###
</search for>

<add before>
    $mod_personalpad = q~Personal Notepad|Derek Barnstorm, updated for 2.6.11 by Dandello|Adds a Personal Notepad to the User CP|0.9|13th Jan 2015~;
    push @installed_mods, $mod_personalpad;
</add before>

<edit file>
Admin/NewSettings.pm
</edit file>

<search for>
1;
EOF
</search for>

<add before>
### Personal Notepad Mod Start ###
\$PersonalPadEnabled = $PersonalPadEnabled;         # Enable Personal Notepad
\$MaxNotesLen = $MaxNotesLen;            # Maximum Allowed Characters in Personal Notepad
### Personal Notepad Mod End ###
</add before>

<edit file>
Admin/Settings_Main.pm
</edit file>

<search for>
if ($ML_Allowed eq q{}) { $ML_Allowed = 1;}
</search for>

<add after>
if ( $MaxNotesLen eq q{} ) { $MaxNotesLen = 2000; } ### Personal Notepad Mod ###
</add after>

<search for>
            name => 'buddyListEnabled',
            validate => 'boolean',
        },
</search for>

<add after>
        ### Personal Notepad Mod Start ###
        {
            description => qq~<label for="PersonalPadEnabled">$admin_txt{'personalpad'}</label>~,
            input_html => qq~<input type="checkbox" name="PersonalPadEnabled" id="PersonalPadEnabled" value="1"${ischecked($PersonalPadEnabled)} />~,
            name => 'PersonalPadEnabled',
            validate => 'boolean',
        },
        {
            description => qq~<label for="MaxNotesLen">$admin_txt{'689b'}</label>~,
            input_html => qq~<input type="text" name="MaxNotesLen" id="MaxNotesLen" size="5" value="$MaxNotesLen" />~,
            name => 'MaxNotesLen',
            validate => 'number,null',
        },
        ### Personal Notepad Mod End ###
</add after>

<edit file>
Languages/English/Admin.lng
</edit file>

<search for>
1;
</search for>

<add before>
$admin_txt{'689b'} = 'Maximum allowed characters in Personal Notepad'; ### Personal Notepad Mod ###
$admin_txt{'personalpad'} = 'Enable Personal Notepad?'; ### Personal Notepad Mod ###
</add before>

<edit file>
Languages/English/Profile.lng
</edit file>

<search for>
1;
</search for>

<add before>
### Personal Notepad Mod Start ###
$profile_txt{'notepad'} = 'Personal Notepad';
$profile_txt{'savenotes'} = 'Save Notes';
$profile_txt{'maxnotes'} = "Max $MaxNotesLen characters. Remaining characters: ";
%spell_check = (
'chck_spell' => 'Check spelling',
'revert' => 'Revert to',
'close' => 'Close',
'rsm_edt' => 'Resume editing',
'no_error_found' => 'No spelling errors found',
'no_suggestions' => 'No suggestions found',
);
### Personal Notepad Mod End ###

</add before>

<edit file>
Sources/MyCenter.pm
</edit file>

<search for>
        $my_IMpref = $my_thislink_impref;
        $my_IMpref =~ s/{yabb thisLink_f}/$thisLink_f/sm;
    }
</search for>

<add after>

    ### Personal Notepad Mod Start ###
    if ($PersonalPadEnabled) {
        $thisLink = $profileLink . 'myprofileNotepad;username=' . $useraccount{$username} . $sidLink;
        $myPPad = qq~
        <span class="nav"><b><a href="$scripturl?$thisLink">$profile_txt{'notepad'}</a></b></span><br />~;
    }
    ### Personal Notepad Mod End ###
</add after>

<search for>
        elsif ( $action eq 'myprofileBuddy2' )    { ModifyProfileBuddy2(); }
</search for>

<add after>
        ### Personal Notepad Mod Start ###
        elsif ( $action eq 'myprofileNotepad' )  { ModifyProfileNotepad(); }
        elsif ( $action eq 'myprofileNotepad2' ) { ModifyProfileNotepad2(); }
        ### Personal Notepad Mod End ###
</add after>

<search for>
    $MCProfMenu =~ s/{yabb my_IMpref}/$my_IMpref/sm;
</search for>

<add after>
    $MCProfMenu =~ s/{yabb myPPad}/$myPPad/sm;
</add after>

<edit file>
Sources/PostBox.pm
</edit file>

<search for>
    if ( !$img_greybox || $action eq 'guestpm' ) {
</search for>

<replace>
    if ( !$img_greybox || $action eq 'guestpm' || $action eq 'myprofileNotepad' ) {
</replace>

<search for>
            googie1.setSpellContainer("spell_container");
            googie1.decorateTextarea("message");
            </script>~;
</search for>

<replace>
            googie1.setSpellContainer("spell_container");~;
            if ($action eq 'myprofileNotepad' ) {
                $googie .= q~        googie1.decorateTextarea("personalpad");~;
            }
            else { $googie .= q~        googie1.decorateTextarea("message");~; }

    $googie .= q~        </script>~;
</replace>

<edit file>
Sources/Profile.pm
</edit file>

<search for>
sub ModifyProfileAdmin {
</search for>

<add before>
### Personal Notepad Mod Start ###
sub ModifyProfileNotepad {
    SidCheck($action);
    PrepareProfile();

    ProfileMenu();

    $scriptAction = qq~myprofileNotepad2~;
    $yytitle = qq~$profile_txt{'editmyprofile'} &rsaquo; $profile_txt{'notepad'}~;
    $profiletitle = qq~$profile_txt{'editmyprofile'} ($user) &rsaquo; $profile_txt{'notepad'}~;
    $yynavigation = qq~&rsaquo; <a href="$scripturl?action=mycenter" class="nav">$img_txt{'mycenter'}</a> &rsaquo; $profiletitle~;

    $personalpad = ${$uid.$user}{'personalpad'};
    $personalpad =~ s/<br \/>/\n/gsm;
    my $personalpad_spellcheck = q{};

    # SpellChecker start
    if ($enable_spell_check) {
        require Sources::PostBox;
        $yyinlinestyle .= googiea();
        my $userdefaultlang = (split(/-/, $abbr_lang))[0];
        $userdefaultlang ||= 'en';
        $personalpad_spellcheck .= googie($userdefaultlang);
    }
    # SpellChecker end
    get_template('Mods/personal_notepad');
    $showProfile .= $shownotepad;
    $showProfile =~ s/{yabb profiletitle}/$profiletitle/gsm;
    $showProfile =~ s/{yabb personalpad_spelldiv}/$personalpad_spelldiv/gsm;
    $showProfile =~ s/{yabb expiretxt}/$expiretxt/gsm;
    $showProfile =~ s/{yabb personalpad}/$personalpad/gsm;
    $showProfile =~ s/{yabb MaxNotesLen}/$MaxNotesLen/gsm;
    $showProfile =~ s/{yabb personalpad_spellcheck}/$personalpad_spellcheck/gsm;
    $showProfile =~ s/{yabb expiretxt}/$expiretxt/gsm;

}
### Personal Notepad Mod End ###

</add before>

<search for>
    if ( $pm_lev == 1 ) {
        $scriptAction = q~profileIM~;
    }
    if ($buddyListEnabled) {
        $scriptAction = q~profileBuddy~;
    }
</search for>

<add before>
    ### Personal Notepad Mod Start ###
    if ($PersonalPadEnabled && $view) {
        $scriptAction = qq~profileNotepad~;
    }
    ### Personal Notepad Mod End ###
</add before>

<search for>
    ${ $uid . $user }{'buddylist'} = $member{'buddylist'};
    UserAccount( $user, 'update' );

    my $scriptAction;
    if (
        $iamadmin
        || (   $iamgmod
            && $allow_gmod_profile
            && $gmod_access2{'profileAdmin'} eq 'on' )
      )
    {
        $scriptAction = q~profileAdmin~;
    }
    else {
        $scriptAction = q~viewprofile~;
    }
</search for>

<add after>
    ### Personal Notepad Mod Start ###
    if ($PersonalPadEnabled && $view) {
        $scriptAction = qq~profileNotepad~;
    }
    ### Personal Notepad Mod End ###
</add after>

<search for>
    my $scriptAction = q~viewprofile~;
    if (
        $iamadmin
        || (   $iamgmod
            && $allow_gmod_profile
            && $gmod_access2{'profileAdmin'} eq 'on' )
      )
    {
        $scriptAction = q~profileAdmin~;
    }
    if ($view) { $scriptAction = qq~my$scriptAction~; }
    $yySetLocation =
qq~$scripturl?action=$scriptAction;username=$useraccount{$member{'username'}};sid=$INFO{'sid'}~;
    redirectexit();
    return;
}
</search for>

<replace>
    ### Personal Notepad Mod Edit Start ###
    my $scriptAction;
    if (
        $iamadmin
        || (   $iamgmod
            && $allow_gmod_profile
            && $gmod_access2{'profileAdmin'} eq 'on')
      )
    {
        $scriptAction = qq~profileAdmin~;
    }
    else {
        $scriptAction = qq~viewprofile~;
    }
    if ( $PersonalPadEnabled && $view ) {
        $scriptAction = qq~profileNotepad~;
    }
    if ( $view ) { $scriptAction = qq~my$scriptAction~; }
    $yySetLocation = qq~$scripturl?action=$scriptAction;username=$useraccount{$member{'username'}};sid=$INFO{'sid'}~;
    redirectexit();
    return;
}

sub ModifyProfileNotepad2 {
    SidCheck($action);
    PrepareProfile();

    my (%member, $key, $value);
    while (($key, $value) = each(%FORM)) {
        $value =~ s/\A\s+//sm;
        $value =~ s/\s+\Z//sm;
        $member{$key} = $value;
    }
    $member{'username'} = $user;

     if ( $member{'moda'} ne $profile_txt{'savenotes'} ) { fatal_error('not_allowed'); }

    FromChars($member{'personalpad'});
    ToHTML($member{'personalpad'});
    $member{'personalpad'} =~ s/[\n\r]{1,2}/<br \/>/gsm;
    $convertstr = $member{'personalpad'};
    $convertcut = $MaxNotesLen;
    CountChars();
    $member{'personalpad'} = $convertstr;
    ToChars($member{'personalpad'});
    ${$uid.$user}{'personalpad'} = $member{'personalpad'};

    if ($extendedprofiles) { # run this before you start to save something!
        require Sources::ExtendedProfiles;
        my $error = ext_validate_submition($username,$user);
        if ($error ne '') { fatal_error('extended_profiles_validation',$error); }
        ext_saveprofile($user);
    }

    UserAccount($user, 'update');

    my $scriptAction = qq~viewprofile~;
    if ($iamadmin || ($iamgmod && $allow_gmod_profile && $gmod_access2{'profileAdmin'} eq 'on')) {
        $scriptAction = qq~profileAdmin~;
    }
    if ($view) { $scriptAction = qq~my$scriptAction~; }
    $yySetLocation = qq~$scripturl?action=$scriptAction;username=$useraccount{$member{'username'}};sid=$INFO{'sid'}~;
    redirectexit();
    return;
}
    ### Personal Notepad Mod Edit End ###
</replace>

<edit file>
Sources/SubList.pm
</edit file>

<search for>
1;
</search for>

<add before>
### Personal Notepad Mod Start ###
$director{'myprofileNotepad'} = 'MyCenter.pm&mycenter';
$director{'myprofileNotepad2'} = 'MyCenter.pm&mycenter';
### Personal Notepad Mod End ###
</add before>

<edit file>
Sources/System.pm
</edit file>

<search for>
   ## Mod hook ##
</search for>

<add before>
    push @tags, 'personalpad'; ### Personal Notepad Mod ###
</add before>

<edit file>
Templates/default/MyCenter.template
</edit file>

<search for>
                <br />{yabb my_buddylink}{yabb my_IMpref}{yabb my_adminlink}
</search for>

<replace>
                <br />{yabb my_buddylink}{yabb my_IMpref}{yabb myPPad}{yabb my_adminlink}
</replace>