###############################################################################
# RSS_Display.pl  version 1.1                                                 #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 1 Gold - SP 1.3                                        #
# Released:       December 2001; Updated April 6, 2003                        #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2003 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
###############################################################################

$rssdisplayplver = "1.1";

sub RSS_Display {
	$yymain = '';
	my $viewnum = $INFO{'num'};
	if( $viewnum =~ /\D/ ) { &fatal_error($txt{'337'}); }
	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }
	$maxmessagedisplay ||= 10;
	my($buffer,$views,$lastposter,$moderators,$counter,$counterwords,$pageindex,$msubthread,$mnum,$mstate,$mdate,$msub,$mname,$memail,$mreplies,$musername,$micon,$noposting,$threadclass,$notify,$max,$start,$bgcolornum,$windowbg,$mattach,$mip,$mlm,$mlmb,$lastmodified,$postinfo,$star,$sendm,$topicdate);
	my(@userprofile,@messages,@bgcolors);

	# Determine what category we are in.
	fopen(FILE, "$boardsdir/$currentboard.ctb") || &fatal_error("300 $txt{'106'}: $txt{'23'} $currentboard.ctb");
	$curcat = <FILE>;
	fclose(FILE);
	#$curcat = $cat;
	fopen(FILE, "$boardsdir/$curcat.cat") || &fatal_error("300 $txt{'106'}: $txt{'23'} $cat.cat");
	$cat = <FILE>;
	fclose(FILE);

	# Load the membergroups list.
	fopen(FILE, "$vardir/membergroups.txt") || &fatal_error("100 $txt{'106'}: $txt{'23'} membergroups.txt");
	@membergroups = <FILE>;
	fclose(FILE);

	# Mark current thread as read.
	($mnum,$tmpa,$tmpa,$tmpa,$mdate) = split(/\|/,$yyThreadLine);
	&dumplog($mnum,$date);

	# Add 1 to the number of views of this thread.
	if(fopen(FILE, "$datadir/$viewnum.data")) {
		$tmpa = <FILE>;
		fclose(FILE);
	}
	elsif( -e "$datadir/$viewnum.data" ) { &fatal_error("102 $txt{'106'}: $txt{'23'} $viewnum.data"); }
	else { $tmpa = '0'; }
	($tmpa, $tmpb) = split( /\|/, $tmpa );
	$tmpa++;
	fopen(FILE, "+>$datadir/$viewnum.data") || &fatal_error("103 $txt{'106'}: $txt{'23'} $viewnum.data");
	print FILE qq~$tmpa|$tmpb~;
	fclose(FILE);
	$views = $tmpa - 1;

	# Check to make sure this thread isn't locked.
	($mnum,$msubthread,$mname,$memail,$mdate,$mreplies,$musername,$micon,$mstate) = split( /\|/, $yyThreadLine );
	$noposting = $viewnum eq $mnum && $mstate == 1 ? 1 : 0;

	# Get the class of this thread, based on lock status and number of replies.
	$replybutton = qq~<a href="$cgi;action=post;num=$viewnum;title=$txt{'116'};start=$start">$img{'reply'}</a>~;
	$threadclass = 'thread';
	if( $mstate == 1 ) {
		$threadclass = 'locked';
		$replybutton = "";
	}
	elsif( $mreplies > 24 ) { $threadclass = 'veryhotthread'; }
	elsif( $mreplies > 14 ) { $threadclass = 'hotthread'; }
	elsif( $mstate == 0 ) { $threadclass = 'thread'; }
	fopen(FILE, "$boardsdir/sticky.stk") || &fatal_error("300 $txt{'106'}: $txt{'23'} sticky.stk");
	@stickys = <FILE>;
	fclose(FILE);
	foreach $curnum (@stickys) {
		if ($mnum == $curnum) {
			if($threadclass eq 'locked') { $threadclass = 'stickylock'; }
			else { $threadclass = 'sticky'; }
		}
	}

	&LoadCensorList;	# Load Censor List

	# Build a list of this board's moderators.
	if( scalar keys %moderators > 0 ) {
		if( scalar keys %moderators == 1 ) { $showmods = qq~($txt{'298'}: ~; }
		else { $showmods = qq~($txt{'299'}: ~; }
		while( $_ = each(%moderators) ) {
			&FormatUserName($_);
			$showmods .= qq~<a href="$scripturl?action=viewprofile;username=$useraccount{$_}" class="nav">$moderators{$_}</a>, ~;
		}
		$showmods =~ s/, \Z/)/;
	}

	if($enable_notification) {
		my $startnum = $start || '0';
		$notify = qq~$menusep<a href="$cgi;action=notify;thread=$viewnum;start=$startnum">$img{'notify'}</a>~;
	}
	&jumpto;	# create the jumpto list

	# Build the page links list.
	$postdisplaynum = 3;	# max number of pages to display
	$max = $mreplies + 1;
	$start = $INFO{'start'} || 0;
	$start = $start > $mreplies ? $mreplies : $start;
	$start = ( int( $start / $maxmessagedisplay ) ) * $maxmessagedisplay;
	$tmpa = 1;
	$tmpx = int( $max / $maxmessagedisplay );
	if ($start >= (($postdisplaynum-1) * $maxmessagedisplay)) { $startpage = $start - (($postdisplaynum-1) * $maxmessagedisplay); $tmpa = int( $startpage / $maxmessagedisplay ) + 1; }
	if ($max >= $start + ($postdisplaynum * $maxmessagedisplay)) { $endpage = $start + ($postdisplaynum * $maxmessagedisplay); } else { $endpage = $max }
	if ($startpage > 0) { $pageindex = qq~<a href="$cgi;action=rssdisplay;num=$viewnum;start=0">1</a>&nbsp;...&nbsp;~; }
	if ($startpage == $maxmessagedisplay) { $pageindex = qq~<a href="$cgi;action=rssdisplay;num=$viewnum;start=0">1</a>&nbsp;~;}
	for( $counter = $startpage; $counter < $endpage; $counter += $maxmessagedisplay ) {
		$pageindex .= $start == $counter ? qq~<b>$tmpa</b>&nbsp;~ : qq~<a href="$cgi;action=rssdisplay;num=$viewnum;start=$counter">$tmpa</a>&nbsp;~;
		$tmpa++;
	}
	$tmpx = $max - $maxmessagedisplay;
	$outerpn = int($tmpx / $maxmessagedisplay) + 0;
	$lastpn = int($mreplies / $maxmessagedisplay) + 1;
	$lastptn = ($lastpn - 1) * $maxmessagedisplay;
	if ($endpage < $max - ($maxmessagedisplay) ) {$pageindexadd = qq~&nbsp;...&nbsp;~;}
	if ($endpage != $max) {$pageindexadd .= qq~&nbsp;<a href="$cgi;action=rssdisplay;num=$viewnum;start=$lastptn">$lastpn</a>~;}
	$pageindex .= $pageindexadd;

	foreach (@censored) {
		($tmpa,$tmpb) = @{$_};
		$msubthread =~ s~\Q$tmpa\E~$tmpb~gi;
	}
	$curthreadurl = $curposlinks ? qq~<a href="$cgi;action=rssdisplay;num=$viewnum" class="nav">$msubthread</a>~ : $msubthread;

	# Create next/prev links
	fopen(LISTS, "$boardsdir/$INFO{'board'}.txt");
	@boardtopics = <LISTS>;
	seek LISTS, 0, 0;
	my $found;
	my $name = $INFO{'num'};
	my $bcount = 0;
	$CurrentPosition = -1;
	while($ThreadNum = <LISTS>) {
		++$CurrentPosition;
		$boardtopics[$bcount] = $ThreadNum;
		$bcount++;
		if ($ThreadNum =~ m/\A$name/o) { $found = 1; last; }
	}
	fclose(LISTS);
	$previous = $boardtopics[$CurrentPosition-1];
	$next = $boardtopics[$CurrentPosition+1];
	@prevthread = split(/\|/, $previous);
	$goprevious = $prevthread[0];
	@nextthread = split(/\|/, $next);
	$gonext = $nextthread[0];
	@getlastthread = @boardtopics;
	$lastthread = pop(@getlastthread);
	@lasttopic = split(/\|/, $lastthread);
	$endthread2 = $lasttopic[0];
	if($found) {
		$prevtopic = "$cgi;action=rssdisplay;num=$goprevious";
		$nexttopic = "$cgi;action=rssdisplay;num=$gonext";
		$endthread = "$cgi;action=rssdisplay;num=$endthread2";
	}
	if( $endthread eq $prevtopic && $gonext eq "") { $nav = qq~&#171; $txt{'766'} | $txt{'766'} &#187;~; }
	if($endthread eq $prevtopic && $gonext ne "") { $nav = qq~&#171; $txt{'766'} | <a href="$nexttopic">$txt{'767'}</a> &#187;~; }
	if ( $endthread ne $prevtopic && $gonext eq "") { $nav = qq~&#171; <a href="$prevtopic">$txt{'768'}</a> | $txt{'766'} &#187;~; }
	if ($endthread ne $prevtopic && $gonext ne "") { $nav = qq~&#171; <a href="$prevtopic">$txt{'768'}</a> | <a href="$nexttopic">$txt{'767'}</a> &#187;~; 	}
###
	fopen(RSSTEMPLATE,"template.html") || die("$txt{'23'}: template.html");
	@rsstemparray = <RSSTEMPLATE>;
	fclose(RSSTEMPLATE);
	$rsswholwtemp = '';
	foreach $rsstempline(@rsstemparray) {
		$rsswholtemp .= $rsstempline;
	}
	($rsstemplate1, $dummy) = split(/\<body/,$rsswholtemp);
	($dummy, $rsstemplate) = split(/\<html\>/,$rsstemplate1);
	$rsswholtemp =~ /\<body(.+?)\>/;
	$rssbodytag = '<body' . $1 . '>';

###  <body text="#000000" bgcolor="#F5F5F5" link="#0033FF">

	$yymain .= qq~Content-type: text/html\n\n
<html>
$rsstemplate
$rssbodytag
<script language="JavaScript1.2" src="$ubbcjspath" type="text/javascript"></script>
<table border="0" width="100%" cellspacing="0" cellpadding="0" bgcolor="$color{'bordercolor'}" class="bordercolor">
  <tr>
    <td>
    <table cellpadding="4" cellspacing="1" border="0" width="100%">
      <tr>
        <td align="left" class="catbg" bgcolor="$color{'catbg'}" width="100%">
        <table cellpadding="3" cellspacing="0" width="100%">
          <tr>
            <td><font size="2"><b>$txt{'139'}:</b> $pageindex</font></td>
            <td class="catbg" bgcolor="$color{'catbg'}" align="right"><font size="2">
            $replybutton$notify$menusep
            <a href="$cgi;action=sendtopic;topic=$viewnum">$img{'sendtopic'}</a>$menusep
            <a href="$cgi;action=print;num=$viewnum" target="_blank">$img{'print'}</a>
            </font></td>
          </tr>
        </table>
        </td>
      </tr>
    </table>
    </td>
  </tr>
</table>
<table cellpadding="0" cellspacing="0" border="0" width="100%" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
  <tr>
    <td>
    <table cellpadding="3" cellspacing="1" border="0" width="100%">
      <tr>
        <td valign="middle" align="left" width="20%" bgcolor="$color{'titlebg'}" class="titlebg">
        <font size=2 class="text1" color="$color{'titletext'}">&nbsp;<img src="$imagesdir/$threadclass.gif" alt="">
        &nbsp;<b>$txt{'29'}</b></font></td>
        <td valign="middle" align="left" bgcolor="$color{'titlebg'}" class="titlebg" width="80%">
        <font size=2 class="text1" color="$color{'titletext'}"><b>&nbsp;$txt{'118'}: $msubthread</b> &nbsp;($txt{'641'} $views $txt{'642'})</font></td>
      </tr>
    </table>
    </td>
  </tr>
</table>
~;

	# Load background color list.
	@bgcolors = ( $color{windowbg}, $color{windowbg2} );
	$bgcolornum = scalar @bgcolors;
	@cssvalues = ( "windowbg","windowbg2" );
	$cssnum = scalar @bgcolors;

	if(!$MenuType) { $sm = 1; }
	$counter = 0;

	fopen(FILE,"$datadir/$viewnum.txt") || &fatal_error("104 $txt{'106'}: $txt{'23'} $viewnum.txt");

	# Skip past the posts in this thread until we reach $start.
	while($counter < $start && ($buffer = <FILE>)) { $counter++; }

	$#messages = $maxmessagedisplay - 1;
	for($counter = 0; $counter < $maxmessagedisplay && ($buffer = <FILE>); $counter++) {
		$messages[$counter] = $buffer;
	}
	fclose(FILE);
	$#messages = $counter - 1;
	$counter = $start;

	# For each post in this thread:
	foreach (@messages) {
		$windowbg = $bgcolors[($counter % $bgcolornum)];
		$css = $cssvalues[($counter % $cssnum)];
		chomp;
		($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $postmessage, $ns, $mlm, $mlmb) = split(/[\|]/, $_);
		# Should we show "last modified by?"
		if( $mlm && $showmodify && $mlm ne "" && $mlmb ne "") {
			$mlm = &timeformat($mlm);
			&LoadUser($mlmb);
			$mlmb = $userprofile{$mlmb}->[1] || $mlmb || $txt{'470'};
			$lastmodified = qq~&#171; <i>$txt{'211'}: $mlm $txt{'525'} $mlmb</i> &#187;~;
		}
		else {
			$mlm = '-';
			$lastmodified = '';
		}
		$msub ||= $txt{'24'};
		$messdate = &timeformat($mdate);
		$mip = $settings[7] eq 'Administrator' ? $mip : "$txt{'511'}";
		$sendm = '';

		# If the user isn't a guest, load his/her info.
		if($musername ne 'Guest' && ! $yyUDLoaded{$musername} && -e("$memberdir/$musername.dat") ) {
			&LoadUserDisplay($musername);	# If user is not in memory, s/he must be loaded.
		}
		if($yyUDLoaded{$musername}) {
			@userprofile = @{$userprofile{$musername}};
			$displayname = $userprofile[1];
			$star = $memberstar{$musername};
			$memberinfo = $memberinfo{$musername};
			$memberinfo =~ s~\n~~g;
			$icqad = $icqad{$musername};
			$yimon = $yimon{$musername};
			if($username ne 'Guest') {
				# Allow instant message sending if current user is a member.
				$sendm = qq~$menusep<a href="$cgi;action=imsend;to=$useraccount{$musername}">$img{'message_sm'}</a>~;
			}
			$usernamelink = qq~<a href="$scripturl?board=$currentboard;action=viewprofile;username=$useraccount{$musername}"><font size="2"><b>$userprofile[1]</b></font></a>~;
			$postinfo = qq~$txt{'26'}: $userprofile[6]<br>~;
			$memail = $userprofile[2];
		}
		else {
			$musername = "Guest";
			$star = '';
			$memberinfo = "$txt{'28'}";
			$icqad = '';
			$yimon = '';
			$usernamelink = qq~<font size="2"><b>$mname</b></font>~;
			$postinfo = '';
			@userprofile = ();
			$displayname = $mname;
		}
		# Censor the subject and message.
		foreach (@censored) {
			($tmpa,$tmpb) = @{$_};
			$postmessage =~ s~\Q$tmpa\E~$tmpb~gi;
			$msub =~ s~\Q$tmpa\E~$tmpb~gi;
		}
		# Run UBBC interpreter on the message.
		$message = $postmessage; # put the message back into the proper variable to do ubbc on it
		&wrap;
		if($enable_ubbc) { if(!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; } &DoUBBC; }
		&wrap2;
		$profbutton = $profilebutton && $musername ne 'Guest' ? qq~<a href="$scripturl?action=viewprofile;username=$useraccount{$musername}">$img{'viewprofile_sm'}</a>$menusep~ : '';
		if($counter != 0) { $counterwords = "$txt{'146'} #$counter"; }
		else { $counterwords = ""; }
		# Print the post and user info for the poster.
		$yymain .= qq~
<table cellpadding="0" cellspacing="0" border="0" width="100%" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
  <tr>
    <td>
    <table cellpadding="3" cellspacing="1" border="0" width="100%">
      <tr>
        <td bgcolor="$windowbg" class="$css">
        <a name="$counter"></a>
        <table width="100%" cellpadding="4" cellspacing="0" class="$css" bgcolor="$windowbg">
          <tr>
            <td class="$css" bgcolor="$windowbg" valign="top" width="20%" rowspan="2"><font size="1">
            $usernamelink<br>
            $memberinfo<br>~;
	if($musername ne "Guest") {
		$yymain .= qq~
            $star<br><br>
            $userprofile[13]$userprofile[12]
            <br>$userprofile[8] $icqad &nbsp; $userprofile[10] $yimon &nbsp; $userprofile[9]<br>
~;
	}
	if($musername eq "Guest") {
		$yymain .= qq~
            <br><a href="mailto:$memail">$img{'email_sm'}</a><br><br>
~;
	}
	elsif ($userprofile[19] ne "checked" || $settings[7] eq "Administrator" || $allow_hide_email ne 1) {
		$yymain .= qq~
            $profbutton$userprofile[4] <a href="mailto:$memail">$img{'email_sm'}</a>$sendm<br><br>
~;
	} else {
		$yymain .= qq~
    $profbutton$userprofile[4]$sendm<br><br>
~;
	}
	$yymain .= qq~
            $userprofile[11]
            $postinfo
            </font></td>
            <td class="$css" bgcolor="$windowbg" valign="top" width="80%" height="100%">
            <table width="100%" border="0">
              <tr>
                <td align="left" valign="middle"><img src="$imagesdir/$micon.gif" alt=""></td>
                <td align="left" valign="middle">
                <font size="2"><B>$msub</b></font><br>
                <font size="1">&#171; <B>$counterwords $txt{'30'}:</B> $messdate &#187;</font></td>
                <td align="right" valign="bottom" nowrap height="20">
                <font size=-1>
~;
if ($mstate != 1)
{
$yymain .= qq~
                <a href="$cgi;action=post;num=$viewnum;quote=$counter;title=$txt{'116'};start=$start">$img{'replyquote'}</a>$menusep<a href="$cgi;action=modify;message=$counter;thread=$viewnum">$img{'modify'}</a>
~;
	if(exists $moderators{$username} || $settings[7] eq 'Administrator' || $username eq $musername) {
		$yymain .= qq~  $menusep<a href="$cgi;action=modify2;thread=$viewnum;id=$counter;d=1" onclick="return confirm('$txt{'739'}')">$img{'delete'}</a>~;
	}
}
	$yymain .= qq~
                </font></td>
              </tr>
            </table>
            <hr width="100%" size="1" class="hr">
            <font size="2">
            $message
            </font>
            </td>
          </tr><tr>
            <td class="$css" bgcolor="$windowbg" valign="bottom">
            <table width="100%" border="0">
              <tr>
                <td align="left"><font size="1">$lastmodified</font></td>
                <td align="right"><font size="1"><img src="$imagesdir/ip.gif" alt="" border="0"> $mip</font></td>
              </tr>
            </table>
            <font size="1">
            $userprofile[5]
            </font></td>
          </tr>
        </table>
        </td>
      </tr>
    </table>
    </td>
  </tr>
</table>~;
		$counter++;
	}
	$yymain .= qq~
<table border=0 width="100%" cellspacing="0" cellpadding="0" bgcolor="$color{'bordercolor'}" class="bordercolor">
  <tr>
    <td>
    <table cellpadding="4" cellspacing="1" border="0" width="100%">
      <tr>
        <td align="left" class="catbg" bgcolor="$color{'catbg'}" width="100%">
        <table cellpadding="3" cellspacing="0" width="100%">
          <tr>
            <td><font size=2><b>$txt{'139'}:</b> $pageindex</font></td>
            <td class="catbg" bgcolor="$color{'catbg'}" align=right><font size=2>
            $replybutton$notify$menusep
            <a href="$cgi;action=sendtopic;topic=$viewnum">$img{'sendtopic'}</a>$menusep
            <a href="$cgi;action=print;num=$viewnum" target="_blank">$img{'print'}</a>
            </font></td>
          </tr>
        </table>
        </td>
      </tr>
    </table>
    </td>
  </tr>
</table><br>
<table border="0" width="100%" cellpadding="0" cellspacing="0">
  <tr>
    <td colspan="3" valign="top" height="18" align="right"><font size="1">$selecthtml</font></td>
  </tr>
</table>
</body>
</html>
~;
print "$yymain";
	exit;
}

sub RSS_Feed {
	@categories = ();
	require "$vardir/rssfeed.txt";
	while ( ( $testcat, $rssvalue ) = each %rsscat ) {
		if ( $rssvalue ne 'rss' ) { delete $rsscat{$testcat}; }
	}
	@categories = keys %rsscat;
	$oldestfound = stringtotime("01/10/37 at 00:00:00");

	foreach $curcat (@categories) {
		chomp $curcat;

		fopen(FILE, "$boardsdir/$curcat.cat");
		$catname{$curcat} = <FILE>;
		chomp $catname{$curcat};
		$cataccess{$curcat} = <FILE>;
		chomp $cataccess{$curcat};
		@{$catboards{$curcat}} = <FILE>;
		fclose(FILE);

		foreach $curboard (@{$catboards{$curcat}}) {
			chomp $curboard;

			fopen(FILE, "$boardsdir/$curboard.txt");
			@threads = <FILE>;
			fclose(FILE);
			fopen(FILE, "$boardsdir/$curboard.dat");
			@boardinfo = <FILE>;
			fclose(FILE);
			foreach (@boardinfo) {
				chomp;
			}
			@{$boardinfo{$curboard}} = @boardinfo;
			$cat{$curboard} = $curcat;

			for ($i = 0; $i < @threads; $i++) {
				chomp $threads[$i];

				($tnum, $tsub, $tname, $temail, $tdate, $treplies, $tusername, $ticon, $tstate) = split( /\|/, $threads[$i] );
				fopen(FILE, "$datadir/$tnum.txt") || next;
				while( <FILE> ) { $recentmessage = $_; }
#				@tempmessages = <FILE>;
#				$recentmessage = $tempmessages[0];
				# get only the last post for this thread.
				fclose(FILE);

				chomp $recentmessage;
				if( $recentmessage ) {
					($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $recentmessage, $mns) = split(/\|/,$recentmessage);
					$mtime = stringtotime($mdate);
					if( $numfound >= $RSS_Display && $mtime <= $oldestfound ) {
						next;
					}
					else {
						# Decide if thread should have the "NEW" indicator next to it.
						# Do this by reading the user's log for last read time on thread,
						# and compare to the last post time on the thread.
						$dlp = &getlog($tnum);
						$threaddate = stringtotime($tdate);
						if( $max_log_days_old && $dlp < $threaddate && $username ne 'Guest' && &getlog("$currentboard--mark") < $threaddate ) {
							$tmpx = &getlog("$curboard--mark");
							$new = qq~ NEW~;
						}
						else { $new = ''; }

						$data{$mtime} = [$curboard, $tnum, $treplies, $tusername, $tname, $tsub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $recentmessage, $mns, $new];
						if( $mtime < $oldestfound ) { $oldestfound = $mtime; }
						++$numfound;
					}
				}
			}
		}
	}

	@messages = sort {$b <=> $a } keys %data;
	if( @messages ) {
		if( @messages > $RSS_Display ) { $#messages = $RSS_Display - 1; }
		&LoadCensorList; # Load Censor List
	}

### strip weird characters from boardname and RSS Description
&StripChars($mbname);
&StripChars($RSS_Description);

	$YaBB_RSS = qq~Content-type: application/xml\n
<?xml version="1.0" encoding="iso-8859-1" ?> 
<rss version="2.0" 
    xmlns:dc="http://purl.org/dc/elements/1.1/">
<channel>
  <image> 
    <title>$mbname</title>
    <url>$imagesdir/$RSS_Image</url>
    <link>$scripturl</link>  
    <description>$RSS_Description</description>
  </image>
  <title>$mbname</title>
  <description>$RSS_Description</description>
  <link>$scripturl</link>
~;
	for( $i = 0; $i < @messages; $i++ ) {
		($board, $tnum, $c, $tusername, $tname, $msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $recentmessage, $mns, $new) = @{ $data{$messages[$i]} };
		foreach (@censored) {
			($tmpa,$tmpb) = @{$_};
			$recentmessage =~ s~\Q$tmpa\E~$tmpb~gi;
			$msub =~ s~\Q$tmpa\E~$tmpb~gi;
		}
### figure out board dislay name
		fopen(FILE, "$boardsdir/$board.dat");
		@boardinfo = <FILE>;
		fclose(FILE);
		$boardlong = $boardinfo[0];
### Get last poster display name
		if($musername ne 'Guest' && ! $yyUDLoaded{$musername} && -e("$memberdir/$musername.dat") ) {
			&LoadUserDisplay($musername);	# If user is not in memory, s/he must be loaded.
		}
			@userprofile = @{$userprofile{$musername}};
			$mdisplayname = $userprofile[1];
### Get first poster display name
		if($tusername ne 'Guest' && ! $yyUDLoaded{$tusername} && -e("$memberdir/$tusername.dat") ) {
			&LoadUserDisplay($tusername);	# If user is not in memory, s/he must be loaded.
		}
		@userprofile = @{$userprofile{$tusername}};
		$tdisplayname = $userprofile[1];

### Set display name to Guest for guests 
		if($musername eq 'Guest') {$mdisplayname = $txt{'28'}; }
###

		if ($RSS_Cutoff) {
			if (length($recentmessage) > $RSS_Cutoff) { $recentmessage = substr($recentmessage,0,$RSS_Cutoff); $recentmessage .= "...";}
		}

# Run UBBC interpreter on the message body.
		$message = $recentmessage; # put the message back into the proper variable to do ubbc on it
		&wrap;
		if($enable_ubbc) { if(!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; } &DoUBBC; }
		&wrap2;
		$recentmessage = $message;

### strip weird characters out of all user input fields

		&StripChars($recentmessage);
		&StripChars($mdisplayname);
		&StripChars($msub);
		&StripChars($boardlong);

		unless ($RSS_Timeoffset) { $RSS_Timeoffset = '+00:00'; }
		( $rssdate, $rsstime ) = split(/ at /,$mdate);
		( $rssmonth, $rssday, $rssyear ) = split(/\//,$rssdate);
		( $rsshour, $rssmin, $rsssec ) = split(/\:/,$rsstime);
		$rsstimestring = '20' . $rssyear . '-' . $rssmonth . '-' . $rssday . 'T' . $rsshour . ':' . $rssmin . ':' . $rsssec . $RSS_Timeoffset;

		$YaBB_RSS .= qq~
<item>
<title>$msub</title>
<link>$scripturl?board=$board;action=rssdisplay;num=$tnum</link>
<dc:date>$rsstimestring</dc:date>
<dc:creator>$mdisplayname</dc:creator>
<dc:subject>$boardlong</dc:subject>~;

		if($RSS_ShortForm == 1) {
			$YaBB_RSS .= qq~
<description>$recentmessage</description>
~;
		}	
		$YaBB_RSS .= qq~
</item>
~; 
	}
$YaBB_RSS .= qq~
</channel>
</rss>
~;
print $YaBB_RSS;
exit;
}

# End RSS_Feed
#    List of possible xml definitions:
#    xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"
#    xmlns:admin="http://webns.net/mvcb/"
#    xmlns:slash="http://purl.org/rss/1.0/modules/slash/"
#    xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"   
#    xmlns:content="http://purl.org/rss/1.0/modules/content/"

### Strip weird characters from input string
sub StripChars {
	$ch_32 = chr(32);
	$ch_160 = chr(160);
	$_[0] =~ s/[$ch_32]+/ /g;
	$_[0] =~ s/[$ch_160]+/ /g;
	$_[0] =~ s/&/&amp;/g;
	$_[0] =~ s/&nbsp;/ /g;
#	$_[0] =~ s/<br>//g;
	$_[0] =~ s/[\s]{2}/ /g;
	$_[0] =~ s/"/&quot;/g;
	$_[0] =~ s/</&lt;/g;
	$_[0] =~ s/>/&gt;/g;
#	$_[0] =~ s/#/&#35;/g;
#	$_[0] =~ s/$/&#36;/g;
#	$_[0] =~ s/%/&#37;/g;
#	$_[0] =~ s/@/&#64;/g;
#	$_[0] =~ s/^/&#94;/g;
#	$_[0] =~ s/`/&#96;/g;
#	$_[0] =~ s/}/&#125;/g;
#	$_[0] =~ s/~/&#126;/g;
#	$_[0] =~ s//&#150;/g;
#	$_[0] =~ s//&#151;/g;
	$_[0] =~ s//&#161;/g;
	$_[0] =~ s//&#162;/g;
	$_[0] =~ s//&#163;/g;
	$_[0] =~ s//&#8364;/g;
	$_[0] =~ s//&#164;/g;
	$_[0] =~ s//&#165;/g;
#	$_[0] =~ s//&#166;/g;
	$_[0] =~ s//&#167;/g;
	$_[0] =~ s//&#168;/g;
	$_[0] =~ s//&#169;/g;
	$_[0] =~ s//&#170;/g;
	$_[0] =~ s//&#171;/g;
	$_[0] =~ s//&#172;/g;
#	$_[0] =~ s/  /&#173;/g;
	$_[0] =~ s//&#174;/g;
	$_[0] =~ s//&#175;/g;
	$_[0] =~ s//&#176;/g;
	$_[0] =~ s//&#177;/g;
	$_[0] =~ s//&#178;/g;
	$_[0] =~ s//&#179;/g;
	$_[0] =~ s//&#180;/g;
	$_[0] =~ s//&#181;/g;
	$_[0] =~ s//&#182;/g;
	$_[0] =~ s//&#183;/g;
	$_[0] =~ s//&#184;/g;
	$_[0] =~ s//&#185;/g;
	$_[0] =~ s//&#186;/g;
	$_[0] =~ s//&#187;/g;
	$_[0] =~ s//&#188;/g;
	$_[0] =~ s//&#189;/g;
	$_[0] =~ s//&#190;/g;
	$_[0] =~ s//&#191;/g;
	$_[0] =~ s//&#192;/g;
	$_[0] =~ s//&#193;/g;
	$_[0] =~ s//&#194;/g;
	$_[0] =~ s//&#195;/g;
	$_[0] =~ s//&#196;/g;
	$_[0] =~ s//&#197;/g;
	$_[0] =~ s//&#198;/g;
	$_[0] =~ s//&#199;/g;
	$_[0] =~ s//&#200;/g;
	$_[0] =~ s//&#201;/g;
	$_[0] =~ s//&#202;/g;
	$_[0] =~ s//&#203;/g;
	$_[0] =~ s//&#204;/g;
	$_[0] =~ s//&#205;/g;
	$_[0] =~ s//&#206;/g;
	$_[0] =~ s//&#207;/g;
	$_[0] =~ s//&#208;/g;
	$_[0] =~ s//&#209;/g;
	$_[0] =~ s//&#210;/g;
	$_[0] =~ s//&#211;/g;
	$_[0] =~ s//&#212;/g;
	$_[0] =~ s//&#213;/g;
	$_[0] =~ s//&#214;/g;
	$_[0] =~ s//&#215;/g;
	$_[0] =~ s//&#216;/g;
	$_[0] =~ s//&#217;/g;
	$_[0] =~ s//&#218;/g;
	$_[0] =~ s//&#219;/g;
	$_[0] =~ s//&#220;/g;
	$_[0] =~ s//&#221;/g;
	$_[0] =~ s//&#222;/g;
	$_[0] =~ s//&#223;/g;
	$_[0] =~ s//&#224;/g;
	$_[0] =~ s//&#225;/g;
	$_[0] =~ s//&#226;/g;
	$_[0] =~ s//&#227;/g;
	$_[0] =~ s//&#228;/g;
	$_[0] =~ s//&#229;/g;
	$_[0] =~ s//&#230;/g;
	$_[0] =~ s//&#231;/g;
	$_[0] =~ s//&#232;/g;
	$_[0] =~ s//&#233;/g;
	$_[0] =~ s//&#234;/g;
	$_[0] =~ s//&#235;/g;
	$_[0] =~ s//&#236;/g;
	$_[0] =~ s//&#237;/g;
	$_[0] =~ s//&#238;/g;
	$_[0] =~ s//&#239;/g;
	$_[0] =~ s//&#240;/g;
	$_[0] =~ s//&#241;/g;
	$_[0] =~ s//&#242;/g;
	$_[0] =~ s//&#243;/g;
	$_[0] =~ s//&#244;/g;
	$_[0] =~ s//&#245;/g;
	$_[0] =~ s//&#246;/g;
	$_[0] =~ s//&#247;/g;
	$_[0] =~ s//&#248;/g;
	$_[0] =~ s//&#249;/g;
	$_[0] =~ s//&#250;/g;
	$_[0] =~ s//&#251;/g;
	$_[0] =~ s//&#252;/g;
	$_[0] =~ s//&#253;/g;
	$_[0] =~ s//&#254;/g;
	$_[0] =~ s//&#255;/g;
## new chars
	$_[0] =~ s//&#8216;/g;
	$_[0] =~ s//&#8217;/g;
	$_[0] =~ s//&#8230;/g;
	$_[0] =~ s//&#8240;/g;
}

sub RSS_Manage {
	&is_admin;
	%rsscat;
	my %rsscatchecked;
	my($RSS_ShortFormchecked);
	require "$vardir/rssfeed.txt";
	fopen(FILE, "$vardir/cat.txt");
	@categories = <FILE>;
	fclose(FILE);

	if ($RSS_ShortForm) { $RSS_ShortFormchecked = ' checked'; }

### Set checks for each Category, determined by rssfeed.txt ### 
	foreach $curcat(@categories) {
		chomp $curcat;
		if( $rsscat{"$curcat"} eq 'rss' ) {
			$rsscatchecked{"$curcat"} = ' checked';
		}
	}
### Set help file location
	my $helpfile2 = $helpfile;
	$helpfile2 =~ m/(.+)(\/.+$)/;
	my $rsshelpfile = $1 . qq~/RSSFeedHelp.html~;

### Start building page, global RSS settings first, then catagory check boxs
	$yymain .= qq~
<form action="$cgi;action=rssmanage2" method="POST">
<table width="90%" border="0" cellspacing="1" cellpadding="0" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
  <tr>
  <td>
  <table border="0" cellspacing="0" cellpadding="4" align="center">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}" colspan=2>
    </img src="$imagesdir/preferences.gif" alt="" border="0">
    <font size=2 class="text1" color="$color{'titletext'}"><B>$RSStxt{'07'}</B></font></td>
  </tr><tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}" colspan="2" align="right"><font size="1"><A HREF="$rsshelpfile" target=_blank>$RSStxt{'08'}</A></font></td>
  </tr><tr>
    <td colspan=2 class="windowbg2" bgcolor="$color{'windowbg2'}">
    <hr size=1 width="100%" class="hr"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$RSStxt{'01'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="RSS_Display" size="3" value="$RSS_Display"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$RSStxt{'02'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="RSS_Description" size="30" value="$RSS_Description"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$RSStxt{'03'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="RSS_Timeoffset" size="7" value="$RSS_Timeoffset"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$RSStxt{'11'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="RSS_ShortForm" value="1" $RSS_ShortFormchecked></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$RSStxt{'04'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="RSS_Cutoff" size="5" value="$RSS_Cutoff"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$RSStxt{'05'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="RSS_Image" size="20" value="$RSS_Image"></td>
  </tr><tr>
    <td colspan=2 class="windowbg2" bgcolor="$color{'windowbg2'}">
    <hr size=1 width="100%" class="hr"></td>
  </tr><tr>
    <td colspan=2 class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$RSStxt{'09'}</font><br>$RSStxt{'10'}<br></td>
  </tr><tr>~;

	foreach $curcat(@categories) {
		$yymain .= qq~
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$curcat</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}" align=center><input type=checkbox name="rsscat{$curcat}" value="1" $rsscatchecked{$curcat}></td>
  </tr><tr>~;
	}
	$yymain .= qq~
    <td class="windowbg2" bgcolor="$color{'windowbg2'}" colspan="2" align="center" valign="middle">
    <br><input type=submit value="$txt{'10'}">
    </td>
  </tr>
 </table>
</td>
</tr>
</table>
</form>
~;
	$yytitle = qq~$RSStxt{'07'}~;
	&template;
	exit;
}

sub RSS_Manage2 {
	&is_admin;

	$RSS_Display = $FORM{'RSS_Display'} || "5";
	$RSS_Description = $FORM{'RSS_Description'} || "RSS Feed Description Here";
	$RSS_Timeoffset = $FORM{'RSS_Timeoffset'} || "+00:00";
	$RSS_Cutoff = $FORM{'RSS_Cutoff'} || "150";
	$RSS_Image = $FORM{'RSS_Image'} || "home.gif";
	if( $FORM{'RSS_ShortForm'} ) { $RSS_ShortForm = 1; } else { $RSS_ShortForm = 0; }

	my $filler = q~										      ~;
	my $setfile = << "EOF";
###############################################################################
# rssfeed.txt - Settings for RSS Feed 1.0  		       		      #
###############################################################################

\$RSS_Display = $RSS_Display;			# Number of recent Posts to display in RSS Feed
\$RSS_Description = "$RSS_Description";	# Description of RSS Feed Content
\$RSS_Timeoffset = "$RSS_Timeoffset";	# Enter Server time offset from GMT in hours (examples: +05:00 or -10:00 )
\$RSS_Cutoff = $RSS_Cutoff;			# Number of characters of each post to show in RSS content description, default = 150
\$RSS_Image = "$RSS_Image";			# Image to be used as logo on RSS Feed, must be in YaBB Images folder
\$RSS_ShortForm = $RSS_ShortForm;		# Set to 1 to use short form post description, 0 to go straight to thread view
1;
EOF

#### Set RSS Cats
	my %rsscat;
	fopen(FILE, "$vardir/cat.txt");
	@categories = <FILE>;
	fclose(FILE);
	foreach $curcat(@categories) {
		chomp $curcat;
		if( $FORM{"rsscat{$curcat}"} ) {$rsscat{"$curcat"} = 'rss'; }
		else { $rsscat{$curcat} = 'norss'; }
		$setfile .= qq~\$rsscat\{"$curcat"\} = "$rsscat{$curcat}";\n~;
	}
	$setfile .= qq~1;\n~;
#### end RSS Cats

	$setfile =~ s~(.+\;)\s+(\#.+$)~$1 . substr( $filler, 0, (70-(length $1)) ) . $2 ~gem;
	$setfile =~ s~(.{64,}\;)\s+(\#.+$)~$1 . "\n   " . $2~gem;
	$setfile =~ s~^\s\s\s+(\#.+$)~substr( $filler, 0, 70 ) . $1~gem;

	fopen(FILE, ">$vardir/rssfeed.txt");
	print FILE $setfile;
	fclose(FILE);
	$yySetLocation = qq~$cgi;action=rssmanage~;
	&redirectexit;

}

1;