#Shoutbox.pl
#v1.0b1
#16/10/03
#ronnie@badpoo.co.uk
#http://www.badpoo.co.uk/ronnie/pages/yabbmods.shtml

#file locations
$shout_template_file = "$vardir/shoutbox.html";
$shout_messages_file = "$vardir/shoutbox.txt";
$shout_settings_file = "$vardir/shoutbox.pl";

require $shout_settings_file;
	$shout_add_to_top_old = $shout_add_to_top;

#display the shoutbox HTML - the iframe and the form to add shouts
sub ShoutBox
{
	if ($username eq 'Guest')
	{
		$random = int(rand(99));
		$displayname = $txt{'28'} . $random;
	}
	else { $displayname = $settings[1]; }

	$colspan = ($settings[7] eq 'Administrator') ? 3 : 2;
	$width = ($settings[7] eq 'Administrator') ? '33%' : '50%';

	my $scrolling;
	if ($shout_scrolling == 2) { $scrolling = 'auto'; }
	elsif ($shout_scrolling == 1) { $scrolling = 'yes'; }
	else { $scrolling = 'no'; }

	$iframe_url = qq~$cgi;action=shoutboxdisplay~;

	$yymain .= qq~
<table border="0" cellpadding="0" cellspacing="1" width="$shout_box_width">
<tr>
<td colspan="$colspan">~;

	#whether to position the frame at the bottom of the list or top
   	if ($shout_add_to_top)
	{ $yymain .= qq~
<iframe src="$iframe_url" name="chatout" width="100%" height="$shout_box_height" align="center" border="0" frameborder="0" leftmargin="0" topmargin="0" marginwidth="2" marginheight="2" scrolling="$scrolling"><font size="2" face="Verdana">Your browser does not support inline frames or is currently configured not to display inline frames.</font></iframe>~; }
   	else
	{ $yymain .= qq~
<iframe src="$iframe_url" onload="window.chatout.scrollTo(0,99999);" name="chatout" width="100%" height="$shout_box_height" align="center" border="0" frameborder="0" leftmargin="0" topmargin="0" marginwidth="2" marginheight="2" scrolling="$scrolling"><font size="2" face="Verdana">Your browser does not support inline frames or is currently configured not to display inline frames.</font></iframe>~; }

	$yymain .= qq~
</td>
</tr>~;

	#check whether they're a guest before showing the form to add shouts
	unless ($shout_guest_posting == 0 && $username eq 'Guest')
	{
		$yymain .= qq~
<script language="JavaScript" type="text/javascript">
<!--
function smily() { document.editor.message.value += " :)"; }
function smily2() { document.editor.message.value += " ;D"; }
function sad() { document.editor.message.value += " :("; }
function tongue() { document.editor.message.value += " :P"; }
function wink() { document.editor.message.value += " ;)"; }
function angry() { document.editor.message.value += " >:("; }
function cool() { document.editor.message.value += " 8)"; }
function cry() { document.editor.message.value += " :'("; }
// -->
</script>

<form action="$cgi;action=shoutboxadd" method="post" target="chatout" name="editor">~;

		if ($shout_change_names) { $yymain .= qq~
<tr><td colspan="$colspan"><input type="text" name="name" value="$displayname" size="10" maxlength="20" onFocus="javascript:if(this.defaultValue==this.value)this.value='';" style="width:100%;background-color:#F5F5F5;font-family: Verdana, Helvetica, Arial;font-size:10px;color:#000000;"></td></tr>~; }
		else { $yymain .= qq~<input type="hidden" name="name" value="$username">~; }

		$yymain .= qq~
<tr><td colspan="$colspan"><input type="text" name="message" value="$shout_txt{'1'}" size="25" maxlength="$shout_max_shout_length" onFocus="this.value='';" style="width:100%;background-color:#F5F5F5;font-family: Verdana, Helvetica, Arial;font-size:10px;color:#000000;">
<tr><td width="$width"><input type="submit" name="submit" value="$shout_txt{'2'}!" style="width:100%;background-color:#F5F5F5;font-family: Verdana, Helvetica, Arial;font-size:10px;color:#000000;"></td><td width="$width"><input type="submit" name="submit" value="$shout_txt{'3'}" style="width:100%;background-color:#F5F5F5;font-family: Verdana, Helvetica, Arial;font-size:10px;color:#000000;"></td>~;

		if ($settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator') { $yymain .= qq~<td width="$width"><input type="submit" name="submit" value="$shout_txt{'4'}" style="width:100%;background-color:#F5F5F5;font-family: Verdana, Helvetica, Arial;font-size:10px;color:#000000;"></td>~; }

		$yymain .= qq~
</tr></form>

<tr><td colspan="$colspan"><div align="center"><img src="$imagesdir/smiley.gif" onclick="javascript:smily();" alt="$txt{'287'}" border="0">
<img src="$imagesdir/grin.gif" onclick="javascript:smily2();" alt="$txt{'293'}" border="0">
<img src="$imagesdir/sad.gif" onclick="javascript:sad();" alt="$txt{'291'}" border="0">
<img src="$imagesdir/tongue.gif" onclick="javascript:tongue();" alt="$txt{'451'}" border="0">
<img src="$imagesdir/wink.gif" onclick="javascript:wink();" alt="$txt{'292'}" border="0">
<img src="$imagesdir/angry.gif" onclick="javascript:angry();" alt="$txt{'288'}" border="0">
<img src="$imagesdir/cool.gif" onclick="javascript:cool();" alt="$txt{'295'}" border="0">
<img src="$imagesdir/cry.gif" onclick="javascript:cry();" alt="$txt{'530'}" border="0"></div></td></tr>~;
	}

	$yymain .= qq~</table>~;

}



#add a message to the shoutbox
sub ShoutboxAdd
{
	my $message = $FORM{'message'};
	my $name = $FORM{'name'};
	my $submit_type = $FORM{'submit'};

	#just redirect to the display page when we don't want to print the standard message, or if they clicked refresh
	if ($message eq $shout_txt{'1'} || $submit_type eq $shout_txt{'3'})
	{
		$yySetLocation = qq~$cgi;action=shoutboxdisplay~;
		&redirectexit;
	}
	
	#clear the shoutbox file if that's what we've been told to do
	if ($submit_type eq $shout_txt{'4'}) { &ShoutboxClear; }

	#call them "Anon" if they haven't entered a name
	if (!$name) { $name = $shout_txt{'6'}; }

	#append "(Guest)" to their name if they've entered a different name than their randomly-generated "Guest52" etc.
	if ($username eq 'Guest' && $name !~ $txt{'28'})
	{
		 $name = $name . qq~($txt{'28'})~;
	}

	#cut up overly-long strings of characters (15+) with a space to avoid distorting the table too much
	$message =~ s~(\w{15})~$1 ~ig;
	#replace < and > to avoid nastiness
	$message =~ s/</&lt;/g;
	$message =~ s/>/&gt;/g;
	#cut off the message if it's too long
	if (length($message) > $shout_max_shout_length) { $message = substr($message, 0, $shout_max_shout_length); }

	#construct the line to store on file
	$shout_new_line = qq~$name|$message\n~;

	#read in the shout file so we know what we have
	fopen(DATA, "$shout_messages_file"); @lines = <DATA>; fclose(DATA);

	#if there are no lines stored, just add it now
	if (scalar(@lines) == 0) { fopen(DATA, ">$shout_messages_file"); print DATA $shout_new_line; fclose(DATA); }
	else
	{
		#add this line to the shout file and make sure we're only storing as many as we've been told to
		if ($shout_add_to_top)
		{
			unshift(@lines, $shout_new_line);
			while (scalar(@lines) > $shout_max_shouts) { pop(@lines); }
		}
		else
		{
			push(@lines, $shout_new_line);
			while (scalar(@lines) > $shout_max_shouts) { shift(@lines); }
		}

		#add to file
		fopen(DATA, ">$shout_messages_file"); print DATA @lines; fclose(DATA);
	}

	$yySetLocation = qq~$cgi;action=shoutboxdisplay~;
	&redirectexit;
}



#create html output to display the shouts in the iframe
sub ShoutboxDisplay
{
	&LoadCensorList;

	#read the template file
	fopen(FILE, "$shout_template_file"); @lines = <FILE>; fclose(FILE);

	print qq~Content-type:text/html\n\n~;

	foreach $line (@lines)
	{
		#print out the template, replacing <!-- MARKER --> with the shouts
		if ($line eq qq~<!-- MARKER -->\n~)
		{
			#read the messages file
			fopen(FILE, "$shout_messages_file"); @shouts = <FILE>; fclose(FILE);
			chomp @shouts;

			#print each shout in the file
			$count2 = 0;
			foreach $shout_line (@shouts)
			{

				($poster, $shout) = split(/\|/, $shout_line);

				#if name-changing is off, we know that $poster is a username so we can get their real name from it
				if (!$shout_change_names && $poster ne 'Guest')
				{
					if (fopen(MEMFILE, "$memberdir/$poster.dat"))
					{
						@memsets = <MEMFILE>; fclose(MEMFILE);
						chomp $memsets[1];

						$poster = qq~<a href="$cgi;action=viewprofile;username=$poster" target="_top">$memsets[1]</a>~;
					}
				}

				#censor the shout
				foreach (@censored)
				{
					($tmpa,$tmpb) = @{$_};
					$shout =~ s~\Q$tmpa\E~$tmpb~gi;
					$poster =~ s~\Q$tmpa\E~$tmpb~gi;
				}

				#UBBC the shout?
				if ($enable_ubbc) { require "$sourcedir/YaBBC.pl"; $message = $shout; &DoUBBC; $shout = $message; }
				else { $shout =~ s~\n~<br>\n~g; }

				#give this row the right alternating bgcolor
				if ($count2 % 2 == 0) { $bgcolor = 'message1';}
				else  { $bgcolor = 'message2';}
				if ($shout_self_highlight) { if ($poster =~ qq~>$settings[1]<~) { $bgcolor = 'ownmessage'; } }
				$count2++;
				print qq~<tr><td class="$bgcolor"><b>$poster:</b> $shout</td></tr>\n~;
				
			}
		}
		else { print $line; }
	}

	exit;
}



#return $shout_messages_file to its default state
sub ShoutboxClear
{
	unlink($shout_messages_file);

	#whether to position the frame at the bottom of the list or top
	$yySetLocation = qq~$cgi;action=shoutboxdisplay~;
	&redirectexit;
}



#configure the shoutbox options
sub ShoutboxConfig
{
	&is_admin;

	#fill in fields
	$checked_guest_posting = $shout_guest_posting ? ' checked' : '';
	$checked_self_highlight = $shout_self_highlight ? ' checked' : '';
	$checked_change_names = $shout_change_names ? ' checked' : '';
	$checked_add_to_top = $shout_add_to_top ? ' checked' : '';
	if ($shout_scrolling == 0) { $select_scrolling_0 = ' selected'; } elsif ($shout_scrolling == 1) { $select_scrolling_1 = ' selected'; } else { $select_scrolling_2 = ' selected'; }

	$yymain .= qq~
<form action="$cgi;action=shoutboxconfig2" method="POST">
<table border="0" width="70%" cellspacing="1" cellpadding="3" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}">
    <img src="$imagesdir/xx.gif" alt="">
    <font size=2 class="text1" color="$color{'titletext'}"><b>$shout_txt{'7'}</b></font></td>
  <tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><BR><font size="2">

	<p><a href="$cgi;action=shoutboxtemplate">$shout_txt{'20'}</a>.</p>
	
	<table border=0>
	<tr><td><font size="2">$shout_txt{'8'}</font></td>
	<td><input type=checkbox name="guest_posting"$checked_guest_posting></td></tr>

	<tr><td><font size="2">$shout_txt{'9'}</font></td>
	<td><input type=checkbox name="self_highlight"$checked_self_highlight></td></tr>
	
	<tr><td><font size="2">$shout_txt{'10'}</font></td>
	<td><input type=checkbox name="change_names"$checked_change_names></td></tr>
	
 	<tr><td><font size="2">$shout_txt{'11'}</font></td>
	<td><input type=checkbox name="add_to_top"$checked_add_to_top></td></tr>
	
	<tr><td><font size="2">$shout_txt{'12'}</font></td>
	<td><select name="scrolling"><option value="0"$select_scrolling_0>$txt{'164'}</option><option value="1"$select_scrolling_1>$txt{'163'}</option><option value="2"$select_scrolling_2>$shout_txt{'13'}</option></select></td></tr>

	<tr><td><font size="2">$shout_txt{'14'}</font></td>
	<td><input type=text name="max_shouts" size="5" value="$shout_max_shouts" maxlength="2"></td></tr>
	
	<tr><td><font size="2">$shout_txt{'15'}</font></td>
	<td><input type=text name="max_shout_length" size="5" value="$shout_max_shout_length" maxlength="3"></td></tr>
	
	<tr><td><font size="2">$shout_txt{'16'}</font></td>
	<td><input type=text name="refresh" size="5" value="$shout_refresh" maxlength="3"></td></tr>
	
	<tr><td><font size="2">$shout_txt{'17'}</font></td>
	<td><input type=text name="box_width" size="5" value="$shout_box_width" maxlength="3"></td></tr>
	
	<tr><td><font size="2">$shout_txt{'18'}</font></td>
	<td><input type=text name="box_height" size="5" value="$shout_box_height" maxlength="3"></td></tr>
	
	<tr><td><font size="2">$shout_txt{'19'}</font></td>
	<td><input type=text name="rowspan" size="5" value="$shout_rowspan" maxlength="2"></td></tr>
	
	<tr><td></td><td><input type="submit" value="$txt{'10'}"></td></tr>
	
	</table>

    <BR></font></td>
  </tr>
</table>
</form>
~;

	$yytitle = $shout_txt{'7'};
	&template;
	exit;
}



#save the shoutbox options to file
sub ShoutboxConfig2
{
	&is_admin;

	#error checking for bad characters
	if ($FORM{'max_shouts'} =~ /\D/) { &fatal_error($shout_txt{'21'}); }
	if ($FORM{'max_shout_length'} =~ /\D/) { &fatal_error($shout_txt{'21'}); }
	if ($FORM{'rowspan'} =~ /\D/) { &fatal_error($shout_txt{'21'}); }
	if ($FORM{'box_width'} =~ /\D/) { &fatal_error($shout_txt{'21'}); }
	if ($FORM{'box_height'} =~ /\D/) { &fatal_error($shout_txt{'21'}); }

	#default values if submitted bad values
	$shout_guest_posting = $FORM{'guest_posting'} ? 1 : 0;
	$shout_self_highlight = $FORM{'self_highlight'} ? 1 : 0;
	$shout_change_names = $FORM{'change_names'} ? 1 : 0;
	$shout_add_to_top = $FORM{'add_to_top'} ? 1 : 0;
	$shout_scrolling = $FORM{'scrolling'};
	$shout_max_shouts = $FORM{'max_shouts'} || 15;
	$shout_max_shout_length = $FORM{'max_shout_length'} || 150;
	$shout_refresh = $FORM{'refresh'} || -1;
	$shout_box_width = $FORM{'box_width'} || 190;
	$shout_box_height = $FORM{'box_height'} || 190;
	$shout_rowspan = $FORM{'rowspan'} || 6;

	#Checks to see if the order of the list has been reversed
	if ($shout_add_to_top != $shout_add_to_top_old)
	{
		fopen(DATA, "$shout_messages_file"); @lines = <DATA>; fclose(DATA);
		fopen(DATA, ">$shout_messages_file"); print DATA reverse(@lines); fclose(DATA);
	}

	#print to file
	fopen(SETFILE, ">$shout_settings_file");
	print SETFILE qq~\$shout_guest_posting = $shout_guest_posting;
\$shout_self_highlight = $shout_self_highlight;
\$shout_change_names = $shout_change_names;
\$shout_add_to_top = $shout_add_to_top;
\$shout_scrolling = $shout_scrolling;
\$shout_max_shouts = $shout_max_shouts;
\$shout_max_shout_length = $shout_max_shout_length;
\$shout_refresh = $shout_refresh;
\$shout_box_width = $shout_box_width;
\$shout_box_height = $shout_box_height;
\$shout_rowspan = $shout_rowspan;

1;~;
	fclose(SETFILE);

	$yySetLocation = qq~$cgi;action=shoutboxconfig~;
	&redirectexit;
}



#the page for editing the template
sub ShoutboxTemplate
{
	&is_admin;

	#if this is first time run and no template file yet exists, create it with default values
	if (fopen(FILE, "$shout_template_file"))
	{
		@tem_lines = <FILE>; fclose(FILE);
		$template = join("", @tem_lines);
	}
	else { $template = ShoutboxDefaultHTML; }
	
	$yymain .= qq~
<form action="$cgi;action=shoutboxtemplate2" method="POST">
<table border="0" width="70%" cellspacing="1" cellpadding="3" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}">
    <img src="$imagesdir/xx.gif" alt="">
    <font size=2 class="text1" color="$color{'titletext'}"><b>$shout_txt{'20'}</b></font></td>
  <tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><BR><font size="2">
	<p>$shout_txt{'23'}</p>

<textarea cols=70 rows=15 name="template" style="width:100%">$template</textarea><br>
<input type="submit" name="submit" value="$txt{'10'}">&nbsp;<input type="submit" name="submit" value="$shout_txt{'22'}">

    <BR></font></td>
  </tr>
</table>
</form>
~;

	$yytitle = $shout_txt{'20'};
	&template;
	exit;
}



#save the template to file
sub ShoutboxTemplate2
{
	&is_admin;

	if ($FORM{'submit'} eq $shout_txt{'22'} || $FORM{'template'} eq '') { $template = &ShoutboxDefaultHTML; }
	else { $template = $FORM{'template'}; $template =~ s~\r~~g; }

	fopen(FILE, ">$shout_template_file");
	print FILE $template;
	fclose(FILE);

	$yySetLocation = qq~$cgi;action=shoutboxtemplate~;
	&redirectexit;
}



#generate the default HTML for the shoutbox iframe if the user hasn't created any yet or is wiping the file
sub ShoutboxDefaultHTML
{
	#whether to position the frame at the bottom of the list or top
#	$refresh_url = ($shout_add_to_top) ? qq~$cgi;action=shoutboxdisplay~ : qq~$cgi;action=shoutboxdisplay#bottom~;
	$refresh_url = qq~$cgi;action=shoutboxdisplay~;
	#add the positioning html if new shouts are being added to the bottom
#	$bottom_anchor = ($shout_add_to_top) ? '' : qq~\n<a name="bottom"></a>\n~;

	return qq~<html>
<head>
<style type="text/css">
<!--
BODY          { background-color:#F5F5F5; scrollbar-face-color: #AFC6DB; scrollbar-shadow-color: #000000; scrollbar-highlight-color: #DEE7EF;
                scrollbar-3dlight-color: #FFFFFF; scrollbar-darkshadow-color: #AFC6DB;
                scrollbar-track-color: #F5F5F5; scrollbar-arrow-color: #DEE7EF; font-family: Verdana, Helvetica, Arial; 
                font-size:10px; margin-top: 0; margin-bottom:0px; margin-left: 0; margin-right: 0; padding-top: 0; padding-left: 0; 
                padding-right: 0; padding-bottom:0; }
.bordercolor  { background-color: #6394BD; }
td            { font-family: Verdana, Helvetica, Arial; font-size:10px; color:#000000; }
a:link        { color: #005177; font-weight:bold; }
A:visited     { color: #005177; font-weight: bold; }
A:hover       { color: #CC3333; font-weight: bold; }
.message1     { background-color: #AFC6DB; }
.message2     { background-color: #DEE7EF; }
.ownmessage   { background-color: lightgoldenrodyellow; }
-->
</style>

<meta http-equiv="Refresh" content="$shout_refresh">
</head>
<body>

<table border=0 width=100% cellspacing=1 cellpadding=1 class="bordercolor">

<!-- MARKER -->

</table>
$bottom_anchor
</body>
</html>~;
}

1;
