<id>
Sub-Boards for YaBB 2 RC 3
</id>

<version>
0.1.1
</version>

<mod info>
This mod allows one to create sub-boards for YaBB 2 RC 3.

Installation:
1) Save the SubBoard.lng file (English version) to the Languages/English/ directory.
2) Install the Sub-Boards_for_Y2rc3_0-1.mod via BoardMod.exe

To create a sub-board:
1) In the Manage Boards section, edit or add a board.
2) Under the Location option, choose a parent board for your currently edited board, and Save.

To reorder the subboards:
1) Click the "Reorder Sub-boards" link in the Manage Boards section.
2) Rearrange the boards in the order you choose, and Save.
</mod info>

<author>
BRO_co03
</author>

<homepage>
http://broco03.tk
</homepage>

<edit file>
Admin/ManageBoards.pl
</edit file>

<search for>
require "$vardir/membergroups.txt";
</search for>

<add before>
LoadLanguage("SubBoard");
</add before>

<search for>
				$boardname =~ s/\&quot\;/&#34;/g;
				&ToChars($boardname);
				$descr = ${$uid.$curboard}{'description'};
				$descr =~ s~\<br />~\n~g;
				my $bicon ="";
				if (${$uid.$curboard}{'ann'} == 1) {$bicon = qq~ <img src="$imagesdir/ann.gif" alt="$admin_txt{'64g'}" border="0" />~;}
				if (${$uid.$curboard}{'rbin'} == 1) {$bicon = qq~ <img src="$imagesdir/admin_rem.gif" alt="$admin_txt{'64i'}" border="0" />~;}
				$convertstr = $descr;
				$convertcut = 60;
				&CountChars;
				my $descr = $convertstr;
				&ToChars($descr);
				if ($cliped){$descr .= "...";}
				$yymain .= qq~
  <tr>
    <td class="windowbg" width="25%" align="left">$boardname</td>
    <td class="windowbg" width="65%" align="left">$descr</td>
    <td class="windowbg" width="5%" align="center">$bicon</td>
    <td class="titlebg" width="5%" align="center"><input type="checkbox" name="$curboard" value="1" /></td>
  </tr>
~;
		}
	}
}
</search for>

<replace>
				$boardname =~ s/\&quot\;/&#34;/g;
				&ToChars($boardname);
				$descr = ${$uid.$curboard}{'description'};
				$descr =~ s~\<br />~\n~g;
				my $bicon ="";
				if (${$uid.$curboard}{'ann'} == 1) {$bicon = qq~ <img src="$imagesdir/ann.gif" alt="$admin_txt{'64g'}" border="0" />~;}
				if (${$uid.$curboard}{'rbin'} == 1) {$bicon = qq~ <img src="$imagesdir/admin_rem.gif" alt="$admin_txt{'64i'}" border="0" />~;}
				$convertstr = $descr;
				$convertcut = 60;
				&CountChars;
				my $descr = $convertstr;
				&ToChars($descr);
				if ($cliped){$descr .= "...";}
				if ($sboard{"$curboard"} ne "") {
					$reordersubs = qq~<br />(<a href="$adminurl?action=reorderboards;location=board;item=$curboard">$subboard_txt{'1'}</a>)~;
				} else { $reordersubs = ""; }
				$level = 0;
				$yymain .= qq~
  <tr>
    <td class="windowbg" width="25%" align="left">$boardname$reordersubs</td>
    <td class="windowbg" width="65%" align="left">$descr</td>
    <td class="windowbg" width="5%" align="center">$bicon</td>
    <td class="titlebg" width="5%" align="center"><input type="checkbox" name="$curboard" value="1" /></td>
  </tr>
~;
				if ($sboard{"$curboard"} ne "") {
					$subboards = $sboard{"$curboard"};
					$level++;
					&CalcSubBoards2;
				}
		}
	}
}
</replace>

<search for>
		foreach $catid (@categoryorder){
			$boardlist = $cat{$catid};
			(@bdlist) = split(/\,/, $boardlist);
			($curcatname, $catperms) = split(/\|/, $catinfo{"$catid"});
			my $boardcat = ${$uid.$editboards[$i]}{'cat'};
			if ($INFO{"action"} eq "boardscreen"){
				if ($catid eq $boardcat){$selected = qq~selected="selected" ~;} else {$selected = "";}
			}
			$catsel{$i} .= qq~<option value="$catid"$selected>$curcatname</option>~;
		}
		$catsel .= qq~</select>~;
</search for>

<replace>
		foreach $catid (@categoryorder){
			$boardlist = $cat{$catid};
			(@bdlist) = split(/\,/, $boardlist);
			($curcatname, $catperms) = split(/\|/, $catinfo{"$catid"});
			my $boardcat = ${$uid.$editboards[$i]}{'cat'};
			if ($INFO{"action"} eq "boardscreen"){
				if ($catid eq $boardcat && $pboard{"$editboard"} eq ""){$selected = qq~selected="selected" ~;} else {$selected = "";}
			}
			$locsel{$i} .= qq~<option value="cat=$catid"$selected>$curcatname</option>~;
			foreach $board (@bdlist) {
				$level = 1;
				($board_name, $trash, $trash) = split(/\|/, $board{"$board"});
				&CalcIcon;
				$disabled = "";
				if ($INFO{"action"} eq "boardscreen"){
					if ($editboards[$i] eq $board){$disabled = qq~ disabled="disabled" ~;}
				}
				if ($board eq $pboard{"$editboards[$i]"}){$selected = qq~ selected="selected" ~;} else {$selected = "";}
				$locsel{$i} .= qq~<option value="board=$board"$selected$disabled>$icon$board_name</option>~;
				if ($sboard{"$board"} ne "") {
					$subboards = $sboard{"$board"};
					$level++;
					&CalcSubBoards1;
				}
			}
		}
		$locsel{$i} .= qq~</select>~;
</replace>

<search for>
  </tr><tr>
    <td class="windowbg" width="25%" align="left"><b>$admin_txt{'44'}:</b></td>
    <td class="windowbg2" width="75%" colspan="3" align="left"><select name="cat$i">$catsel{$i}</td>
</search for>

<replace>
  </tr><tr>
    <td class="windowbg" width="25%" align="left"><b>$subboard_txt{'2'}:</b></td>
    <td class="windowbg2" width="75%" colspan="3" align="left"><select name="loc$i">$locsel{$i} ($subboard_txt{'3'})</td>
</replace>

<search for>
		if ($FORM{'screenornot'} ne "boardscreen"){
			### adding a board ###
			# make sure no board already exists with that id
			&admin_fatal_error("$admin_txt{'674'} '$id' $admin_txt{'675'}") if (exists $board{"$id"});
			#foreach $catid (@categoryorder){
			#	$boardlist = $cat{$catid};
			#	(@bdlist) = split(/\,/, $boardlist);
			#	($curcatname, $catperms) = split(/\|/, $catinfo{"$catid"});
			#	foreach $curboard (@bdlist) {
			#		&admin_fatal_error("$admin_txt{'674'} '$id' $admin_txt{'675'}") if ($id eq "$curboard");
			#	}
			#}
			my (@bdlist) = split(/\,/, $cat{"$FORM{\"cat$i\"}"});
			push (@bdlist, "$id");
			my ($bdlist) = join (',', @bdlist);
			$cat{$FORM{"cat$i"}} = $bdlist;
			fopen(BOARDINFO, ">$boardsdir/$id.txt");
			print BOARDINFO '';
			fclose(BOARDINFO);
		}
		if ($FORM{'screenornot'} eq "boardscreen"){
			### editing a board ####
			#chomp $cat[0];
			my $category = ${$uid.$id}{'cat'};
			### move category of board ###
			if ($category ne $FORM{"cat$i"}){
				${$uid.$id}{'cat'} = qq~$FORM{"cat$i"}~;
				my (@bdlist) = split(/\,/, $cat{$category});
				#Remove Board from old Category
				my $k = 0;
				foreach $bd (@bdlist){
					if ($id eq $bd){splice (@bdlist,$k,1); }
					$k++;
				}
				my $boardlist = join(',',@bdlist);
				$cat{"$category"} = $boardlist;
				#Add Category to new Category
				my $ncat = $FORM{"cat$i"};
				my $newcat = $cat{$ncat};
				if ($newcat ne ""){$newcat .= ",$id";}
				else {$newcat .= "$id";}
				$cat{$ncat} = $newcat;			
			}
		}
</search for>

<replace>
		### Determine if this a sub-board or not. ###
		($location, $loc_id) = split(/=/, $FORM{"loc$i"});
		if ($FORM{'screenornot'} ne "boardscreen"){
			### adding a board ###
			# make sure no board already exists with that id
			&admin_fatal_error("$admin_txt{'674'} '$id' $admin_txt{'675'}") if (exists $board{"$id"});
			#foreach $catid (@categoryorder){
			#	$boardlist = $cat{$catid};
			#	(@bdlist) = split(/\,/, $boardlist);
			#	($curcatname, $catperms) = split(/\|/, $catinfo{"$catid"});
			#	foreach $curboard (@bdlist) {
			#		&admin_fatal_error("$admin_txt{'674'} '$id' $admin_txt{'675'}") if ($id eq "$curboard");
			#	}
			#}

			if ($location eq "cat") {
				my (@bdlist) = split(/\,/, $cat{"$loc_id"});
				push (@bdlist, "$id");
				my ($bdlist) = join (',', @bdlist);
				$cat{"$loc_id"} = $bdlist;
				$cat_id = $loc_id;
			} else {
				# First, add board to parent's sub-board list.
				if ($sboard{"$loc_id"} eq "") { $sboard{"$loc_id"} .= "$id"; }
				else { $sboard{"$loc_id"} .= ",$id"; }

				# Next, add parent to board's parent board list.
				$pboard{"$id"} = $loc_id;
				$cat_id = ${$uid.$loc_id}{'cat'};
			}
			fopen(BOARDINFO, ">$boardsdir/$id.txt");
			print BOARDINFO '';
			fclose(BOARDINFO);

			if (!$pboard{"$id"}) { $pboard{"$id"} = ""; }
			if (!$sboard{"$id"}) { $sboard{"$id"} = ""; }
		}
		if ($FORM{'screenornot'} eq "boardscreen"){
			### editing a board ####
			#chomp $cat[0];

			# Check to see if it will be a sub-board or not.
			if ($location eq "cat") {
				# It will not be a sub-board.
				if ($pboard{"$id"} eq "") {
					# It is not a sub-board.
					my $category = ${$uid.$id}{'cat'};
					### move category of board ###
					if ($category ne $loc_id){
						${$uid.$id}{'cat'} = qq~$loc_id~;
						my (@bdlist) = split(/\,/, $cat{$category});
						#Remove Board from old Category
						my $k = 0;
						foreach $bd (@bdlist){
							if ($id eq $bd){splice (@bdlist,$k,1); }
							$k++;
						}
						my $boardlist = join(',',@bdlist);
						$cat{"$category"} = $boardlist;

						#Add Category to new Category
						my $ncat = $loc_id;
						my $newcat = $cat{$ncat};
						if ($newcat ne ""){$newcat .= ",$id";}
						else {$newcat .= "$id";}
						$cat{$ncat} = $newcat;
					}
				} else {
					# It is a sub-board, and will not be any more.
					${$uid.$id}{'cat'} = qq~$loc_id~;
	
					# Remove it from its parent's sub-board list.
					$parent = $pboard{"$id"};
					my (@sblist) = split(/\,/, $sboard{$parent});
					my $k = 0;
					foreach $sb (@sblist){
						if ($id eq $sb){splice (@sblist,$k,1); }
						$k++;
					}
					my $sboardlist = join(/\,/,@sblist);
					$sboard{"$parent"} = $sboardlist;
					
					# Add it to a category
					my $ncat = $loc_id;
					my $newcat = $cat{$ncat};
					if ($newcat ne ""){$newcat .= ",$id";}
					else {$newcat .= "$id";}
					$cat{$ncat} = $newcat;
				}
				$cat_id = $loc_id;
			} else {
				# It will be a sub-board.
				# First, check to make sure it's parent board is not already a sub-board
				$parent_check = $loc_id;
				while ($pboard{"$parent_check"} ne "") {
					if ($pboard{"$parent_check"} eq $id) {
						&admin_fatal_error("$subboard_txt{'4'}");
					}
					$parent_check = $pboard{"$parent_check"};
				}
				my $former_category = ${$uid.$id}{'cat'};
				${$uid.$id}{'cat'} = qq~${$uid.$parent_check}{'cat'}~; # Category declared for the navigation links.

				if ($pboard{"$id"} eq "") {
					# It is not a sub-board. Remove it from the Category list.
					my (@bdlist) = split(/\,/, $cat{"$former_category"});
					#Remove Board from old Category
					my $k = 0;
					foreach $bd (@bdlist){
						if ($id eq $bd){splice (@bdlist,$k,1); }
						$k++;
					}
					my $boardlist = join(',',@bdlist);
					$cat{"$category"} = $boardlist;
				} else {
					# It is a sub-board. Remove it from it's parent's sub-board list.
					$parent = $pboard{"$id"};
					my (@sblist) = split(/\,/, $sboard{$parent});
					my $k = 0;
					foreach $sb (@sblist){
						if ($id eq $sb){splice (@sblist,$k,1); }
						$k++;
					}
					my $sboardlist = "";
					foreach $sb (@sblist) {
						if ($sboardlist eq "") { $sboardlist .= "$sb"; }
						else { $sboardlist .= ",$sb"; }
					}
					$sboard{"$parent"} = $sboardlist;
				}
				# Now, let's make it a sub-board
				$pboard{"$id"} = $loc_id;
				if ($sboard{"$loc_id"} eq "") { $sboard{"$loc_id"} .= "$id"; }
				else { $sboard{"$loc_id"} .= ",$id"; }
				$cat_id = ${$uid.$loc_id}{'cat'};
			}
			if (!$pboard{"$id"}) { $pboard{"$id"} = ""; }
			if (!$sboard{"$id"}) { $sboard{"$id"} = ""; }
		}
</replace>

<search for>
sub ReorderBoards {
	&is_admin_or_gmod;
	unless ($mloaded == 1){require "$boardsdir/forum.master";}
	(@bdlist) = split(/\,/, $cat{$INFO{"item"}});
	($curcatname, $catperms) = split(/\|/, $catinfo{$INFO{"item"}});
	# Prepare the list of current boards to be put in the textarea
	foreach $board (@bdlist){
		chomp $board;
		$boardslist .= qq~\n$board~;
	}
	$yymain .= qq~
<br /><br />
<form action="$adminurl?action=reorderboards2;item=$INFO{'item'}" method="POST">
<table border="0" cellspacing="1" class="bordercolor" align="center">
  <tr>
    <td class="titlebg" colspan="2"><img src="$imagesdir/board.gif" /><b>$admin_txt{'46'} ($curcatname)</b><br /><span class="small">$admin_txt{'738'}</span></td>
  </tr><tr>
    <td class="windowbg"  valign="top" align="left"><b>$admin_txt{'825'}<b/></td>
    <td class="windowbg"  valign="top" align="left"><b>$admin_txt{'826'}<b/></td>
  </tr><tr>
    <td class="windowbg"  valign="top" align="center"><br /><textarea name="original" rows="12" cols="20" style="width: 20em; height:20em" readonly>$boardslist</textarea><br /><br />
    <td class="windowbg"  valign=top align="center"><br /><textarea name="neworder" cols="20" rows="12" style="width: 20em; height:20em">$boardslist</textarea><br /><br /></td>
  </tr><tr>
    <td class="titlebg" colspan="2" align="center"><input type="submit" value="Submit" /></form></td>
  </tr>
</table>~;
	$yytitle = "$admin_txt{'46'}";
	$action_area = "manageboards";
	&AdminTemplate;
	exit;
}
</search for>

<replace>
sub ReorderBoards {
	&is_admin_or_gmod;
	unless ($mloaded == 1){require "$boardsdir/forum.master";}
	if ($INFO{"location"} eq "board") {
		(@bdlist) = split(/\,/, $sboard{$INFO{"item"}});
		($locationname, $trash) = split(/\|/, $board{$INFO{"item"}});
		$sectiontitle = "$subboard_txt{'1'}";
		$sectiondesc = "$subboard_txt{'5'}";
	} else {
		(@bdlist) = split(/\,/, $cat{$INFO{"item"}});
		($locationname, $catperms) = split(/\|/, $catinfo{$INFO{"item"}});
		$sectiontitle = "$admin_txt{'46'}";
		$sectiondesc = "$admin_txt{'738'}";
	}
	# Prepare the list of current boards to be put in the textarea
	foreach $board (@bdlist){
		chomp $board;
		$boardslist .= qq~\n$board~;
	}
	$yymain .= qq~
<br /><br />
<form action="$adminurl?action=reorderboards2;location=board;item=$INFO{'item'}" method="POST">
<table border="0" cellspacing="1" class="bordercolor" align="center">
  <tr>
    <td class="titlebg" colspan="2"><img src="$imagesdir/board.gif" /><b>$sectiontitle ($locationname)</b><br /><span class="small">$sectiondesc</span></td>
  </tr><tr>
    <td class="windowbg"  valign="top" align="left"><b>$admin_txt{'825'}<b/></td>
    <td class="windowbg"  valign="top" align="left"><b>$admin_txt{'826'}<b/></td>
  </tr><tr>
    <td class="windowbg"  valign="top" align="center"><br /><textarea name="original" rows="12" cols="20" style="width: 20em; height:20em" readonly>$boardslist</textarea><br /><br />
    <td class="windowbg"  valign=top align="center"><br /><textarea name="neworder" cols="20" rows="12" style="width: 20em; height:20em">$boardslist</textarea><br /><br /></td>
  </tr><tr>
    <td class="titlebg" colspan="2" align="center"><input type="submit" value="Submit" /></form></td>
  </tr>
</table>~;
	$yytitle = "$admin_txt{'46'}";
	$action_area = "manageboards";
	&AdminTemplate;
	exit;
}
</replace>

<search for>
	$cat{$INFO{"item"}} = qq~$tmp_master~;
</search for>

<replace>
	if ($INFO{"location"} eq "board") {
		$sboard{$INFO{"item"}} = qq~$tmp_master~;
	} else {
		$cat{$INFO{"item"}} = qq~$tmp_master~;
	}
</replace>

<search for>
1;
</search for>

<add before>
sub CalcSubBoards1 {
	@boardarray = split(/\,/, $subboards);
	$board_count{"$level"} = @boardarray;
	$board_list{"$level"} = $subboards;
	$boardcount = 0;
	while ($boardcount < $board_count{"$level"}) {
		$cur_board_id = $boardarray[$boardcount];
		($board_name, $trash, $trash) = split(/\|/, $board{"$cur_board_id"});
		&CalcIcon;
		if ($INFO{"action"} eq "boardscreen"){
			if ($editboards[$i] eq $cur_board_id) {
				$disabled = qq~ disabled="disabled" ~;
				$disable_level = $level;
			} else {
				if ($disable_level == $level) {
					$disabled = qq~~;
				}
			}
			if ($cur_board_id eq $pboard{"$editboards[$i]"}){$selected = qq~ selected="selected" ~;} else {$selected = "";}
		}
		$locsel{$i} .= qq~<option value="board=$cur_board_id"$selected$disabled>$icon$board_name</option>~;
		if ($sboard{"$cur_board_id"} ne "") {
			$count_store[$level] = $boardcount;
			$subboards = $sboard{"$cur_board_id"};
			$level++;
			&CalcSubBoards1;
			$level--;
			@boardarray = split(/\,/, $board_list{"$level"});
			$boardcount = $count_store[$level];
		}
		$boardcount++;
	}
}

sub CalcSubBoards2 {
	@boardarray = split(/\,/, $subboards);
	$board_count{"$level"} = @boardarray;
	$board_list{"$level"} = $subboards;
	$boardcount = 0;
	while ($boardcount < $board_count{"$level"}) {
		$cur_board_id = $boardarray[$boardcount];
		($board_name, $trash, $trash) = split(/\|/, $board{"$cur_board_id"});

		$boardname =~ s/\&quot\;/&#34;/g;
		&ToChars($boardname);
		$descr = ${$uid.$cur_board_id}{'description'};
		$descr =~ s~\<br />~\n~g;
		my $bicon ="";
		if (${$uid.$cur_board_id}{'ann'} == 1) {$bicon = qq~ <img src="$imagesdir/ann.gif" alt="$admin_txt{'64g'}" border="0" />~;}
		if (${$uid.$cur_board_id}{'rbin'} == 1) {$bicon = qq~ <img src="$imagesdir/admin_rem.gif" alt="$admin_txt{'64i'}" border="0" />~;}
		$convertstr = $descr;
		$convertcut = 60;
		&CountChars;
		my $descr = $convertstr;
		&ToChars($descr);
		if ($cliped){$descr .= "...";}

		if ($sboard{"$cur_board_id"} ne "") {
			$reordersubs = qq~<br />(<a href="$adminurl?action=reorderboards;location=board;item=$cur_board_id">$subboard_txt{'1'}</a>)~;
		} else { $reordersubs = ""; }
		&CalcIcon;
		$yymain .= qq~
  <tr>
    <td class="windowbg" width="25%" align="left">$icon$board_name$reordersubs</td>
    <td class="windowbg" width="65%" align="left">$descr</td>
    <td class="windowbg" width="5%" align="center">$bicon</td>
    <td class="titlebg" width="5%" align="center"><input type="checkbox" name="$cur_board_id" value="1" /></td>
  </tr>
~;
		if ($sboard{"$cur_board_id"} ne "") {
			$count_store[$level] = $boardcount;
			$subboards = $sboard{"$cur_board_id"};
			$level++;
			&CalcSubBoards2;
			$level--;
			@boardarray = split(/\,/, $board_list{"$level"});
			$boardcount = $count_store[$level];
		}
		$boardcount++;
	}
}

</add before>

<edit file>
Admin/ModList.pl
</edit file>

<search for>
### END BOARDMOD ANCHOR ###
</search for>

<add before>
 	$my_mod = "Sub-Board_for_YaBB_2|BRO_co03|This mod allows one to create sub-boards for YaBB 2. Currently for YaBB 2 RC 3.<br /><br /><b>To create a sub-board:</b><br />1) In the Manage Boards section, edit or add a board.<br />2) Under the Location option, choose a parent board for your currently edited board, and Save.<br /><br /><b>To reorder the subboards:</b><br />1) Click the <u>Reorder Sub-boards</u> link in the Manage Boards section.<br />2) Rearrange the boards in the order you choose, and Save.|0.1|09/14/05";
	push (@installed_mods, "$my_mod");

</add before>

<edit file>
Sources/BoardIndex.pl
</edit file>

<search for>
LoadLanguage("BoardIndex");
</search for>

<add after>
LoadLanguage("SubBoard");
</add after>

<search for>
				if($showmodgroups eq "" && $showmods eq "") { $showmodgroups = qq~<br />~; }
				if($showmodgroups ne "" && $showmods ne "") { $showmods .= qq~<br />~; }
</search for>

<replace>
				if ($sboard{"$curboard"} ne "") {
					my @subboard = split(/\,/, $sboard{"$curboard"});
					$subcount = @subboard;
					if ($subcount == 1) { $subboards = "$subboard_txt{'6'}: "; }
					else {$subboards = "$subboard_txt{'7'}: "; }
					$commacount = 1;
					foreach $sub (@subboard) {
						($subboard_name, $trash, $trash) = split(/\|/, $board{"$sub"});
						if ($commacount++ == 1) {
							$subboards .= qq~<a href="$scripturl?board=$sub" class="nav">$subboard_name</a>~;
						} else {
							$subboards .= qq~, <a href="$scripturl?board=$sub" class="nav">$subboard_name</a>~;
						}
					}
				} else { $subboards = ""; }

				if($showmodgroups eq "" && $showmods eq "" && $subboards eq "") { $subboards = qq~<br />~; }
				if($showmodgroups eq "" && $showmods ne "" && $subboards ne "") { $showmods .= qq~<br />~; }
				if($showmodgroups ne "" && $showmods ne "" && $subboards eq "") { $showmods .= qq~<br />~; }
				if($showmodgroups ne "" && $showmods eq "" && $subboards ne "") { $showmodgroups .= qq~<br />~; }
				if($showmodgroups ne "" && $showmods ne "" && $subboards ne "") { $showmods .= qq~<br />~; $showmodgroups .= qq~<br />~; }
</replace>

<search for>
				$templateblock =~ s/<yabb moderators>/$showmods$showmodgroups/g;
</search for>

<add after>
				$templateblock =~ s/<yabb subboards>/$subboards/g;
</add after>

<edit file>
Sources/Display.pl
</edit file>

<search for>
LoadLanguage("Display");
LoadLanguage("FA");
</search for>

<add after>
LoadLanguage("SubBoard");
</add after>

<search for>
# Template it
</search for>

<add before>
if ($pboard{"$currentboard"} ne "") {
	my @parents = ();
	$parent = $currentboard;
	while ($pboard{"$parent"} ne "") {
		$parent = $pboard{"$parent"};
		unshift(@parents, $parent);
	}
	$parentboards = "";
	foreach $parent (@parents) {
		($parent_name, $trash, $trash) = split(/\|/, $board{"$parent"});
		$parentboards .= qq~<a href="$scripturl?board=$parent" class="nav">$parent_name</a>$parentseparator~;
	}
} else { $parentboards = ""; }

</add before>

<search for>
	$display_template =~ s/<yabb board>/$template_board/g;
</search for>

<add before>
	$display_template =~ s/<yabb parentboards>/$parentboards/g;
</add before>

<edit file>
Sources/MessageIndex.pl
</edit file>

<search for>
LoadLanguage("MessageIndex");
</search for>

<add after>
LoadLanguage("SubBoard");
</add after>

<search for>
LoadLanguage("MessageIndex");
</search for>

<add before>
LoadLanguage("BoardIndex");
</add before>

<search for>
#template it
</search for>

<add before>
if ($sboard{"$currentboard"} ne "") {
	$subboardlist = $sboard{"$currentboard"};
	@sblist = split(/\,/, $subboardlist);
	foreach $curboard (@sblist) {
		## now fill all the neccesary hashes to show all board index stuff ##
		chomp $curboard;
		$cat_boardcnt{$catid}++;
		my ($boardname, $boardperms, $boardview) = split(/\|/, $board{"$curboard"});
		my $access = &AccessCheck($curboard, '', $boardperms);
		if (!$iamadmin && $access ne "granted" && $boardview != 1) {next;}
		push (@goodboards, "$catid|$curboard");
		push (@loadboards, $curboard);
	}
	&BoardTotals("load",@loadboards);
	&getlog(@goodboards);
	foreach $curboard (@loadboards) {
		chomp $curboard;
		$lastposttime = ${$uid.$curboard}{'lastposttime'};
		${$uid.$curboard}{'lastposttime'} = ${$uid.$curboard}{'lastposttime'} eq 'N/A' || ! ${$uid.$curboard}{'lastposttime'} ? $boardindex_txt{'470'} : ${$uid.$curboard}{'lastposttime'};
		if(${$uid.$curboard}{'lastposttime'} != 0){$lastposttime{$curboard} = &timeformat(${$uid.$curboard}{'lastposttime'});} else {$lastposttime{$curboard} = $boardindex_txt{'470'};}
		$lastpostrealtime{$curboard} = ${$uid.$curboard}{'lastposttime'} eq 'N/A' || ! ${$uid.$curboard}{'lastposttime'} ? '' : ${$uid.$curboard}{'lastposttime'};
		$lsreply{$curboard} = ${$uid.$curboard}{'lastreply'}+ 1;
		if( ${$uid.$curboard}{'lastposter'} =~ m~\AGuest-(.*)~ ) {
			${$uid.$curboard}{'lastposter'} = $1;
			$lastposterguest{$curboard} = 1;
		}
		${$uid.$curboard}{'lastposter'} = ${$uid.$curboard}{'lastposter'} eq 'N/A' || ! ${$uid.$curboard}{'lastposter'} ? $boardindex_txt{'470'} : ${$uid.$curboard}{'lastposter'};
		${$uid.$curboard}{'messagecount'} = ${$uid.$curboard}{'messagecount'} || 0;
		${$uid.$curboard}{'threadcount'} = ${$uid.$curboard}{'threadcount'} || 0;
		$totalm += ${$uid.$curboard}{'messagecount'};
		$totalt += ${$uid.$curboard}{'threadcount'};
		## determine the true last post on all the boards a user has access to ##
		if ($lastposttime > $lastthreadtime){
			$lsdatetime = &timeformat($lastposttime);
			$lsposter = ${$uid.$curboard}{'lastposter'};
			$lssub = ${$uid.$curboard}{'lastsubject'};
			&ToChars($lssub);
			$lspostid = ${$uid.$curboard}{'lastpostid'};
			$lsreply = ${$uid.$curboard}{'lastreply'};
			$lastthreadtime = $lastposttime;
		}
	}
	foreach my $boardinfo (@goodboards) {
		chomp $boardinfo;
		my ($testcat);
		($testcat,$curboard)=split(/\|/,$boardinfo);

		if ($testcat ne $catid){next;}
		## as we fill the vars based on all boards we need to skip any cat already shown before ##

		if (${$uid.$curboard}{'ann'} == 1) {${$uid.$curboard}{'pic'} = "ann.gif";}
		if (${$uid.$curboard}{'rbin'} == 1) {${$uid.$curboard}{'pic'} = "recycle.gif";}
		($boardname, $boardperms, $boardview) = split(/\|/, $board{"$curboard"});
		&ToChars($boardname);
		$INFO{'zeropost'} = 0; $zero = "";
		## hide the actual global announcement board for all normal users but admins and gmods ##
		if ($annboard eq $curboard && !$iamadmin && !$iamgmod) {next;}
		## hide the actual recycle bin board for all normal users but admins ##
		if ($annboard eq $curboard && $iamguest && !$iamadmin) {next;}
		$bdpic = ${$uid.$curboard}{'pic'};
		$bddescr = ${$uid.$curboard}{'description'};
		&ToChars($bddescr);
		$bdmods = ${$uid.$curboard}{'mods'};
		$bdmods =~ s/\, /\,/g;
		$bdmods =~ s/\ /\,/g;
		%moderators = ();
		foreach $curuser (split(/\,/, $bdmods)) {
			&LoadUser($curuser);
			$moderators{$curuser} = ${$uid.$curuser}{'realname'};
		}
		$showmods = '';
		if(scalar keys %moderators == 1) { $showmods = qq~$boardindex_txt{'298'}: ~; }
		elsif(scalar keys %moderators != 0) { $showmods = qq~$boardindex_txt{'63'}: ~; }
		while($tmpa = each(%moderators)) {
			&FormatUserName($tmpa);
			$showmods .= qq~<a href="$scripturl?action=viewprofile;username=$useraccount{$tmpa}">$moderators{$tmpa}</a>, ~;
		}
		$showmods =~ s/, \Z//;

		$bdmodgroups = ${$uid.$curboard}{'modgroups'};
		$bdmodgroups =~ s/\, /\,/g;
		%moderatorgroups = ();
		foreach $curgroup (split(/\,/, $bdmodgroups)) {
			$moderatorgroups{$curgroup} = $curgroup;
		}

		$showmodgroups = '';
		if(scalar keys %moderatorgroups == 1) { $showmodgroups = qq~$boardindex_txt{'298a'}: ~; }
		elsif(scalar keys %moderatorgroups != 0) { $showmodgroups = qq~$boardindex_txt{'63a'}: ~; }
		while($tmpa = each(%moderatorgroups)) {
			$showmodgroups .= qq~$moderatorgroups{$tmpa}, ~;
		}
		$showmodgroups =~ s/, \Z//;

		if ($sboard{"$curboard"} ne "") {
			my @subboard = split(/\,/, $sboard{"$curboard"});
			$subcount = @subboard;
			if ($subcount == 1) { $subboards = "$subboard_txt{'6'}: "; }
			else {$subboards = "$subboard_txt{'7'}: "; }
			$commacount = 1;
			foreach $sub (@subboard) {
				($subboard_name, $trash, $trash) = split(/\|/, $board{"$sub"});
				if ($commacount++ == 1) {
					$subboards .= qq~<a href="$scripturl?board=$sub" class="nav">$subboard_name</a>~;
				} else {
					$subboards .= qq~, <a href="$scripturl?board=$sub" class="nav">$subboard_name</a>~;
				}
			}
		} else { $subboards = ""; }

		if($showmodgroups eq "" && $showmods eq "" && $subboards eq "") { $subboards = qq~<br />~; }
		if($showmodgroups eq "" && $showmods ne "" && $subboards ne "") { $showmods .= qq~<br />~; }
		if($showmodgroups ne "" && $showmods ne "" && $subboards eq "") { $showmods .= qq~<br />~; }
		if($showmodgroups ne "" && $showmods eq "" && $subboards ne "") { $showmodgroups .= qq~<br />~; }
		if($showmodgroups ne "" && $showmods ne "" && $subboards ne "") { $showmods .= qq~<br />~; $showmodgroups .= qq~<br />~; }

		my $dlp = $yyuserlog{$curboard} ? $yyuserlog{$curboard} : 0;
		if( $max_log_days_old && ${$uid.$curboard}{'lastposttime'} ne $boardindex_txt{'470'} && !$iamguest && $dlp < $lastpostrealtime{$curboard} && ($dlp>$max_log_days_old*86400 || $dlp eq 0)) {
			$new = qq~<img src="$imagesdir/on.gif" alt="$boardindex_txt{'333'}" border="0" />~;
		}
		else { $new = qq~<img src="$imagesdir/off.gif" alt="$boardindex_txt{'334'}" border="0" />~; }
		if (${$uid.$curboard}{'ann'} == 1) {$new = qq~<img src="$imagesdir/ann.gif" alt="" border="0" />~;}
		if (${$uid.$curboard}{'rbin'} == 1) {$new = qq~<img src="$imagesdir/recycle.gif" alt="" border="0" />~;}
		$lastposter = ${$uid.$curboard}{'lastposter'};
		unless( $lastposterguest{$curboard} || ${$uid.$curboard}{'lastposter'} eq $boardindex_txt{'470'} ) {
			&LoadUser($lastposter);
			$registrationdate = ${$uid.$lastposter}{'regtime'};

			# No Need to open up each threadid.txt JUST to get last post time..
			# It's stored in forum.totals!
			#fopen (MNUM, "$datadir/${$uid.$curboard}{'lastpostid'}.txt");
			#@threadlist = <MNUM>; 
			#($dummy, $dummy, $dummy, $messagedate, $dummy) =  split(/\|/, $threadlist[${$uid.$curboard}{'lastreply'}],5);
			#fclose (MNUM);
				$messagedate = ${$uid.$curboard}{'lastposttime'};
				if((${$uid.$lastposter}{'regdate'} && $messagedate > $registrationdate) || ${$uid.$lastposter}{'status'} eq "Administrator" || ${$uid.$lastposter}{'status'} eq "Global Moderator") { $lastposter = qq~<a href="$scripturl?action=viewprofile;username=$lastposter">${$uid.$lastposter}{'realname'}</a>~; }
			else { $lastposter .= qq~ - $boardindex_txt{'470a'}~; }
		}
		${$uid.$curboard}{'lastposter'} ||= $boardindex_txt{'470'};
		${$uid.$curboard}{'lastposttime'} ||= $boardindex_txt{'470'};

		if ($bdpic =~ /\//i) {$bdpic = qq~ <img src="$bdpic" alt="" border="0" align="middle" /> ~;}
		elsif ($bdpic) {$bdpic = qq~ <img src="$imagesdir/$bdpic" alt="" border="0" align="middle" /> ~;}

		my $templateblock = $subboardblock;
		my $lastpostlink = qq~<a href="$scripturl?num=${$uid.$curboard}{'lastpostid'}/${$uid.$curboard}{'lastreply'}#${$uid.$curboard}{'lastreply'}">$lastposttime{$curboard}</a>~;

		if(!$topiccut){$topiccut = 15;}
		my $lasttopictxt = ${$uid.$curboard}{'lastsubject'};
		$lasttopictxt =~ s/\A\[m\]/$maintxt{'758'}/;

		&LoadCensorList;	# Load Censor List
		# Censor subjects
		$lasttopictxt = &Censor($lasttopictxt);
		&ToChars($lasttopictxt);

		$convertstr = $lasttopictxt;
		$convertcut = $topiccut;
		&FromHTML($convertstr);
		&CountChars;
		my $lasttopictxt = $convertstr;
		&ToChars($lasttopictxt);

		if ($cliped){$lasttopictxt .= "...";}

		$lasttopictxt =~ s/  / \&nbsp;/g;
		$lasttopictxt =~ s/</&lt;/g;
		$lasttopictxt =~ s/>/&gt;/g;
		$lasttopictxt =~ s/\|/\&#124;/g;

		my $lasttopiclink = qq~<a href="$scripturl?num=${$uid.$curboard}{'lastpostid'}/${$uid.$curboard}{'lastreply'}#${$uid.$curboard}{'lastreply'}">$lasttopictxt</a>~;
		if(${$uid.$curboard}{'threadcount'}<0){${$uid.$curboard}{'threadcount'} = 0;}
		if(${$uid.$curboard}{'messagecount'}<0){${$uid.$curboard}{'messagecount'} = 0;}
		$templateblock =~ s/<yabb boardanchor>/$curboard/g;
		$templateblock =~ s/<yabb boardurl>/$scripturl\?board\=$curboard/g;
		$templateblock =~ s/<yabb new>/$new/g;
		$templateblock =~ s/<yabb boardpic>/$bdpic/g;
		$templateblock =~ s/<yabb boardname>/$boardname/g;
		$templateblock =~ s/<yabb boarddesc>/$bddescr/g;
		$templateblock =~ s/<yabb moderators>/$showmods$showmodgroups/g;
		$templateblock =~ s/<yabb subboards>/$subboards/g;
		$templateblock =~ s/<yabb threadcount>/${$uid.$curboard}{'threadcount'}/g;
		$templateblock =~ s/<yabb messagecount>/${$uid.$curboard}{'messagecount'}/g;
		$templateblock =~ s/<yabb lastpostlink>/$lastpostlink/g;
		$templateblock =~ s/<yabb lastposter>/$lastposter/g;
		$templateblock =~ s/<yabb lasttopiclink>/$lasttopiclink/g;

		$subblock .= $templateblock;
	}

	$showsubboards = "$subboardtitle$subboardheader$subblock$subboardfooter";
} else { $showsubboards = ""; }
if ($pboard{"$currentboard"} ne "") {
	my @parents = ();
	$parent = $currentboard;
	while ($pboard{"$parent"} ne "") {
		$parent = $pboard{"$parent"};
		unshift(@parents, $parent);
	}
	$parentboards = "";
	foreach $parent (@parents) {
		($parent_name, $trash, $trash) = split(/\|/, $board{"$parent"});
		$parentboards .= qq~<a href="$scripturl?board=$parent" class="nav">$parent_name</a>$parentseparator~;
	}
} else { $parentboards = ""; }


</add before>

<search for>
	$messageindex_template =~ s/<yabb board>/$boardlink/g;
</search for>

<add before>
	$messageindex_template =~ s/<yabb parentboards>/$parentboards/g;
</add before>

<search for>
	$messageindex_template =~ s/<yabb moderators>/$modslink$showmodgroups/g;
</search for>

<add after>
	$messageindex_template =~ s/<yabb subboardblock>/$showsubboards/g;
</add after>

<edit file>
Sources/Subs.pl
</edit file>

<search for>
			if ($board eq $currentboard) { $selecthtml .= "<option selected=\"selected\" value=\"?board=$board\">=> $boardname</option>\n"; }
			else { $selecthtml .= "<option value=\"?board=$board\">&nbsp; - $boardname</option>\n"; }
</search for>

<replace>
			$level = 0;
			&CalcIcon;
			if ($board eq $currentboard) { $selecthtml .= "<option selected=\"selected\" value=\"?board=$board\">=> $boardname</option>\n"; }
			else { $selecthtml .= "<option value=\"?board=$board\">&nbsp; - $boardname</option>\n"; }
			if ($sboard{"$board"} ne "") {
				$subboards = $sboard{"$board"};
				$level++;
				&CalcSubBoards3;
			}
</replace>

<search for>
sub Write_ForumMaster {
	fopen(FORUMMASTER, ">$boardsdir/forum.master", 1);	
   	print FORUMMASTER qq~\$mloaded = 1;\n~;
	@catorder = &undupe(@categoryorder);
    print FORUMMASTER qq~\@categoryorder = qw(@catorder);\n~;
    while (($key, $value) = each(%cat)){
		# Escape membergroups with a $ in them
		$value =~ s~\$~\\\$~g;
        print FORUMMASTER qq~\$cat{'$key'} = "$value";\n~;
    }
    while (($key, $value) = each(%catinfo)){
		# Escape membergroups with a $ in them
		$value =~ s~\$~\\\$~g;
        print FORUMMASTER qq~\$catinfo{'$key'} = "$value";\n~;
    }
    while (($key, $value) = each(%board)){
		# Escape membergroups with a $ in them
		$value =~ s~\$~\\\$~g;
        print FORUMMASTER qq~\$board{'$key'} = "$value";\n~;
    }
    print FORUMMASTER qq~\n1;~;
	fclose(FORUMMASTER);
}
</search for>

<replace>
sub Write_ForumMaster {
	fopen(FORUMMASTER, ">$boardsdir/forum.master", 1);	
   	print FORUMMASTER qq~\$mloaded = 1;\n~;
	@catorder = &undupe(@categoryorder);
    print FORUMMASTER qq~\@categoryorder = qw(@catorder);\n~;
    while (($key, $value) = each(%cat)){
		# Escape membergroups with a $ in them
		$value =~ s~\$~\\\$~g;
        print FORUMMASTER qq~\$cat{'$key'} = "$value";\n~;
    }
    while (($key, $value) = each(%catinfo)){
		# Escape membergroups with a $ in them
		$value =~ s~\$~\\\$~g;
        print FORUMMASTER qq~\$catinfo{'$key'} = "$value";\n~;
    }
    print FORUMMASTER qq~\n~;
    while (($key, $value) = each(%board)){
		# Escape membergroups with a $ in them
		$value =~ s~\$~\\\$~g;
        print FORUMMASTER qq~\$board{'$key'} = "$value";\n~;
    }
    print FORUMMASTER qq~\n~;
    while (($key, $value) = each(%pboard)){
		# Escape membergroups with a $ in them
		$value =~ s~\$~\\\$~g;
        print FORUMMASTER qq~\$pboard{'$key'} = "$value";\n~;
    }
    print FORUMMASTER qq~\n~;
    while (($key, $value) = each(%sboard)){
		# Escape membergroups with a $ in them
		$value =~ s~\$~\\\$~g;
        print FORUMMASTER qq~\$sboard{'$key'} = "$value";\n~;
    }
    print FORUMMASTER qq~\n1;~;
	fclose(FORUMMASTER);
}
</replace>

<search for>
1;
</search for>

<add before>
sub CalcSubBoards3 {
	@boardarray = split(/\,/, $subboards);
	$board_count{"$level"} = @boardarray;
	$board_list{"$level"} = $subboards;
	$boardcount = 0;
	while ($boardcount < $board_count{"$level"}) {
		$cur_board_id = $boardarray[$boardcount];
		($board_name, $trash, $trash) = split(/\|/, $board{"$cur_board_id"});

		if ($cur_board_id eq $currentboard) {
			$level--;
			&CalcIcon;
			$selecthtml .= "<option selected=\"selected\" value=\"?board=$cur_board_id\">&nbsp; $icon=> $board_name</option>\n";
			$level++;
		} else {
			&CalcIcon;
			$selecthtml .= "<option value=\"?board=$cur_board_id\">&nbsp; $icon- $board_name</option>\n";
		}

		if ($sboard{"$cur_board_id"} ne "") {
			$count_store[$level] = $boardcount;
			$subboards = $sboard{"$cur_board_id"};
			$level++;
			&CalcSubBoards3;
			$level--;
			@boardarray = split(/\,/, $board_list{"$level"});
			$boardcount = $count_store[$level];
		}
		$boardcount++;
	}
}

sub CalcIcon {
	my $start = $level;
	$icon = "";
	while ($start > 0) {
		$icon .= "- ";
		$start--;
	}
}



</add before>

<edit file>
Templates/default/BoardIndex.template
</edit file>

<search for>
	<td class="windowbg2" width="55%" align="left"><a name="<yabb boardanchor>" href="<yabb boardurl>"><yabb boardpic><b><yabb boardname></b></a><br /><yabb boarddesc><br /><br /><span class="small"><i><yabb moderators></i></span></td>
</search for>

<replace>
	<td class="windowbg2" width="55%" align="left"><a name="<yabb boardanchor>" href="<yabb boardurl>"><yabb boardpic><b><yabb boardname></b></a><br /><yabb boarddesc><br /><br /><span class="small"><i><yabb moderators></i></span><span class="small"><i><yabb subboards></i></span></td>
</replace>

<edit file>
Templates/default/Display.template
</edit file>

<search for>
		<b><yabb home>  <yabb category>  <yabb board></b> <yabb moderators>
</search for>

<replace>
		<b><yabb home>  <yabb category>  <yabb parentboards><yabb board></b> <yabb moderators>
</replace>

<search for>
		<b><yabb home>  <yabb category>  <yabb board></b> <yabb moderators>
</search for>

<replace>
		<b><yabb home>  <yabb category>  <yabb parentboards><yabb board></b> <yabb moderators>
</replace>

<search for>
1;
</search for>

<add before>
$parentseparator = " - ";

</add before>

<edit file>
Templates/default/MessageIndex.template
</edit file>

<search for>
<!-- Navigation Bar start -->

<span class="small"><b><yabb home>  <yabb category>  <yabb board></b> <yabb moderators></span>

<!-- Navigation Bar end -->
</search for>

<replace>
<!-- Navigation Bar start -->

<span class="small"><b><yabb home>  <yabb category>  <yabb parentboards><yabb board></b> <yabb moderators></span>

<!-- Navigation Bar end -->
</replace>

<search for>
	  <span class="small"><b><yabb home>  <yabb category>  <yabb board></b> <yabb moderators></span>
</search for>

<replace>
	  <span class="small"><b><yabb home>  <yabb category>  <yabb parentboard><yabb board></b> <yabb moderators></span>
</replace>

<search for>
<!-- Navigation Bar end -->

</search for>

<add after>
<!-- Sub-Board block start, should be left as is -->

<yabb subboardblock>

<!-- Sub-Board block end, should be left as is -->
</add after>

<search for>
1;
</search for>

<add before>
$subboardtitle = qq~
<!-- Sub-Board Title Bar start -->

<div class="seperator">
<table cellpadding="4" cellspacing="1" border="0" width="100%">
<tr>
	<td class="titlebg" colspan="2" width="60%">
		$boardindex_txt{'20'}
	</td>
	<td class="titlebg" width="24%" align="center">
		$boardindex_txt{'22'}
	</td>
	<td class="titlebg" width="8%" align="center">
		$boardindex_txt{'330'}
	</td>
	<td class="titlebg" width="8%" align="center">
		$boardindex_txt{'21'}
	</td>
</tr>
</table>
</div><br />

<!-- Sub-Board Title Bar end -->
~;

$subboardheader = qq~
<div class="boardcontainer">
<table cellpadding="4" cellspacing="1" border="0" width="100%">
~;

$subboardblock = qq~
<tr>
	<td class="windowbg" width="5%" align="center" valign="top"><yabb new></td>
	<td class="windowbg2" width="55%" align="left"><a name="<yabb boardanchor>" href="<yabb boardurl>"><yabb boardpic><b><yabb boardname></b></a><br /><yabb boarddesc><br /><br /><span class="small"><i><yabb moderators></i></span><span class="small"><i><yabb subboards></i></span></td>
	<td class="windowbg" valign="middle" align="center" width="24%"><span class="small"><yabb lastpostlink><br /><img src="$imagesdir/lastpost.gif" border="0" alt="" /> <yabb lasttopiclink><br />$boardindex_txt{'525'} <yabb lastposter></span></td>
	<td class="windowbg2" valign="middle" align="center" width="8%"><yabb threadcount></td>
	<td class="windowbg2" valign="middle" align="center" width="8%"><yabb messagecount></td>
</tr>
~;

$subboardfooter = qq~
</table>
</div><br />
~;

$parentseparator = " - ";

</add before>