<id>
User Age in Message View for YaBB 2.5 (To work with the COPPA Compliance Mod)
</id>

<version>
1.2
</version>

<mod info>
Description
-----------
This mod will add users age in the message view if the birthdate field is filled out.
You can enable/disable this option in the Admin Center. 

Installation
------------
1) Modify YaBB files using BoardMod or manually.
2) Upload modified files to your server in ASCII mode.
3) Go into Admin Center => Forum Settings => Show / Hide Items to enable the setting.

Files to edit
-------------
Admin/ManageTemplates.pl
Admin/ModList.pl
Admin/NewSettings.pl
Admin/Settings_Main.pl
Languages/English/Admin.lng
Languages/English/Display.lng 
Sources/Display.pl 
Sources/MyCenter.pl
Templates/default/Display.template
Templates/default/MyCenter.template
Templates/yabb21/Display.template
Templates/yabb21/MyCenter.template

Version History
---------------
1.0 - First Release - 6th January 2009
1.1 - Updated for YaBB 2.4 - 15th April 2009
1.2 - Updated for YaBB 2.5 - 24th April 2012
</mod info>

<author>
Derek Barnstorm
</author>

<homepage>
http://www.boardmod.org
</homepage>

<edit file>
Admin/ManageTemplates.pl
</edit file>

<search for>
		$outblock =~ s/({|<)yabb gender(}|>)//g;
</search for>

<add after>
		$outblock =~ s/({|<)yabb age(}|>)//g;
</add after>

<edit file>
Admin/ModList.pl
</edit file>

<search for>
### END BOARDMOD ANCHOR ###
</search for>

<add before>
	$userage_mod = "User Age in Message View|Derek Barnstorm|This mod will add users age in the message view if the birthdate field is filled out.|1.2|24th April 2012";
	push (@installed_mods, "$userage_mod");
	
</add before>

<edit file>
Admin/NewSettings.pl
</edit file>

<search for>
\$showgenderimage = $showgenderimage;			# Set to 1 to display each member's gender in the message view (by the ICQ.. etc.)
</search for>

<add after>
\$showuserage = $showuserage;                   # Set to 1 to display each member's age in the message view 
</add after>

<edit file>
Admin/Settings_Main.pl
</edit file>

<search for>
			name => 'showgenderimage',
			validate => 'boolean',
		},
</search for>

<add after>
		{
			description => qq~<label for="showuserage">$admin_txt{'show_user_age'}</label>~,
			input_html => qq~<input type="checkbox" name="showuserage" id="showuserage" value="1"${ischecked($showuserage)} />~,
			name => 'showuserage',
			validate => 'boolean',
		}, 
</add after>

<edit file>
Languages/English/Admin.lng
</edit file>

<search for>
);

%floodtxt = (
</search for>

<add before>
'show_user_age' => 'Show User Age in Message View?', 
</add before>

<edit file>
Languages/English/Display.lng
</edit file>

<search for>
);

1;
</search for>

<add before>
'age' => 'Age', 
</add before>

<edit file>
Sources/Display.pl
</edit file>

<search for>
		my ($userlocation, $aimad, $yimad, $msnad, $gtalkad, $skypead, $myspacead, $facebookad, $icqad, $buddyad, $addbuddy, $isbuddy, $addbuddylink, $userOnline, $signature_hr, $lastmodified, $memberinfo, $template_postinfo, $template_ext_prof, $template_profile, $template_quote, $template_email, $template_www, $template_pm);
</search for>

<add after>
		my $template_age;
</add after>

<search for>
			$template_postinfo = qq~$display_txt{'21'}: $tmppostcount<br />~;
</search for>

<add after>
            if (${$uid.$musername}{'bday'} && $showuserage && (!${$uid.$musername}{'hideage'} || $iamadmin || !$allow_hide_age)) {
			    &CalcAge($musername, "calc");
			    $template_age = qq~$display_txt{'age'}: $age<br />~;
			}
</add after>

<search for>
		$outblock =~ s/({|<)yabb gender(}|>)/${$uid.$musername}{'gender'}/g;
</search for>

<add after>
		$outblock =~ s/({|<)yabb age(}|>)/$template_age/g;
</add after>

<edit file>
Sources/MyCenter.pl
</edit file>

<search for>
		my $template_postinfo = qq~$mycenter_txt{'posts'}: ~ . &NumberFormat(${$uid.$username}{'postcount'}) . qq~<br />~;
</search for>

<add after>
		my $template_age;
		if (${$uid.$username}{'bday'} && $showuserage) {
		    &CalcAge($username, "calc");
		    $template_age = qq~$profile_txt{'420'}: $age<br />~;
		}
</add after>

<search for>
		$myprofileblock =~ s/({|<)yabb gender(}|>)/${$uid.$username}{'gender'}/g;
</search for>

<add after>
		$myprofileblock =~ s/({|<)yabb age(}|>)/$template_age/g;
</add after>

<edit file>
Templates/default/Display.template
</edit file>

<search for>
	    <b>{yabb gender}</b>
</search for>

<add before>
	    <b>{yabb age}</b>
</add before>

<edit file>
Templates/default/MyCenter.template
</edit file>

<search for>
		{yabb gender}
</search for>

<add after>
		{yabb age}
</add after>

<edit file>
Templates/yabb21/Display.template
</edit file>

<search for>
		<yabb gender>
</search for>

<add after>
		<yabb age>
</add after>

<edit file>
Templates/yabb21/MyCenter.template
</edit file>

<search for>
		<yabb gender>
</search for>

<add after>
		<yabb age>
</add after>
