<id>
Whisper mod YaBB 2.1
</id>

<version>
1.0
</version>

<mod info>
This mod adds the capability to Whisper to a person, or to all except a person. A new YaBBC tag is created:

[whisper=<username>,<username>,<username>,etc]
...
...
...
[/whisper]

The format is as such: [whisper=username,username2,username3] text to be whispered [/whisper] for text _to_ a person, and
[whisper!username,username2,username3] text to be whispered [/whisper] for text to all _except_ a person.

Administrators/Moderators can ALWAYS see whispered text. Normal users will only see [This is a private whisper to <screen names>]

This is a revision of the Whisper Beta mod made available for YaBB 1.4 by Christer(krikkert) with his permission.  

Concerns on upgrading from YaBB 1.4 to YaBB 2.1:

Anyone who had the original version in YaBB 1.4 and upgraded to YaBB 2 would have had to make revisions to YaBBC.pl, and Printpage.pl in order to hide those whispers since a Whisper mod was not available for YaBB 2 (until now).  Those revisions will need to be undone.  If you don't know what I'm talking about, don't worry about it.  If you are thinking that maybe your forum might apply, search YaBBC.pl and Printpage.pl for "whisper" and remove the line that contains it.  This mod file assumes that these issues (if applicable) have been taken care of.

If you are upgrading from YaBB 1.4 to YaBB 2.1 and want to apply this mod in conjunction with your overall upgrade, it will not require any special actions on your part, and all of your previous whispers in messages should still apply.

</mod info>

<author>
Imp_In_Training
</author>

<homepage>
darkandmoodyforums.com
</homepage>

<edit file>
Sources/YaBBC.pl 
</edit file>

<search for>
LoadLanguage("Post");
</search for>

<add after>
LoadLanguage("Whisper");
</add after>

<search for>
sub quotemsg {
</search for>

<add before>
## Added with Whisper mod

sub whisper { 
	my ($whisper_name, $whisper_msg) = @_;
	my ($whispered, $collectednames, $return_whsp);
	@whispsub = split(/\,/, $whisper_name);
	foreach $name (@whispsub) { 
		&LoadUserDisplay($name);
		$collectednames .= qq~$userprofile{$name}->[1]\,~;
		if (lc $name eq lc $realname) { 
			$whispered = "user";
		} elsif (lc $realname eq lc $tmpuname || $iammod || &iamadmin || $iamgmod { 
			$whispered = "adm"; 
		}
	}
	chop($collectednames);
	$collectednames = $Whisper{'2'} . $collectednames;
	$return_whsp = $Whisper{'5'};
	$return_whsp =~ s~QUOTE~$whisper_msg~g;
	$return_whsp =~ s~NAMES~$collectednames~g;
	if(!$whispered) { $return_whsp = ""; }
	return $return_whsp;
} 
sub xwhisper { 
	if ($username ne 'Guest') {
		my ($whisper_name, $whisper_msg) = @_;
		my ($whispered, $collectednames, $return_whsp);
		@whispsub = split(/\,/, $whisper_name);
		foreach $name (@whispsub) { 
			&LoadUserDisplay($name);
			$collectednames .= qq~$userprofile{$name}->[1]\,~;
			if (lc $name ne lc $realname) { 
				$whispered = "user";
			} elsif (lc $realname eq lc $tmpuname || $iammod || $iamadmin || $iamgmod { 
				$whispered = "adm"; 
			}
		}
		chop($collectednames);
		$collectednames = $Whisper{'4'} . $collectednames;
		$return_whsp = $Whisper{'5'};
		$return_whsp =~ s~QUOTE~$whisper_msg~g;
		$return_whsp =~ s~NAMES~$collectednames~g;
		if(!$whispered) { $return_whsp = ""; }
		return $return_whsp;
	}
} 

## End Whisper mod
 
</add before>

<search for>
	$message =~ s~\/me\s+(.*)~<span style="color: #FF0000;"><i>* $displayname $1</i></span>~ig;
</search for>

<add after>

## Added with Whisper mod

	$message =~ s~\[whisper\=(.+?)\](.+?)\[\/whisper\]~&whisper($1,$2)~eisg; 
	$message =~ s~\[whisper\!(.+?)\](.+?)\[\/whisper\]~&xwhisper($1,$2)~eisg; 

## End Whisper mod

</add after>

<edit file>
Sources/Printpage.pl
</edit file>

<search for>
sub Print_IM {
</search for>

<add before>
LoadLanguage("Whisper");

</add before>

<search for>
	$threadpost =~ s~\[news\](.+?)\[/news\]~$1~isg;
	$threadpost =~ s~\[gopher\](.+?)\[/gopher\]~$1~isg;
	$threadpost =~ s~\[ftp\](.+?)\[/ftp\]~$1~isg;
</search for>

<add after>

## Added with Whisper mod

	require "$sourcedir/YaBBC.pl";
	$message =~ s~\[whisper\=(.+?)\](.+?)\[\/whisper\]~$Whisper{'1'} $1, $Whisper{'6'} $2)~eisg; 
	$message =~ s~\[whisper\!(.+?)\](.+?)\[\/whisper\]~$Whisper{'3'} $1, $Whisper{'6'} $2~eisg; 

## End whisper mod

</add after>

<edit file>
Sources/Post.pl
</edit file>

<search for>
		if ($quotemsg ne '') {
			($msubject, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage, $mns) = split(/\|/, $messages[$quotemsg]);
			$message = $mmessage;
			$message =~ s~<br>~\n~ig;
			$message =~ s~<br />~\n~g;
			$message =~ s/ \&nbsp; \&nbsp; \&nbsp;/\t/ig;
			if (!$nestedquotes) {
				$message =~ s~\n{0,1}\[quote([^\]]*)\](.*?)\[/quote\]\n{0,1}~\n~isg;
				$message =~ s~\n*\[/*quote([^\]]*)\]\n*~~ig;
			}
			$mname ||= $musername || $post_txt{'470'};
			$quotestart = int($quotemsg / $maxmessagedisplay) * $maxmessagedisplay;
			$message    = qq~[quote author=$mname link=$threadid/$quotestart#$quotemsg date=$mdate\]$message\[/quote\]\n~;
			$msubject =~ s/\bre:\s+//ig;
			if ($mns eq "NS") { $nscheck = "checked"; }
</search for>

<add after>
## Modified with Whisper mod

			$message =~ s~\[whisper(.+?)\](.+?)\[\/whisper\]~~eisg; 

## End Whisper mod

</add after>
