<id>
Whisper mod
</id>

<version>
1.4
</version>

<mod info>
This mod adds the capability to Whisper to a person, or to all except a person. A new YaBBC tag is created:

[whisper=<username>,<username>,<username>,etc]
...
...
...
[/whisper]

The format is as such: [whisper=username,username2,username3] text to be whispered [/whisper] for text _to_ a person, and
[whisper!username,username2,username3] text to be whispered [/whisper] for text to all _except_ a person.

Administrators/Moderators can ALWAYS see whispered text. Normal users will only see [This is a private whisper to <screen names>]

Issues fixed and left to fix:
1...When you quote a whispered message, it is visible in the message textarea on the post page. 
<<<Fixed>>>
2...The author of the message cannot see whispered text (the $musername variable isn't normally available in the YaBBC.pl file.) 
<<<Believed fixed by passing the username in  a variable to &DoUBBC;>>>
3...The code above has two different messages depending on who is viewing the whispered message and who it was intended for. I think I prefer the one that admins/moderators see that includes the name of the intended recipient. This may have to be altered so that it shows the screen name instead of the username. 
<<<Believed fixed>>>
4...Some formatting will probably have to be added to whispered text to make it stand out from the rest. 
<<Added Quote formatting>>
5...Don't forget: When you add extra UBBC tags, they will have to be added to Printpage.pl as well! 
<<<added>>>

</mod info>

<author>
Christer(krikkert)
</author>

<homepage>
None ATM
</homepage>

<edit file>
Sources/YaBBC.pl 
</edit file>

<search for>
sub quotemsg {
</search for>

<add before>
sub whisper { 
	my ($whisper_name, $whisper_msg) = @_;
	my ($whispered, $collectednames, $return_whsp);
	@whispsub = split(/\,/, $whisper_name);
	foreach $name (@whispsub) { 
		&LoadUserDisplay($name);
		$collectednames .= qq~$userprofile{$name}->[1]\,~;
		if (lc $name eq lc $username) { 
			$whispered = "user";
		} elsif (lc $username eq lc $tmpuname || $moderators{$username} || $settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator') { 
			$whispered = "adm"; 
		}
	}
	chop($collectednames);
	$collectednames = "To " . $collectednames;
	$return_whsp = $YaBBCtxt{'whsp6'};
	$return_whsp =~ s~QUOTE~$whisper_msg~g;
	$return_whsp =~ s~NAMES~$collectednames~g;
	if(!$whispered) { $return_whsp = ""; }
	return $return_whsp;
} 
sub xwhisper { 
	if ($username ne 'Guest') {
		my ($whisper_name, $whisper_msg) = @_;
		my ($whispered, $collectednames, $return_whsp);
		@whispsub = split(/\,/, $whisper_name);
		foreach $name (@whispsub) { 
			&LoadUserDisplay($name);
			$collectednames .= qq~$userprofile{$name}->[1]\,~;
			if (lc $name ne lc $username) { 
				$whispered = "user";
			} elsif (lc $username eq lc $tmpuname || $moderators{$username} || $settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator') { 
				$whispered = "adm"; 
			}
		}
		chop($collectednames);
		$collectednames = "To all except " . $collectednames;
		$return_whsp = $YaBBCtxt{'whsp6'};
		$return_whsp =~ s~QUOTE~$whisper_msg~g;
		$return_whsp =~ s~NAMES~$collectednames~g;
		if(!$whispered) { $return_whsp = ""; }
		return $return_whsp;
	}
} 
 
</add before>

<search for>
	$message =~ s~\/me\s+(.*)~<font color="#FF0000">* $displayname $1</font>~ig;
</search for>

<add after>
	$message =~ s~\[whisper\=(.+?)\](.+?)\[\/whisper\]~&whisper($1,$2)~eisg; 
	$message =~ s~\[whisper\!(.+?)\](.+?)\[\/whisper\]~&xwhisper($1,$2)~eisg; 
</add after>

<edit file>
Sources/Printpage.pl
</edit file>

<search for>
		$threadpost =~ s~\[news\](.+?)\[/news\]~$1~isg;
		$threadpost =~ s~\[gopher\](.+?)\[/gopher\]~$1~isg;
		$threadpost =~ s~\[ftp\](.+?)\[/ftp\]~$1~isg;
</search for>

<add after>
	require "$sourcedir/YaBBC.pl";
	$message =~ s~\[whisper\=(.+?)\](.+?)\[\/whisper\]~Whisper to: $1, message: $2)~eisg; 
	$message =~ s~\[whisper\!(.+?)\](.+?)\[\/whisper\]~Whisper to all except: $1, message: $2~eisg; 
</add after>

<edit file>
Sources/Post.pl
</edit file>

<search for>
		if($quotemsg ne '') {
			($msubject, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage, $mns) = split(/\|/,$messages[$quotemsg]);
			$message=$mmessage;
			$message =~ s~<br>~\n~g;
			$message =~ s~\n{0,1}\[quote([^\]]*)\](.*?)\[/quote\]\n{0,1}~\n~isg;
			$message =~ s~\n*\[/*quote([^\]]*)\]\n*~~ig;

			$mname ||= $musername || $txt{'470'};
			$quotestart = int( $quotemsg / $maxmessagedisplay ) * $maxmessagedisplay;
			$message = qq~[quote author=$mname link=board=$currentboard;num=$threadid;start=$quotestart#$quotemsg date=$mdate\]$message\[/quote\]\n~;
			$msubject =~ s/\bre:\s+//ig;
			if ($mns eq "NS") {$nscheck="checked";}
		}
</search for>

<replace>
		if($quotemsg ne '') {
			($msubject, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage, $mns) = split(/\|/,$messages[$quotemsg]);
			$message=$mmessage;
			$message =~ s~<br>~\n~g;
			$message =~ s~\n{0,1}\[quote([^\]]*)\](.*?)\[/quote\]\n{0,1}~\n~isg;
			$message =~ s~\n*\[/*quote([^\]]*)\]\n*~~ig;

			$mname ||= $musername || $txt{'470'};
			$quotestart = int( $quotemsg / $maxmessagedisplay ) * $maxmessagedisplay;
			$message = qq~[quote author=$mname link=board=$currentboard;num=$threadid;start=$quotestart#$quotemsg date=$mdate\]$message\[/quote\]\n~;
			$msubject =~ s/\bre:\s+//ig;
			if ($mns eq "NS") {$nscheck="checked";}
			$message =~ s~\[whisper(.+?)\](.+?)\[\/whisper\]~~eisg; 
		}
</replace>

<edit file>
english.lng
</edit file>

<search for>
if($MenuType == 1) {
</search for>

<add before>
$YaBBCtxt{'whsp1'} = "Whispers to ";
#$YaBBCtxt{'whsp2'} = "Whisper to you: ";
$YaBBCtxt{'whsp3'} = "This is a private whisper to ";
$YaBBCtxt{'whsp4'} = "Whispers to all except: ";
$YaBBCtxt{'whsp5'} = "This is a private whisper to everyone except you";
# Do NOT translate the below line except the word 'Whisper'
$YaBBCtxt{'whsp6'} = qq~<B>Whisper:</B><table bgcolor="$color{'bordercolor'}" class="bordercolor" cellspacing="1" width="90%"><tr><td width="100%"><table cellpadding="2" cellspacing="0" class="quote" width="100%"><tr><td width="100%"><font face="Arial,Helvetica" class="quote" size="1">NAMES <b>-</b> QUOTE</font></td></tr></table></td></tr></table>~;

</add before>


