<id>
Add More Membergroups
</id>

<version>
1.5
</version>

<mod info>
This allows you to add as much Membergroups as you want easily from the Admin Center.

- you can choose how many stars a Membergroup should have
  and can choose a pic for the stars (ex: staradmin.gif)
- you can add Membergroups to the category access list and if a user reaches
  the post count of the Membergroup the category will become visible
  and accessable for him
- if you give a user a Membergroup nothing else will be shown in the
  user display - except if he's an Moderator in a forum
- full implemented Global Moderator Mod (created by DaveB)
- you can set effects/colors to the MemberNames assigned to the
  Membergroups
- you can create MemberGroups which aren't accessable by posts
- you can search Members which you have given a specific MemberGroup

History:
V 1.5.1
- SP1.3.2 compatible

V 1.5:

- SP1.3/1.3.1 compatible
- Added ability to hide Admins, GMods and Mods from Thread Display
- Added ability to add MemberGroups in any order you want/need
- Added ability to use MemberGroup-Display in YaBB Standard
- Added easy MemberGroup update functions
- Improved Speed for Assigned Member Search
- Fixed Bug where Admins lost powers if they updated their profile if Admin Group Name was changed
- Fixed Bug where users still had no access to hidden forums which got available for them throug postcount
- Compatible with more mods

V 1.2:

- Fixed bug which shows hidden Board to users which got access through their postcount there but hadn't let them entered
- Fixed bug which caused loosing Administrator powers if you renamed the Admin Display Name and edited Admin profile
- Fixed bug which had showed wrong MemberGroup Names for Admin and Global Mod if Membergroup was renamed
- Cleaned some code

V 1.1:

- Fixed the bug that Global Moderators and Admins weren't checked in the Category options if they got access to a Category.
- Fixed the bug that Global Moderators and Admins still have access if the Displayed Names of the Membergroups were changed.
- Fixed some Layout Bugs (Class Tags)
- Fixed the bug that the Moderator Function picture wasn't shown
</mod info>

<author>
dOCda S!
</author>

<homepage>

</homepage>

<edit file>
english.lng
</edit file>

<search for>
$txt{'800'} = "Other";
</search for>

<add after>
# Add More MemberGroups Mod

$txt{'gmod1'} = "Admin";
$txt{'gmod2'} = "Global Moderator";
$txt{'gmod3'} = "Show Global Moderators the \"Global Moderators - Center\"?";
$txt{'gmod4'} = "Global Moderators";
$txt{'gmod5'} = "YaBB Global Moderators Center";
$txt{'gmod6'} = "This is your '$txt{'gmod5'}'. You can ban Members, edit the News and take a look into the board statistics.<BR><BR>We thank you for using <a href=\"http://yabb.xnull.com\" target=\"_blank\">YaBB</a>!";
$txt{'gmod7'} = "Allow $txt{'gmod4'} to see hidden email addresses?";
$txt{'gmod8'} = "Allow $txt{'gmod4'} to edit the forum template?";
$txt{'gmod9'} = "Allow $txt{'gmod4'} to edit Boards and Categories?";
$txt{'gmod10'} = "Allow $txt{'gmod4'} to ban members?";
$txt{'gmod11'} = "Allow $txt{'gmod4'} to do basic forum maintenance?";
$txt{'gmod12'} = "Allow $txt{'gmod4'} to edit user profiles (high security items not editable)?";
$amgtxt{'01'} = "Colors/Effects Center for Member Names";
$amgtxt{'02'} = "Allow Global Moderators to edit news and ban members?";
$amgtxt{'03'} = "Member Title to display";
$amgtxt{'04'} = "# of Posts";
$amgtxt{'05'} = "# of Stars";
$amgtxt{'06'} = "Star";
$amgtxt{'07'} = "Effect";
$amgtxt{'08'} = "Color";
$amgtxt{'09'} = "Example";
$amgtxt{'10'} = "Global Moderator Center";
$amgtxt{'11'} = "This is your Global Moderator Center. You can add/edit news items and the banned user listing.<BR><BR>If you have any problems, please read <a href=\"$helpfile\" target=\"_blank\">the manual</a> regarding these features as listed under the admin functions! You may also find answers to your problems on the";
$amgtxt{'12'} = "support forum";
$amgtxt{'13'} = "or at";
$amgtxt{'14'} = "BoardMod's Site";
$amgtxt{'15'} = "Global Moderator Options";
$amgtxt{'16'} = "Description";
$amgtxt{'17'} = "Choose Star";
$amgtxt{'18'} = "Own Pic";
$amgtxt{'19'} = "Pic";
$amgtxt{'20'} = "Administrator Star";
$amgtxt{'21'} = "Global Mod Star";
$amgtxt{'22'} = "Moderator Star";
$amgtxt{'23'} = "Blue Star";
$amgtxt{'24'} = "Silver Star";
$amgtxt{'25'} = "Gold Star";
$amgtxt{'26'} = "Other";
$amgtxt{'27'} = "Del?";
$amgtxt{'28'} = "Here you can edit/delete Member Groups!";
$amgtxt{'29'} = "Here you can add new Member Groups!";
$amgtxt{'30'} = "Search assigned Members";
$amgtxt{'31'} = "Choose MemberGroup";
$amgtxt{'32'} = "No Members found with that search criteria!";
$amgtxt{'33'} = "<b>Sorry! You made an error!</b><br><br><i><u>Error information:</u><br><br>You gave a new MemberGroup a higher or equal postcount than an already existing MemberGroup!<br>This would end in a board failure by output the user-info!<br>Please use your back button and fix this error!</i>";
$amgtxt{'34'} = "Moderator Functions:";
$amgtxt{'35'} = "YaBB Style MemberGroups Display in Posts";
$amgtxt{'36'} = "Hide Administrator Status in Posts and IMs";
$amgtxt{'37'} = "Hide Global Moderator Status in Posts and IMs";
$amgtxt{'38'} = "Hide Moderator Status in Posts";
$amgtxt{'39'} = "Allow $txt{'gmod4'} to edit the censored words?";
$amgtxt{'40'} = "Allow $txt{'gmod4'} to view the forum statistics?";
$amgtxt{'41'} = "Allow $txt{'gmod4'} to edit the news?";
$amgtxt{'42'} = "Rebuild MemberGroups Files";
$amgtxt{'43'} = "Update Assigned MemberGroups for Users";
$amgtxt{'44'} = "Missed to mark a user?";
$amgtxt{'45'} = "You've missed to upload the MemberStats.txt to your \"Variables\" directory!<br>Please Upload the file in ASCII into the directory before proceeding.";
$amgtxt{'46'} = "You've missed to upload the MemberGroups.pl to your \"Sources\" directory!<br>Please Upload the file in ASCII into the directory before proceeding.";
</add after>

<search for>
	$img{'admin_func'} = qq~<img src="$imagesdir/admin.gif" alt="$txt{'137'}" title="$txt{'137'}" border="0"> <font size="1" class="imgbg">$txt{'137'}</font>~;
</search for>

<add after>
	$img{'moderator_func'} = qq~<font size="1" class="imgbg">$amgtxt{'34'}</font>~;
</add after>

<search for>
	$img{'admin_func'} = qq~<img src="$imagesdir/admin.gif" alt="$txt{'137'}" title="$txt{'137'}" border="0"> <font size="1" class="imgbg">$txt{'137'}</font>~;
</search for>

<add after>
	$img{'moderator_func'} = qq~<img src="$imagesdir/admin.gif" alt="$txt{'137'}" border="0"> <font size="1" class="imgbg">$amgtxt{'34'}</font>~;
</add after>

<edit file>
YaBB.pl
</edit file>

<search for>
require "$sourcedir/Security.pl";
</search for>

<add after>
if (!-e("$vardir/MemberStats.txt"))  { &fatal_error("$amgtxt{'45'}"); }
if (!-e("$sourcedir/MemberGroups.pl"))  { &fatal_error("$amgtxt{'46'}"); }
require "$vardir/MemberStats.txt";
</add after>

<edit file>
Sources/Admin.pl
</edit file>

<search for>
        <td bgcolor="$color{'catbg'}" height="19" class="catbg"><img src="$imagesdir/board.gif" alt="" border="0"> <font size="2"><b>$txt{'426'}</b></font></td>
      </tr><tr>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2"><font size="1">
</search for>

<add after>
        - <a href="$cgi;action=modmemgr">$txt{'8'}</a><br>
        - <a href="$cgi;action=cefmemgr">$amgtxt{'01'}</a><br>
        - <a href="$cgi;action=assigned">$amgtxt{'30'}</a><br>
        - <a href="$cgi;action=rebmemgrp">$amgtxt{'42'}</a><br>
        - <a href="$cgi;action=memupdate">$amgtxt{'43'}</a><br>
        <hr width="100%" size="1" class="hr">
</add after>

<search for>
        - <a href="$cgi;action=viewmembers">$txt{'5'}</a><br>
        - <a href="$cgi;action=modmemgr">$txt{'8'}</a><br>
</search for>

<replace>
        - <a href="$cgi;action=viewmembers">$txt{'5'}</a><br>
</replace>

<search for>
sub FullStats {
	&is_admin;
</search for>

<replace>
sub FullStats {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator' && $showgmod_info != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
		$yyAccessCat{$curcat} = $settings[7] eq 'Administrator' || $moderators{$username} || ! $curcataccess;
</search for>

<replace>
		$yyAccessCat{$curcat} = $settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator' || $moderators{$username} || ! $curcataccess;
</replace>

<search for>
	&LoadAdmins;
</search for>

<add after>
	&LoadGMods;
</add after>

<search for>
    <font size="2"><B>$txt{'684'}:</B></font> <font size="1">$administrators</font><BR><BR>
</search for>

<add after>
    <font size="2"><B>$txt{'gmod4'}:</B></font> <font size="1">$gmoderators</font><BR><BR>
</add after>

<search for>
sub ShowClickLog {
	&is_admin;
</search for>

<replace>
sub ShowClickLog {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $showgmod_info != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub AdminBoardRecount {
	&is_admin;
</search for>

<replace>
sub AdminBoardRecount {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_maint != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub RebuildMemList { 
	&is_admin; 
</search for>

<replace>
sub RebuildMemList { 
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_maint != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub ipban {
	&is_admin;
</search for>

<replace>
sub ipban {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_ban != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub ipban2 {
	&is_admin;
</search for>

<replace>
sub ipban2 {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_ban != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
	print FILE "$FORM{'ban_memname'}";
	fclose(FILE);
	$yySetLocation = qq~$cgi;action=admin~;
</search for>

<replace>
	print FILE "$FORM{'ban_memname'}";
	fclose(FILE);
	if ($settings[7] eq 'Global Moderator') {
	$yySetLocation = qq~$cgi\;action=moderate~;
	} else {
	$yySetLocation = qq~$cgi\;action=admin~;
	}
</replace>

<search for>
sub ver_detail {
	&is_admin;
</search for>

<replace>
sub ver_detail {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $showgmod_info != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<edit file>
Sources/AdminEdit.pl
</edit file>

<search for>
	my($snfchecked, $fls1, $fls2, $fls3, $utfchecked, $truncchecked, $mts1, $mts2, $mts3, $tsl6, $tsl5, $tsl4, $tsl3, $tsl2, $tsl1);
</search for>

<add after>
	my($gmodchecked, $disprealinfochecked, $hideadminchecked, $hidegmodchecked, $hidemodchecked);
	my($gmodedittemplate, $gmodeditcat, $gmodban, $gmodmaint, $gmodeditprof);
</add after>

<search for>
	if ($enable_ubbc) { $ubbcchecked = ' checked'; }
</search for>

<add before>
	if ($allow_mod) { $gmodchecked = ' checked'; }
	if ($disprealinfo) { $disprealinfochecked = ' checked'; }
	if ($hideadmin) { $hideadminchecked = ' checked'; }
	if ($hidegmod) { $hidegmodchecked = ' checked'; }
	if ($hidemod) { $hidemodchecked = ' checked'; }
	if ($showgmod_info) {$gmodshowstats = ' checked'; }
	if ($allowgmod_censor) {$gmodshowcensor = ' checked'; }
	if ($allowgmod_edittemp) {$gmodedittemplate = ' checked'; }
	if ($allowgmod_editcat) {$gmodeditcat = ' checked'; }
	if ($allowgmod_ban) {$gmodban = ' checked'; }
	if ($allowgmod_news) {$gmodnews = ' checked'; }
	if ($allowgmod_maint) {$gmodmaint = ' checked'; }
	if ($allowgmod_editprof) {$gmodeditprof = ' checked'; }
</add before>

<search for>
    <td colspan=2 class="windowbg2" bgcolor="$color{'windowbg2'}">
    <HR size=1 width="100%" class="hr"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$txt{'588'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="jrmem" size="5" value="$JrPostNum"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$txt{'589'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="fullmem" size="5" value="$FullPostNum"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$txt{'590'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="srmem" size="5" value="$SrPostNum"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$txt{'591'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="godmem" size="5" value="$GodPostNum"></td>
  </tr><tr>
</search for>

<replace>
    <td colspan="2" bgcolor="$color{'titlebg'}" height="19" class="titlebg"><img src="$imagesdir/guest.gif" alt="" border="0" align="absmiddle"> <font size="2" color="$color{'titletext'}"><b>MemberGroups Options</b></font></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$amgtxt{'35'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="oldskool" value="1"$disprealinfochecked></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$txt{'gmod3'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="allow_mod" value="1"$gmodchecked></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$amgtxt{'40'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="showgmod_info" value="1"$gmodshowstats></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$amgtxt{'41'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="allowgmod_news" value="1"$gmodnews></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$amgtxt{'39'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="allowgmod_censor" value="1"$gmodshowcensor></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$txt{'gmod8'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="allowgmod_edittemp" value="1"$gmodedittemplate></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$txt{'gmod9'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="allowgmod_editcat" value="1"$gmodeditcat></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$txt{'gmod10'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="allowgmod_ban" value="1"$gmodban></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$txt{'gmod11'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="allowgmod_maint" value="1"$gmodmaint></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$txt{'gmod12'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="allowgmod_editprof" value="1"$gmodeditprof></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$amgtxt{'36'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="hideadmin" value="1"$hideadminchecked></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$amgtxt{'37'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="hidegmod" value="1"$hidegmodchecked></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$amgtxt{'38'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="hidemod" value="1"$hidemodchecked></td>
  </tr><tr>
    <td colspan="2" align="right" bgcolor="$color{'titlebg'}" height="19" class="titlebg"><font size="1" color="$color{'titletext'}"><b><I>AMM 1.5</I></b>&nbsp;</font></td>
  </tr><tr>
    <td colspan="2" align="right" bgcolor="$color{'windowbg2'}" height="19">&nbsp;</td>
  </tr><tr>
</replace>

<search for>
	$timeout = $FORM{'timeout'} || 5;
</search for>

<add before>
	$allow_mod = $FORM{'allow_mod'} || 0;
	$disprealinfo = $FORM{'oldskool'} || 0;
	$hideadmin = $FORM{'hideadmin'} || 0;
	$hidegmod = $FORM{'hidegmod'} || 0;
	$hidemod = $FORM{'hidemod'} || 0;
	$showgmod_info = $FORM{'showgmod_info'} || 0;
	$allowgmod_censor = $FORM{'allowgmod_censor'} || 0;
	$allowgmod_edittemp = $FORM{'allowgmod_edittemp'} || 0;
	$allowgmod_editcat = $FORM{'allowgmod_editcat'} || 0;
	$allowgmod_ban = $FORM{'allowgmod_ban'} || 0;
	$allowgmod_news = $FORM{'allowgmod_news'} || 0;
	$allowgmod_maint = $FORM{'allowgmod_maint'} || 0;
	$allowgmod_editprof = $FORM{'allowgmod_editprof'} || 0;
</add before>

<search for>
	$maxsiglen = $FORM{'maxsiglen'} || 200;
	$maxsiglen =~ s/\D//g;
	$jrmem = $FORM{'jrmem'} || 50;
	$jrmem =~ s/\D//g;
	$fullmem = $FORM{'fullmem'} || 100;
	$fullmem =~ s/\D//g;
	$srmem = $FORM{'srmem'} || 250;
	$srmem =~ s/\D//g;
	$godmem = $FORM{'godmem'} || 500;
	$godmem =~ s/\D//g;</search for>

<replace>
	$maxsiglen = $FORM{'maxsiglen'} || 200;
	$language = $FORM{'language'} || 'english.lng';
</replace>

<search for>
########## Feature Settings ##########
</search for>

<add before>
######## AMM Feature Settings ########

\$disprealinfo = $disprealinfo;				# Set to 1 to use YaBBs original MemberGroup display in posts
\$hideadmin = $hideadmin;				# Set to 1 to disable showing Admin Status in Posts and IMs
\$hidegmod = $hidegmod;					# Set to 1 to disable showing Global Mod Status in Posts and IMs
\$hidemod = $hidemod;					# Set to 1 to disable showing Moderato Status in Posts
\$allow_mod = $allow_mod;  				# Set to 1 to activate a "Global Moderators - Center"
\$allowgmod_news = $allowgmod_news;			# Set to 1 to let Global Moderators edit the news
\$showgmod_info = $showgmod_info;	  		# Set to 1 to let Global Moderators see board statistics
\$allowgmod_censor = $allowgmod_censor;  		# Set to 1 to let Global Moderators edit censored words
\$allowgmod_edittemp = $allowgmod_edittemp;  		# Set to 1 to let Global Moderators edit the forum template
\$allowgmod_editcat = $allowgmod_editcat;  		# Set to 1 to let Global Moderators edit the forum boards and categories
\$allowgmod_ban = $allowgmod_ban;  			# Set to 1 to let Global Moderators edit the ban list
\$allowgmod_maint = $allowgmod_maint;  			# Set to 1 to let Global Moderators perform routine forum maintenance
\$allowgmod_editprof = $allowgmod_editprof;		# Set to 1 to let Global Moderators edit non-security related profile items
</add before>

<search for>
########## Membergroups ##########

\$JrPostNum = $jrmem;					# Number of Posts required to show person as 'junior' membergroup
\$FullPostNum = $fullmem;				# Number of Posts required to show person as 'full' membergroup
\$SrPostNum = $srmem;					# Number of Posts required to show person as 'senior' membergroup
\$GodPostNum = $godmem;					# Number of Posts required to show person as 'god' membergroup


########## MemberPic Settings ##########
</search for>

<replace>
########## MemberPic Settings ##########
</replace>

<search for>
sub EditNews {
	&is_admin;
</search for>

<replace>
sub EditNews {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_news != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub EditNews2 {
	&is_admin;
</search for>

<replace>
sub EditNews2 {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_news != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
	print FILE "$FORM{'news'}";
	fclose(FILE);
	$yySetLocation = qq~$cgi\;action=admin~;
</search for>

<replace>
	print FILE "$FORM{'news'}";
	fclose(FILE);
	if ($settings[7] eq 'Global Moderator') {
	$yySetLocation = qq~$cgi\;action=moderate~;
	} else {
	$yySetLocation = qq~$cgi\;action=admin~;
	}
</replace>

<search for>
sub SetCensor {
	&is_admin;
</search for>

<replace>
sub SetCensor {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_censor != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub SetCensor2 {
	&is_admin;
</search for>

<replace>
sub SetCensor2 {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_censor != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
	fopen(FILE, ">$vardir/censor.txt", 1);
	foreach my $i (@lines) {
		$i =~ tr/\n//d;
		unless( $i && $i =~ m~.+\=.+~ ) { next; }
		print FILE "$i\n";
	}
	fclose(FILE);
	$yySetLocation = qq~$cgi;action=admin~;
</search for>

<replace>
	fopen(FILE, ">$vardir/censor.txt", 1);
	foreach my $i (@lines) {
		$i =~ tr/\n//d;
		unless( $i && $i =~ m~.+\=.+~ ) { next; }
		print FILE "$i\n";
	}
	fclose(FILE);
	if ($settings[7] eq 'Global Moderator') {
	$yySetLocation = qq~$cgi\;action=moderate~;
	} else {
	$yySetLocation = qq~$cgi\;action=admin~;
	}
</replace>

<search for>
sub ModifyTemplate {
	&is_admin;
</search for>

<replace>
sub ModifyTemplate {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_edittemp != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub ModifyTemplate2 {
	&is_admin;
</search for>

<replace>
sub ModifyTemplate2 {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_edittemp != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
	print FILE $FORM{'template'};
	fclose(FILE);
	$yySetLocation = qq~$cgi;action=admin~;
</search for>

<replace>
	print FILE $FORM{'template'};
	fclose(FILE);
	if ($settings[7] eq 'Global Moderator') {
	$yySetLocation = qq~$cgi\;action=moderate~;
	} else {
	$yySetLocation = qq~$cgi\;action=admin~;
	}
</replace>

<edit file>
Sources/BoardIndex.pl
</edit file>

<search for>
		foreach $tmpa (@membergroups) { if($tmpa eq $settings[7]) { $openmemgr{$curcat} = 1; last; } }
		if(!$cataccess{$curcat} || $settings[7] eq 'Administrator') { $openmemgr{$curcat} = 1; }
</search for>

<replace>
		my($mscount);
		$mscount=0;
		foreach $tmpa (@membergroups) {
			if( $tmpa eq $settings[7]) { $openmemgr{$curcat} = 1; last; }
	while($MemStat[$mscount]) {
	if($settings[6] >= $MemPostNum[$mscount] && $MemPostNum[$mscount] ne "x") {
	$memberinfo = "$MemStat[$mscount]"; }
	++$mscount;
	}
	if ( $memberinfo eq $tmpa ) { $openmemgr{$curcat} = 1; last; }
		}
		if( ! $cataccess{$curcat} || $settings[7] eq 'Administrator' ) { $openmemgr{$curcat} = 1; }
</replace>

<edit file>
Sources/Display.pl
</edit file>

<search for>
	if(exists $moderators{$username} || $settings[7] eq 'Administrator') {
		$yymain .= qq~<font size="1"><b>$img{'admin_func'}</b>
</search for>

<replace>
	if(exists $moderators{$username} || $settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator') {
		if($settings[7] eq 'Administrator') {$sadminf = $img{'admin_func'};} else {$sadminf = $img{'moderator_func'};}
		$yymain .= qq~<font size="1"><b>$sadminf</b>
</replace>

<search for>
		$mip = $settings[7] eq 'Administrator' ? $mip : "$txt{'511'}";
</search for>

<replace>
		if ($settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator' && $allow_mod == 1) { $mip = $mip } else { $mip = "$txt{'511'}"; }
</replace>

<search for>
			$usernamelink = qq~<font size="2"><b>$mname</b></font>~;
			$postinfo = '';
</search for>

<replace>
			$usernamelink = qq~<font size="2"><b>$mname</b></font>~;
			if ($memberinfo eq "$txt{'28'}") { $usernamelink = qq~<font size="2"><b>$mname<br></b></font>~; }
			$postinfo = '';
</replace>

<search for>
			$usernamelink = qq~<a href="$scripturl?board=$currentboard;action=viewprofile;username=$useraccount{$musername}"><font size="2"><b>$userprofile[1]</b></font></a>~;
</search for>

<replace>
			$usernamelink = $link{$musername};
</replace>

<search for>
            $usernamelink<br>
</search for>

<replace>
            $usernamelink
</replace>

<search for>
	elsif ($userprofile[19] ne "checked" || $settings[7] eq "Administrator" || $allow_hide_email ne 1) {
</search for>

<replace>
	elsif ($userprofile[19] ne "checked" || $settings[7] eq "Administrator" || $settings[7] eq "Global Moderator" || $allow_hide_email ne 1) {
</replace>

<search for>
	if(exists $moderators{$username} || $settings[7] eq 'Administrator' || $username eq $musername) {
</search for>

<replace>
	if(exists $moderators{$username} || $settings[7] eq 'Administrator' || $username eq $musername || $settings[7] eq 'Global Moderator') {
</replace>

<search for>
	# For each post in this thread:
	foreach (@messages) {
</search for>

<add after>
		undef $realgroup;
</add after>

<search for>
			$memail = $userprofile[2];
		}
		else {
			$musername = "Guest";
</search for>

<replace>
			$memail = $userprofile[2];
if ($disprealinfo == 1) {
	if ($userprofile[7] ne "Global Moderator" && $userprofile[7] ne "Administrator") {
				undef $star;
				require "$sourcedir/MemberGroups.pl";
				$realname=$musername;
				&Load_Real_Group;
				$realgroup = "$memrealinfo{$realname}";
				$star = $memberstar{$musername};
		if ($memrealinfo{$realname} eq "$memberinfo{$musername}") { $realgroup = ""; }
	}
}
		}
		else {
			$musername = "Guest";
</replace>

<edit file>
Sources/InstantMessage.pl
</edit file>

<search for>
			$memail = $userprofile[2];
		}
		if (!$useraccount{$musername}) {$usernamelink=qq~<font  size="2"><B>$musername</B></font>~; $memberinfo ="<b>$txt{'783'}</b>"; $displayname = $musername;}
		foreach (@censored) {
</search for>

<replace>
			$memail = $userprofile[2];
			$usernamelink = $link{$musername};
		}
		if (!$useraccount{$musername}) {$usernamelink=qq~<font size="2"><B>$musername</B></font>~; $memberinfo ="<b>$txt{'783'}</b>";}
		foreach (@censored) {
</replace>

<search for>
			$memail = $userprofile[2];
		}
		if (!$useraccount{$musername}) {$usernamelink=qq~<font size="2"><B>$musername</B></font>~; $memberinfo ="<b>$txt{'783'}</b>"; $displayname = $musername;}
		$message = $immessage; # put the message back in the proper variable for doing ubbc
		foreach (@censored) {
</search for>

<replace>
			$memail = $userprofile[2];
			$usernamelink = $link{$musername};
		}
		if (!$useraccount{$musername}) {$usernamelink=qq~<font size="2"><B>$musername</B></font>~; $memberinfo ="<b>$txt{'783'}</b>"; $displayname = $musername;}
		$message = $immessage; # put the message back in the proper variable for doing ubbc
		foreach (@censored) {
</replace>

<edit file>
Sources/Load.pl
</edit file>

<search for>
	if($userprofile{$user}->[6] > $GodPostNum) {
		$memberinfo{$user} = "$membergroups[6]";
		$memberstar{$user} = qq~<img src="$imagesdir/star.gif" border="0" alt="*"><img src="$imagesdir/star.gif" border="0" alt="*"><img src="$imagesdir/star.gif" border="0" alt="*"><img src="$imagesdir/star.gif" border="0" alt="*"><img src="$imagesdir/star.gif" border="0" alt="*">~;
	}
	elsif($userprofile{$user}->[6] > $SrPostNum) {
		$memberinfo{$user} = "$membergroups[5]";
		$memberstar{$user} = qq~<img src="$imagesdir/star.gif" border="0" alt="*"><img src="$imagesdir/star.gif" border="0" alt="*"><img src="$imagesdir/star.gif" border="0" alt="*"><img src="$imagesdir/star.gif" border="0" alt="*">~;
	}
	elsif($userprofile{$user}->[6] > $FullPostNum) {
		$memberinfo{$user} = "$membergroups[4]";
		$memberstar{$user} = qq~<img src="$imagesdir/star.gif" border="0" alt="*"><img src="$imagesdir/star.gif" border="0" alt="*"><img src="$imagesdir/star.gif" border="0" alt="*">~;
	}
	elsif($userprofile{$user}->[6] > $JrPostNum) {
		$memberinfo{$user} = "$membergroups[3]";
		$memberstar{$user} = qq~<img src="$imagesdir/star.gif" border="0" alt="*"><img src="$imagesdir/star.gif" border="0" alt="*">~;
	}
	else {
		$memberinfo{$user} = "$membergroups[2]";
		$memberstar{$user} = qq~<img src="$imagesdir/star.gif" border="0" alt="*">~;
	}
	if(exists $moderators{$user} && $sender ne "im") {
		$modinfo{$user} = "<i>$membergroups[1]</i><BR>";
		$memberstar{$user} = qq~<img src="$imagesdir/starmod.gif" border="0" alt="*"><img src="$imagesdir/starmod.gif" border="0" alt="*"><img src="$imagesdir/starmod.gif" border="0" alt="*"><img src="$imagesdir/starmod.gif" border="0" alt="*"><img src="$imagesdir/starmod.gif" border="0" alt="*">~;
	}
	if($userprofile{$user}->[7] eq 'Administrator') {
		$memberstar{$user} = qq~<img src="$imagesdir/staradmin.gif" border="0" alt="*"><img src="$imagesdir/staradmin.gif" border="0" alt="*"><img src="$imagesdir/staradmin.gif" border="0" alt="*"><img src="$imagesdir/staradmin.gif" border="0" alt="*"><img src="$imagesdir/staradmin.gif" border="0" alt="*">~;
		$memberinfo{$user} = "<B>$membergroups[0]</B>";
	}
	if($userprofile{$user}->[7] && $userprofile{$user}->[7] ne 'Administrator') { $groupinfo{$user} = "$userprofile{$user}->[7]<BR>"; }
	if($userprofile{$user}->[7] ne 'Administrator') {
		$memberinfo{$user} = "$modinfo{$user}$groupinfo{$user}$memberinfo{$user}";
	}
</search for>

<replace>
	if( $userprofile{$user}->[7] eq 'Administrator' && $hideadmin != 1) {
		if ($MemTypeAdmin == 1)    {	$link{$user} = qq~<table style="filter:shadow(color=$MemTypeColAdmin, direction=left)"><a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$color{'fadertext2'}><b>$userprofile{$user}->[1]</b></font></a></table>~; }
		elsif ($MemTypeAdmin == 2) {	$link{$user} = qq~<table style=filter:glow(color=$MemTypeColAdmin, strength=5)"><a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$color{'fadertext2'}><b>$userprofile{$user}->[1]</b></font></a></table>~; }
		else 			   {	$link{$user} = qq~<a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$MemTypeColAdmin><b>$userprofile{$user}->[1]</b></font></a><br>~; }
		$memberinfo{$user} = "<B>$MemStatAdmin</B>";
		$starnum = "0";
		if ($MemStarNumAdmin eq "") { $MemStarNumAdmin = "0"; }
		$memberstartemp ='';
		while($MemStarNumAdmin ne "$starnum") {
		$memberstartemp .= qq(<img src="$imagesdir/$MemStarPicAdmin" border="0" alt="*">);
           ++$starnum;
           }
           $memberstar{$user} = $memberstartemp;
	$starnum = "0";
	}

	elsif ( $userprofile{$user}->[7] eq 'Global Moderator' && $hidegmod != 1) {
		if ($MemTypeGMod == 1)    {	$link{$user} = qq~<table style="filter:shadow(color=$MemTypeColGMod, direction=left)"><a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$color{'fadertext2'}><b>$userprofile{$user}->[1]</b></font></a></table>~; }
		elsif ($MemTypeGMod == 2) {	$link{$user} = qq~<table style=filter:glow(color=$MemTypeColGMod, strength=5)"><a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$color{'fadertext2'}><b>$userprofile{$user}->[1]</b></font></a></table>~; }
		else 			   {	$link{$user} = qq~<a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$MemTypeColGMod><b>$userprofile{$user}->[1]</b></font></a><br>~; }  
		$memberinfo{$user} = "<B>$MemStatGMod</B>";
		$starnum = "0";
		if ($MemStarNumGMod eq "") { $MemStarNumGMod = "0"; }
		$memberstartemp ='';
		while($MemStarNumGMod ne "$starnum") {
		$memberstartemp .= qq(<img src="$imagesdir/$MemStarPicGMod" border="0" alt="*">);
           ++$starnum;
           }
           $memberstar{$user} = $memberstartemp;
	$starnum = "0";
	}

	else {
	if ($MemStarNumNewbie eq "") { $MemStarNumNewbie = "0"; }
	$starnum = "0";
	if( $userprofile{$user}->[6] >= $MemPostNewbie) {
		if ($MemTypeNewbie == 1)    {	$link{$user} = qq~<table style="filter:shadow(color=$MemTypeColNewbie, direction=left)"><a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$color{'fadertext2'}><b>$userprofile{$user}->[1]</b></font></a></table>~; }
		elsif ($MemTypeNewbie == 2) {	$link{$user} = qq~<table style=filter:glow(color=$MemTypeColNewbie, strength=5)"><a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$color{'fadertext2'}><b>$userprofile{$user}->[1]</b></font></a></table>~; }
		else 			   {	$link{$user} = qq~<a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$MemTypeColNewbie><b>$userprofile{$user}->[1]</b></font></a><br>~; }
		$memberinfo{$user} = "$MemStatNewbie";
		$memberstartemp ='';
		  while($MemStarNumNewbie ne "$starnum") { $memberstartemp .= qq(<img src="$imagesdir/$MemStarPicNewbie" border="0" alt="*">); ++$starnum; }
                  $memberstar{$user} = $memberstartemp;
	          $starnum = "0";
	


	$msstatcount = "0";
	$starnum = "0";
	while($MemStat[$msstatcount]) {
	if( $userprofile{$user}->[6] >= $MemPostNum[$msstatcount] && $MemPostNum[$msstatcount] ne "x") {
		if ($MemType[$msstatcount] == 1)    {	$link{$user} = qq~<table style="filter:shadow(color=$MemTypeCol[$msstatcount], direction=left)"><a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$color{'fadertext2'}><b>$userprofile{$user}->[1]</b></font></a></table>~; }
		elsif ($MemType[$msstatcount] == 2) {	$link{$user} = qq~<table style=filter:glow(color=$MemTypeCol[$msstatcount], strength=5)"><a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$color{'fadertext2'}><b>$userprofile{$user}->[1]</b></font></a></table>~; }
		else 			   {	$link{$user} = qq~<a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$MemTypeCol[$msstatcount]><b>$userprofile{$user}->[1]</b></font></a><br>~; }

		$memberinfo{$user} = "$MemStat[$msstatcount]";

		if ($MemStarNum[$msstatcount] eq "") { $MemStarNum[$msstatcount] = "0"; }
		$memberstartemp ='';
		while($MemStarNum[$msstatcount] ne "$starnum") {
		$memberstartemp .= qq(<img src="$imagesdir/$MemStarPic[$msstatcount]" border="0" alt="*">);
           ++$starnum;
           }
           $memberstar{$user} = $memberstartemp;
	$starnum = "0";
	}
	++$msstatcount;
	}
}

	if( exists $moderators{$user} && $sender ne "im" && $hidemod != 1) {
		if ($MemTypeMod == 1)    {	$link{$user} = qq~<table style="filter:shadow(color=$MemTypeColMod, direction=left)"><a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$color{'fadertext2'}><b>$userprofile{$user}->[1]</b></font></a></table>~; }
		elsif ($MemTypeMod == 2) {	$link{$user} = qq~<table style=filter:glow(color=$MemTypeColMod, strength=5)"><a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$color{'fadertext2'}><b>$userprofile{$user}->[1]</b></font></a></table>~; }
		else 			   {	$link{$user} = qq~<a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$MemTypeColMod><b>$userprofile{$user}->[1]</b></font></a><br>~; }
		$modinfo{$user} = "<i>$MemStatMod</i>";
		$starnum = "0";
		if ($MemStarNumMod eq "") { $MemStarNumMod = "0"; }
		$memberstartemp ='';
		while($MemStarNumMod ne "$starnum") {
		$memberstartemp .= qq(<img src="$imagesdir/$MemStarPicMod" border="0" alt="*">);
           ++$starnum;
           }
           $memberstar{$user} = $memberstartemp;
		$starnum = "0";
	}

  if ($disprealinfo == 1) {
	if( $userprofile{$user}->[7] && $userprofile{$user}->[7] ne 'Administrator' && $userprofile{$user}->[7] ne 'Global Moderator') {
		$memberinfo{$user} = "$userprofile{$user}->[7]<BR>$memberinfo{$user}";
		if ($modinfo{$user}) { $memberinfo{$user} = "$modinfo{$user}<br>$memberinfo{$user}" }
	}
  } else {

    if( $userprofile{$user}->[7] && $userprofile{$user}->[7] ne 'Administrator' && $userprofile{$user}->[7] ne 'Global Moderator'&& !$modinfo{$user}) {
	$msstatcount = "0";
	$starnum = "0";
	while($MemStat[$msstatcount] && $MemStat[$msstatcount] ne "$userprofile{$user}->[7]") { $msstatcount++; }
	   if($MemStat[$msstatcount] eq "$userprofile{$user}->[7]") {
		if ($MemType[$msstatcount] == 1)    {	$link{$user} = qq~<table style="filter:shadow(color=$MemTypeCol[$msstatcount], direction=left)"><a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$color{'fadertext2'}><b>$userprofile{$user}->[1]</b></font></a></table>~; }
		elsif ($MemType[$msstatcount] == 2) {	$link{$user} = qq~<table style=filter:glow(color=$MemTypeCol[$msstatcount], strength=5)"><a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$color{'fadertext2'}><b>$userprofile{$user}->[1]</b></font></a></table>~; }
		else 			   {	$link{$user} = qq~<a href="$cgi;action=viewprofile;username=$user"><font size="2" color=$MemTypeCol[$msstatcount]><b>$userprofile{$user}->[1]</b></font></a><br>~; }
		$memberinfo{$user} = "$MemStat[$msstatcount]";
		if ($MemStarNum[$msstatcount] eq "") { $MemStarNum[$msstatcount] = "0"; }
		$memberstartemp ='';
		while($MemStarNum[$msstatcount] ne "$starnum") {
		  $memberstartemp .= qq(<img src="$imagesdir/$MemStarPic[$msstatcount]" border="0" alt="*">);
                  $starnum++;
                }
           $memberstar{$user} = $memberstartemp;
	   $starnum = "0";
	   }
	}
		if ($modinfo{$user}) { $memberinfo{$user} = "$modinfo{$user}<br>$memberinfo{$user}"; }
    }
  }
</replace>

<search for>
sub LoadLogCount {
	&is_admin;
</search for>

<replace>
sub LoadLogCount {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $showgmod_info != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
		if (!$user_ip && $settings[7] eq 'Administrator') { $yyim .= qq~<br><b>$txt{'773'}</b>~; }
</search for>

<replace>
		if (!$user_ip && ($settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator')) { $yyim .= qq~<br><b>$txt{'773'}</b>~; }
</replace>

<search for>
sub LoadLogCount {
</search for>

<add before>
sub LoadGMods {
	&is_admin_or_gmod;
	my (@members, $curentry);

	$gmoderators = '';
	fopen(FILE, "$memberdir/memberlist.txt");
	@members = <FILE>;
	fclose(FILE);
	foreach $curentry (@members) {
		chomp $curentry;
		&LoadUser($curentry);
		if($userprofile{$curentry}->[7] eq 'Global Moderator') {
			$gmoderators .= qq~ <a href="$scripturl?action=viewprofile;username=$useraccount{$curentry}">$userprofile{$curentry}->[1]</a><font size="1">,</font> \n~;
		}
	}
	$gmoderators =~ s~<font size="1">,</font> \n\Z~~;
}

</add before>

<edit file>
Sources/LockThread.pl
</edit file>

<search for>
	if((exists $moderators{$username}) || $settings[7] eq "Administrator") {
</search for>

<replace>
	if((exists $moderators{$username}) || $settings[7] eq "Global Moderator" || $settings[7] eq "Administrator") {
</replace>

<edit file>
Sources/ManageBoards.pl
</edit file>

<search for>
sub ManageBoards {
	&is_admin;
</search for>

<replace>
sub ManageBoards {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_editcat != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub ReorderBoards {
	&is_admin;
</search for>

<replace>
sub ReorderBoards {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_editcat != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub ReorderBoards2 {
	&is_admin;
</search for>

<replace>
sub ReorderBoards2 {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_editcat != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub ModifyBoard {
	&is_admin;
</search for>

<replace>
sub ModifyBoard {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_editcat != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub CreateBoard {
	&is_admin;
</search for>

<replace>
sub CreateBoard {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_editcat != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<edit file>
Sources/ManageCats.pl
</edit file>

<search for>
	my $mgroups = qq~<select multiple name="memgroup" size="3">~;
	fopen(FILE, "$vardir/membergroups.txt");
	@groups = <FILE>;
	fclose(FILE);
	for($i = 7; $i < @groups; ++$i ) {
		$groups[$i] =~ s/[\n\r]//g;
		chomp $groups[$i];
		$groups[$i] =~ s~\<~&lt;~g;
		$groups[$i] =~ s~\>~&gt;~g;
		$mgroups .= qq~\n<option>$groups[$i]</option>~;
</search for>

<replace>
	my $mgroups = qq~<select multiple name="memgroup" size="3">~;
		$mgroups .= qq~\n<option value="Administrator">$MemStatAdmin</option>~;
		$mgroups .= qq~\n<option value="Global Moderator">$MemStatGMod</option>~;
		$mgroups .= qq~\n<option>$MemStatNewbie</option>~;
	$count=0;
	while($MemStat[$count]) {
		$mgroups .= qq~\n<option>$MemStat[$count]</option>~;
	$count++;
</replace>

<search for>
		$mgroups = qq~<select multiple name="catgroups" size="3">~;
		for($i = 7; $i < @groups; ++$i) {
			$groups[$i] =~ s~[\n\r]~~g;
			chomp $groups[$i];
			$selected = "";
			foreach $cur (@curcatgroups) {
				$cur =~ s~[\n\r]~~g;
				chomp $cur;
				if($cur eq $groups[$i]) { $selected = " selected"; break;}
			}
			$groups[$i] =~ s~\<~&lt;~g;
			$groups[$i] =~ s~\>~&gt;~g;
			$mgroups .= qq~\n<option$selected>$groups[$i]</option>~;
</search for>

<replace>
			$adsel = "";
			$glosel = "";
			$newsel = "";
			foreach $cur (@curcatgroups) {
				$cur =~ s~[\n\r]~~g;
				chomp $cur;
				if($cur eq "Administrator") { $adsel = " selected"; break;}
				if($cur eq "Global Moderator") { $glosel = " selected"; break;}
				if($cur eq $MemStatNewbie) { $newsel = " selected"; break;}
			}
		$mgroups = qq~<select multiple name="catgroups" size="3">~;
		$mgroups .= qq~\n<option value="Administrator" $adsel>$MemStatAdmin</option>~;
		$mgroups .= qq~\n<option value="Global Moderator" $glosel>$MemStatGMod</option>~;
		$mgroups .= qq~\n<option$newsel>$MemStatNewbie</option>~;
		$count=0;

	while($MemStat[$count]) {
			$groups[$i] =~ s~[\n\r]~~g;
			chomp $groups[$i];
			$selected = "";
			foreach $cur (@curcatgroups) {
				$cur =~ s~[\n\r]~~g;
				chomp $cur;
				if($cur eq $MemStat[$count]) { $selected = " selected"; break;}
			}
			$groups[$i] =~ s~\<~&lt;~g;
			$groups[$i] =~ s~\>~&gt;~g;
			$mgroups .= qq~\n<option$selected>$MemStat[$count]</option>~;
			$count++;
</replace>

<search for>
sub ManageCats {
	&is_admin;
</search for>

<replace>
sub ManageCats {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_editcat != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub ReorderCats {
	&is_admin;
</search for>

<replace>
sub ReorderCats {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_editcat != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub CreateCat {
	&is_admin;
</search for>

<replace>
sub CreateCat {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_editcat != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<search for>
sub ModifyCat {
	&is_admin;
</search for>

<replace>
sub ModifyCat {
	&is_admin_or_gmod;
	if ($settings[7] eq 'Global Moderator'  && $allowgmod_editcat != 1 ) { &fatal_error("$txt{'1'}"); }
</replace>

<edit file>
Sources/Memberlist.pl
</edit file>

<search for>
				if ($member[19] eq "checked" && $settings[7] ne "Administrator" && $allow_hide_email eq 1) { $yymain .= qq~
</search for>

<replace>
				if ($member[19] eq "checked" && $settings[7] ne "Administrator" &&  $settings[7] ne 'Global Moderator' && $allow_hide_email eq 1) { $yymain .= qq~
</replace>

<search for>
			if ($member[19] eq "checked" && $settings[7] ne "Administrator" && $allow_hide_email eq 1) { $yymain .= qq~
</search for>

<replace>
			if ($member[19] eq "checked" && $settings[7] ne "Administrator" &&  $settings[7] ne 'Global Moderator' && $allow_hide_email eq 1) { $yymain .= qq~
</replace>

<search for>
		if ($member[19] eq "checked" && $settings[7] ne "Administrator" && $allow_hide_email eq 1) { $yymain .= qq~
</search for>

<replace>
		if ($member[19] eq "checked" && $settings[7] ne "Administrator" &&  $settings[7] ne 'Global Moderator' && $allow_hide_email eq 1) { $yymain .= qq~
</replace>

<edit file>
Sources/ModifyMessage.pl
</edit file>

<search for>
	if($musername ne $username && (!exists $moderators{$username}) && $settings[7] ne 'Administrator' ) {
</search for>

<replace>
	if($musername ne $username && (!exists $moderators{$username}) && $settings[7] ne 'Administrator'  && $settings[7] ne 'Global Moderator' ) {
</replace>

<search for>
			unless($musername eq $username || exists $moderators{$username} || $settings[7] eq 'Administrator') {
				&fatal_error("$txt{'73'}");
			}
		}
		else {
			unless($musername eq $username || exists $moderators{$username} || $settings[7] eq 'Administrator') {
				&fatal_error("$txt{'67'}");
</search for>

<replace>
			unless($musername eq $username || exists $moderators{$username} || $settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator' ) {
				&fatal_error("$txt{'73'}");
			}
		}
		else {
			unless($musername eq $username || exists $moderators{$username} || $settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator') {
				&fatal_error("$txt{'67'}");
</replace>

<edit file>
Sources/MoveThread.pl
</edit file>

<search for>
	if((!exists $moderators{$username}) && $settings[7] ne "Administrator") { &fatal_error("$txt{'134'}"); }
</search for>

<replace>
	if((!exists $moderators{$username}) && $settings[7] ne "Administrator" && $settings[7] ne "Global Moderator") { &fatal_error("$txt{'134'}"); }
</replace>

<search for>
	if((!exists $moderators{$username}) && $settings[7] ne "Administrator") { &fatal_error("$txt{'134'}"); }
</search for>

<replace>
	if((!exists $moderators{$username}) && $settings[7] ne "Administrator" && $settings[7] ne "Global Moderator") { &fatal_error("$txt{'134'}"); }
</replace>

<edit file>
Sources/Profile.pl
</edit file>

<search for>
~;
	fopen(FILE, "$vardir/membergroups.txt");
	@lines = <FILE>;
	fclose(FILE);
	if($settings[7] eq 'Administrator') {
		$position='';
		foreach $curl (@lines) {
			if($curl ne $lines[1] && $curl ne $lines[2] && $curl ne $lines[3] && $curl ne $lines[4] && $curl ne $lines[5] && $curl ne $lines[6]) {
				if($curl ne $lines[0]) { $position= qq~$position<option>$curl~; }
				else { $position= qq~$position<option value="Administrator">$curl~; }
			}
		}
		if($memsettings[7] eq 'Administrator') { $tt = $lines[0]; }
		else { $tt = $memsettings[7]; }
		$yymain .= qq~
      <tr>
	<td colspan=2><hr width="100%" size="1" class="hr"></td>
      </tr><tr>
	<td width="320"><font size=2><b>$txt{'86'}: </b></font></td>
	<td><font size=2><input type=text name=settings6 size=4 value="$memsettings[6]"></font></td>
      </tr><tr>
	<td width="320"><font size=2><b>$txt{'87'}: </b></font></td>
	<td><font size=2><select name="settings7">
	 <option value="$memsettings[7]">$tt
	 <option value="$memsettings[7]">---------------
	 <option value="">
	 $position
	</select></font></td>
      </tr><tr>
        <td width="320"><font size="2"><b>$txt{'233'}:</b></font><br>
        <font size="1">$txt{'421'}</font><br><br></td>
        <td><input type="text" name="dr" size="20" value="$dr"><br><br></td>
      </tr>~;
	}
	if($settings[7] eq 'Administrator') { $confdel_text = "$txt{'775'} $txt{'777'} $INFO{'username'} $txt{'778'}"; }
	else { $confdel_text = "$txt{'775'} $txt{'776'} $txt{'778'}"; }
	$yymain .= qq~
    </table>
    </font></td>
  </tr><tr>
    <td class="catbg" bgcolor="$color{'catbg'}" height="25" align="center"><font size=2><BR>
    <input type=submit name=moda value="$txt{'88'}">
    <input type=submit name=moda value="$txt{'89'}" onClick="return confirm('$confdel_text')"><BR><BR>
    </font></td>
  </tr>
</table>
</form>
~;
	$yytitle = $txt{'79'};
	&template;
	exit;
}
</search for>

<replace>
~;
if($settings[7] eq "Administrator") {
		if($memsettings[7] eq 'Administrator') { $tt2 = $MemStatAdmin; $tt = "Administrator"; }
		elsif ($memsettings[7] eq 'Global Moderator') { $tt2 = $MemStatGMod; $tt = "Global Moderator"; }
		else { $tt = $memsettings[7]; $tt2 = $memsettings[7]; }
	$yymain .= qq~
      <tr>
	<td colspan=2><HR size=1 width="100%" class="hr"></td>
      </tr><tr>
	<td width="320"><font size=2><b>$txt{'86'}: </b></font></td>
	<td><font size=2><input type=text name=settings6 size=4 value="$memsettings[6]"></font></td>
      </tr><tr>
	<td width="320"><font size=2><b>$txt{'87'}: </b></font></td>
	<td><font size=2><select name="settings7">
	 <option value="$tt">$tt2
	 <option value="$tt">---------------
	 <option value="">
~;
		$position='';
		$z=0;
	 $yymain .= qq~<option value="Administrator">$MemStatAdmin~;
	 $yymain .= qq~<option value="Global Moderator">$MemStatGMod~;
	 $yymain .= qq~<option value="$MemStatNewbie">$MemStatNewbie~;
		while($MemStat[$z]) {
			$position= qq~<option value="$MemStat[$z]">$MemStat[$z]~;
			++$z;
		$yymain .= qq~$position~;
}
		$yymain .= qq~
	</select></font></td>
      </tr><tr>
        <td width="320"><font size="2"><b>$txt{'233'}:</b><br>
        <font size=1>$txt{'421'}</font></td>
        <td><input type="text" name="dr" size="20" value="$dr"></td></tr>
~;
}
	$yymain .= qq~
    </table>
    </font></td>
  </tr><tr>
    <td class="catbg" bgcolor="$color{'catbg'}" height="25" align="center"><font size=2><BR>
    <input type=submit name=moda value="$txt{'88'}">
    <input type=submit name=moda value="$txt{'89'}" onClick="return confirm('$confdel_text')"><BR><BR>
    </font></td>
  </tr>
</table>
</form>
~;
	$yytitle = $txt{'79'};
	&template;
	exit;
}
</replace>

<search for>
	fopen(FILE, "$vardir/membergroups.txt");
	@membergroups = <FILE>;
	fclose(FILE);
	if($memsettings[6] > $GodPostNum) { $memberinfo = "$membergroups[6]"; }
	elsif($memsettings[6] > $SrPostNum) { $memberinfo = "$membergroups[5]"; }
	elsif($memsettings[6] > $FullPostNum) { $memberinfo = "$membergroups[4]"; }
	elsif($memsettings[6] > $JrPostNum) { $memberinfo = "$membergroups[3]"; }
	else { $memberinfo = "$membergroups[2]"; }
	if($memsettings[7] ne "") { $memberinfo = "$memsettings[7]"; }
	if($memsettings[7] eq "Administrator") { $memberinfo = "$membergroups[0]"; }
</search for>

<replace>
	my ($msstatcount);
	$msstatcount=0;
	if ($memsettings[7]) { 
		chomp($memsettings[7]);
		if ($memsettings[7] eq "Administrator") { $memberinfo = $MemStatAdmin; }
		elsif ($memsettings[7] eq "Global Moderator") { $memberinfo = $MemStatGMod; }
		else { $memberinfo = "$memsettings[7]"; }
	} else {
	if( $memsettings[6] >= $MemPostNewbie) { $memberinfo = "$MemStatNewbie"; }
	while($MemStat[$msstatcount] && $MemPostNum[$msstatcount] ne "x") {
	if( $memsettings[6] >= $MemPostNum[$msstatcount] ) { $memberinfo = "$MemStat[$msstatcount]"; }
	++$msstatcount;
	}
}
</replace>

<search for>
		@membergroups = split( /,/, $cataccess{$curcat} );
		foreach $tmpa (@membergroups) {
			if( $tmpa eq $settings[7]) { $openmemgr{$curcat} = 1; last; }
		}
		if( ! $cataccess{$curcat} || $settings[7] eq 'Administrator' ) {
			$openmemgr{$curcat} = 1;
		}
		unless( $openmemgr{$curcat} ) { next; }
</search for>

<replace>
		my($mscount);
		$mscount=0;
		@membergroups = split( /,/, $cataccess{$curcat} );
		foreach $tmpa (@membergroups) {
		$tmpa =~ s/\n//g;
			if( $settings[7] eq "$tmpa") { $openmemgr{$curcat} = 1; last; }
	while($MemStat[$mscount]) {
	if( $settings[6] >= $MemPostNum[$mscount] && $MemPostNum[$mscount] ne "x") {
	$memberinfo = "$MemStat[$mscount]"; }
	++$mscount;
	}
	if ( $memberinfo eq $tmpa ) { $openmemgr{$curcat} = 1; last; }
		}
		if( ! $cataccess{$curcat} || $settings[7] eq 'Administrator' ) {
			$openmemgr{$curcat} = 1;
		}
		unless( $openmemgr{$curcat} ) { next; }

</replace>

<search for>
	if ($memsettings[19] ne "checked" || $settings[7] eq "Administrator" || !$allow_hide_email) {
</search for>

<replace>
	if ($username ne $INFO{'username'} && ($settings[7] eq "Global Moderator" && $allowgmod_editprof)) {
		$modify = qq~&#171; <a href="$cgi;action=gmodeditprofile;username=$useraccount{$INFO{'username'}}"><font size=2 class="text1" color="$color{'titletext'}">$txt{'17'}</font></a> &#187;~;
	}
	if ($memsettings[19] ne "checked" || $settings[7] eq "Administrator" || ($settings[7] eq 'Global Moderator') || !$allow_hide_email) {
</replace>

<search for>
	if($newpassemail) {
</search for>

<add before>
	if($memset[7] ne "$member{'settings7'}") { require "$sourcedir/MemberGroups.pl"; &RebuildMemGroup; }
</add before>

<edit file>
Sources/Recent.pl
</edit file>

<search for>
			if($settings[7] ne 'Administrator' && !exists $membergroups{$settings[7]}) { next; }
</search for>

<replace>
			if($settings[7] ne 'Administrator' && $settings[7] ne 'Global Moderator' && !exists $membergroups{$settings[7]}) { next; }
</replace>

<search for>
		if( ! $cataccess{$curcat} || $settings[7] eq 'Administrator' ) {
</search for>

<replace>
		if( ! $cataccess{$curcat} || $settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator' ) {
</replace>

<edit file>
Sources/RemoveThread.pl
</edit file>

<search for>
	if((!exists $moderators{$username}) && $settings[7] ne "Administrator") {
</search for>

<replace>
	if((!exists $moderators{$username}) && $settings[7] ne "Administrator" && $settings[7] ne "Global Moderator") {
</replace>

<edit file>
Sources/Security.pl
</edit file>

<search for>
sub banning {
</search for>

<add before>
sub is_admin_or_gmod {
	if($settings[7] ne 'Administrator' && ($settings[7] ne 'Global Moderator' || $allow_mod != 1)) { &fatal_error($txt{'1'}); }
}
</add before>

<edit file>
Sources/Search.pl
</edit file>

<search for>
		@membergroups = split( /,/, $cataccess{$curcat} );
		foreach $tmpa (@membergroups) {
			if( $tmpa eq $settings[7]) { $openmemgr{$curcat} = 1; last; }
		}
		if( ! $cataccess{$curcat} || $settings[7] eq 'Administrator' ) {
			$openmemgr{$curcat} = 1;
		}
		unless( $openmemgr{$curcat} ) { next; }
</search for>

<replace>
		my($mscount);
		$mscount=0;
		@membergroups = split( /,/, $cataccess{$curcat} );
		foreach $tmpa (@membergroups) {
		$tmpa =~ s/\n//g;
			if( $settings[7] eq "$tmpa") { $openmemgr{$curcat} = 1; last; }
	while($MemStat[$mscount]) {
	if( $settings[6] >= $MemPostNum[$mscount] && $MemPostNum[$mscount] ne "x") {
	$memberinfo = "$MemStat[$mscount]"; }
	++$mscount;

	}
	if ( $memberinfo eq $tmpa ) { $openmemgr{$curcat} = 1; last; }
		}
		if( ! $cataccess{$curcat} || $settings[7] eq 'Administrator' ) {
			$openmemgr{$curcat} = 1;
		}
		unless( $openmemgr{$curcat} ) { next; }
</replace>

<edit file>
Sources/SubList.pl
</edit file>

<search for>
'modmemgr',"AdminEdit.pl&EditMemberGroups",
'modmemgr2',"AdminEdit.pl&EditMemberGroups2",
</search for>

<replace>
'modmemgr',"MemberGroups.pl&EditMemberGroups",
'modmemgr2',"MemberGroups.pl&EditMemberGroups2",
</replace>

<search for>
'modify',"ModifyMessage.pl&ModifyMessage",
</search for>

<replace>
'modify',"ModifyMessage.pl&ModifyMessage",
'gmodeditprofile',"MemberGroups.pl&GModEditProfile",
'gmodeditprofile2',"MemberGroups.pl&GModEditProfile2",
'moderate',"MemberGroups.pl&Moderate",
</replace>

<search for>
'ipban',"Admin.pl&ipban",
</search for>

<add after>
'ipbangm',"MemberGroups.pl&ipban",
'ipban2gm',"MemberGroups.pl&ipban2",
</add after>

<search for>
'clean_log',"Admin.pl&clean_log",
</search for>

<add after>
'cefmemgr',"MemberGroups.pl&MemGroup_Effects",
'cefmemgr2',"MemberGroups.pl&MemGroup_Effects2",
</add after>

<search for>
'editnews',"AdminEdit.pl&EditNews",
</search for>

<add after>
'editnewsgm',"MemberGroups.pl&EditNews",
</add after>

<search for>
'editnews2',"AdminEdit.pl&EditNews2",
</search for>

<add after>
'editnews2gm',"MemberGroups.pl&EditNews2",
</add after>

<search for>
'admin',"Admin.pl&Admin",
</search for>

<add after>
'assigned',"MemberGroups.pl&Assigned_Members",
'assigned2',"MemberGroups.pl&Assigned_Members2",
</add after>

<search for>
'reorderboards2',"ManageBoards.pl&ReorderBoards2",
</search for>

<add after>
'rebmemgrp',"MemberGroups.pl&RebuildMemGroup",
</add after>

<search for>
'membershiprecount',"Admin.pl&AdminMembershipRecount",
</search for>

<add after>
'memupdate',"MemberGroups.pl&Members_Update",
'memupdate2',"MemberGroups.pl&Members_Update2",
'memupdate3',"MemberGroups.pl&Members_Update3",
</add after>

<edit file>
Sources/Subs.pl
</edit file>

<search for>
	if($settings[7] eq 'Administrator') { $yymenu .= qq~$menusep<a href="$cgi;action=admin">$img{'admin'}</a>~; }
</search for>

<add after>
	if($settings[7] eq 'Global Moderator' && $allow_mod == 1) { $yymenu .= qq~$menusep<a href="$cgi;action=moderate">$img{'admin'}</a>~; }
</add after>

<search for>
			foreach ( split(/\,/, $curcataccess) ) {
				if( $_ && $_ eq $settings[7]) { $yyAccessCat{$yyCatBoard{$curboard}} = 1; last; }
</search for>

<replace>
			foreach ( split(/\,/, $curcataccess) ) {
			my $mscount=0;
				if( $_ && $_ eq $settings[7]) { $yyAccessCat{$yyCatBoard{$curboard}} = 1; last; }
					while($MemStat[$mscount]) {
					if($settings[6] >= $MemPostNum[$mscount] && $MemPostNum[$mscount] ne "x") { $memberinfo = $MemStat[$mscount]; }
					$mscount++;
					if ( $_ && $_ eq $memberinfo ) { $yyAccessCat{$yyCatBoard{$curboard}} = 1; last; }
					}
</replace>