###############################################################################
# Links.pl                                                                    #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 1 Platinum Release                                     #
# Released:       August 2002                                                 #
# Distributed by: http://www.spikecity.net                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################
use Carp;
$linkplver = "1 Platinum Release";
$subversion ="1.1";

sub links {
$catprint =$INFO{'category'};

&getcatlist;
&getlinklang;

	if($catprint eq ""){ $catprint="All";}

	if($catprint eq "All"){ &showall;}
	else { &showcat;}

}


sub getlinklang {
	($lnklang, $extension) = split (/\./, $language);
	fopen(FILE, "$linksdir/$lnklang.txt");
	@lnklanguages = <FILE>;
	fclose(FILE);
	foreach $lnklnginfo (@lnklanguages){
		chomp $lnklnginfo;
		($lngid,$lnklanguage)= split (/\|/, $lnklnginfo);
		push(@lngtext,$lnklanguage);
	}
}

sub getcatlist {
	# Open the file with all linkcategories
	fopen(FILE, "$linksdir/linkcat.txt");
	@itemcategories = <FILE>;
	fclose(FILE);
	$catlist = qq~<option value=";category=All"$selected> \n~;
	$catlist .= qq~<option value=";category=All"$selected> - $lnktxt{'37'}\n~;
	foreach $catitem (@itemcategories) {
	($catlink,$catdescr) = split (/\|/,$catitem);
		$catlist .= qq~<option value=";category=$catlink"$selected> - $catdescr</option>\n~;
	}
}

sub getcatselect {
	# Open the file with all linkcategories
	fopen(FILE, "$linksdir/linkcat.txt");
	@itemcategories = <FILE>;
	fclose(FILE);
	$catselect = qq~<select name="category" size="1">\n~;
	foreach $catitem (@itemcategories) {
	($catlink,$catdescr) = split (/\|/,$catitem);
		if(lc($linkcategory) eq lc("\#$catlink\#")){ $catselected =" selected"; } else {$catselected =""; }
		$catselect .= qq~<option value="$catlink"$catselected> - $catdescr</option>\n~;
	}
      $catselect .= qq~</select>~;
}

sub writelinktext {
	&is_admin;
	fopen(FILE, ">$vardir/linktext.txt", 1);
	print FILE "$FORM{'linktext'}";
	fclose(FILE);
	$yySetLocation = qq~$cgi\;action=links~;
	&redirectexit;
}


sub link_edit {
$editid =$INFO{'linkid'};

	&LoadUserSettings;

fopen (FILE,"$linksdir/data.txt") || die "Cant open $linksdir/data.txt !\n";
@linkdata=<FILE>;
fclose(FILE);
foreach	$line(@linkdata){
	chomp($line);
	($linkid,$linkapprove,$title,$description,$address,$linklanguage,$linkkeys,$linkcategory,$reallinkname,$linkuser,$linkemail)=split(/\|/, $line);
if ($linkid eq $editid){
	$description =~ s/<br>/\n/g;

	($lnklang, $extension) = split (/\./, $language);
	fopen(FILE, "$linksdir/$lnklang.txt");
	@lnklanguages = <FILE>;
	fclose(FILE);
	$lnklangselect = qq~<select name="language" size="1">\n~;
	foreach $lnklnginfo (@lnklanguages){
		chomp $lnklnginfo;
		($lngid,$lnklanguage)= split (/\|/, $lnklnginfo);
		if($linklanguage eq $lngid){ $lngselected =" selected"; } else {$lngselected =""; }
		$lnklangselect .= qq~<option value="$lngid" $lngselected>- $lnklanguage</option>\n~;
	}
	$lnklangselect .= qq~</select>\n~;
	&getcatselect;
	&getlinklang;


$yymain .= qq~
<form action="$cgi;action=link_edit2;linkid=$linkid" method="POST">
<table border=0 width="100%" cellspacing="0" cellpadding="0" bgcolor="$color{'bordercolor'}" class="bordercolor">
  <tr>
    <td>
    <table cellpadding="4" cellspacing="1" border="0" width="100%">
      <tr>
       <td colspan="2" class="titlebg" bgcolor="$color{'titlebg'}" <font class="text1" color="$color{'titletext'}" size="3"><center><b>$lnktxt{'14'} (ID: $linkid)</b></center></font></a></td>
      </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'4'}:</font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial"><input name="title" size="50" maxlength="60" value="$title"> </font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'6'}:</font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial"><textarea name="description" rows="3" cols="50" wrap="virtual">$description</textarea> </font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'5'}:</font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial"><input name="address" size="50" value="$address"> </font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'30'}: </font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial">$lnklangselect</font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'8'}</font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial"><input name="keywords" size="50" maxlength="75"> </font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'33'}:</font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial">$catselect</font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'7'}:</font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial"><input type=hidden name="realname" value="$reallinkname" size="35"><b><a href="$cgi;action=viewprofile;username=$linkuser">$reallinkname</a></b></font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'20'}:</font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial"><input type=hidden name="email" value="$linkemail" size="35"><input type=hidden name="linkuser" value="$linkuser" size="35"><b><a href="mailto:$linkemail">$linkemail</a></b> </font></td>
    </tr>
    <tr>
      <td colspan="2" class="windowbg" bgcolor="$color{'windowbg'}" align="center"><font face="Arial"><input type="submit" value="$lnktxt{'14'}"></font></td>
    </tr>
  </table>
</td></tr>
</table>
~;
}
} ## end record found ##

	$yytitle = $lnktxt{'14'};
	&template;
	exit;

}

sub link_add {
	&LoadUserSettings;
	($lnklang, $extension) = split (/\./, $language);
	fopen(FILE, "$linksdir/$lnklang.txt");
	@lnklanguages = <FILE>;
	fclose(FILE);
	$lnklangselect = qq~<select name="language" size="1">\n~;
	foreach $lnklnginfo (@lnklanguages){
		chomp $lnklnginfo;
		($lngid,$lnklanguage)= split (/\|/, $lnklnginfo);
		$lnklangselect .= qq~<option value="$lngid">- $lnklanguage</option>\n~;
	}
	$lnklangselect .= qq~</select>\n~;
	&getcatselect;

$yymain .= qq~
<form action="$cgi;action=link_add2" method="POST">
<table border=0 width="100%" cellspacing="0" cellpadding="0" bgcolor="$color{'bordercolor'}" class="bordercolor">
  <tr>
    <td>
    <table cellpadding="4" cellspacing="1" border="0" width="100%">
      <tr>
       <td colspan="2" class="titlebg" bgcolor="$color{'titlebg'}" <font class="text1" color="$color{'titletext'}" size="3"><center><b>$lnktxt{'17'}</b></center></font></a></td>
      </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'4'}:</font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial"><input name="title" size="50" maxlength="60"> </font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'6'}:</font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial"><textarea name="description" rows="3" cols="50" wrap="virtual"></textarea> </font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'5'}:</font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial"><input name="address" size="50" value="http://"> </font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'30'}:</font></font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial">$lnklangselect</font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'8'}: </font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial"><input name="keywords" size="50" maxlength="75"> </font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'33'}: </font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial">$catselect</font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'7'}:</font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial"><input type=hidden name="realname" value="$realname" size="35"><b><a href="$cgi;action=viewprofile;username=$username">$realname</a></b></font></td>
    </tr>
    <tr>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial" size="2">$lnktxt{'20'}:</font></td>
      <td class="windowbg" bgcolor="$color{'windowbg'}"><font face="Arial"><input type=hidden name="email" value="$realemail" size="35"><b>$realemail</b> </font></td>
    </tr>
    <tr>
      <td colspan="2" class="windowbg" bgcolor="$color{'windowbg'}" align="center"><small><font face="Arial"><input type="submit" value="$lnktxt{'18'}"></font></td>
    </tr>
  </table>
</td></tr>
</table>
~;
	$yytitle = $lnktxt{'17'};
	&template;
	exit;

}

sub link_add2{

# If you change urlcheck to "no" you may need to remark the following
# lines by putting a # at the start of the line
  if($testlink == 1){
  	require LWP::UserAgent;
  	require HTTP::Request;
  	require HTTP::Response;
  }
  
# Changing anything below this line is not recommened

# Gets the data from the form
  $title       = $FORM{'title'};
  $description = $FORM{'description'};
  $address     = $FORM{'address'};
  $lnklanguage = $FORM{'language'};
  $keywords    = $FORM{'keywords'};
  $category    = $FORM{'category'}."#";
  $realname    = $FORM{'realname'};
  $email       = $FORM{'email'};
  $category="#".lc($category);


# Reads existing posts 
  fopen (FILE,"$linksdir/data.txt") || die "Cant open $linksdir/data.txt !\n";
  @LINES=<FILE>;
  fclose(FILE);
  fopen (FILE,"$linksdir/link.id") || die "Cant open $linksdir/link.id !\n";
	$linkid=<FILE>;
  fclose(FILE);
  chomp $linkid;

if($settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator'){
	$linkapproved=1;
} else {
	$linkapproved=0;
}

$linkid++;

# Calls subroutine to validate the input
  &validate;

# Converts < to &lt; to avoid abuse (<script etc)
  $title =~ s/</\&lt;/g;
  $description =~ s/</\&lt;/g;
  $address =~ s/</\&lt;/g;
  $keywords =~ s/</\&lt;/g;
  $realname =~ s/</\&lt;/g;
  $email =~ s/</\&lt;/g;

# Removes | and returns that might be present

  $title =~ s/\|//g;
  $description =~ s/\|//g;
  $address =~ s/\|//g;
  $lnklanguage =~ s/\|//g;
  $keywords =~ s/\|//g;
  $email =~ s/\|//g;
  $realname =~ s/\|//g;
  $description =~ s/\n/<br>/g;
  $description =~ s/\r//g;



# Creates the new post
  $newpost = $linkid . "|" . $linkapproved . "|" . $title . "|" . $description . "|" . $address . "|" . $lnklanguage . "|";
  $newpost = $newpost . $keywords . "|" . $category . "|" . $realname . "|" . $username . "|" . $email . "\n";

# Adds the new post to the database
  push (@LINES, $newpost);

# Sorts the data  - non case sensitiv
  @outlines = sort {uc($a) cmp uc($b)} @LINES;

# Write the updated database to file
  fopen (FILE,">$linksdir/data.txt") || die "Can not open $linksdir/data.txt !\n\n";
	  print FILE @outlines;
  fclose(FILE);
  fopen (FILE,">$linksdir/link.id") || die "Can not open $linksdir/link.id !\n\n";
	  print FILE $linkid;
  fclose(FILE);

if ($linkconfirm ==1){
	&getlinklang;
	$tempcategory = $category;
	$tempcategory =~ s/\#//g;
	$receiver = $username;
	$lnkmessage ="";
	$lnksubject="";
	$lnksubject .= qq~$lnktxt{'14'} $lnktxt{'32'}~;
	$lnkmessage .= qq~$lnktxt{'47'} $lnktxt{'48a'} $lnktxt{'52'}\n\n~;  
	$lnkmessage .= qq~$lnktxt{'54'}:\n\n~;  
	$lnkmessage .= qq~$lnktxt{'4'}: $title\n~;  
	$lnkmessage .= qq~$lnktxt{'5'}: $address\n~;  
	$lnkmessage .= qq~$lnktxt{'6'}: $description\n~;  
	$lnkmessage .= qq~$lnktxt{'33'}: $tempcategory\n~;  
	$lnkmessage .= qq~$lnktxt{'30'}: $lngtext[$lnklanguage]\n\n~;
	$lnkmessage .= qq~$lnktxt{'53'}\n~;  
	&linknotify;
	$receiver = $linkadmin;
	&linknotify;
}
# Redirects to selected page

	$yySetLocation = qq~$cgi;action=links~;
	&redirectexit;


}

sub link_ok{
&getlinklang;
$approveid =$INFO{'linkid'};
  fopen (FILE,"$linksdir/data.txt") || die "Cant open $linksdir/data.txt !\n";
  @inlines=<FILE>;
  fclose(FILE);

# Adds the approved post to the database
foreach	$line(@inlines){
	($linkid,$linkapprove,$title,$description,$address,$linklanguage,$linkkeys,$linkcategory,$reallinkname,$linkuser,$linkemail)=split(/\|/, $line);
	if ($approveid eq $linkid){
	$approveline = "$linkid|1|$title|$description|$address|$linklanguage|$linkkeys|$linkcategory|$reallinkname|$linkuser|$linkemail";
		push (@outlines, $approveline);
		$temptitle = $title;
		$tempaddress = $address;
		$tempdescription = $description;
		$tempcategory = $linkcategory;
		$tempcategory =~ s/\#//g;
		$templanguage = $linklanguage;
		$tempuser = $linkuser;
	} else {
		push (@outlines, $line);
	}
}

# Sorts the data  - non case sensitiv
  @outlines = sort {uc($a) cmp uc($b)} @outlines;

# Write the updated database to file
  fopen (FILE,">$linksdir/data.txt") || die "Can not open $linksdir/data.txt !\n\n";
	  print FILE @outlines;
  fclose(FILE);

if ($linkconfirm ==1){
	$receiver = $tempuser;
	$lnkmessage ="";
	$lnksubject="";
	$lnksubject .= qq~$lnktxt{'14'} $lnktxt{'32'}~;
	$lnkmessage .= qq~$lnktxt{'47'} $lnktxt{'48'} $realname $lnktxt{'51'}\n\n~;  
	$lnkmessage .= qq~$lnktxt{'54'}:\n\n~;  
	$lnkmessage .= qq~$lnktxt{'4'}: $temptitle\n~;  
	$lnkmessage .= qq~$lnktxt{'5'}: $tempaddress\n~;  
	$lnkmessage .= qq~$lnktxt{'6'}: $tempdescription\n~;  
	$lnkmessage .= qq~$lnktxt{'33'}: $tempcategory\n~;  
	$lnkmessage .= qq~$lnktxt{'30'}: $lngtext[$templanguage]\n\n~;
	$lnkmessage .= qq~$lnktxt{'53'}\n~;  
	&linknotify;
}
# Redirects to selected page

	$yySetLocation = qq~$cgi;action=links~;
	&redirectexit;
}

sub link_not_ok{
&getlinklang;
$unapproveid =$INFO{'linkid'};
  fopen (FILE,"$linksdir/data.txt") || die "Cant open $linksdir/data.txt !\n";
  @inlines=<FILE>;
  fclose(FILE);

# Adds the approved post to the database
foreach	$line(@inlines){
	($linkid,$linkapprove,$title,$description,$address,$linklanguage,$linkkeys,$linkcategory,$reallinkname,$linkuser,$linkemail)=split(/\|/, $line);
	if ($unapproveid eq $linkid){
	$unapproveline = "$linkid|0|$title|$description|$address|$linklanguage|$linkkeys|$linkcategory|$reallinkname|$linkuser|$linkemail";
		push (@outlines, $unapproveline);
		$temptitle = $title;
		$tempaddress = $address;
		$tempdescription = $description;
		$tempcategory = $linkcategory;
		$tempcategory =~ s/\#//g;
		$templanguage = $linklanguage;
		$tempuser = $linkuser;
	} else {
		push (@outlines, $line);
	}

}

# Sorts the data  - non case sensitiv
  @outlines = sort {uc($a) cmp uc($b)} @outlines;

# Write the updated database to file
  fopen(FILE,">$linksdir/data.txt") || die "Can not open $linksdir/data.txt !\n\n";
	  print FILE @outlines;
  fclose(FILE);

if ($linkconfirm ==1){
	$receiver = $tempuser;
	$lnkmessage ="";
	$lnksubject="";
	$lnksubject .= qq~$lnktxt{'14'} $lnktxt{'32'}~;
	$lnkmessage .= qq~$lnktxt{'47'} $lnktxt{'49'} $realname $lnktxt{'52'}\n\n~;  
	$lnkmessage .= qq~$lnktxt{'54'}:\n\n~;  
	$lnkmessage .= qq~$lnktxt{'4'}: $temptitle\n~;  
	$lnkmessage .= qq~$lnktxt{'5'}: $tempaddress\n~;  
	$lnkmessage .= qq~$lnktxt{'6'}: $tempdescription\n~;  
	$lnkmessage .= qq~$lnktxt{'33'}: $tempcategory\n~;  
	$lnkmessage .= qq~$lnktxt{'30'}: $lngtext[$templanguage]\n\n~;
#	$lnkmessage .= qq~$lnktxt{'53'}\n~;  
	&linknotify;
}

# Redirects to selected page

	$yySetLocation = qq~$cgi;action=links~;
	&redirectexit;
}

sub link_edit2{

$modifyid =$INFO{'linkid'};

# Perform URL lookup/validation ?

# If you change urlcheck to "no" you may need to remark the following
# lines by putting a # at the start of the line
  if($testlink == 1){
  	require LWP::UserAgent;
  	require HTTP::Request;
  	require HTTP::Response;
  }

# Changing anything below this line is not recommened

# Gets the data from the form
  $title       = $FORM{'title'};
  $description = $FORM{'description'};
  $address     = $FORM{'address'};
  $lnklanguage = $FORM{'language'};
  $keywords    = $FORM{'keywords'};
  $category    = $FORM{'category'}."#";
  $realeditname    = $FORM{'realname'};
  $linkedituser    = $FORM{'linkuser'};
  $editemail       = $FORM{'email'};
  $category="#".lc($category);


# Reads existing posts 
  fopen (FILE,"$linksdir/data.txt") || die "Cant open $linksdir/data.txt !\n";
  @inlines=<FILE>;
  fclose(FILE);

if($settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator'){
	$linkapproved=1;
} else {
	$linkapproved=0;
}

# Calls subroutine to validate the input
  &validate;

# Converts < to &lt; to avoid abuse (<script etc)
  $title =~ s/</\&lt;/g;
  $description =~ s/</\&lt;/g;
  $address =~ s/</\&lt;/g;
  $keywords =~ s/</\&lt;/g;
  $realeditname =~ s/</\&lt;/g;
  $editemail =~ s/</\&lt;/g;

# Removes | and returns that might be present

  $title =~ s/\|//g;
  $description =~ s/\|//g;
  $address =~ s/\|//g;
  $lnklanguage =~ s/\|//g;
  $keywords =~ s/\|//g;
  $editemail =~ s/\|//g;
  $realeditname =~ s/\|//g;
  $description =~ s/\n/<br>/g;
  $description =~ s/\r//g;


# Creates the modified post
  $modifiedpost = $modifyid . "|" . $linkapproved . "|" . $title . "|" . $description . "|" . $address . "|" . $lnklanguage . "|";
  $modifiedpost = $modifiedpost . $keywords . "|" . $category . "|" . $realeditname . "|" . $linkedituser . "|" . $editemail . "\n";

# Adds the modified post to the database
foreach	$line(@inlines){
	($linkid,$linkapprove,$title,$description,$address,$linklanguage,$linkkeys,$linkcategory,$reallinkname,$linkuser,$linkemail)=split(/\|/, $line);
	if ($modifyid eq $linkid){
		push (@outlines, $modifiedpost);
		$temptitle = $title;
		$tempaddress = $address;
		$tempdescription = $description;
		$tempcategory = $linkcategory;
		$tempcategory =~ s/\#//g;
		$templanguage = $linklanguage;
		$tempuser = $linkuser;
	} else {
		push (@outlines, $line);
	}
}

# Sorts the data  - non case sensitiv
  @outlines = sort {uc($a) cmp uc($b)} @outlines;

# Write the updated database to file
  fopen (FILE,">$linksdir/data.txt") || die "Can not open $linksdir/data.txt !\n\n";
	  print FILE @outlines;
  fclose(FILE);

if ($linkconfirm ==1){
	&getlinklang;
	$tempcategory = $category;
	$tempcategory =~ s/\#//g;
	$receiver = $tempuser;
	$lnkmessage ="";
	$lnksubject="";
	$lnksubject .= qq~$lnktxt{'14'} $lnktxt{'32'}~;
	$lnkmessage .= qq~$lnktxt{'47'} $lnktxt{'50a'} $realname\n\n~;  
	$lnkmessage .= qq~$lnktxt{'54'}:\n\n~;  
	$lnkmessage .= qq~$lnktxt{'4'}: $temptitle\n~;  
	$lnkmessage .= qq~$lnktxt{'5'}: $tempaddress\n~;  
	$lnkmessage .= qq~$lnktxt{'6'}: $tempdescription\n~;  
	$lnkmessage .= qq~$lnktxt{'33'}: $tempcategory\n~;  
	$lnkmessage .= qq~$lnktxt{'30'}: $lngtext[$templanguage]\n\n~;
	$lnkmessage .= qq~$lnktxt{'53'}\n~;  
	&linknotify;
	$receiver = $linkadmin;
	&linknotify;
}

# Redirects to selected page

	$yySetLocation = qq~$cgi;action=links~;
	&redirectexit;


}


sub link_delete {

$deleteid =$INFO{'linkid'};

  fopen (FILE,"$linksdir/data.txt") || die "Cant open $linksdir/data.txt !\n";
  @inlines=<FILE>;
  fclose(FILE);

foreach	$line(@inlines){
	($linkid,$linkapprove,$title,$description,$address,$linklanguage,$linkkeys,$linkcategory,$reallinkname,$linkuser,$linkemail)=split(/\|/, $line);
	if ($deleteid ne $linkid){
		push (@outlines, $line);
	} else {
		$temptitle = $title;
		$tempaddress = $address;
		$tempdescription = $description;
		$tempcategory = $linkcategory;
		$tempcategory =~ s/\#//g;
		$templanguage = $linklanguage;
		$tempuser = $linkuser;
	}
}

# Sorts the data  - non case sensitiv
  @outlines = sort {uc($a) cmp uc($b)} @outlines;

# Write the updated database to file
  fopen(FILE,">$linksdir/data.txt") || die "Can not open $linksdir/data.txt !\n\n";
	  print FILE @outlines;
  fclose(FILE);

if ($linkconfirm ==1){
	&getlinklang;
	$tempcategory = $category;
	$tempcategory =~ s/\#//g;
	$receiver = $tempuser;
	$lnkmessage ="";
	$lnksubject="";
	$lnksubject .= qq~$lnktxt{'14'} $lnktxt{'32'}~;
	$lnkmessage .= qq~$lnktxt{'47'} $lnktxt{'50'} $realname\n\n~;  
	$lnkmessage .= qq~$lnktxt{'54'}:\n\n~;  
	$lnkmessage .= qq~$lnktxt{'4'}: $temptitle\n~;  
	$lnkmessage .= qq~$lnktxt{'5'}: $tempaddress\n~;  
	$lnkmessage .= qq~$lnktxt{'6'}: $tempdescription\n~;  
	$lnkmessage .= qq~$lnktxt{'30'}: $lngtext[$templanguage]\n\n~;
	&linknotify;
	$receiver = $linkadmin;
	&linknotify;
}
# Redirects to selected page

	$yySetLocation = qq~$cgi;action=links~;
	&redirectexit;


}

sub showall {

	# Open the file with all linkcategories
	fopen(FILE, "$linksdir/linkcat.txt");
	@linkcategories = <FILE>;
	fclose(FILE);

if ($settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator'){
	$addlink=" - <a href='$cgi&action=link_add'>$lnktxt{'15'}";
} elsif ($allowaddlink ==1 && $username ne 'Guest'){
	$addlink=" - <a href='$cgi&action=link_add'>$lnktxt{'15'}";
} else {
	$addlink="";
}

	$yymain .= qq~
<table border=0 width="100%" cellspacing="0" cellpadding="0" bgcolor="$color{'bordercolor'}" class="bordercolor">
  <tr>
    <td>
    <table cellpadding="4" cellspacing="1" border="0" width="100%">
      <tr>
~;
if ($testlinklive eq "1"){	
	$yymain .= qq~
	<td colspan="5" class="titlebg" bgcolor="$color{'titlebg'}" <font class="text1" color="$color{'titletext'}" size="3"><center><b>$lnktxt{'2'}</b></center></font></a></td>
	~;
} elsif ($testlinklive eq "0"){
	$yymain .= qq~
	<td colspan="4" class="titlebg" bgcolor="$color{'titlebg'}" <font class="text1" color="$color{'titletext'}" size="3"><center><b>$lnktxt{'2'}</b></center></font></a></td>
	~;
}
	$yymain .= qq~
      </tr>
        <td class="titlebg" bgcolor="$color{'titlebg'}" colspan="2"><font class="text1" color="$color{'titletext'}" size="2"><b>$lnktxt{'25'} $lnktxt{'33'} : <select name="select" size="1" onchange="javascript:window.location.href='$scripturl?'+select.options[select.selectedIndex].value+';action=links'">
        $catlist 
        </select>$addlink</font></td>
        <td class="titlebg" bgcolor="$color{'titlebg'}" width="1%" align="center"><font class="text1" color="$color{'titletext'}" size="2"><b>$lnktxt{'30'}</b></font></td>
~;
if ($testlinklive eq "1"){	
	$yymain .= qq~
        <td class="titlebg" bgcolor="$color{'titlebg'}" width="1%" align="center"><font class="text1" color="$color{'titletext'}" size="2"><b>$lnktxt{'32'}</b></font></td>
	~;
}
	$yymain .= qq~
        <td class="titlebg" bgcolor="$color{'titlebg'}" width="24%" align="center"><font class="text1" color="$color{'titletext'}" size="2"><b>$lnktxt{'31'}</b></font></td>
      </tr>~;

# Reads from datafile
  fopen(FILE,"$linksdir/data.txt") || die "Cant open $linksdir/data.txt !\n";
  @ALLDATA = <FILE>;
  fclose(FILE);

# Loops through all data and pics out the once in this category
foreach $catdata (@linkcategories) {
	($catprint,$cattext) = split (/\|/,$catdata);
	&printlinks;
}
	$yymain .= qq~
           </font></td>
      </tr>
        <td class="titlebg" bgcolor="$color{'titlebg'}" colspan="5"><font class="text1" color="$color{'titletext'}" size="2"><b>$lnktxt{'25'} $lnktxt{'33'} : <select name="select2" size="1" onchange="javascript:window.location.href='$scripturl?'+select2.options[select2.selectedIndex].value+';action=links'">
        $catlist
        </select>$addlink</font></td>
          </tr>
        </table>
        </td>
      </tr>~;
	$yymain .= qq~
    </table>~;

	$yytitle = "$lnktxt{'2'}";
	&template;
	exit;

}

sub showcat {

$catprint =$INFO{'category'};

	fopen(FILE, "$linksdir/linkcat.txt");
	@linkcategories = <FILE>;
	fclose(FILE);
foreach $catdata (@linkcategories) {
	($catinfo,$catdescr) = split (/\|/,$catdata);
	if ($catinfo eq $catprint){ $cattext = $catdescr;}
}
# Reads from datafile
$filename = "data.txt";
fopen(FILE,"$linksdir/$filename") || die "Cant open $linksdir/$filename !\n";
@ALLDATA = <FILE>;
fclose(FILE);

if ($settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator'){
	$addlink=" - <a href='$cgi&action=link_add'>$lnktxt{'15'}";
} elsif ($allowaddlink ==1 && $username ne 'Guest'){
	$addlink=" - <a href='$cgi&action=link_add'>$lnktxt{'15'}";
} else {
	$addlink="";
}

	$yymain .= qq~
<table border="0" width="100%" cellspacing="0" cellpadding="0" bgcolor="$color{'bordercolor'}" class="bordercolor">
  <tr>
    <td>
    <table cellpadding="4" cellspacing="1" border="0" width="100%">
      <tr>~;
if ($testlinklive eq "1"){	
	$yymain .= qq~
	<td colspan="5" class="titlebg" bgcolor="$color{'titlebg'}" <font class="text1" color="$color{'titletext'}" size="3"><center><b>$lnktxt{'2'}</b></center></font></a></td>
	~;
} elsif ($testlinklive eq "0"){
	$yymain .= qq~
	<td colspan="4" class="titlebg" bgcolor="$color{'titlebg'}" <font class="text1" color="$color{'titletext'}" size="3"><center><b>$lnktxt{'2'}</b></center></font></a></td>
	~;
}
	$yymain .= qq~
      </tr>
        <td class="titlebg" bgcolor="$color{'titlebg'}" colspan="2"><font class="text1" color="$color{'titletext'}" size="2"><b>$lnktxt{'25'} $lnktxt{'33'} : <select name="select" size="1" onchange="javascript:window.location.href='$scripturl?'+select.options[select.selectedIndex].value+';action=links'">
        $catlist
        </select>$addlink</font></td>
        <td class="titlebg" bgcolor="$color{'titlebg'}" width="1%" align="center"><font class="text1" color="$color{'titletext'}" size="2"><b>$lnktxt{'30'}</b></font></td>
~;
if ($testlinklive eq "1"){	
	$yymain .= qq~
        <td class="titlebg" bgcolor="$color{'titlebg'}" width="1%" align="center"><font class="text1" color="$color{'titletext'}" size="2"><b>$lnktxt{'32'}</b></font></td>
	~;
}
	$yymain .= qq~
        <td class="titlebg" bgcolor="$color{'titlebg'}" width="24%" align="center"><font class="text1" color="$color{'titletext'}" size="2"><b>$lnktxt{'31'}</b></font></td>
      </tr>~;
	&printlinks;
	$yymain .= qq~
           </font></td>
      </tr>
        <td class="titlebg" bgcolor="$color{'titlebg'}" colspan="5"><font class="text1" color="$color{'titletext'}" size="2"><b>$lnktxt{'25'} $lnktxt{'33'} : <select name="select2" size="1" onchange="javascript:window.location.href='$scripturl?'+select2.options[select2.selectedIndex].value+';action=links'">
        $catlist
        </select>$addlink</font></td>
          </tr>
         </table>
        </td>
      </tr>~;
	$yymain .= qq~
    </table>~;

	$yytitle = "$lnktxt{'2'}";
	&template;
	exit;

}

sub printlinks {
  @DATA=();

	for($n=0; $n<@ALLDATA; $n++)    {
		@parts=split(/\|/,$ALLDATA[$n]);
   		if($parts[7] =~ /#$catprint#/i && ($parts[1] eq "1" || $settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator' || $parts[9] eq $username)){
        		push(@DATA,$ALLDATA[$n]);
		}
	}
	

	$yymain .= qq~<tr>
        <td colspan="5" class="catbg" bgcolor="$color{'catbg'}" height="18"><a name="$catprint"> <font size=2><b>$cattext</b></font></a></td>
      </tr>~;

# Loops throug the records
	foreach	$line(@DATA){
		chomp($line);
		($linkid,$linkapprove,$title,$description,$address,$language,$linkkeys,$linkcategory,$reallinkname,$linkuser,$linkemail)=split(/\|/, $line);
		if ($testlinklive eq "1"){
			&verify_links;
		} else {
	        	$linkstatus ="<img src='$imagesdir/ybl_maint.gif' alt='$lnktxt{'36'}' border='0''>";

		}

	$yymain .= qq~<tr>~;
	if ($linkuser eq $username && $linkapprove eq "0" && $settings[7] ne 'Administrator' && $settings[7] ne 'Global Moderator'){
	$yymain .= qq~
	        <td class="windowbg" bgcolor="$color{'windowbg'}" width="8%" align="center" valign="top"><a href="$cgi;action=link_edit;linkid=$linkid">$lnktxt{'23'}</a><br><a href="$cgi;action=link_delete;linkid=$linkid">$lnktxt{'22'}</a><br>$lnktxt{'24'}</td>
	~;
	} elsif ($linkuser eq $username && $linkapprove eq "1" && $settings[7] ne 'Administrator' && $settings[7] ne 'Global Moderator'){
	$yymain .= qq~
	        <td class="windowbg" bgcolor="$color{'windowbg'}" width="8%" align="center" valign="top"><a href="$cgi;action=link_edit;linkid=$linkid">$lnktxt{'23'}</a><br><a href="$cgi;action=link_delete;linkid=$linkid">$lnktxt{'22'}</a></td>
	~;
	}elsif (($settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator') && $linkapprove eq "0"){
	$yymain .= qq~
	        <td class="windowbg" bgcolor="$color{'windowbg'}" width="8%" align="center" valign="top"><a href="$cgi;action=link_edit;linkid=$linkid">$lnktxt{'23'}</a><br><a href="$cgi;action=link_delete;linkid=$linkid">$lnktxt{'22'}</a><br><a href="$cgi;action=link_ok;linkid=$linkid">$lnktxt{'39'}</a></td>
	~;
	} elsif (($settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator') && $linkapprove eq "1"){
	$yymain .= qq~
	        <td class="windowbg" bgcolor="$color{'windowbg'}" width="8%" align="center" valign="top"><a href="$cgi;action=link_edit;linkid=$linkid">$lnktxt{'23'}</a><br><a href="$cgi;action=link_delete;linkid=$linkid">$lnktxt{'22'}</a><br><a href="$cgi;action=link_not_ok;linkid=$linkid">$lnktxt{'38'}</a></td>
	~;
	} else {
	$yymain .= qq~
	        <td class="windowbg" bgcolor="$color{'windowbg'}" width="8%" align="center" valign="top"></td>
	~;
	}
	$yymain .= qq~
        <td class="windowbg2" bgcolor="$color{'windowbg2'}" align="left" width="66%">
        <a name="$title"></a>        
        <font size=2><a href="$address" target="_blank"><B>$title</B></a></font>
        <br><font size="1">$description</font></td>
        <td class="windowbg" bgcolor="$color{'windowbg'}" valign="middle" align="center" width="1%"><font size="2">$lngtext[$language]</font></td>
~;
if ($testlinklive eq "1"){	
	$yymain .= qq~
        <td class="windowbg" bgcolor="$color{'windowbg'}" valign="middle" align="center" width="1%"><font size="2">$linkstatus</font></td>
	~;
}
	$yymain .= qq~
        <td class="windowbg2" bgcolor="$color{'windowbg2'}" valign="middle" align="center" width="14%"><font size="1"><a href="$cgi;action=viewprofile;username=$linkuser">$reallinkname</a></font></td>
	</tr>~;
	}

}

sub verify_links {
# -----------------------------------------------------
    use vars qw(%urls %code %msg $method);
    
# Try to init the Parallel User Checker.
    my ($checker, $slow, %ok_status, %fail_status);
    %ok_status = (
              200, "OK 200",
              201, "CREATED 201",
              202, "Accepted 202",
              203, "Partial Information 203",
              204, "No Response 204",
        );

    %fail_status = (
              -1,  "Could not lookup server",
              -2,  "Could not open socket",
              -3,  "Could not bind socket",
              -4,  "Could not connect",
              301, "Found, but moved",
              302, "Found, but data resides under different URL (add a /)",
              303, "Method",
              304, "Not Modified",
              400, "Bad request",
              401, "Unauthorized",
              402, "PaymentRequired",
              403, "Forbidden",
              404, "File Not found",
              500, "Internal Error",
              501, "Not implemented",
              502, "Service temporarily overloaded",
              503, "Gateway timeout ",
              600, "Bad request",
              601, "Not implemented",
              602, "Connection failed (host not found?)",
              603, "Timed out",
    );      

    my ($request, $status, $error, $url);    
            ($status, $error) = &check_link ($address);
            if (exists $ok_status{$status}) {
                    $linkstatus ="<img src='$imagesdir/ybl_online.gif' alt='$lnktxt{'34'}' border='0''>";
            }
            else {
                $error =~ s/\n//g;
                if (exists $fail_status{$status}) {
                    $linkstatus ="<img src='$imagesdir/ybl_offline.gif' alt='$lnktxt{'35'}' border='0''>";
                }
                else {
                    $linkstatus ="<img src='$imagesdir/ybl_offline.gif' alt='$lnktxt{'35'}' border='0''>";
                }
	    }
}

sub check_link {
# -----------------------------------------------------
# Check links without LWP.
#
    my ($url) = shift;
    my ($host, $port, $path, $sock, $line);
    my $cr = "\015\012";

    ($url =~ m,^http://([^:/]+):?(\d*)(.*),i) and (($host, $port, $path) = ($1, $2, $3));
    $path ||= '/';
    $port ||= 80;
    $path =~ s/#.*//;

    $host or return undef, "Can't parse host from url: $url";   
    use IO::Socket;
    $sock = new IO::Socket::INET ( PeerAddr => $host,
                                   PeerPort => 80,
                                   Proto    => 'tcp',
                                   Type     => SOCK_STREAM,
                                   ) or return undef, $@;
    $sock->autoflush(1);
    $sock->timeout(1);
    print $sock "GET $path HTTP/1.0$cr";
    print $sock "Host: $host$cr";
    print $sock "User-Agent: YaBB Link Exchange Project $cr$cr";
    my $response = <$sock>;
    ($protocol, $status) = split / /, $response;
    close $sock;
   
    return $status;
}

sub validate {

$errors="";

foreach $testline (@LINES){
	if($testline =~ m/$address/){
	        $errors=$errors . "$lnkerrtxt{'1'} !\n";
	}
}


  if($title eq "")  {
    $errors=$errors . "$lnkerrtxt{'2'} !\n";
                    }

  if($description eq "")  {
    $errors=$errors . "$lnkerrtxt{'3'} !\n";
                    }

  if(($address eq "") || ($address eq "http://")) {
    $errors=$errors . "$lnkerrtxt{'4'} !\n";
                    }

  if((lc($testlink) eq "1") && ($address ne "") && ($address ne "http://")) {
    # Defines the useragent
    $ua = new LWP::UserAgent;
    $ua->agent("AgentName/0.1 " . $ua->agent);
    # Requesting
    $request = HTTP::Request->new(GET => $address);
    $respons = $ua->request($request); 
    if($respons->code != 200)    {
        $errors=$errors . "$lnkerrtxt{'5'} ".$respons->code." !\n";
                                 }
    }


	if ($errors ne "")	{
 	&fatal_error ("$errors");
	}
}

sub link_cat {

	&is_admin;
	my( @linkcat, $i );
	fopen(FILE, "$linksdir/linkcat.txt");
	@linkcats = <FILE>;
	fclose(FILE);
	foreach $i (@linkcats) {
		$i =~ tr/\r//d;
		$i =~ tr/\n//d;
	}
	$yymain .= qq~
<table border="0" width="300" cellspacing="1" cellpadding="4" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}">
    <img src="$imagesdir/links.gif" alt="" border="0">
    <font size=2 class="text1" color="$color{'titletext'}"><b>$lnktxt{'10'}</b></font></td>
  </tr><tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}" align="center"><font size=1><i>
$lnktxt{'11'}</i></td>
  </tr><tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}" align="center"><font size=2>
    <form action="$cgi;action=link_cat2" method="POST">
        <textarea cols=55 rows=15 name="linkcat">
~;
	foreach $i (@linkcats) {
		unless( $i && $i =~ m/.+[\|~].+/ ) { next; }
		$yymain .= "$i\n";
	}
	$yymain .= qq~
</textarea><br><BR>
    <input type=submit value="$lnktxt{'28'}"></form></font></td>
  </tr>
</table>
~;
	$yytitle = "$lnktxt{'12'}";
	&template;
	exit;

}

sub link_cat2 {
	&is_admin;
	$FORM{'linkcat'} =~ tr/\r//d;
	$FORM{'linkcat'} =~ s~\A[\s\n]+~~;
	$FORM{'linkcat'} =~ s~[\s\n]+\Z~~;
	$FORM{'linkcat'} =~ s~\n\s*\n~\n~g;
	my @lines = split( /\n/, $FORM{'linkcat'} );
	fopen(FILE, ">$linksdir/linkcat.txt", 1);
	foreach my $i (@lines) {
		$i =~ tr/\n//d;
		unless( $i && $i =~ m/.+[\|~].+/ ) { next; }
		print FILE "$i\n";
	}
	fclose(FILE);
	$yySetLocation = qq~$cgi;action=admin~;
	&redirectexit;
}		

sub linknotify {
# Send notification
	fopen(FILE, "$memberdir/$receiver.dat");
	@recipient = <FILE>;
	fclose(FILE);
	$mydate = &timeformat($date);
	$recipient[2] =~ s/[\n\r]//g; # get email address
	if ($recipient[2] ne "") {
		$fromname = "$mbname Administration";
		$lnktxt{'43'} =~ s~SUBJECT~$lnksubject~g;
		$lnktxt{'43'} =~ s~SENDER~$linkadmin~g;
		$lnktxt{'43'} =~ s~DATE~$mydate~g;
		$lnktxt{'44'} =~ s~SUBJECT~$lnksubject~g;
		$lnktxt{'44'} =~ s~MESSAGE~$lnkmessage~g;
		$lnktxt{'44'} =~ s~SENDER~$fromname~g;
		$lnktxt{'44'} =~ s~DATE~$mydate~g;
		&sendmail($recipient[2],$lnktxt{'43'},$lnktxt{'44'});
	}
} 
 
1;
