###############################################################################
# BoardTemplates.pl                                                           #
###############################################################################
# Board Templates                                                             #
# Allows the admin to select templates for each board/category.               #
# Version:        1.4 (YaBB 2.0/2.1)                                          #
# Released:       March 13th, 2006                                            #
# =========================================================================== #
# Written by AK108 for the YaBB community                                     #
###############################################################################
# BoardTemplates Admin area, changes settings                                 # 
###############################################################################

if($action eq 'detailedversion') { return 1; }

LoadLanguage('BoardTemplates');

if(-e "$vardir/boardtemplatelist.txt") {require "$vardir/boardtemplatelist.txt";}

### Oddly, this isn't loaded.
### But I like the category order array and the boards belonging to each category
### So I'll load it now.
require "$boardsdir/forum.master";

sub boardtemplates {
	my($templatelist, @overridecheck);

	if($INFO{'updated'} == 1) {
		$yymain .= qq~
 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="windowbg" colspan="2">
		 <b>$boardtemplates_txt{11}</b>
	   </td>
     </tr>
   </table>
 </div>
<br />
~;
	}

	$yymain .= qq~
 <form action="$adminurl?action=boardtemplates2" method="post" name="boardtemplates">
 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="titlebg" colspan="2">
		 <img src="$imagesdir/preferences.gif" alt="" border="0" /><b>$boardtemplates_txt{1}</b>
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg" colspan="2">
         $boardtemplates_txt{2}
       </td>
     </tr>~;

	# Build a list of the templates into a drop-down selector
	$templatelist .= qq~
<option value="0">$boardtemplates_txt{3}</option>~;
	while (($curtemplate, $value) = each(%templateset)) {
		$templatelist .= qq~
<option value="$curtemplate">$curtemplate</option>~;
	}

	$boardnum = 0;

	# Loop through each category and display the selector
	for($i = 0; $i < @categoryorder; $i++) {
		my($cat, $mytemplatelist, $mytemplate, $j, @catboards);
		$cat = $categoryorder[$i];

		# Use a regex to find out what template, menu, and smilies we're using.
		$mytemplate = $cattemplate{$cat} || 0;
		$mytemplatelist = $templatelist;
		$mytemplatelist =~ s/\<option value\=\"$mytemplate\"\>/\<option value\=\"$mytemplate\" selected\=\"selected\"\>/i;

		$yymain .= qq~
     <tr valign="middle">
        <td class="catbg">
          <input type="hidden" name="catname$i" value="$cat" /><b>$cat</b>
        </td>
        <td class="catbg">
          <select name="cattemplate$i">$mytemplatelist</select>
        </td>
     </tr>~;
		@catboards = split(/\,/, $cat{$cat});
		# Now we'll go through every board belonging to that category
		for($j = 0; $j < @catboards; $j++) {
			my($board, $mytemplatelist, $mytemplate);
			$board = $catboards[$j];

			# Use a regex to find out what template we're using.
			$mytemplate = $boardtemplate{$board} || 0;
			$mytemplatelist = $templatelist;
			$mytemplatelist =~ s/\<option value\=\"$mytemplate\"\>/\<option value\=\"$mytemplate\" selected\=\"selected\"\>/i;

			$yymain .= qq~
     <tr valign="middle">
        <td class="windowbg2">
          <input type="hidden" name="boardname$boardnum" value="$board" /><b>$board</b>
        </td>
        <td class="windowbg2">
          <select name="boardtemplate$boardnum">$mytemplatelist</select>
        </td>
     </tr>~;
		$boardnum++;
		}
	}


	@overridecheck = ();
	$overridecheck[$templateoverridemode] = ' selected="selected"';
	$yymain .= qq~
     <tr valign="middle">
       <td class="windowbg" colspan="2">
         $boardtemplates_txt{5}
       </td>
     </tr>
     <tr valign="middle">
        <td class="windowbg2" width="50%">
          <b>$boardtemplates_txt{6}</b>
          <br />$boardtemplates_txt{7}
        </td>
        <td class="windowbg2">
          <select name="overridemode">
            <option value="0"$overridecheck[0]> $boardtemplates_txt{8}</option>
            <option value="1"$overridecheck[1]> $boardtemplates_txt{9}</option>
          </select>
        </td>
     </tr>
     <tr valign="middle">
       <td align="center" class="catbg" colspan="2">
	 <input type="submit" name="submit" value="$boardtemplates_txt{10}" />
       </td>
     </tr>
   </table>
 </div>
 </form>

 <br />
 <br />

 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
  <table width="100%" cellspacing="1" cellpadding="4">
    <tr class="titlebg"><td><img src="$imagesdir/preferences.gif" alt="" border="0" /><b>$boardtemplates_txt{12}</b></td></tr>
    <tr class="windowbg"><td>$boardtemplates_txt{13}</td></tr>
  </table>
 </div>
~;
	$yytitle = 'Board Template Settings';
	$action_area = 'boardtemplates';
	&AdminTemplate;
	exit;
}

sub boardtemplates2 {
	my($settings);
	# Write out the settings
	# IMPORTANT TO ANYONE TRYING TO UNDERSTAND THIS SECTION!
	# I change between qq~~; and q~~; so sometimes variables are interpeted and sometimes not.
	# Pay close attention. It's confusing, but (more) efficient then backslashing all variables.

	# Board-level templates
	$settings = q~%boardtemplate = (
~;
	for($i = 0; $FORM{"boardname$i"}; $i++) {
		if($FORM{"boardtemplate$i"}) {
			$settings .= qq~'$FORM{"boardname$i"}', '$FORM{"boardtemplate$i"}',\n~;
		}
	}
	$settings =~ s~,\n\Z~~s; # Clean out final comma -- I like my generated code clean
	$settings .= q~
);

%cattemplate = (
~;

	# Category loop
	for($i = 0; $FORM{"catname$i"}; $i++) {
		if($FORM{"cattemplate$i"}) {
			$settings .= qq~'$FORM{"catname$i"}', '$FORM{"cattemplate$i"}',\n~;
		}
	}
	$settings =~ s~,\n\Z~~s;
	$settings .= q~
);~;

	# Override setting
	if($FORM{'overridemode'} !~ /\A(1|2)\Z/) {$FORM{'overridemode'} = 0;}
	$settings .= qq~

\$templateoverridemode = \'$FORM{'overridemode'}\';
~;

	# Logic to make it work
	### First, we check if we're allowed to override.
	### Then we change the user's template value, saving the original. We call WhatTemplate and then return the original value.
	$settings .= q~
if($templateoverridemode == 0 || ($templateoverridemode == 1 && ${$uid.$username}{'template'} eq 'Forum default')) {
	my($oldtemp) = ${$uid.$username}{'template'};
	if($boardtemplate{$INFO{'virboard'}}) {${$uid.$username}{'template'} = $boardtemplate{$INFO{'virboard'}}; &WhatTemplate();}
	elsif($boardtemplate{$currentboard}) {${$uid.$username}{'template'} = $boardtemplate{$currentboard}; &WhatTemplate();}
	elsif($cattemplate{$INFO{'catselect'}} || ${$uid.$currentboard}{'cat'}) {
		${$uid.$username}{'template'} = $cattemplate{$INFO{'catselect'}} || $cattemplate{${$uid.$currentboard}{'cat'}};
		&WhatTemplate();
	}
	${$uid.$username}{'template'} = $oldtemp;
}

1;~;
	
	fopen(BOARDTEMPLATEUPDATE, ">$vardir/boardtemplatelist.txt") || &admin_fatal_error("$load_txt{23} $vardir/boardtemplatelist.txt: $!");
	print BOARDTEMPLATEUPDATE $settings;
	fclose(BOARDTEMPLATEUPDATE);
	$yySetLocation = qq~$adminurl?action=boardtemplates;updated=1~;
	&redirectexit;
}

1;
