<id>
Board Templates for YaBB 2
</id>

<version>
1.4 (YaBB 2.0/2.1)
</version>

<mod info>
See my BoardMod topic for info.

This mod allows the administrators to set what template is displayed on a per-board/category basis.

Another somewhat unrelated feature is the ability to set a menu .def file for each template. The menu changes affect the template all the time, not just ones activated by BoardTemplates.

Note: This mod was written and tested mostly on YaBB 2.1. It should work on YaBB 2.0 though.

To install:
Use BoardMod like normal
Upload these files in Sources/: BoardIndex.pl, MessageIndex.pl, Display.pl, Post.pl, Load.pl, System.pl
Upload these files in Admin/: Modlist.pl, AdminSubList.pl, ManageTemplates.pl, BoardTemplates.pl (provided in zip)
Upload AdminIndex.pl
Upload Languages/English/BoardTemplates.lng (provided in zip)

Version History of Stable Releases:
1.4 (YaBB 2.0/2.1): Massive bugfix updates. Also added Dutch lng pack. (March 13th, 2006)
1.3 (YaBB 2.0/2.1): Rewrote the code changing menu styles and put it into the ManageTemplates section. (December 23rd, 2005)
1.2 (YaBB 2.0/2.1): Changed the arrangement of boards and categories in the Admin section to match the view on the Board Index. Added the ability to use a different .def file with a template. (December 8th, 2005)
1.1 (YaBB 2.0/2.1): Fixed bug with announcements board. Fixed bug with a board template replacing a user-set template in their profile. Updated the Language file. (November 20th, 2005)
1.0 (YaBB 2.0/2.1): Mod package made available on BoardMod. (November 11th, 2005)
</mod info>

<author>
AK108
</author>

<homepage>
http://fkp.jkcsi.com/
</homepage>

<edit file>
Sources/BoardIndex.pl
</edit file>

<search for>
LoadLanguage("BoardIndex");
</search for>

<add before>
### AK108 Board Templates
### All the work is done in there ;)
if(-e "$vardir/boardtemplatelist.txt" && $INFO{'catselect'}) {require "$vardir/boardtemplatelist.txt";}

</add before>

<edit file>
Sources/MessageIndex.pl
</edit file>

<search for>
LoadLanguage("MessageIndex");
</search for>

<add before>
### AK108 Board Templates
### All the work is done in there ;)
if(-e "$vardir/boardtemplatelist.txt") {require "$vardir/boardtemplatelist.txt";}

</add before>

<edit file>
Sources/Display.pl
</edit file>

<search for>
LoadLanguage("Display");
</search for>

<add before>
### AK108 Board Templates
### All the work is done in there ;)
if(-e "$vardir/boardtemplatelist.txt") {require "$vardir/boardtemplatelist.txt";}

</add before>

<edit file>
Sources/Post.pl
</edit file>

<search for>
LoadLanguage("Post");
</search for>

<add before>
### AK108 Board Templates
### All the work is done in there ;)
if(-e "$vardir/boardtemplatelist.txt") {require "$vardir/boardtemplatelist.txt";}

</add before>

<edit file>
Sources/Load.pl
</edit file>

<search for>
	LoadLanguage("Main");
	LoadLanguage("Menu");
</search for>

<add after>
	# Board Templates Mod
	# Provide template-specific .def files
	# This is an odd place to put this, but LoadLanguage("Menu"); resets the %img hash, so I'll do this here
	if($usemenu eq '0') {do "$vardir/Menu0.def";}
	elsif($usemenu eq '1') {do "$vardir/Menu1.def";}
	elsif($usemenu eq '2') {do "$vardir/Menu2.def";}
	elsif($usemenu) {
		if(($adminscreen && $managetemplatesoktoreload) || !$adminscreen) {
			%imgcopy = %img;
			do "$templatesdir/$usemenu/$usemenu.def";
			%img = (%imgcopy, %img);
			undef %imgcopy;
		}
	}
</add after>

<search for>
	($usestyle, $useimages, $usehead, $useboard, $usemessage, $usedisplay) = split(/\|/, $templateset{"$template"});
</search for>

<add after>
	$usemenu = $menutype{$template};
	$changedbuttonmap = $buttonmap{$template} || '';
</add after>

<search for>
	if (!-e "$templatesdir/$usedisplay/Display.template")      { $usedisplay = "default"; }
</search for>

<add after>
	if (!-d "$htmldir/Buttons/$lang/$changedbuttonmap")        { undef $changedbuttonmap; }
	if (!-e "$templatesdir/$menutype{$template}/$menutype{$template}.def" && $usemenu ne '0' && $usemenu ne '1' && $usemenu ne '2')      { $usemenu = ''; }
</add after>

<edit file>
Sources/System.pl
</edit file>

<search for>
		fclose(UPDATETEMPLATE);
	}
	if ($tempjob eq "delete") {
</search for>

<add before>
		# BoardTemplates: Write out the hashes
		print UPDATETEMPLATE "\n";
		while(($key, $value) = each(%menutype)) {
			# Check if the templateset exists
			if($templateset{$key} && $value ne 'default') {print UPDATETEMPLATE qq~\$menutype{'$key'} = '$value';\n~;}
		}
		print UPDATETEMPLATE "\n";
		while(($key, $value) = each(%buttonmap)) {
			# Check if the templateset exists
			if($templateset{$key} && $value ne 'default') {print UPDATETEMPLATE qq~\$buttonmap{'$key'} = '$value';\n~;}
		}
		# End BoardTemplates
		print UPDATETEMPLATE "\n1;";
</add before>

<search for>
		fclose(UPDATETEMPLATE);
	}
	$templatesloaded = 0;
</search for>

<add before>
		# BoardTemplates: Write out the hashes
		print UPDATETEMPLATE "\n";
		while(($key, $value) = each(%menutype)) {
			# Check if the templateset exists
			if($templateset{$key}) {print UPDATETEMPLATE qq~\$menutype{'$key'} = '$value';\n~;}
		}
		print UPDATETEMPLATE "\n";
		while(($key, $value) = each(%buttonmap)) {
			# Check if the templateset exists
			if($templateset{$key}) {print UPDATETEMPLATE qq~\$buttonmap{'$key'} = '$value';\n~;}
		}
		# End BoardTemplates
		print UPDATETEMPLATE "\n1;";
</add before>

<edit file>
Sources/Subs.pl
</edit file>

<search for>
sub template {
</search for>

<add before>
sub ButtonLoc {
	my $map = $_[1] || $changedbuttonmap;
	unless($map) {return $_[0]}
	my $path = $_[2] || "$htmldir/Buttons/$language";
	if(-e "$path/$map/$_[0]") {return "$map/$_[0]";}
	return $_[0];
}

</add before>

<search for>
		$output .= $curline;
</search for>

<add before>
		# Board Templates mod
		if($changedbuttonmap) {
			$curline =~ s~src=(\"|\')$html_root/Buttons/$language/(.*?)\1~"src=$1$html_root/Buttons/$language/" . &ButtonLoc($2) . $1~eig;
			$curline =~ s~src=(\"|\')$modimgurl/(\w+)/(.*?)\1~"src=$1$modimgurl/$2/" . &ButtonLoc($3, '', "$modimgdir/$2") . $1~eig; 
		}
		# End
</add before>

<edit file>
Admin/ManageTemplates.pl
</edit file>

<search for>
	($aktstyle, $aktimages, $akthead, $aktboard, $aktmessage, $aktdisplay) = split(/\|/, $templateset{"$akttemplate"});
	$thisimagesdir = "$forumstylesurl/$aktimages";

	my ($fullcss, $line);
</search for>

<add after>
	### BoardTemplates menu type
	&LoadLanguage('BoardTemplates');
	# Figure out which menu def to use
	$usemenu = $INFO{'menutype'}; # Load from the URL
	if ($INFO{'menutype'} eq 'default') {$usemenu = $MenuType;} # Set it to default if needed
	unless(defined $usemenu) {$usemenu = $menutype{$akttemplate} || $MenuType;} # If it's not there at all, set to saved or default.

	$usemenu =~ s/\.def\Z//;
	$managetemplatesoktoreload = 1;
	&WhatLanguage;
	if($INFO{'menutype'} ne 'default' && $usemenu =~ /\A(\d)\Z/) {$selectedmenu[$1] = ' selected="selected"';}
	$aktmenutype = $usemenu;
	# More magic for buttonmaps
	if(!$buttonmap{$thistemplate} && $INFO{'buttonmap'} eq undef && $INFO{'buttonmap'} == undef) {$INFO{'buttonmap'} = 'default';}
	if($INFO{'buttonmap'}) {$selectedbuttonmap{$INFO{'buttonmap'}} = 'selected="selected" ';}
	elsif($buttonmap{$thistemplate}) {$selectedbuttonmap{$buttonmap{$thistemplate}} = 'selected="selected" ';}
	if(defined $INFO{'buttonmap'}) {$changedbuttonmap = $INFO{'buttonmap'};}

	# Make a list of all the possible button maps
	$buttonmaps = qq~<option value="default">$boardtemplates_txt{3}</option>~;
	opendir(TMPLDIR, "$htmldir/Buttons/$lang");
	while($_ = readdir(TMPLDIR)) {
		if($_ ne '.' && $_ ne '..' && -d "$htmldir/Buttons/$lang/$_") {$buttonmaps .= qq~\n<option value="$_"$selectedbuttonmap{$_}>$_</option>~;}
	}
	closedir(TMPLDIR);
	### End BoardTemplates
</add after>

<search for>
				$headtemplates .= qq~<option value="$file"$hselected>$name</option>\n~;
			}
			$bselected = "";
			if ($section eq 'BoardIndex') {
</search for>

<replace>
				$headtemplates .= qq~<option value="$file"$hselected>$name</option>\n~;
			}
			# BoardTemplates menus
			$menutypeselected = "";
			if ($ext eq 'def') {
				if ($file eq "$usemenu.def") { $menutypeselected = qq~ selected="selected"~; }
				$menutypes .= qq~<option value="$file"$menutypeselected>$name</option>\n~;
			}
			$bselected = "";
			if ($section eq 'BoardIndex') {
</replace>

<search for>
	}

	fopen(TMPL, "$templatesdir/$viewhead/$viewhead.html");
	while ($line = <TMPL>) {
</search for>

<replace>
	}

	# BoardTemplates menu type
	my(@selectedmenu);
	if($menutypes !~ / selected=\"selected\"\>/ && $usemenu !~ /\D/) {$selectedmenu[3] = ' selected="selected"';}
	$menutypes = qq~
				<option value="default"$selectedmenu[3]>$boardtemplates_txt{3}</option>
				<option value="0"$selectedmenu[0]>$admin_txt{'521a'}</option>
				<option value="1"$selectedmenu[1]>$admin_txt{'521b'}</option>
				<option value="2"$selectedmenu[2]>$admin_txt{'521c'}</option>
~ . $menutypes;
	undef @selectedmenu;

	fopen(TMPL, "$templatesdir/$viewhead/$viewhead.html");
	while ($line = <TMPL>) {
</replace>

<search for>
	<tr valign="middle">
		<td align="left" class="windowbg2">
		<div style="float: left; width: 30%; padding: 3px;"><b>$templ_txt{'12'}</b></div>
		<div style="float: left; width: 69%;">
			<input type="hidden" name="tempname" value="$fulltemplate" />
			<input type="hidden" name="templateset" value="$akttemplate" />
			<input type="text" name="saveas" size="30" maxlength="50" />
			<input type="submit" value="$templ_txt{'13'}" onclick="document.selskin.button.value = '2';" />
			<input type="submit" value="$templ_txt{'9'}" onclick="document.selskin.button.value = '1';" />
		</div>
		</form>
		</td>
	</tr>
</search for>

<add before>
	<tr valign="middle">
		<td align="left" class="windowbg2">
		<div style="float: left; width: 30%; padding: 3px;"><b>$admin_txt{'521'}</b></div>
		<div style="float: left; width: 32%;">
				<select name="menutype" id="menutype" size="1" style="width: 90%;">
				$menutypes
				</select>
		</div>
		</td>
	</tr>
	<tr valign="middle">
		<td align="left" class="windowbg2">
		<div style="float: left; width: 30%; padding: 3px;"><b>Button map</b></div>
		<div style="float: left; width: 32%;">
				<select name="buttonmap" id="buttonmap" size="1" style="width: 90%;">
				$buttonmaps
				</select>
		</div>
		</td>
	</tr>
</add before>

<search for>
		$formattemp = $FORM{'templateset'};
		&formatTempname;
		$yySetLocation = qq~$adminurl?action=modskin;templateset=$formattemp;cssfile=$FORM{'cssfile'};imgfolder=$FORM{'imgfolder'};headfile=$FORM{'headfile'};boardfile=$FORM{'boardfile'};messagefile=$FORM{'messagefile'};displayfile=$FORM{'displayfile'};selsection=$FORM{'selsection'}~;
</search for>

<add after>
		# BoardTemplates mod
		if(defined $FORM{'menutype'}) {$yySetLocation .= qq~;menutype=$FORM{'menutype'}~;}
		if($FORM{'buttonmap'}) {$yySetLocation .= qq~;buttonmap=$FORM{'buttonmap'}~;}
		# End BoardTemplates mod
</add after>

<search for>
		$formattemp = $FORM{'saveas'};
		&formatTempname;
		$yySetLocation = qq~$adminurl?action=modskin;templateset=$formattemp;cssfile=$FORM{'cssfile'};imgfolder=$FORM{'imgfolder'};headfile=$FORM{'headfile'};boardfile=$FORM{'boardfile'};messagefile=$FORM{'messagefile'};displayfile=$FORM{'displayfile'};selsection=$FORM{'selsection'}~;
</search for>

<add after>
		# BoardTemplates mod
		if(defined $FORM{'menutype'}) {$yySetLocation .= qq~;menutype=$FORM{'menutype'}~;}
		if($FORM{'buttonmap'}) {$yySetLocation .= qq~;buttonmap=$FORM{'buttonmap'}~;}
		$menutype{$template_name} = $FORM{'menutype'};
		$menutype{$template_name} =~ s/\.def\Z//;
		$buttonmap{$template_name} = $FORM{'buttonmap'};
		# End BoardTemplates mod
</add after>

<edit file>
Admin/AdminSubList.pl
</edit file>

<search for>
%director=(
</search for>

<add after>
'boardtemplates2', 'BoardTemplates.pl&boardtemplates2',
'boardtemplates', 'BoardTemplates.pl&boardtemplates',
</add after>

<edit file>
Admin/ModList.pl
</edit file>

<search for>
### END BOARDMOD ANCHOR ###
</search for>

<add before>
	$boardtemplates = "Board Templates|AK108|Allows the administrator to change templates and menus on a per-board/category basis.|1.4|March 13th, 2006";
	push(@installed_mods, $boardtemplates);
</add before>

<edit file>
AdminIndex.pl
</edit file>

<search for>
### END BOARDMOD ANCHOR ###
</search for>

<add before>
 	$boardtemplates = 'boardtemplates|Board Templates|Set templates on a per-board/category basis|';
	push(@boardmod_mods, $boardtemplates);
</add before>