sub DeletePosts {
  &is_admin;
	
	#get the search type (Posted by, email address etc) and the value
	my $searchterm = $FORM{'SearchFor'} || fatal_error($delposttxt{'4'});
	my $searchfield = $FORM{'Field'} || fatal_error($delposttxt{'4'});

	#some hashes that get built as we go through the messages
  my %to_delete;      #holds a list of threads to remove a post from
  my %to_annihalate;  #holds a list of threads to remove completely
  my %to_remove;      #holds a list of messages to remove from the board itself
  
	#Searchable fields - not sure what fields 5,6 and 9 are for
  my %fields = (
  	'Subject' => '0',
  	'Poster' => '1',
  	'Email' => '2',
  	'Date' => '3',
  	'UserName' => 4,
    'unknown' => 5,
  	'unknown' => 6,
  	'IP' => '7',
  	'message' => '8',
  	'unknown' => 9,
  );
  
	#foreach of the messages in the datadir:
  MESSAGE: foreach my $message (<$datadir/*.txt>) {
  	my $count = "0";  #keeps track of the amount of posts && replies
  
  	fopen (MESS,"<$message") || fatal_error( "Could not open $message: $!");  #try to open the message

		#loop through the message
  	while (<MESS>) {
			#split it into posts (delimited by newline)
  		my @posts = split /\n/,$_;
			
  		foreach (@posts) {
				#split a particular post into it's fields (delimited by pipe symbol)
       	my @fields = split/\|/,$_;

				#if the first post (count is still 0) matches - then we want to remove the thread
				#so, count in %to_annihalate and skip to the next message
  			if ($count == 0 && $fields[ $fields{$searchfield} ] eq $searchterm) {
  				$to_annihalate{$message}++; 
  				next MESSAGE;
  			}
				#if the search term matches, then we want to remove this post only - all we do is 
				#add the message ID to %to_delete here
  			$to_delete{$message}++ if $fields[ $fields{$searchfield} ] eq $searchterm;

				#count which post in the thread we are in
  			++$count;
  		} #end foreach @posts
  	} #end while (<MESS>)
  } #end foreach message

	#did we find any messages to delete?
	kill_messages(\%to_delete, 
	              \%fields, 
								$searchterm,
							  $searchfield,) if %to_delete;

	#or did we find anything to annihalate?
	annihalate(\%to_annihalate) if %to_annihalate;

	all_done($searchterm, $searchfield);

}

sub kill_messages {
	my $to_delete = shift;
	my $fields = shift;
	my $term = shift;
	my $field = shift;

	#foreach of the posts to delete from threads
  foreach my $message (keys %{$to_delete}) {
  	my @new_message;  #array to hold the new message
  	my $last_poster;  #the "new" last poster
  	my $datafile = $message;  #the datafile is the same as the message
  	$datafile =~ s/\.txt$/.data/; #except ends in .data instead of .txt
  	
		#fopen the message
  	fopen (MESS, "<$message") || fatal_error( "Could not open $message: $!");

  	while (<MESS>) {
			#split the message into posts (delimited by newline)
  		my @post = split /\n/,$_;
			
  		foreach (@post) {
				#split the post into fields (delimited by pipe symbol)
  			my @fields = split /\|/,$_;
				#if this post is a match - we skip it
  			next if $fields[ $fields->{$field} ] eq $term;
				#put the line back into the array that we will print out
  			push @new_message,$_;
				#get the person that posted last
  			$last_poster = $fields [ $fields->{'Poster'} ];
  		}
  	}
		#fclose the message
  	fclose(MESS);
  
		#clobber the message file
  	fopen (MESS_W, ">$message") || fatal_error( "Could not overwrite $message: $!");
		#print out the "lines" in @new_message array
  	print MESS_W $_,"\n" foreach @new_message;
  	fclose(MESS_W);
  
		#get the "viewed" number from the datafile (first field)
  	fopen (DATA_R, "<$datafile") || fatal_error( "Could not open $datafile: $!");
  	my $viewed = (split/\|/,<DATA_R>)[0];
		fclose(DATA_R);
  	
		#clobber the data file
  	fopen (DATA_W, ">$datafile") || fatal_error( "Could not overwrite $datafile: $!");
		#print back the viewed number & the new last poster
  	print DATA_W $viewed,"|",$last_poster;
  	fclose(DATA_W);

		#lastly fopen the boards file
		foreach my $file (<$boardsdir/*.txt>) {
			my @to_print;
			fopen (SUBJECTS,$file) || fatal_error( "Could not open $file: $!");
			while (my $msg = <SUBJECTS>) {
			  my @tmpmsg = split/|/,$msg;	
				my $msgid = $tmpmsg[0];
			  #add the path info to the msgid - the message is in the hash with
				#path info included!
				$msgid = $datadir . "/" . $msgid . ".txt";
				if ($to_delete->{$msgid}) {
					my @tmpmsg = split/\|/,$msg;
					$tmpmsg[5] = $tmpmsg[5] - $to_delete->{$msgid};
					$msg = join "|",@tmpmsg;
					}
				push @to_print,$msg;
			}
			fclose(SUBJECTS);
			fopen (SUBJECTS,">$file") || fatal_error( "Could not overwrite $file: $!");
			print SUBJECTS $_ foreach @to_print;
			fclose(SUBJECTS);
		}
	}
}


sub annihalate {
  
	my $to_annihalate = shift;

	my %to_remove;
	
	#delete the threads completely if needed:
  foreach my $msgid (keys %{$to_annihalate}) {
  	my $datafile = $msgid;
  	$datafile =~ s/\.txt$/.data/;
  	unlink $msgid || fatal_error( "Could not unlink $msgid: $!");
  	unlink $datafile || fatal_error( "Could not unlink $datafile: $!" );
  }

  
	#fopen the threads indexes (boardname.txt)
  foreach my $file (<$boardsdir/*.txt>) {
  	fopen (SUBJECTS, "<$file") || fatal_error( "Could not open $file: $!");

		#foreach line in the file
  	while (my $msg = <SUBJECTS>) {
			#foreach message id to annihlatate
			my $msgid = (split/\|/,$msg)[0];
			#add path info to make it like the msg ids
			$msgid = $datadir. "/" . $msgid . ".txt";
			$to_remove{$file}++ if $to_annihalate->{$msgid};
  	}
		fclose(SUBJECTS);
  }
  
	#lastly for each threads index file that had an "annihalated" message
  foreach my $file (keys %to_remove) {
  	my @new_index;  #holds the "new" index

		#fopen the file
  	fopen (SUBS_R, "<$file") || fatal_error( "Could not open $file: $!");

		while (<SUBS_R>) {
			#get the message id
  		my $msgid = (split/\|/,$_)[0];

			#make the message id look like whats in the %to_annihalate hash
  		$msgid = "$datadir/$msgid.txt";

			#skip the line if it's in the annihalate hash
  		next if $to_annihalate->{$msgid};

			#otherwise add it back to the new "file"
      push @new_index,$_;
  	}
  	fclose(SUBS_R);
	
		#clobber the file
   	fopen (SUBS_W, ">$file") || fatal_error( "Could not clobber $file: $!");
		#print out the "new" index
  	print SUBS_W $_ foreach @new_index;
  	fclose(SUBS_W);
  }
}

sub all_done {

	my $field = shift;
	my $term = shift;

	$yymain .= qq|
	<br><br>
	<div align=center>
	<hr width = "75%">
	<p>Finished deleting all posts where $field was equal to $term</p>
	<br>
	<p>Return to <a href=$cgi>Main</a></p>
	<hr width = "75%">
	</div>
	
	|;
	$yytitle = $delposttxt{'1'};
	&template;
	exit;

}

sub get_DelPostInfo {
	&is_admin;
	&loadfiles;
	$yymain .= qq|<form action="$cgi;action=delposts2" method="POST">
	<table align="center">
	<tr>
	  <td class="titlebg" colspan="2">Delete Posts</td>
	</tr>
	<tr>
	  <td><font size="2">Search Field:</td>
	  <td><font size="2">
		  <select name=Field>
		  <option value="Poster">Poster</option>
			<option value="UserName">Username</option>
			<option value="Email">Email Address</option>
			<option value="IP">IP address</option>
			<option value="Subject">Subject</option>
			</select>
		</td>
	</tr>
	<tr>
	  <td><font size="2">Search for:</td>
		<td><input type="text" name="SearchFor"></td>
  </tr>
	<tr>
	  <td colspan="2"><input type="submit" value="Delete Posts" name="Delete Posts"></td>
	</tr>
  </table>
	|;
	$yytitle = $delposttxt{'1'};
	&template;
	exit;
}

1;
