<id>
file_attachment.mod
</id>

<version>
2.5 Beta
</version>

<mod info>
Allows the attachment of a file to a post. Filesize, types, and paths all must be edited in the admin center after applying this mod before file attaching will work. If settings are not applied immediately, uers may experience errors when trying to post until you define all the variables for the mod. Directory and URL paths should be without trailing '/'. The directory you create for attachments should be world readable and writeable, also (chmod 666 or 777).
The paperclip.gif file should be placed into your YaBBImages folder or wherever you keep all your YaBB images. The Attachments.pl file should be put into your Sources folder (leave as is, dont chmod to anything), and upload attachments.txt, oldestattach.txt, and maxattachsize.txt to your variables folder and chmod all of them to 666. Make sure you upload everything but the paperclip.gif image in ASCII mode.

Read the included readme.txt file for more information and thanks.
</mod info>

<author>
Dave Baughman
</author>

<homepage>
http://www.caveden.com
</homepage>

<edit file>
Sources/SubList.pl
</edit file>

<search for>
'editnews2',"AdminEdit.pl&EditNews2",
</search for>

<add after>
'deleteattachment',"Attachments.pl&DeleteAttachments",
'manageattachments',"Attachments.pl&Attachments",
'manageattachments2',"Attachments.pl&ViewAttachments",
'removeoldattachments',"Attachments.pl&RemoveOldAttachments",
'removebigattachments',"Attachments.pl&RemoveBigAttachments",
</add after>

<edit file>
english.lng
</edit file>

<search for>
1;
</search for>

<add before>

$fatxt{'1'} = "(attachment deleted)";
$fatxt{'2'} = "Allowed file types:";
$fatxt{'3'} = "Maximum attachment size:";
$fatxt{'4'} = "All types.";
$fatxt{'5'} = "No limit.";
$fatxt{'6'} = "Attach:";
$fatxt{'7'} = "NOTICE: If you had an attachment in your post, you will need to reselect the attachment again in the browse box for security reasons.";
$fatxt{'8'} = "A file on the server already exists with that name. Please rename your file before attaching.";
$fatxt{'9'} = "Attachment Statistics and Functions";
$fatxt{'10'} = "Attachments Directory";
$fatxt{'11'} = "Attachments URL";
$fatxt{'12'} = "File size limit for attachments in KB (set to 0 to disable)";
$fatxt{'13'} = "Attachment directory size limit in KB (set to 0 to disable)";
$fatxt{'14'} = "Allowed file extensions for attachments (ex: 'jpg gif bmp')";
$fatxt{'15'} = "Enable file extension check? (Turn off to allow all file types)";
$fatxt{'16'} = "Display picture attachments in posts?";
$fatxt{'17'} = "Allow file attaching in posts?";
$fatxt{'18'} = "Allow guests to upload attachments?";
$fatxt{'19'} = "Could not open";
$fatxt{'20'} = "Invalid File Format. Valid files are";
$fatxt{'21'} = "Attachment is approximately";
$fatxt{'21b'} = "too large.";
$fatxt{'22'} = "This attachment causes the attachments directory to exceed it's maximum capacity by approximately ";
$fatxt{'22b'} = "and cannot be uploaded.";
$fatxt{'23'} = "No max directory size for attachments currently set.";
$fatxt{'24'} = "Administrate File Attachments";
$fatxt{'25'} = "From here you can administrate the files on your system that have been attached to messages in your YaBB. You can delete attachments by size and date from your system. Statistics on attachments are also displayed below.";
$fatxt{'26'} = "File Attachment Stats";
$fatxt{'27'} = "Total";
$fatxt{'28'} = "Total Attachments:";
$fatxt{'29'} = "Total Size of Attachment Directory:";
$fatxt{'30'} = "Total Space Available in Attachments Directory:";
$fatxt{'31'} = "File Attachment Options";
$fatxt{'32'} = "Remove attachments older than";
$fatxt{'33'} = "Remove attachments larger than";
$fatxt{'34'} = "Remove attachments older than number of days:";
$fatxt{'35'} = "Remove attachment larger than";
$fatxt{'36'} = "Administrate File Attachments";
$fatxt{'37'} = "Administrate File Attachments : View Log";
$fatxt{'38'} = "The attachment log displays info about every attachment on your forum. You can download attachments from this section, delete attachments, or jump to the thread where the attachment is posted.";
$fatxt{'39'} = "Attachment Log";
$fatxt{'40'} = "Attachment Name";
$fatxt{'41'} = "File Size";
$fatxt{'42'} = "Posted By";
$fatxt{'43'} = "Date";
$fatxt{'44'} = "Topic";
$fatxt{'45'} = "Delete";
$fatxt{'46'} = "Are you sure you want to delete all attachments?";
$fatxt{'47'} = "Webserver Type";
$fatxt{'48'} = "There are currently no attachments uploaded";
$fatxt{'49'} = "Illegal attempt to attach a file.";

</add before>

<edit file>
Sources/Display.pl
</edit file>

<search for>
sub Display {
</search for>

<add after>
	my($msf,$mfn,$attachment,$showattach);
</add after>

<search for>
		($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $postmessage, $ns, $mlm, $mlmb) = split(/[\|]/, $_);
</search for>

<replace>
		($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $postmessage, $ns, $mlm, $mlmb, $msf, $mfn) = split(/[\|]/, $_);
</replace>

<search for>
		# Should we show "last modified by?"
</search for>

<replace>
		# Should we show an attachment file?
			if( $msf && $mfn && $msf ne "" && $mfn ne "") {
			if (-e ("$upload_dir/$mfn")) {
			$attachment = qq~<font size="1"><a href="$msf" target="_blank"><img src="$imagesdir/paperclip.gif" border="0" align="absmiddle">  $mfn</a></font>~;
				if(($mfn =~ /(jpg|gif|bmp|png|jpeg)$/i) && ($amdisplaypics == 1)) {
					$showattach = qq~<hr width="100%"><center><img src="$msf" alt"$msf" border="0"></center>~;
				} else { 
					$showattach = ''; 
				}
			} else { 
				$attachment = qq~<font size="1"><img src="$imagesdir/paperclip.gif" border="0" align="absmiddle">  $mfn $fatxt{'1'}</font>~;
				$showattach = '';
			}
		} else {
			$attachment = '';
			$showattach = '';
		}
		
		# Should we show "last modified by?"
</replace>

<search for>
                <font size="2"><B>$msub</b></font><BR>
</search for>

<replace>
                <font size="2"><B>$msub</b></font> &nbsp;$attachment<BR>
</replace>

<search for>
                <td align="right"><font size="1"><img src="$imagesdir/ip.gif" alt="" border="0"> $mip</font></td>
              </tr>
            </table>
</search for>

<add after>
            $showattach
</add after>

<edit file>
Sources/Subs.pl
</edit file>

<search for>
	if ($ENV{REQUEST_METHOD} eq 'POST')
	{
		read(STDIN, my $input, $ENV{CONTENT_LENGTH});
		split_string(\$input, \%FORM) 
	}
</search for>

<replace>
	if ($ENV{REQUEST_METHOD} eq 'POST') {
		if ($ENV{CONTENT_TYPE} =~ /multipart\/form-data/){
			require CGI; import CGI qw(:standard);
			my $query = new CGI;
			my (@keylist) = sort($query->param());
			foreach $key (@keylist) {
				if ($query->param('file')) {
					$filename = $query->param('file');
					$postsize -= length($query->param('file'));
					$tmpfile = $query->tmpFileName($filename);
				}
			
			$postsize += length($query->param($key));
			# may be dealing with multiple values; need to join with comma
			$value = join(', ', $query->param($key));
			$FORM{$key} = $value;
			}

		} else {
			read(STDIN, my $input, $ENV{CONTENT_LENGTH});
			split_string(\$input, \%FORM) 
		}
	
	}
</replace>

<search for>
sub get_date {
</search for>

<add before>
sub dirstats {
	use File::Find;
	my ($size, $used_space, $free_space) = 0;
	&find ( sub { $dirsize += -s }, $upload_dir );
	$used_space = int ($dirsize / 1024);
	$spaceleft = ($mydirlimit - $dirsize);
	$kbspaceleft = ($dirlimit - $used_space);
}

sub clear_temp {
	if($filename) {
		close($filename);
	}
	if (-e $tmpfile && $tmpfile ne '')  {
		close($tmpfile);
		unlink $tmpfile || &fatal_error("Error deleting tempfile '$tmp': $!\n");
	}
}

sub write_error {
	my $e = $_[0];
	&clear_temp;
	&LoadIMs;	# Load IM's
	$yymain .= qq~
<table border=0 width="80%" cellspacing=1 bgcolor="$color{'bordercolor'}" class="bordercolor" align="center" cellpadding="4">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}"><font size=2 class="text1" color="$color{'titletext'}"><b>$txt{'106'}</b></font></td>
  </tr><tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}"><BR><font size=2>$e</font><BR><BR></td>
  </tr>
</table>
<center><BR><a href="javascript:history.go(-1)">$txt{'250'}</a></center>
~;
	$yytitle = "$txt{'106'}";
	&template;
	exit;

}

</add before>

<edit file>
Sources/Post.pl
</edit file>

<search for>
	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }
</search for>

<add after>
	my($filetype_info, $filesize_info);
</add after>

<search for>
	my $extra;
</search for>

<replace>
	my $extra;
	my($filetype_info, $filesize_info, $extensions);
	$extensions = join(" ", @ext);
	$filetype_info = $checkext == 1 ? qq~$fatxt{'2'} $extensions~ : qq~$fatxt{'2'} $fatxt{'4'}~;
	$filesize_info = $limit != 0 ? qq~$fatxt{'3'} $limit KB~ : qq~$fatxt{'3'} $fatxt{'5'}~;
</replace>

<search for>
        </font><BR><BR></td>
      </tr>
</search for>

<replace>
        </font><BR></td>
      </tr>
~;
# File Attachment's Browse Box Code
if ($allowattach == 1 && ($action eq 'post' || $action eq 'post2') && (($allowguestattach == 0 && $username ne 'Guest') || $allowguestattach == 1)) {
$yymain .= qq~
<tr>
	<td valign="top"><font size=2><b>$fatxt{'6'}</b></font></td>
	<td><input type="file" name="file" size="49"></td>
</tr>
<tr>
	<td align="right"></td>
	<td><font size="1">$filetype_info<br>$filesize_info</font></td>
</tr>
~;
if( ($is_preview == 1) && $FORM{'file'} ) {
$yymain .= qq~
<tr>
	<td align="right"></td>
	<td><font size="1" color="#FF0000">$fatxt{'7'}</font></td>
</tr>
~;
}

}
# /File Attachment's Browse Box Code
$yymain .= qq~
</replace>

<search for>
<form action="$cgi;action=$destination" method="post" name="postmodify" onSubmit="return submitproc()">
</search for>

<replace>
<form action="$cgi;action=$destination" method="post" name="postmodify" ENCTYPE="multipart/form-data" onSubmit="return submitproc()">
</replace>

<search for>
sub Preview {
</search for>

<replace>
sub Preview {
	&clear_temp;
</replace>

<search for>
	# If no thread specified, this is a new thread.
</search for>

<add before>

######################################
## DaveB's File Attachment Mod v2.5 ##
######################################

if ($FORM{'file'}) {
if (!$FORM{'post'} && !$FORM{'postmodify'}) { &write_error("$fatxt{'49'}"); }
$mylimit = 1024 * $limit;
$mydirlimit = 1024 * $dirlimit;

$file = $filename;
$file =~ s/.+\\([^\\]+)$|.+\/([^\/]+)$/$1/;
$file =~ s/[#%+,\/:?"<>'|@^!]//g;	#edit in between [ ] to include characters you dont want to allow in filenames (dont put a . there or you wont be able to get any file extensions).
$file =~ s/ /_/g;			#replaces spaces in filenames with a "_" character.

opendir(AMD, $upload_dir) || &write_error("$fatxt{'19'} $upload_dir.");
@dirlist = readdir(AMD);
closedir(AMD);

foreach $dirlist(@dirlist)
   {
          if (lc $dirlist eq lc $file) { &write_error("$fatxt{'8'}"); last;} 

   }

if ($checkext == 0) { $match = 1; } else {
foreach $ext (@ext){
	chomp ($ext);
		if (grep /$ext$/i,$file){$match=1; last;}
	}
}
if ($match) {
	if ($allowattach == 1 && (($allowguestattach == 0 && $username ne 'Guest') || $allowguestattach == 1)) { 
		$upload_okay = 1;
	}
} else {
		&write_error("$fatxt{'20'} @ext"); 
	}

if ($mydirlimit > 0) {
	&dirstats;
}

$filesize = $ENV{'CONTENT_LENGTH'} - $postsize;
$filesizekb = int ($filesize/1024);
if ($filesize > $mylimit && $mylimit != 0) {
	$filesizediff = $filesizekb - $limit;
	if ($filesizediff == 1) { $sizevar = "kilobyte"; } else { $sizevar = "kilobytes"; }
	&write_error("$fatxt{'21'} $filesizediff $sizevar $fatxt{'21b'}");
} elsif ($filesize > $spaceleft && $mydirlimit != 0) {	
	$filesizediff = $filesizekb - $kbspaceleft;
	if ($filesizediff == 1) { $sizevar = "kilobyte"; } else { $sizevar = "kilobytes"; }
	&write_error("$fatxt{'22'} $filesizediff $sizevar $fatxt{'22b'}");
}

$write_file = "$upload_dir/$file";
$save_file = "$http_dir/$file"; 

}

#######################################
## /DaveB's File Attachment Mod v2.5 ##
#######################################		

</add before>

<search for>
		fopen(FILE, "+<$boardsdir/$currentboard.txt", 1) || &fatal_error("210 $txt{'106'}: $txt{'23'} $currentboard.txt");
</search for>

<replace>
		fopen(FILE, "+<$boardsdir/$currentboard.txt", 1) || &write_error("210 $txt{'106'}: $txt{'23'} $currentboard.txt");
</replace>

<search for>
		fopen(FILE, "+<$boardsdir/$currentboard.txt", 1) || &fatal_error("211 $txt{'106'}: $txt{'23'} $currentboard.txt");
</search for>

<replace>
		fopen(FILE, "+<$boardsdir/$currentboard.txt", 1) || &write_error("211 $txt{'106'}: $txt{'23'} $currentboard.txt");
</replace>

<search for>
		fopen(FILE, ">$datadir/$newthreadid.txt") || &fatal_error("$txt{'23'} $newthreadid.txt");
		print FILE qq~$subject|$name|$email|$date|$username|$icon|0|$user_ip|$message|$ns|\n~;
		fclose(FILE);
		$mreplies = 0;
</search for>

<replace>
		fopen(FILE, ">$datadir/$newthreadid.txt") || &write_error("$txt{'23'} $newthreadid.txt");
		print FILE qq~$subject|$name|$email|$date|$username|$icon|0|$user_ip|$message|$ns|||$save_file|$file\n~;
		fclose(FILE);
		$mreplies = 0;
		if ($file) {
		fopen(AMP, ">>$vardir/attachments.txt") || &write_error("209 $txt{'106'}: $txt{'23'} $vardir/attachments.txt");
		print AMP qq~$newthreadid|$mreplies|$subject|$name|$currentboard|$filesizekb|$date|$file\n~;
		fclose(AMP);
		}
</replace>

<search for>
		fopen(FILE, ">>$datadir/$threadid.txt") || &fatal_error("212 $txt{'106'}: $txt{'23'} $threadid.txt");
		print FILE qq~$subject|$name|$email|$date|$username|$icon|0|$user_ip|$message|$ns|\n~;
		fclose(FILE);
</search for>

<replace>
		fopen(FILE, ">>$datadir/$threadid.txt") || &write_error("212 $txt{'106'}: $txt{'23'} $threadid.txt");
		print FILE qq~$subject|$name|$email|$date|$username|$icon|0|$user_ip|$message|$ns|||$save_file|$file\n~;
		fclose(FILE);
		if ($file) {
		fopen(AMP, ">>$vardir/attachments.txt") || &write_error("209 $txt{'106'}: $txt{'23'} $vardir/attachments.txt");
		print AMP qq~$mnum|$mreplies|$subject|$name|$currentboard|$filesizekb|$date|$file\n~;
		fclose(AMP);
		}
</replace>

<search for>
	# Let's figure out what page number to show
</search for>

<add before>

######################################
## DaveB's File Attachment Mod v2.5 ##
######################################
if ($upload_okay == 1) {
	if($servertype == 0) {
		eval { use File::Copy; };
		unless($@) {
		close($filename);
		move("$tmpfile", "$write_file") || &write_error("Error renaming '$tmpfile' to '$write_file'!");
		} else { &fatal_error("File::Copy module either not present or producing errors. Please override by having the administrator select the web server type in the forum settings section."); }
	} elsif ($servertype == 1) {
		fopen(AMT, ">$write_file")||&write_error("$fatxt{'19'} $write_file. $!");
		binmode AMT;
		# binmode is for windows only. Ignored by unix
		while ($bytesread=read($filename,$buffer,1024)) { print AMT $buffer; }
		fclose(AMT);	
		chmod (0666, "$write_file");
		close($filename);
		1;
	} elsif ($servertype == 2) {
		close($filename);
		rename $tmpfile, $write_file || &write_error("Error renaming '$tmpfile' to '$write_file'!");
		1;
	}
&clear_temp;
}
#######################################
## /DaveB's File Attachment Mod v2.5 ##
#######################################

</add before>

<edit file>
Sources/ModifyMessage.pl
</edit file>

<search for>
sub ModifyMessage {
</search for>

<add after>
	my( $msf, $mfn);
</add after>

<search for>
	($sub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip,  $message, $mns, $mlm, $mlmb) = split(/\|/,$messages[$postid]);
</search for>

<replace>
	($sub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip,  $message, $mns, $mlm, $mlmb, $msf, $mfn) = split(/\|/,$messages[$postid]);
</replace>

<search for>
	my( $deletepost, $threadid, $postid, @messages, $msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage, $mns, $mlm, $mlmb, $tnum, $tsub, $tname, $temail, $tdate, $treplies, $tusername, $ticon, $tstate, @threads, $tmpa, $tmpb, $tnum2, $tdate2, $newlastposttime, $newlastposter, $lastpostid, $views, $name, $email, $subject, $message, $ns, $postkilled, $threadkilled );
</search for>

<replace>
	my( $deletepost, $threadid, $postid, @messages, $msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage, $mns, $mlm, $mlmb, $tnum, $tsub, $tname, $temail, $tdate, $treplies, $tusername, $ticon, $tstate, @threads, $tmpa, $tmpb, $tnum2, $tdate2, $newlastposttime, $newlastposter, $lastpostid, $views, $name, $email, $subject, $message, $ns, $postkilled, $threadkilled );
	my( $msf, $mfn );
</replace>

<search for>
		($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage, $mns, $mlm, $mlmb) = split( /\|/, $messages[$postid]);
</search for>

<replace>
		($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage, $mns, $mlm, $mlmb, $msf, $mfn) = split( /\|/, $messages[$postid]);
</replace>

<search for>
			$threadkilled = 1;
</search for>

<add after>
			fopen(FILE, "$datadir/$tnum.txt");
			my @amthreadcheck = <FILE>;
			fclose(FILE);
			chomp $amthreadcheck[0];
			($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage, $mns, $mlm, $mlmb, $msf, $mfn) = split( /\|/, $amthreadcheck[0] );	
				if(-e("$upload_dir/$mfn")) { 
				fopen(AMV, "$vardir/attachments.txt");
				my @attachments = <AMV>;
				fclose(AMV);
				fopen(AMV, ">$vardir/attachments.txt");
				foreach $row(@attachments) {
					chomp $row;
					my ($amthreadid, $amreplies, $amthreadsub, $amposter, $amcurrentboard, $amkb, $amdate, $amfn) = split(/\|/,$row);
					if($mfn ne $amfn) {
						print AMV qq~$amthreadid|$amreplies|$amthreadsub|$amposter|$amcurrentboard|$amkb|$amdate|$amfn\n~;
					}
				}
				fclose(AMV);
			unlink("$upload_dir/$mfn"); 
			}
</add after>

<search for>
			$messages[$postid] = '';
</search for>

<add before>
			($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage, $mns, $mlm, $mlmb, $msf, $mfn) = split( /\|/, $messages[$postid] );
				if(-e("$upload_dir/$mfn")) { 
				fopen(AMV, "$vardir/attachments.txt");
				my @attachments = <AMV>;
				fclose(AMV);
				fopen(AMV, ">$vardir/attachments.txt");
				foreach $row(@attachments) {
					chomp $row;
					my ($amthreadid, $amreplies, $amthreadsub, $amposter, $amcurrentboard, $amkb, $amdate, $amfn) = split(/\|/,$row);
					if($mfn ne $amfn) {
						print AMV qq~$amthreadid|$amreplies|$amthreadsub|$amposter|$amcurrentboard|$amkb|$amdate|$amfn\n~;
					}
				}
				fclose(AMV);
			unlink("$upload_dir/$mfn"); 
			}
</add before>

<search for>
				$_ = $messages[1];
				chomp;
				($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage, $mns, $mlm, $mlmb) = split( /\|/, $_ );
</search for>

<replace>
				$_ = $messages[1];
				chomp;
				($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage, $mns, $mlm, $mlmb, $msf, $mfn) = split( /\|/, $_ );
</replace>

<search for>
				$_ = $messages[$lastpostid];
				chomp;
				($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage, $mns, $mlm, $mlmb) = split( /\|/, $_ );
</search for>

<replace>
				$_ = $messages[$lastpostid];
				chomp;
				($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage, $mns, $mlm, $mlmb, $msf, $mfn) = split( /\|/, $_ );
</replace>

<search for>
		$messages[$postid] = qq~$subject|$mname|$memail|$mdate|$musername|$icon|0|$useredit_ip|$message|$ns|$date|$username\n~;
</search for>

<replace>
		$messages[$postid] = qq~$subject|$mname|$memail|$mdate|$musername|$icon|0|$useredit_ip|$message|$ns|$date|$username|$msf|$mfn\n~;
</replace>

<edit file>
Sources/MoveThread.pl
</edit file>

<search for>
	$movedpost = join("|", @movedthread);
</search for>

<add before>
	if ($movedthread[12] ne "") {
		#fix attachment info
		fopen(AMP, "$vardir/attachments.txt") || &write_error("209 $txt{'106'}: $txt{'23'} $vardir/attachments.txt");
		my @attachinfo = <AMP>;
		fclose(AMP);
		foreach (@attachinfo) {
			$row = $_;
			chomp $row;
			my ($amthreadid, $amreplies, $amthreadsub, $amposter, $amcurrentboard, $amkb, $amdate, $amfn) = split(/\|/,$row);
			if ($amfn eq $movedthread[13]) { 
				$_ = qq~$newthreadid|$amreplies|$amthreadsub|$amposter|$toboard|$amkb|$amdate|$amfn\n~;
				last;
			}
		}
		fopen(AMP, ">$vardir/attachments.txt") || &write_error("209 $txt{'106'}: $txt{'23'} $vardir/attachments.txt");
		print AMP @attachinfo;
		fclose(AMP);

		#remove attachment from old post
		$movedthread[12] = "";
		$movedthread[13] = "";
	}
</add before>

<edit file>
Sources/ManageBoards.pl
</edit file>

<search for>
		unlink("$boardsdir/$curboard.ctb");
</search for>

<add after>
		fopen(AMV, "$vardir/attachments.txt");
		my @attachments = <AMV>;
		fclose(AMV);
		fopen(AMV, ">$vardir/attachments.txt");
			foreach $row(@attachments) {
			chomp $row;
			my ($amthreadid, $amreplies, $amthreadsub, $amposter, $amcurrentboard, $amkb, $amdate, $amfn) = split(/\|/,$row);
			if($amcurrentboard ne $curboard) {
				print AMV qq~$amthreadid|$amreplies|$amthreadsub|$amposter|$amcurrentboard|$amkb|$amdate|$amfn\n~;
			} else {
				if (-e("$upload_dir/$amfn")) {
					unlink("$upload_dir/$amfn");
				}
			}
		}
		fclose(AMV);
</add after>

<edit file>
Sources/ManageCats.pl
</edit file>

<search for>
			unlink("$boardsdir/$curboard.dat");
</search for>

<add after>
			fopen(AMV, "$vardir/attachments.txt");
			my @attachments = <AMV>;
			fclose(AMV);
			fopen(AMV, ">$vardir/attachments.txt");
				foreach $row(@attachments) {
				chomp $row;
				my ($amthreadid, $amreplies, $amthreadsub, $amposter, $amcurrentboard, $amkb, $amdate, $amfn) = split(/\|/,$row);
				if($amcurrentboard ne $curboard) {
					print AMV qq~$amthreadid|$amreplies|$amthreadsub|$amposter|$amcurrentboard|$amkb|$amdate|$amfn\n~;
				} else {
					if (-e("$upload_dir/$amfn")) {
						unlink("$upload_dir/$amfn");
					}
				}
			}
			fclose(AMV);
</add after>

<edit file>
Sources/RemoveOldThreads.pl
</edit file>

<search for>
					unlink("$datadir/$num.data");
</search for>

<add after>
					fopen(AMV, "$vardir/attachments.txt");
					my @attachments = <AMV>;
					fclose(AMV);
					fopen(AMV, ">$vardir/attachments.txt");
						foreach $row(@attachments) {
						chomp $row;
						my ($amthreadid, $amreplies, $amthreadsub, $amposter, $amcurrentboard, $amkb, $amdate, $amfn) = split(/\|/,$row);
						if($amthreadid ne $num) {
							print AMV qq~$amthreadid|$amreplies|$amthreadsub|$amposter|$amcurrentboard|$amkb|$amdate|$amfn\n~;
						} else {
							if (-e("$upload_dir/$amfn")) {
								unlink("$upload_dir/$amfn");
							}
						}
						
					}
					fclose(AMV);
</add after>

<edit file>
Sources/RemoveThread.pl
</edit file>

<search for>
	unlink("$datadir/$thread.data");
</search for>

<add after>
	fopen(AMV, "$vardir/attachments.txt");
	my @attachments = <AMV>;
	fclose(AMV);
	fopen(AMV, ">$vardir/attachments.txt");
	foreach $row(@attachments) {
		chomp $row;
		my ($amthreadid, $amreplies, $amthreadsub, $amposter, $amcurrentboard, $amkb, $amdate, $amfn) = split(/\|/,$row);
		if($amthreadid ne $thread) {
			print AMV qq~$amthreadid|$amreplies|$amthreadsub|$amposter|$amcurrentboard|$amkb|$amdate|$amfn\n~;
		} else {
			if (-e("$upload_dir/$amfn")) {
				unlink("$upload_dir/$amfn");
			}
		}
	}
	fclose(AMV);
</add after>

<edit file>
Sources/Admin.pl
</edit file>

<search for>
        <td bgcolor="$color{'catbg'}" height="19" class="catbg"><img src="$imagesdir/board.gif" alt="" border="0"> <font size="2"><b>$txt{'501'}</b></font></td>
      </tr><tr>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2"><font size="1">
</search for>

<add after>
        - <a href="$cgi;action=manageattachments">$fatxt{'9'}</a><br>
</add after>

<edit file>
Sources/AdminEdit.pl
</edit file>

<search for>
sub ModifySettings {
</search for>

<add before>
## /START section added in File Attachments v2.4 to auto-config paths needed for mod
sub AttachDir {
	&is_admin;
	my $findme = 'attachments'; # Set this equal to the name of your attachments directory.
	if((-d $_) && ($_ eq "$findme")) {
		$upload_dir = "$File::Find::dir/$_";
	}
}
## /END File Attachment auto-config paths section

</add before>

<search for>
	my($snfchecked, $fls1, $fls2, $fls3, $utfchecked, $truncchecked, $mts1, $mts2, $mts3, $tsl6, $tsl5, $tsl4, $tsl3, $tsl2, $tsl1);
</search for>

<add after>
	my($checkextcheck, $extlist, $extitem, $amdisplaypicscheck, $allowattachcheck, $allowguestattachcheck, $st0, $st1, $st2, $tmpax0, $tmpax1);

## /START section added in File Attachments v2.4 to auto-config paths needed for mod
	if ((!$upload_dir || !$http_dir) && $ENV{'DOCUMENT_ROOT'} && $INFO{'famod'} ne "autoconfig") {
		$attachment_status = qq~
		  </tr><tr>
		    <td class="windowbg2" bgcolor="$color{'windowbg2'}" colspan="2" align="center"><a href="$cgi;action=modsettings;famod=autoconfig"><font size="2">Click to attempt to auto-configure mod</font></a></td>
		  ~;
	}
		
	if(!$upload_dir && $ENV{'DOCUMENT_ROOT'} && $INFO{'famod'} eq "autoconfig") {
		my $toplevel = "$ENV{'DOCUMENT_ROOT'}";
		if($http_dir) {
			my $upload_dir_temp = $http_dir;
			$upload_dir_temp =~ s~http://[\w|\.]+/?(\S*)~$1~is;
			$upload_dir = "$toplevel/$upload_dir_temp";
			$attachment_status = qq~
				  </tr><tr>
				    <td class="windowbg2" bgcolor="$color{'windowbg2'}" colspan="2" align="center"><font size="2"><script language="javascript">alert("Attachments directory set to: $upload_dir.\\nPlease save your settings.");</script></font></td>
				  ~;			
		} else {
			eval { use File::Find; };
			unless($@) {
				&find(\&AttachDir, $toplevel);
				if($upload_dir && !$http_dir) {
					my $http_dir_temp = $boardurl;
					$http_dir_temp =~ s~(http://[\w|\.]+)/?.*~$1~is;
					my $http_dir_temp2 = $upload_dir;
					$http_dir_temp2 =~ s~$toplevel/?(\S*)~$1~is;
					$http_dir = "$http_dir_temp/$http_dir_temp2";
					$attachment_status = qq~
						  </tr><tr>
						    <td class="windowbg2" bgcolor="$color{'windowbg2'}" colspan="2" align="center"><font size="2"><script language="javascript">alert("Attachments directory set to: $upload_dir.\\nAttachments URL set to: $http_dir.\\nPlease save your settings.");</script></font></td>
						  ~;			
				}
				if(!$upload_dir && (-e "$toplevel/yabbattach")) {
					$upload_dir = "$toplevel/yabbattach";
					my $http_dir_temp = $boardurl;
					$http_dir_temp =~ s~(http://[\w|\.]+)/?.*~$1~is;
					$http_dir = "$http_dir_temp/yabbattach";
					$attachment_status = qq~
						  </tr><tr>
						    <td class="windowbg2" bgcolor="$color{'windowbg2'}" colspan="2" align="center"><font size="2"><script language="javascript">alert("Attachments directory set to: $upload_dir.\\nAttachments URL found: $http_dir.\\nPlease save your settings.");</script></font></td>
						  ~;	
				} elsif(!$upload_dir && (!-e "$toplevel/yabbattach")) { 
					mkdir("$toplevel/yabbattach", 0766) || &fatal_error("Could not create $toplevel/yabbattach for attachments directory.");
					my $http_dir_temp = $boardurl;
					$http_dir_temp =~ s~(http://[\w|\.]+)/?.*~$1~is;
					$http_dir = "$http_dir_temp/yabbattach";		
					$upload_dir = "$toplevel/yabbattach";
					$attachment_status = qq~
						  </tr><tr>
						    <td class="windowbg2" bgcolor="$color{'windowbg2'}" colspan="2" align="center"><font size="2"><script language="javascript">alert("Attachments directory created and set to: $upload_dir.\\nAttachments URL set to: $http_dir.\\nPlease save your settings.");</script></font></td>
						  ~;
				}
			}
		}
	}
	if(!$http_dir && $ENV{'DOCUMENT_ROOT'} && $upload_dir && $INFO{'famod'} eq "autoconfig") {
		my $toplevel = "$ENV{'DOCUMENT_ROOT'}";
		my $http_dir_temp = $boardurl;
		$http_dir_temp =~ s~(http://[\w|\.]+)/?.*~$1~is;
		my $http_dir_temp2 = $upload_dir;
		$http_dir_temp2 =~ s~$toplevel/?(\.*)~$1~is;
		$http_dir = "$http_dir_temp/$http_dir_temp2";
		$attachment_status = qq~
			  </tr><tr>
			    <td class="windowbg2" bgcolor="$color{'windowbg2'}" colspan="2" align="center"><font size="2"><script language="javascript">alert("Attachments URL set to: $http_dir.\\nPlease save your settings.");</script></font></td>
			  ~;
	}

## /END File Attachment auto-config paths section
</add after>

<search for>
	# figure out what to print
</search for>

<add after>
	$extlist = join(" ", @ext);
	$extlist =~ s~\s+$~~;
	$extlist =~ s~^\s+~~;
	if ($checkext == 1) { $checkextcheck = ' checked'; }
	if ($amdisplaypics == 1) { $amdisplaypicscheck = ' checked'; }
	if ($allowattach == 1) { $allowattachcheck = ' checked'; }
	if ($allowguestattach == 1) { $allowguestattachcheck = ' checked'; }
</add after>

<search for>
	if ($timeselected == 6) { $tsl6 = " selected" } elsif ($timeselected == 5) { $tsl5 = " selected" } elsif ($timeselected == 4) { $tsl4 = " selected" } elsif ($timeselected == 3) { $tsl3 = " selected" } elsif ($timeselected == 2) { $tsl2 = " selected" } else { $tsl1 = " selected" }
</search for>

<add after>
	if ($servertype == 0) { $st0 = " selected"; } elsif ($servertype == 1) { $st1 = " selected"; } elsif ($servertype == 2) { $st2 = " selected"; }
	if ($tempaccess == 0) { $tmpax0 = " selected"; } elsif ($tempaccess == 1) { $tmpax1 = " selected"; }
</add after>

<search for>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$txt{'392'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="LOCK_EX" size="5" value="$LOCK_EX"></td>
</search for>

<add before>
  $attachment_status
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$fatxt{'10'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="upload_dir" size="35" value="$upload_dir"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$fatxt{'11'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="http_dir" size="35" value="$http_dir"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$fatxt{'47'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}">
    <select name="servertype" size=1>
    <option value="0"$st0>Standard
    <option value="1"$st1>Unix/Linux
    <option value="2"$st2>Windows
    </select>
    </td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">Temp File Permission Settings</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}">
    <select name="tempaccess" size=1>
    <option value="0"$tmpax0>Standard
    <option value="1"$tmpax1>User Override
    </select>
    </td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$fatxt{'12'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="limit" size="5" value="$limit"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$fatxt{'13'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="dirlimit" size="5" value="$dirlimit"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$fatxt{'14'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="extensions" size="35" value="$extlist"></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$fatxt{'15'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="checkext" value="1"$checkextcheck></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$fatxt{'16'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="amdisplaypics" value="1"$amdisplaypicscheck></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$fatxt{'17'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="allowattach" value="1"$allowattachcheck></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$fatxt{'18'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="allowguestattach" value="1"$allowguestattachcheck></td>
  </tr><tr><!-- AMOD -->
    <td colspan=2 class="windowbg2" bgcolor="$color{'windowbg2'}">
    <HR size=1 width="100%" color="$color{'windowbg3'}" class="windowbg3"></td>
</add before>

<search for>
	# If empty fields are submitted, set them to default-values to save yabb from crashing
</search for>

<add after>
	$upload_dir = $FORM{'upload_dir'};
	$upload_dir =~ s~\s+$~~;
	$http_dir = $FORM{'http_dir'};
	$http_dir =~ s~\s+$~~;
	$servertype = $FORM{'servertype'} || 0;
	$tempaccess = $FORM{'tempaccess'} || 0;
	$extensions = $FORM{'extensions'};
	$extensions =~ s~\s+$~~;
	$limit = $FORM{'limit'} || 0;
	$dirlimit = $FORM{'dirlimit'} || 0;
	$checkext = $FORM{'checkext'} || 0;
	$amdisplaypics = $FORM{'amdisplaypics'} || 0;
	$allowattach = $FORM{'allowattach'} || 0;
	$allowguestattach = $FORM{'allowguestattach'} || 0;
</add after>

<search for>
########## Feature Settings ##########
</search for>

<replace>
########## File Attachment Settings ##########

\$limit = $limit;  					# Set to the maximum number of kilobytes an attachment can be. Set to 0 to disable the file size check.
\$dirlimit = $dirlimit;  				# Set to the maximum number of kilobytes the attachment directory can hold. Set to 0 to disable the directory size check.
\$upload_dir = '$upload_dir';  				# The absolute path to the directory where your attachments are to be stored (without trailing '/' )
\$tempaccess = $tempaccess;
if (\$tempaccess == 1) {
\$TempFile::TMPDIRECTORY = '$upload_dir';		# Puts temporary files used into same folder as attachments to prevent permission problems
}
\$http_dir = '$http_dir';  				# The full url to the directory where your attachments are to be stored (without trailing '/' )
\$servertype = $servertype;				# Set to 0 for Standard cross-platform uploading. If you experience problems, set to 1 if you are running your YaBB on a Unix/Linux webhost, set to 2 if you are running on Windows.
\@ext = qw($extensions);  				# The allowed file extensions for file attachements. Variable should be set in the form of "jpg bmp gif" and so on.
\$checkext = $checkext;  				# Set to 1 to enable file extension checking, set to 0 to allow all file types to be uploaded
\$amdisplaypics = $amdisplaypics;  			# Set to 1 to display attached pictures in posts, set to 0 to only show a link to them.
\$allowattach = $allowattach;				# Set to 1 to allow file attaching, set to 0 to disable file attaching.
\$allowguestattach = $allowguestattach;			# Set to 1 to allow guests to upload attachments, 0 to disable guest attachment uploading.

########## Feature Settings ##########
</replace>