###############################################################################
# Karma.pl - YaBB Mod by Joseph Fung (Joseph@ComESutra.ORg)                   #
# Sp1 version by Matthew Throesch (mthroesch@hotmail.com		      #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Project started by Zef Hemel (zef@zefnet.com)                   #
# Software Version: YaBB Sp1	                                              #
###############################################################################
sub getKarma {
  $sourceUser = shift;
  @karma = &getKarmaData($sourceUser);
  $karma[0] =~ s/[\n\r]//g;
  return $karma[0];
}

sub setKarma {
  $sourceUser = shift;
  $newKarmaValue = shift;
  @karma = &getKarmaData($sourceUser);
  $karma[0] = "$newKarmaValue\n";
  open(FILE, ">$memberdir/$sourceUser.karma");
  foreach $line (@karma){ print FILE "$line"; }
  close(FILE);
}

sub isInMemberGroup {
  my ($inMemberGroup) = 0;
  if ($karmaAllowedMemberGroups eq ''){ $inMemberGroup = 1; }
  my (@karmaGroups) = split(/,/, $karmaAllowedMemberGroups);
  foreach $karmaGroup (@karmaGroups){
    if ($settings[7] eq $karmaGroup) { $inMemberGroup = 1; }
  }
  return $inMemberGroup;
}

sub modifyKarma{
  if ($username eq "Guest"){ &fatal_error("Only registered members can modify karma."); }

  if ($settings[6] < $karmaMinPosts) { &fatal_error("You need $karmaMinPosts posts before you can modify someone\'s karma."); }

  $sourceUserID = $INFO{'username'};
  if ($sourceUserID eq $username) { &fatal_error("You can not modify your own karma."); }

  my($inMemberGroup) = &isInMemberGroup;
  if ($inMemberGroup == 0){ &fatal_error("You are not permitted to modify karma."); }

  $desiredAction = $INFO{'karmaAction'};
  @thekarma = &getKarmaData($username);
  $modifiedEntry = -1;
  $newTimestamp = time;
  for ($i = 1; $i < scalar @thekarma; $i++){
    ($targetUser, $targetAction, $timestamp) = split (/\|/, $thekarma[$i]);
    if ($targetUser eq $sourceUserID){
      $modifiedEntry = $i;
      $timestamp =~ s/[\n\r]//g;
      if (($newTimestamp-$timestamp) < $waitTime){
        if ($desiredAction eq $targetAction && (($settings[7] ne 'Administrator') || $settings[7] eq 'Administrator' && $restrictAdmin == 1)){
          &fatal_error("You cannot make the same modification to the karma of a user that often.");
        }else {
          $newKarma = &getKarma ($sourceUserID);
          if ($settings[7] ne 'Administrator'){
            if ($desiredAction eq "smite"){ $newKarma = $newKarma -2; }
            elsif ($desiredAction eq "applaud"){ $newKarma = $newKarma +2; }
          } else {
            if ($desiredAction eq "smite"){ $newKarma = $newKarma -1; }
            elsif ($desiredAction eq "applaud"){ $newKarma = $newKarma +1; }
          }
	  &setKarma ($sourceUserID, $newKarma);
        }   
      }else {
        $newKarma = &getKarma ($sourceUserID);
        if ($desiredAction eq "smite"){ $newKarma = $newKarma -1; }
        elsif ($desiredAction eq "applaud"){ $newKarma = $newKarma +1; }
	&setKarma ($sourceUserID, $newKarma);
      }
    }
  }
  if ($modifiedEntry == -1){
    $modifiedEntry = scalar @thekarma;
    $newKarma = &getKarma ($sourceUserID);
    if ($desiredAction eq "smite"){
      $newKarma = $newKarma -1;
    } elsif ($desiredAction eq "applaud"){
        $newKarma = $newKarma+ 1;
    }
    &setKarma ($sourceUserID, $newKarma);
  }
  @thekarma[$modifiedEntry] = "$sourceUserID|$desiredAction|$newTimestamp\n";
  open(FILE, ">$memberdir/$username.karma");
  foreach $line (@thekarma){ print FILE $line; }
  close(FILE);
  &yabb_alert ("You have successfully modified the user's karma.<br>To see the modified karma, click refresh after you click back.");
}

sub getKarmaData {
  $sourceUser = shift;
  if(-e("$memberdir/$sourceUser.karma")){
    open(FILE, "$memberdir/$sourceUser.karma");
    @karma = <FILE>;
    close(FILE);
  }else {
    @karma = ("0\n");
  }
  return @karma;
}
1;