<id>
Minify CSS for YaBB 2.5/2.5.2
</id>

<version>
0.1
</version>

<mod info>
Description
-----------
This Mod will allow you to minify the CSS file for any given template from Template Configuration.

Installation
------------
1) Modify YaBB files using BoardMod or manually.
2) Upload modified files to your server in ASCII mode.
3) Upload the 'CSS' folder to the 'yabb2/Modules/' directory in ASCII mode.
4) Go to Admin Center - Forum Layout - Template Configuration to minify your CSS.

Files to edit
-------------
Admin/ModList.pl
Admin/ManageTemplates.pl
Languages/English/Templates.lng

Version History
---------------
V0.1 - First release - 20th December 2012
</mod info>

<author>
Derek Barnstorm
</author>

<homepage>
http://www.boardmod.org
</homepage>

<edit file>
Admin/ModList.pl
</edit file>

<search for>
### END BOARDMOD ANCHOR ###
</search for>

<add before>
	$minifycss_mod = "Minify CSS|Derek Barnstorm|This Mod will allow you to minify CSS the file for any given template from Template Configuration.|0.1|20th December 2012";
	push (@installed_mods, "$minifycss_mod");
	
</add before>

<edit file>
Admin/ManageTemplates.pl
</edit file>

<search for>
	($aktstyle, $aktimages, $akthead, $aktboard, $aktmessage, $aktdisplay, $aktmycenter, $aktmenutype) = split(/\|/, $templateset{$akttemplate});
</search for>

<replace>
	($aktstyle, $aktimages, $akthead, $aktboard, $aktmessage, $aktdisplay, $aktmycenter, $aktmenutype, $aktminifycss) = split(/\|/, $templateset{$akttemplate});
    if ($aktminifycss) { $aktstyle =~ s/_min$//; }
</replace>

<search for>
		if ($ext eq 'css') {
			if ($file eq $cssfile) { $selected = qq~ selected="selected"~; $viewcss = $name; }
			$forumcss .= qq~<option value="$file"$selected>$name</option>\n~;
		}
		if (-d "$forumstylesdir/$file" && $file =~ m^\A[0-9a-zA-Z_\#\%\-\:\+\?\$\&\~\,\@/]+\Z^) {
</search for>

<replace>
		if ($ext eq 'css' && $name !~ /_min$/) {
			if ($file eq $cssfile) { $selected = qq~ selected="selected"~; $viewcss = $name; }
			$forumcss .= qq~<option value="$file"$selected>$name</option>\n~;
		}
		if (-d "$forumstylesdir/$file" && $file =~ m^\A[0-9a-zA-Z_\#\%\-\:\+\?\$\&\~\,\@/]+\Z^) {
</replace>

<search for>
	require "$vardir/Menu$UseMenuType.def";
</search for>

<add after>

	if ($aktminifycss == 1) { $chk_minifycss = q~ checked="checked"~; }
	else { $chk_minifycss = "" }
</add after>

<search for>
				$mycentertemplates
				</select>
			</div>
</search for>

<add after>
			<div style="float: left; width: 32%; text-align: left; margin-top: 15px;">
				<input type="checkbox" name="minifycss" id="minifycss" value="1" style="vertical-align: middle;"$chk_minifycss /><label for="minifycss" class="small">$templ_txt{'minifycss'}</label>
			</div>
</add after>

<search for>
		($template_css, undef, undef) = split(/\./, $FORM{'cssfile'});
</search for>

<add after>
		if ($FORM{'minifycss'}) {
		    use CSS::Minifier qw(minify);
		    &timetostring($date);
		    $css_in = "$forumstylesdir/$template_css" . ".css";
		    $css_out = "$forumstylesdir/$template_css" . "_min.css";
            fopen(CSSIN, "$css_in") || &admin_fatal_error("cannot_open","$css_in", 1);
            fopen(CSSOUT, ">$css_out") || &admin_fatal_error("cannot_open","$css_out", 1);
            minify(input => *CSSIN, outfile => *CSSOUT, copyright => "YaBB $year - Created by: YaBB http://www.yabbforum.com");
            fclose(CSSIN);
            fclose(CSSOUT);
        }
		$template_minifycss = $FORM{'minifycss'};
</add after>

<search for>
		$templateset{"$tempelement"} = "$template_css";
</search for>

<replace>
	    if ($template_minifycss) { $templateset{"$tempelement"} = "$template_css" . "_min"; }
		else { $templateset{"$tempelement"} = "$template_css"; }
</replace>

<search for>
		$templateset{"$tempelement"} .= "|$template_menutype";
</search for>

<add after>
		$templateset{"$tempelement"} .= "|$template_minifycss";
</add after>

<edit file>
Languages/English/Templates.lng
</edit file>

<search for>
);

1;
</search for>

<add before>
'minifycss' => 'Minify CSS',
</add before>


