###############################################################################
# News.pl - v1.3                                                              #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 1 Gold - SP 1.1/1.2/1.3                                #
# Released:       December 2001; Updated April 6, 2003                        #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2003 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
###############################################################################
# This file is part of the News Script Mod which has been created by          #
# Michael Prager. Last modification: 08.09.03                                 #
###############################################################################
# available parameters for "news" action:                                     #
# ---------------------------------------                                     #
# board     - board id of the board which contains the news                   #
# cat       - category id, if you want all threads of a category to be news   #
# type      - either "java", "frame" or empty. Defines the type of output     #
# bgcolor   - bgcolor of iframe (only used if type=frame)                     #
# textcolor - textcolor of iframe (only used if type=frame)                   #
# linkcolor - linkcolor of iframe (only used if type=frame)                   #
###############################################################################

## Settings:
$display = 10;			# number of news to display
$sort_news_by_last_comment = 0; # if set to 1, news will be sorted by last comment, not by creation time
$max_number_of_words = 500;	# set to 0 to disable cut-off of long messages
$only_first_paragraph = 0;	# if set to 1, only the first paragraph will be displayed. Set to 0 to disable (note: this will disable $max_number_of_words)
$link_target = "_blank";	# if set to "_blank", all links will open in a new window. Leave empty to let links open in the current window
$show_older_news_link = 1;	# set to 1 to display a link to the news board at the bottom, 0 to disable
$older_news_link = qq~<center><a href="$scripturl?board=$currentboard" target="$link_target"><b>Older News</b></a></center>~;

## Language Definitions:
$lang_news{'comment'} = "Comment";
$lang_news{'comments'} = "Comments";
$lang_news{'more'} = "read more";
$lang_news{'cat_not_found'} = "Category not found";
$lang_news{'no_threads'} = qq~<hr><b>There are no threads in this board</b><hr>~;
$lang_news{'invalid'} = "Invalid argument set";

## NO NEED TO CHANGE ANYTHING BELOW ###########################################

sub ShowNews {
	my ($curboard, $currcat, @threads, $i, $tnum, $tsub, $tname, $temail, $tdate, $treplies, $tusername, $ticon, $tstate, $messages, $msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mns, $mtime, $news_template, $board, $tnum, $c, $tmpa, $tmpb, @words, $comment, $message_data, $views, $lastposter, $size, $bname, $userpic, $userpic_url, @news, $curline, $template, @boards, @boarddata, $curboardname) = ($currentboard);

	if ($INFO{'cat'}) {
		if ($INFO{'cat'} =~ /^[A-Za-z0-9_-]+$/ig && -e "$boardsdir/$INFO{'cat'}.cat") {
			$currcat = $INFO{'cat'};
		} else {
			&fatal_error($lang_news{'cat_not_found'});
		}
		fopen(CATEGORY, "$boardsdir/$currcat.cat") || &fatal_error($lang_news{'cat_not_found'});
		@boards = <CATEGORY>;
		fclose(CATEGORY);
		chomp @boards; shift @boards; shift @boards;
	} else {
		$currcat = &BoardCatGet($curboard);
		unless ($currcat) { &fatal_error($lang_news{'cat_not_found'}); }
		@boards = $curboard;
	}

	foreach $curboard (@boards) {
		unless (&BoardAccessGet($curboard)) { &fatal_error($txt{'1'}); }

		chomp $curboard;

		# get board name		
		fopen(FILE, "$boardsdir/$curboard.dat");
		@boarddata = <FILE>;
		fclose(FILE);
		$curboardname = @boarddata[0]; chomp $curboardname;

		# get thread list
		fopen(FILE, "$boardsdir/$curboard.txt");
		@threads = <FILE>;
		fclose(FILE);
		chomp @threads;

		# prepare array containing all necessary thread data
		for ($i = 0; $i < @threads; $i++) {
			($tnum, $tsub, $tname, $temail, $tdate, $treplies, $tusername, $ticon, $tstate) = split( /\|/, $threads[$i] );
			fopen(FILE, "$datadir/$tnum.txt") || next;
			@messages = <FILE>;
			fclose(FILE);

			$message = $messages[0];
			chomp $message;

			if ($message) {
				($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $message, $mns) = split(/\|/,$message);
				$mtime = $sort_news_by_last_comment == 0 ? stringtotime($mdate) : stringtotime($tdate);
				$data{$mtime} = [$curboard, $curboardname, $tnum, $treplies, $tusername, $tname, $msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $message, $mns, $treplies];
			}
		}
	}

	@messages = sort {$b <=> $a} keys %data;

	print "Content-type: text/html\n\n";

	# print html header for Iframe
	if ($INFO{'type'} eq "frame") {
		if ($INFO{'bgcolor'} !~ /^[A-F0-9]*$/isg || $INFO{'textcolor'} !~ /^[A-F0-9]*$/isg || $INFO{'linkcolor'} !~ /^[A-F0-9]*$/isg) { &fatal_error($lang_news{'invalid'}); }
		print qq~<html>\n<body bgcolor="#~.$INFO{'bgcolor'}.qq~" text="#~.$INFO{'textcolor'}.qq~" link="#~.$INFO{'linkcolor'}.qq~">\n~;
	}

	if (@messages) {
		# reduce among of threads if we have too many
		if (@messages > $display) {
			$#messages = $display - 1;
		}

		# Load Censor List
		&LoadCensorList;

		# load template
		if ($INFO{'template'} =~ /^([A-Za-z0-9_-]+)\.html$/ig && lc($INFO{'template'}) ne "template.html") {
			$template = "$1.html";
		} else {
			$template = "news_template.html";
		}
		fopen(TEMPLATE,$template) || &fatal_error("$txt{'23'}: $template");
		@news_template = <TEMPLATE>;
		fclose(TEMPLATE);

		# process each thread
		for ($i = 0; $i < @messages; $i++) {
			($board, $bname, $tnum, $c, $tusername, $tname, $msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $message, $mns, $treplies) = @{$data{$messages[$i]}};

			# apply censoring
			foreach (@censored) {
				($tmpa,$tmpb) = @{$_};
				$message =~ s~\Q$tmpa\E~$tmpb~gi;
				$msub =~ s~\Q$tmpa\E~$tmpb~gi;
			}

			$size = length($message);
			if ($only_first_paragraph != 0 && $message =~ m/<br>/is) {
				@words = split(/<br>/,$message);
				$message = $words[0] . qq~ ... <a href="$scripturl?board=$board;action=display;num=$tnum" target="$link_target">$lang_news{'more'}</a>~;
			} elsif ($max_number_of_words != 0) {
				@words = split(/\s/,$message);
				if (@words > $max_number_of_words) {
					$message = "";
					for ($j = 0; $j < $max_number_of_words; $j++) {
						$message .= $words[$j] . " ";
					}
					$message .= qq~... <a href="$scripturl?board=$board;action=display;num=$tnum" target="$link_target">$lang_news{'more'}</a>~;
				}
			}

			if ($enable_ubbc) {
				$displayname = $tname;
				require "$sourcedir/YaBBC.pl";
				&DoUBBC;
			}

			$comment = $treplies == 1 ? $lang_news{'comment'} : $lang_news{'comments'};

			fopen(FILE, "$datadir/$tnum.data");
			$message_data = <FILE>;
			fclose(FILE);
			chomp $message_data;
			($views, $lastposter) = split(/\|/,$message_data);
			if ($treplies > 0) {
				if( $lastposter =~ m~\AGuest-(.*)~ ) {
					$lastposter = $1;
				} else {
					fopen(FILE, "$memberdir/$lastposter.dat");
					@lastposter_data = <FILE>;
					fclose(FILE);
					chomp @lastposter_data;
					$lastposter = $lastposter_data[1];
				}
			} else {
				$lastposter = "";
			}

			if ($tusername ne 'Guest' && &LoadUser($tusername)) {
				$userprofile{$tusername}->[13] ||= 'blank.gif';
				$userpic_url = $userprofile{$tusername}->[13] =~ m~\A[\s\n]*http://~i ? $userprofile{$tusername}->[13] : qq~$facesurl/~.$userprofile{$tusername}->[13];
				$userpic = qq~<img src="$userpic_url" border="0">~;
			}

			$news{'date'} = &timeformat($mdate);
			$news{'title'} = $msub;
			$news{'author'} = $tname;
			$news{'message'} = $message;
			$news{'icon'} = qq~<img src="$imagesdir/$micon.gif">~;
			$news{'icon_src'} = qq~$imagesdir/$micon.gif~;
			$news{'comments_text'} = "$treplies $comment";
			$news{'replies'} = $treplies;
			$news{'viewcomments_url'} = qq~$scripturl?board=$board;action=display;num=$tnum;start=$c~;
			$news{'writecomment_url'} = qq~$scripturl?board=$board;action=post;num=$tnum;start=$c;title=Post+reply~;
			$news{'views'} = $views;
			$news{'lastposter'} = $lastposter;
			$news{'size'} = $size;
			$news{'boardname'} = $bname;
			$news{'userpic'} = $userpic;
			$news{'userpic_src'} = $userpic_url;
			$news{'link_target'} = $link_target;
			$news{'send_topic_url'} = qq~$cgi;action=sendtopic;topic=$tnum~;

			for ($j = 0; $j < @news_template; $j++ ) {
				$curline = $news_template[$j];
				$curline =~ s~<yabb\s+(\w+)>~$news{$1}~g;
				PrintNews($curline);
			}
		}
		if ($show_older_news_link) {
			PrintNews($older_news_link);
		}
	}
	else {
		PrintNews($lang_news{'no_threads'});
	}

	if ($INFO{'type'} eq "frame") { print qq~\n</body>\n</html>~; }

	exit;
}

sub PrintNews {
	my $string = shift;
	if ($INFO{'type'} eq "java") {
		$string =~ s~\'~\\\'~g;
		$string =~ s~\n~\\n~g;
		print "document.write('$string');\n";
	} else {
		print $string;
	}
}

1;
