#!/usr/local/bin/perl -w  

################################################################
# paypal.pl 
#
# Perl Toolkit for PayPal v.0.50
# http://www.paypal.com/pdn
#
# Copyright (c) 2004 PayPal Inc
#
# Released under Common Public License 1.0 
# http://opensource.org/licenses/cpl.php
################################################################

use strict;
use paypalLib;

my(%paypal,%form); 
%form = &paypalLib::get_submission;




## BEGIN CUSTOM CONFIGURATION HERE 

##Configuration Settings

$paypal{business}="$form{business}";
$paypal{site_url}='http://yourURL.com';
$paypal{image_url}='';
$paypal{success_url}='/success.pl';
$paypal{cancel_url}='/error.pl';
$paypal{notify_url}='/ipn/ipn.pl';
$paypal{return_method}='2'; ##1=GET 2=POST
$paypal{currency_code}='USD'; ##{USD,GBP,JPY,CAD,EUR}
$paypal{lc}='US';


$paypal{url}='https://www.paypal.com/cgi-bin/webscr';
#$paypal{url}='https://www.sandbox.paypal.com/cgi-bin/webscr';


$paypal{bn}='toolkit-perl';
$paypal{cmd}='_xclick';

##Payment Page Settings
$paypal{display_comment}='0'; ##0=yes 1=no
$paypal{comment_header}='Comments';
$paypal{continue_button_text}='Continue >>';
$paypal{background_color}=''; ## ""=white 1=black
$paypal{display_shipping_address}=''; ## ""=yes 1=no
$paypal{display_comment}='1'; ## ""=yes 1=no


##Product Settings
$paypal{item_name}="$form{item_name}";
$paypal{item_number}="$form{item_number}";
$paypal{amount}="$form{amount}";
$paypal{on0}="$form{on0}";
$paypal{os0}="$form{os0}";
$paypal{on1}="$form{on1}";
$paypal{os1}="$form{os1}";
$paypal{quantity}="$form{quantity}";
$paypal{edit_quantity}=""; ## 1=yes ""=no
$paypal{invoice}="$form{invoice}";
$paypal{tax}="$form{tax}";

##Shipping and Taxes
$paypal{shipping_amount}="$form{shipping_amount}";
$paypal{shipping_amount_per_item}="";
$paypal{handling_amount}="";
$paypal{custom_field}="";

##Customer Settings
$paypal{firstname}="$form{firstname}";
$paypal{lastname}="$form{lastname}";
$paypal{address1}="$form{address1}";
$paypal{address2}="$form{address2}";
$paypal{city}="$form{city}";
$paypal{state}="$form{state}";
$paypal{zip}="$form{zip}";
$paypal{email}="$form{email}";
$paypal{phone_1}="$form{phone1}";
$paypal{phone_2}="$form{phone2}";
$paypal{phone_3}="$form{phone3}";



## END CUSTOM CONFIGURATION HERE 


## DO NOT EDIT ANYTHING AFTER THIS LINE


print "Content-type: text/html\n\n";

print <<HTML;

<html>
<body onLoad="document.paypal_form.submit();">
<form method="post" name="paypal_form" action="$paypal{'url'}">

<!-- PayPal Configuration --> 
<input type="hidden" name="business" value="$paypal{'business'}"> 
<input type="hidden" name="cmd" value="$paypal{'cmd'}"> 
<input type="hidden" name="image_url" value="$paypal{'site_url'}$paypal{'image_url'}">
<input type="hidden" name="return" value="$paypal{'site_url'}$paypal{'success_url'}">
<input type="hidden" name="cancel_return" value="$paypal{'site_url'}$paypal{'cancel_url'}">
<input type="hidden" name="notify_url" value="$paypal{'site_url'}$paypal{'notify_url'}">
<input type="hidden" name="rm" value="$paypal{'return_method'}">
<input type="hidden" name="currency_code" value="$paypal{'currency_code'}">
<input type="hidden" name="lc" value="$paypal{'lc'}">
<input type="hidden" name="bn" value="$paypal{'bn'}">
<input type="hidden" name="cbt" value="$paypal{'continue_button_text'}">

<!-- Payment Page Information --> 
<input type="hidden" name="no_shipping" value="$paypal{'display_shipping_address'}">
<input type="hidden" name="no_note" value="$paypal{'display_comment'}">
<input type="hidden" name="cn" value="$paypal{'comment_header'}"> 
<input type="hidden" name="cs" value="$paypal{'background_color'}">

<!-- Product Information --> 
<input type="hidden" name="item_name" value="$paypal{'item_name'}">
<input type="hidden" name="amount" value="$paypal{'amount'}">
<input type="hidden" name="quantity" value="$paypal{'quantity'}"> 
<input type="hidden" name="item_number" value="$paypal{'item_number'}">
<input type="hidden" name="undefined_quantity" value="$paypal{'edit_quantity'}">
<input type="hidden" name="on0" value="$paypal{'on0'}">
<input type="hidden" name="os0" value="$paypal{'os0'}">
<input type="hidden" name="on1" value="$paypal{'on1'}">
<input type="hidden" name="os1" value="$paypal{'os1'}">

<!-- Shipping and Misc Information --> 
<input type="hidden" name="shipping" value="$paypal{'shipping_amount'}">
<input type="hidden" name="shipping2" value="$paypal{'shipping_amount_per_item'}">
<input type="hidden" name="handling" value="$paypal{'handling_amount'}">
<input type="hidden" name="tax" value="$paypal{'tax'}">
<input type="hidden" name="custom" value="$paypal{'custom_field'}">
<input type="hidden" name="invoice" value="$paypal{'invoice'}">

<!-- Customer Information --> 
<input type="hidden" name="first_name" value="$paypal{'firstname'}"> 
<input type="hidden" name="last_name" value="$paypal{'lastname'}"> 
<input type="hidden" name="address1" value="$paypal{'address1'}"> 
<input type="hidden" name="address2" value="$paypal{'address2'}"> 
<input type="hidden" name="city" value="$paypal{'city'}"> 
<input type="hidden" name="state" value="$paypal{'state'}"> 
<input type="hidden" name="zip" value="$paypal{'zip'}"> 
<input type="hidden" name="email" value="$paypal{'email'}"> 
<input type="hidden" name="night_phone_a" value="$paypal{'phone_1'}"> 
<input type="hidden" name="night_phone_b" value="$paypal{'phone_2'}"> 
<input type="hidden" name="night_phone_c" value="$paypal{'phone_3'}"> 

<center><font face="Verdana, Arial, Helvetica, sans-serif" size="2">Processing Transaction . . . </font></center>

</form>
</body>   
</html>
HTML





1;
