#-------------------------------------------------------------------#
# PostGraph.pl							    #
#-------------------------------------------------------------------#
# PostGraph 4 YaBB 2.3						    #
# Version 0.1 beta						    #
# by Carsten Dalgaard						    #
#-------------------------------------------------------------------#
# Copyright: 2006 'Carsten Dalgaard' - All Rights Reserved	    #
# Released: December 30, 2008					    #
# e-mail: carsten.dalgaard@gmail.com				    #
#-------------------------------------------------------------------#
# Any redistribution of this script without the expressed written   #
# consent of 'Carsten Dalgaard' is strictly prohibited. Copying     #
# any	of the code contained within this script and claiming it as #
# your own is also prohibited.					    #
#-------------------------------------------------------------------#
# By using this script you agree to indemnify 'Carsten Dalgaard'    #
# from any liability that might arise from its use.		    #
#-------------------------------------------------------------------#
# You may not remove any of these header notices.		    #
#-------------------------------------------------------------------#

LoadLanguage("postgraph");

$graphheight = 140;	# Here you can change the graph height.
$canvaswidth = 440;	# Here you can change the total graph width.

my(@lgvalue, $linegrper, $grafdeg, $nowyr, $nowmd, $lnowmd, $nowda, $totgrposts, $totgrtposts, $totgrtpposts, $thetotgrposts);
my($oldgrafdate, $grdate, $mtime, $oldestgraf, $check1, $check2, $check3, $thisuser);

sub LineGraph {
$thisuser = $_[0];

$thisuser = $INFO{'username'};
if (!${$uid.$thisuser}{'password'}) { &LoadUser($thisuser); }

if (${$uid.$thisuser}{'postcount'}) {
$showProfile .= qq~
			<div style="float: left; width: 30%; padding-bottom: 5px;">
			&nbsp;
			</div>
			<div style="float: left; width: 70%; padding-bottom: 5px;">
			<a href="$scripturl?action=sellinegraf2;username=$useraccount{$thisuser}">$postgraphtxt{'07'}</a>
			</div>
~;
}
}

sub LineGraph2 {

$thisuser = $INFO{'username'};
if (!${$uid.$thisuser}{'password'}) { &LoadUser($thisuser); }

if($FORM{'linegrmode'} == 1) { $linegrper = 1; $check1 = qq~ selected="selected"~; }
elsif($FORM{'linegrmode'} == 2) { $linegrper = 2; $check2 = qq~ selected="selected"~; }
elsif($FORM{'linegrmode'} == 3) { $linegrper = 3; $check3 = qq~ selected="selected"~; }
elsif($FORM{'linegrmode'} == 4) { $linegrper = 4; $check4 = qq~ selected="selected"~; }
elsif($FORM{'linegrmode'} == 5) { $linegrper = 5; $check5 = qq~ selected="selected"~; }
elsif($FORM{'linegrmode'} == 6) { $linegrper = 6; $check6 = qq~ selected="selected"~; }
else { $linegrper = 4; $check4 = qq~ selected="selected"~; }

if($linegrper != 0) {
	&usersyearposts($thisuser);
	$totgrposts += $totgrtposts;
	$thetotgrposts = "$totgrtposts $postgraphtxt{'08'} $postgraphtxt{'09'} $totgrposts $postgraphtxt{'10'} ";
}
else { $thetotgrposts = "$postgraphtxt{'08'} $postgraphtxt{'09'} $postgraphtxt{'10'}" }

@lgvalue = reverse @lgvalue;
$valnum = @lgvalue;
$valuenum = $valnum - 1;

$graphwidth = $canvaswidth - $valnum;
$valwidth = int($graphwidth/$valuenum);
$graphwidth = ($valuenum * $valwidth) + $valnum;

$totwidth = ($valnum * $valwidth) + $valnum;

$grftable_width = $canvaswidth + 60;

$maxgraph = 0;
$topicpgrvalue = 0;
$topicgrvalue = 0;

for($i=0;$i<$valnum;$i++) {
	($labl[$i],$lablmd[$i],$grvalue[$i],$tgrvalue[$i]) = split(/\|/,$lgvalue[$i]);
	if($linegrper == 4 || $linegrper == 5 || $linegrper == 6) {
		$topicgrvalue = $topicgrvalue + $tgrvalue[$i];
		$togrvalue[$i] = $topicgrvalue;
		$topicpgrvalue = $topicpgrvalue + $grvalue[$i] + $tgrvalue[$i];
		$tpgrvalue[$i] = $topicpgrvalue;
	}
	else {
		$tpgrvalue[$i] = $grvalue[$i] + $tgrvalue[$i];
		if($tpgrvalue[$i] > $maxgraph) { $maxgraph = $tpgrvalue[$i] }
	}
}

for($i=0;$i<$valnum;$i++) {
	if($linegrper == 4 || $linegrper == 5 || $linegrper == 6) {
		$maxgraph = $totgrposts;
		$tgrvalue[$i] = $togrvalue[$i];
	}
	if($grvalue[$i] > 0) { $grvalue[$i] = int((($grvalue[$i] * $graphheight) / $maxgraph) + 0.5) }
	if($tgrvalue[$i] > 0) { $tgrvalue[$i] = int((($tgrvalue[$i] * $graphheight) / $maxgraph) + 0.5) }
	if($tpgrvalue[$i] > 0) { $tpgrvalue[$i] = int((($tpgrvalue[$i] * $graphheight) / $maxgraph) + 0.5) }
}

$mes = "px";
$cvgraphheight = $graphheight + 2;

$yymain .= qq~
<script language="JavaScript1.2" type="text/javascript">
<!--
  img1 = new Image();
  img1.src = "$modimgurl/linegraph/tplinedot.gif";
  img2 = new Image();
  img2.src = "$modimgurl/linegraph/tlinedot.gif";
  img3 = new Image();
  img3.src = "$modimgurl/linegraph/linedot.gif";
  img4 = new Image();
  img4.src = "$modimgurl/linegraph/tolinedot.gif";
// -->
</script>

<table align="center" border="0" width="$grftable_width" cellspacing="1" cellpadding="4" class="bordercolor">
	<tr>
		<td class="titlebg">
			<img src="$imagesdir/profile.gif" alt="" border="0" style="vertical-align: middle;" /> <b>$postgraphtxt{'07'}: ${$uid.$thisuser}{'realname'}</b>
		</td>
	</tr>
	<tr>
		<td class="windowbg" align="center">
			<span class="small">${$uid.$thisuser}{'realname'} $postgraphtxt{'12'} $thetotgrposts $postgraphtxt{'01'} </span>
			<form method="post" action="$scripturl?action=sellinegraf2;username=$useraccount{$thisuser}">
			<select name="linegrmode" style="font-size: 9px" onchange="submit(); return true">
			<option value="" $check0></option>
			<option value="1" $check1>$postgraphtxt{'02'}</option>
			<option value="4" $check4>$postgraphtxt{'02'} $postgraphtxt{'05'}</option>
			<option value="2" $check2>$postgraphtxt{'03'}</option>
			<option value="5" $check5>$postgraphtxt{'03'} $postgraphtxt{'05'}</option>
			<option value="3" $check3>$postgraphtxt{'04'}</option>
			<option value="6" $check6>$postgraphtxt{'04'} $postgraphtxt{'05'}</option>
			</select>
			</form>
		</td>
	</tr>
	<tr>
		<td class="windowbg" align="center">
			<div style="position: relative; top: 0px; left: 0px; width: $graphwidth$mes; height: $cvgraphheight$mes; background-color: #aaaaaa; padding-left: 1px; padding-top: 1px; z-index: 1;">

~;
$m = 0;
$zb = 2;
for($i=0;$i<$valuenum;$i++) {
	my($dotcorr, $tdotcorr, $tpdotcorr, $dothigh, $tdothigh, $tpdothigh, $dothi, $tdothi);

	$yax1 = $grvalue[$i];
	$yax2 = $grvalue[$i+1];
	$grv = ($yax2 - $yax1) / $valwidth;
	$dothi = abs($grv);
	$dothigh = int($dothi);
	if($dothigh == 0) { $dothigh = 1; }
	$dotcorr = $dothigh - 1;
	if($yax1 == 0 && $yax2 == 0) { $dotcorr = 1; }

	$tyax1 = $tgrvalue[$i];
	$tyax2 = $tgrvalue[$i+1];
	$tgrv = ($tyax2 - $tyax1) / $valwidth;
	$tdothi = abs($tgrv);
	$tdothigh = int($tdothi);
	if($tdothigh == 0) { $tdothigh = 1; }
	$tdotcorr = $tdothigh - 1;
	if($tyax1 == 0 && $tyax2 == 0) { $tdotcorr = 1; }

	$tpyax1 = $tpgrvalue[$i];
	$tpyax2 = $tpgrvalue[$i+1];
	$tpgrv = ($tpyax2 - $tpyax1) / $valwidth;

	$yymain .= qq~
			<div style="float: left; width: $valwidth$mes; height: $graphheight$mes; background-color: #eeeeee; padding: 0px; margin: 0px; border-right: 1px #aaaaaa solid; border-bottom: 1px #aaaaaa solid;">
	~;

	for($x=0;$x<$valwidth;$x++) {
		$px = $x;
		if($x == 0) { $px = 0.1; }
		$yax = int(($graphheight - $yax1 - ($px * $grv)) - $dotcorr) + 1;
		$tyax = int(($graphheight - $tyax1 - ($px * $tgrv)) - $tdotcorr) + 1;
		$tpyax = int($graphheight - $tpyax1 - ($x * $tpgrv)) + 1;
		$tpdothigh = $graphheight - $tpyax + 1;
		$todothigh = $graphheight - $tyax + 1;
		$xax = $m * ($valwidth + 1) + $x + 1;
		$yymain .= qq~ <img src="$modimgurl/postgraph/tplinedot.gif" style="position: absolute; left: $xax$mes; top: $tpyax$mes; width: 1px; height: $tpdothigh$mes; z-index: $zb" border="0" alt="" />~;
		$zb++;
		$yymain .= qq~<img src="$modimgurl/postgraph/linedot.gif" style="position: absolute; left: $xax$mes; top: $tpyax$mes; width: 1px; height: $dothigh$mes; z-index: $zb" border="0" alt="" />~;
		$zb++;
		$yymain .= qq~<img src="$modimgurl/postgraph/tolinedot.gif" style="position: absolute; left: $xax$mes; top: $tyax$mes; width: 1px; height: $todothigh$mes; z-index: $zb" border="0" alt="" />~;
		$zb++;
		$yymain .= qq~<img src="$modimgurl/postgraph/tlinedot.gif" style="position: absolute; left: $xax$mes; top: $tyax$mes; width: 1px; height: $tdothigh$mes; z-index: $zb" border="0" alt="" />~;
		$zb++;
	}
	$yymain .= qq~
			</div>
	~;
	$m++;
}

$yymain .= qq~
			</div>

			<div style="position: relative; top: 0px; left: 0px; width: $totwidth$mes; border: 0; margin-left: auto; margin-right: auto;">
~;

$pgrafvalue = 0;
$tgrafvalue = 0;

for($i=0;$i<$valnum;$i++) {
	($graflabl_a,$graflabl_b,$grafvalue,$tografvalue) = split(/\|/,$lgvalue[$i]);
	if($linegrper == 4 || $linegrper == 5 || $linegrper == 6) {
		$pgrafvalue = $pgrafvalue + $tografvalue + $grafvalue;
		$tgrafvalue = $tgrafvalue + $tografvalue;
	}
	else {
		$pgrafvalue = 0;
		$tgrafvalue = 0;
		$pgrafvalue = $tografvalue + $grafvalue;
		$tgrafvalue = $tografvalue;
	}

	$yymain .= qq~
			<div style="float: left; width: $valwidth$mes; padding-left: 1px; margin-left: auto; margin-right: auto;">
				<span class="small">$graflabl_a</span><br />
				<span class="small">$graflabl_b</span><br />
				<span class="small" style="color: #339033">$pgrafvalue</span><br />
				<span class="small" style="color: #ff3333">$tgrafvalue</span>
			</div>
	~;
}

$yymain .= qq~
			</div>
		</td>
	</tr>
	<tr>
		<td class="windowbg" align="center" valign="middle">
			<span class="small">$postgraphtxt{'08'} <img src="$modimgurl/postgraph/tolinedot.gif" height="5" width="$valwidth" border="0" alt="" style="vertical-align: middle;" /> &nbsp; $postgraphtxt{'10'} <img src="$modimgurl/postgraph/tplinedot.gif" height="5" width="$valwidth" border="0" alt="" style="vertical-align: middle;" /></span>
		</td>
	</tr>
</table>

<p align="center"><a href="$scripturl?action=viewprofile;username=$useraccount{$thisuser}"><b>$postgraphtxt{'11'} ${$uid.$thisuser}{'realname'}</b></a></p>
~;

$yytitle = "$postgraphtxt{'07'} $memsettings[1]";
&template;
exit;
}


sub usersyearposts {
$theuser = $_[0];

$grafdeg = 0;
if($linegrper == 1 ||$linegrper == 4) { $peri = 14; $grafdeg = 1209600; &GraphDate; }
elsif($linegrper == 2 ||$linegrper == 5) { $peri = 98; $grafdeg = 8467200; &GraphDate; }
elsif($linegrper == 3 ||$linegrper == 6) { $peri = 12; $grafdeg = 29030400; &GraphDate; $nowda = "01"; }
$oldgrafdate = "$nowmd/$nowda/$nowyr $maintxt{'107'} 00:00:00";
$oldestgraf = stringtotime($oldgrafdate);

unless ($mloaded == 1) { require "$boardsdir/forum.master"; }

foreach $curcat (@categoryorder) {
	$boardlist = $cat{$curcat};
	(@bdlist) = split(/\,/, $boardlist);
	foreach $curboard (@bdlist) {
		push(@catboards, $curboard);
	}
}

$testnum = "";

foreach $curboard (@catboards) {
	chomp $curboard;
	fopen(FILE, "$boardsdir/$curboard.txt");
	@threads = <FILE>;
	fclose(FILE);
	threadcheck: for ($i = 0; $i < @threads; $i++) {
		chomp $threads[$i];
		($tnum, $tsub, $tname, $temail, $tdate, $treplies, $tusername, $ticon, $tstate) = split( /\|/, $threads[$i] );
		fopen(FILE, "$datadir/$tnum.txt") || next;
		@messages = <FILE>;
		fclose(FILE);
		@grmessages = reverse @messages;
		for ($c = 0; $c < @grmessages; $c++) {
			$tc = $c + 1;
			chomp $grmessages[$c];
			($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $message, $mns) = split(/\|/,$grmessages[$c]);
			$tmtime = timetostring($mdate);
			if( $mdate <= $oldestgraf ) { next threadcheck }
			if ($theuser eq $musername) {
				$theyear = substr($tmtime,6,2);
				$themont = substr($tmtime,0,2);
				$theday = substr($tmtime,3,2);
				if($linegrper == 3 || $linegrper == 6) { 
					if($tc < @messages) { $theuserdate[$numfound] = "$theyear|$themont"; $numfound++; }
					elsif($tc == @messages) { $theusertdate[$tnumfound] = "$theyear|$themont"; $tnumfound++; }
				}
				else {
					if($tc < @messages) { $theuserdate[$numfound] = "$theyear|$themont|$theday"; $numfound++; }
					elsif($tc == @messages) { $theusertdate[$tnumfound] = "$theyear|$themont|$theday"; $tnumfound++; }
				}
			}
		}
	}
}

@linegrdates = sort{lc($b) cmp lc($a)} (@theuserdate);
@linegrtdates = sort{lc($b) cmp lc($a)} (@theusertdate);

$grafdeg = 0;
$wchecknr = 0;
$wchecktnr = 0;
&GraphDate;
$weekdg = 0;
$x = 0;
$i = 0;
$t = 0;
$totgrposts = 0;
$totgrtposts = 0;
for($z=0;$z<$peri;$z++) {
	$checknr = 0;
	$checktnr = 0;
	while($linegrdates[$i] eq $grdate) { $checknr++; $i++; }
	$totgrposts += $checknr;
	while($linegrtdates[$t] eq $grdate) { $checktnr++; $t++; }
	$totgrtposts += $checktnr;
	if($linegrper == 1 || $linegrper == 4) {
		$labelmd1 = substr($months[$lnowmd],0,3);
		$lgvalue[$z] = "$nowda|$labelmd1|$checknr|$checktnr";
		$grafdeg += 86400;
		&GraphDate;
	}
	elsif($linegrper == 2 || $linegrper == 5) { 
		$wchecknr += $checknr;
		$wchecktnr += $checktnr;
		$weekdg++;
		if($weekdg == 1) { $lablday2 = $nowda; $lablmd2 = $lnowmd; }
		if($weekdg == 7) {
			$labelmd2 = substr($months[$lablmd2],0,3);
			$lgvalue[$x] = "$lablday2|$labelmd2|$wchecknr|$wchecktnr";
			$weekdg = 0;
			$wchecknr = 0;
			$wchecktnr = 0;
			$x++;
		}
		$grafdeg += 86400;
		&GraphDate;
	}
	elsif($linegrper == 3 || $linegrper == 6) {
		$nowmd = $nowmd - 1;
		$lablyear = substr($months[$nowmd],0,3);
		$lgvalue[$z] = "$lablyear|$nowyr|$checknr|$checktnr";
		if($nowmd < 1) { $nowmd = 12; $nowyr--; $nowyr = "0$nowyr" if ($nowyr < 10); }
		$nowmd = "0$nowmd" if ($nowmd < 10);
		$grdate = "$nowyr|$nowmd";
	}
}

}


sub GraphDate {
	(undef, undef, undef, undef, undef, undef, undef, undef, $isdst) = localtime(time + (3600 * $timeoffset));
	if ($isdst > 0 && $dstoffset)  { $thedate = time + 3600; }
	else { $thedate = time; }
	($sec,$min,$hour,$nowda,$lnowmd,$year,$wday,$yday, undef) = gmtime($thedate - $grafdeg + (3600 * $timeoffset));

	$nowmd = $lnowmd+1;
	$nowyr = ($year % 100);
	$nowmd = "0$nowmd" if ($nowmd < 10);
	$nowda = "0$nowda" if ($nowda < 10);
	$nowyr = "0$nowyr" if ($nowyr < 10);
	if($linegrper == 3 || $linegrper == 6) {
		$grdate = "$nowyr|$nowmd";
	}
	else {
		$grdate = "$nowyr|$nowmd|$nowda";
	}
}

1;