<id>
Recent Users List for YaBB 2.x
</id>

<version>
2 (beta 10)
</version>

<mod info>
This is the Recent User List mod, originally coded by Ronnie, for YaBB 2
ITS HIGHLY RECOMMENDED TO BACKUP YOUR FILES BEFORE USE!!!

First follows the original description; the description for the modified mod is put at the end of this text

This mod adds a list of the x most recent visitors, optionally with their avatars, to the right of the info centre on the board index. It is intended to add a little colour and sense of community to your board. It works with SP1.1, SP1.2 and SP1.3.

You can see examples of the various output styles at:

http://www.badpoo.co.uk/ronnie/images/examples/rul_full.gif
http://www.badpoo.co.uk/ronnie/images/examples/rul_resized.gif
http://www.badpoo.co.uk/ronnie/images/examples/rul_no_avatars.gif
http://www.badpoo.co.uk/ronnie/images/examples/rul_options.gif

After installing the mod and uploading, you must set the options through the Preferences page.

- Number of recent users to show on board index: a setting of 1 would show you the most recent user. A setting of 5 would show you the 5 most recently active users.
- Number of rows in Info Centre (not including main Info Centre title row) while not logged in: this option sets the rowspan for the recent users cell in the Info Centre. This is done manually because of the number of mods that affect the Info Centre, making it impossible to hard code the correct rowspan setting for everyone. To work out this value, just count the number of rows in your Info Centre (not including the main "Info Centre" title strip) while not logged in. For example, if you have no mods installed which add rows to the Info Centre, a setting of 6 is correct.
- Show avatars in list on board index?: show each user's avatar in the list, or not.
- Show times in list on board index?: show the time they were last logged as active in the list, or not.
- What should the avatars link to?: the avatars can link to that member's View Profile page, IM Send page or nothing.
- Avatar resizing - maximum width in pixels (0 to disable): setting this will use the JavaScript code to resize the avatar's width to the size you specify, while keeping the avatar's height in proportion. This is the most commonly used of the two settings - to resize all the avatars to a set width (for example, 40) while having a proportional height so the images aren't distorted.
- Avatar resizing - maximum height in pixels (0 to disable): same as width setting, except it resizes the height. If you set both the width and height setting, all avatars will be forced to those dimensions and will look "wrong" - therefore, it is best to set either the width or height, not both.

The following files are edited and need to be uploaded:
- english.lng
- Sources/BoardIndex.pl
- Sources/LogInOut.pl
- Sources/AdminEdit.pl

CHANGES IN v1.4:
- Fixed the Javascript resizing problem! All credit to BHRA Webmaster for his new smart_resize.mod code which seems to have fixed the "1*1 pixel" image problem.
- Slightly improved efficiency.

FEATURES:
- The list outputs the most recent visitor first, descending to the last visitor.
- A user will never appear twice in the list - for example, if they're currently fourth in the list then they log in again, they'll zoom to the top of the list and the other entries will be pushed down to make way.
- Indicates if the user is online now.
- Avatars can be disabled, shown resized to a height/width/height and width you specify or shown at normal size.
- Avatars can link to the View Profile or IM Send pages, or not link at all.
- Admin option to show times on list.

KNOWN PROBLEMS:
- On some servers, the lastuseronline.txt file is not automatically created when the mod is first run, as it should be. The resulting problem is that despite the mod seeming to install fine, no users appear in the list. To solve this, manually create a blank text file called "lastuseronline.txt" and upload it to your Variables directory in ASCII mode, then CHMOD it 766.

Karma to BHRA Webmaster and his smart_resize.mod code which is used in this mod.

-------------------------------------------------------------------------------------------------------
CHANGES FOR Ver. 2:

First of all upload the following files:
1. RecentUserList.lng to your Language directory (chmod to 777)
2. RecentUserList.pl to ../Admin (chmod to 666)
Then run the mod

The whole Recent User List is put in a variable <yabb last_users_online_tbl>, which is placed in the default.template
In addition to that there is an new variable <yabb last_users_online>, which - for example - can be placed at the top of the template; it shows the last users (without avatar) in one text line.

I hope the modifications are working. I think some of the modifications are "quick and dirty" and there may be better solutions. Maybe anyone else can optimize it...

If instead of an avatar is shown the text "Avatar Error: #" the (negative) number means:
-1: No JPEG or GIF file
-2: Unknown server/proxy port
-3: Unable to retreive the image via the Web Server. This could be due to an incorrect perl installation or web server being down.
-4: Connection Error
-5: Error reading GIF file
-6: Error reading JPEG file


Thanks to Ronnie who did the main work and to all BoardMod users who tested the beta versions of the mod for YaBB 2.x.


</mod info>

<author>
Ronnie, modified by r@be for YaBB 2
</author>

<homepage>
http://www.badpoo.co.uk/ronnie/pages/yabbmods.shtml
</homepage>

<edit file>
YaBB.pl
</edit file>

<search for>
require "$vardir/Smilies.txt";
</search for>

<add after>
# RECENT USER LIST START
if (-e("$vardir/RecentUserOnline.txt"))  {
	require "$vardir/RecentUserOnline.txt";
}
# RECENT USER LIST END
</add after>

<edit file>
AdminIndex.pl
</edit file>

<search for>
### END BOARDMOD ANCHOR ###
</search for>

<add before>
# RECENT USER LIST START
	$recentuserlist = "recentuserlist|Recent User List|Recent User List";
	push (@boardmod_mods, "$recentuserlist");
# RECENT USER LIST END
</add before>

<edit file>
Admin/AdminSubList.pl
</edit file>

<search for>
%director=(
</search for>

<add after>
# RECENT USER LIST START
'recentuserlist',"RecentUserList.pl&RecentUserListSet",
'recentuserlist2',"RecentUserList.pl&RecentUserListSet2",
# RECENT USER LIST END
</add after>

<edit file>
Admin/ModList.pl
</edit file>

<search for>
sub ListMods {
</search for>

<add before>
# RECENT USER LIST START
LoadLanguage("RecentUserList");
# RECENT USER LIST END
</add before>

<search for>
### END BOARDMOD ANCHOR ###
</search for>

<add before>
# RECENT USER LIST START
	$recentuserlist = "Recent_User_List|ronnie, modified by r@be|$rul_txt{'17'}|0.1|October 28th, 2005";
	push (@installed_mods, "$recentuserlist");
# RECENT USER LIST END
</add before>

<edit file>
Sources/LogInOut.pl
</edit file>

<search for>
	$iamguest = $username eq 'Guest' ? 1 : 0;
	if ($FORM{'cookielength'} == 1) { $ck{'len'} = 'Sunday, 17-Jan-2038 00:00:00 GMT'; }
	else { $ck{'len'} = "\+$FORM{'cookielength'}m"; }
</search for>

<add after>
# RECENT USERS LIST START
	if ($username ne 'Guest')
	{
		&RecentUsersList;
	}
# RECENT USERS LIST END
</add after>

<search for>
	if ($action ne "profile2") { &UserAccount($username, "update", "lastonline"); }
	&UpdateCookie("delete");
</search for>

<add before>
# RECENT USERS LIST START
	if ($username ne 'Guest')
	{
		&RecentUsersList;
	}
# RECENT USERS LIST END

</add before>

<search for>
sub sharedLogin {
</search for>

<add before>
# RECENT USERS LIST START
# ORGANISES AND UPDATES THE lastuseronline.txt FILE CONTAINING THE LAST $rul_users_display USERS ONLINE
sub RecentUsersList
{
	#READ $rul_users_display FROM FILE
	if (!-e("$vardir/RecentUserList.txt"))  
	{
		$rul_users_display = 5;
	}
	else
	{
		fopen(SETFILE, "$vardir/RecentUserList.txt");
		@rulsettings = <SETFILE>;
		fclose(SETFILE);
		chomp @rulsettings;
		
		($dummy, $rul_users_display) = split(/\= /, $rulsettings[9]);
		($rul_users_display, $dummy) = split(/\;/, $rul_users_display);
	}

	#how many users to store on file
	$rul_users_display = $rul_users_display || 5;
	$display = $rul_users_display - 1;#to take into account we're dealing with [0]
	$user_in_file = 0;
	
	fopen(LUO, "$vardir/lastuseronline.txt"); @lastusers = <LUO>; fclose(LUO);

	#see if there are redundant entries in the file that we don't currently want with $display
	#old entries appear after reducing $display e.g. from 7 to 5 - first time this code run after reducing there would be 2 unwanted entries in @lastusers
	$lastusers_count = scalar(@lastusers) - 1; 
	if ($lastusers_count > $display)
	{
		for ($r = $lastusers_count; $r > $display; $r--) { pop(@lastusers); }
	}

	#check if this user already has an entry in the log
	for ($i = $display; $i >= 0; $i--)
	{
		($this_username, $junk) = split(/\|/, $lastusers[$i]);
		if ($this_username eq $username)
		{
			$user_in_file = 1;
			last;
		}
	}

	#arrange file depending whether this user is already in it
	if (! $user_in_file)
	{
		#shift each of the other entries back
		for ($z = $display; $z > 0; $z--)
		{
			$lastusers[$z] = $lastusers[$z - 1];
		}
		
		#insert this user at the top of the file
		$lastusers[0] = qq~$username|$date\n~;
	}
	#else they are in the file
	else
	{
		#first, check it's not just [0], which we can replace easily
		if ($i == 0)
		{
			#insert this user at the top of the file
			$lastusers[0] = qq~$username|$date\n~;
		}
		#no, it's not [0], so we've got to shift the others around
		else
		{
			#set that line to be the one above it e.g. [2] is replaced by contents of [1]
			for ($k = $i; $k > 0; $k--)
			{
				$lastusers[$k] = $lastusers[$k - 1];
			}

			#insert this user at the top of the file
			$lastusers[0] = qq~$username|$date\n~;
		}
	}

	#write to file
	fopen(LUO, ">$vardir/lastuseronline.txt");
	print LUO @lastusers;
	fclose(LUO);
}
# RECENT USER LIST END

</add before>

<edit file>
Sources/BoardIndex.pl
</edit file>

<search for>
if ($action eq 'detailedversion') { return 1; }
</search for>

<add before>
# RECENT USER LIST START
use Sys::Hostname;
# RECENT USER LIST END
</add before>

<search for>
require "$templatesdir/$useboard/BoardIndex.template";
</search for>

<add before>
# RECENT USER LIST START
LoadLanguage("RecentUserList");
# RECENT USER LIST END
</add before>

<search for>
sub BoardIndex {
</search for>

<add after>
# RECENT USERS LIST START
	if ($username ne 'Guest' && $action ne 'login2')
	{
		require "$sourcedir/LogInOut.pl";
		&RecentUsersList;
	}
# RECENT USERS LIST END
</add after>

<search for>
	$boardindex_template =~ s/<yabb sharedlogin>/$shared_login/g;
</search for>

<add after>
# RECENT USER LIST START
	# READ LIST FROM FILE
	fopen(FILE, "$vardir/lastuseronline.txt");
	@lastusers = <FILE>;
	fclose(FILE);
	chomp @lastusers;
	
	
	#READ SETTINGS FROM FILE	
	if (!-e("$vardir/RecentUserList.txt"))  
	{
		$rul_show_avatars = 1;
		$rul_show_time = 1;
		$rul_avatar_link = 0;
		$rul_avatar_width = 0;
		$rul_avatar_height = 0;
		$rul_rowspan = 6;
		$rul_users_display = 5;
	}
	else
	{
		fopen(SETFILE, "$vardir/RecentUserList.txt");
		@rulsettings = <SETFILE>;
		fclose(SETFILE);
		chomp @rulsettings;
		
		($dummy, $rul_users_display) = split(/\= /, $rulsettings[9]);
		($rul_users_display, $dummy) = split(/\;/, $rul_users_display);
		
		($dummy, $rul_avatar_width) = split(/\= /, $rulsettings[7]);
		($rul_avatar_width, $dummy) = split(/\;/, $rul_avatar_width);
		
		($dummy, $rul_avatar_height) = split(/\= /, $rulsettings[8]);
		($rul_avatar_height, $dummy) = split(/\;/, $rul_avatar_height);
		
		($dummy, $rul_rowspan) = split(/\= /, $rulsettings[10]);
		($rul_rowspan, $dummy) = split(/\;/, $rul_rowspan);
		
		($dummy, $rul_show_avatars) = split(/\= /, $rulsettings[4]);
		($rul_show_avatars, $dummy) = split(/\;/, $rul_show_avatars);
		
		($dummy, $rul_show_time) = split(/\= /, $rulsettings[5]);
		($rul_show_time, $dummy) = split(/\;/, $rul_show_time);
		
		($dummy, $rul_avatar_link) = split(/\= /, $rulsettings[6]);
		($rul_avatar_link, $dummy) = split(/\;/, $rul_avatar_link);
				
		if ($rul_users_display eq '') { $rul_users_display = 5; }
		if ($rul_avatar_width eq '') { $rul_avatar_width = 0; }
		if ($rul_avatar_height eq '') { $rul_avatar_height = 0; }
		if ($rul_rowspan eq '' ) { $rul_rowspan = 6; }
		if ($rul_show_avatars eq '') { $rul_show_avatars = 1; }
		if ($rul_show_time eq '') { $rul_show_time = 1; }
		if ($rul_avatar_link eq '') { $rul_avatar_link = 0; }
	}
	

	$counter = 1;
	$last_users_online = '';
	$last_users_online_tbl = qq~<td rowspan="$rul_rowspan" class="windowbg2" width="25%" valign="top"><table border="0" width="100%" valign="top">~;
	
	foreach $lastuser_line (@lastusers)
	{
		
		#Read last username and his/her last visit from file
		($last_username, $last_userwhen) = split(/\|/, $lastuser_line);
		$online_now = ($users =~ /username=$last_username"/) ? $rul_txt{'2'} : '';
		$last_username2 = $last_username;
				
		#it should never happen, but a Guest entry might have been stored in the file. this avoids showing it 
		if (fopen(MFILE, "$memberdir/$last_username.vars"))
		{
			@memberinfo = <MFILE>; 
			fclose(MFILE); 
			chomp @memberinfo;
		
		
			#Get real name and last online time
			($dummy, $last_username) = split(/\"/, $memberinfo[3]);
			if ( $online_now eq '' ) { $last_userwhen = &timeformat($last_userwhen); }
			else { $last_userwhen = ''; }
		

			#Create the 'one-liner' varible <yabb last_users_online> to put it anywhere in the  template
			if ( $counter > 1 )
			{
				if ( $rul_show_time == 1 ) 
				{ 
					$last_users_online = qq~$last_users_online, $last_username ($last_userwhen$online_now)~; 
				}
				else 
				{ 
					$last_users_online = qq~$last_users_online, $last_username~; 
				}
			}
			else
			{
				if ( $rul_show_time == 1 ) 
				{ 
					$last_users_online = qq~$last_username ($last_userwhen$online_now)~; 
				}
				else 
				{ 
					$last_users_online = qq~$last_username~; 
				}
			}

			#Create the table varible <yabb last_users_oline_tbl> to put it in the boardindex
			#do we want to show an avatar?
			if ($rul_show_avatars)
			{
				#correct url allowing for custom avatars
				#Get the user pic path
				($dummy, $last_userpic) = split(/\"/, $memberinfo[17]);
				if ($last_userpic =~ m~\Ahttp://~) { $avatar = $last_userpic; }
				else { $avatar = $facesurl . '/' . $last_userpic; }
					
				#is resizing enabled or shall we just show a plain image tag? 
				#if we're using avatar resizing 
				if ($rul_avatar_width || $rul_avatar_height) { 
					#GET THE AVATAR SIZE 
					($Width,$Height,$err)=imgsize($avatar);
					#CALCULATE THE NEW SIZE OF THE AVATAR 
					($newwidth, $newheight)=resize_img($rul_avatar_width,$rul_avatar_height,$Width,$Height); 
					if ($err < 0) {
					$avatars_cell = qq~<td>
								<font size="1">Avatar Error:<br />$err</font>
							</td>~; 
					}
					else
					{
						#decide what the avatar link should be 
						if ($rul_avatar_link == 2) { 
							$avatars_cell = qq~<td>
										<a href="$scripturl?action=imsend;to=$last_username2"> 
										<img src="$avatar" width="$newwidth" height="$newheight" alt="$rul_txt{'12'} $last_username" border="0" hspace="3" /> 
										</a> 
									</td>~; 
						}
						elsif ($rul_avatar_link == 1) { 
							$avatars_cell = qq~<td>
										<a href="$scripturl?action=viewprofile;username=$last_username2">
										<img src="$avatar" width="$newwidth" height="$newheight" alt="$last_username" border="0" hspace="3" />
										</a>
									</td>~; 
						} 
						else { 
							$avatars_cell = qq~<td>
										<img src="$avatar" width="$newwidth" height="$newheight" alt="$last_username" border="0" hspace="3" /> 
									</td>~; 
						} 
					}
				}
				#else we're not using resizing so just use the normal image tag
				else
				{
					#decide what the avatar link should be
					if ($rul_avatar_link == 2) 
					{ 
						$avatars_cell = qq~<td>
									<a href="$scripturl?action=imsend;to=$last_username2">
									<img src="$avatar" border="0" alt="$rul_txt{'12'} $last_username" hspace="3" />
									</a>
								</td>~; 
					}
					elsif ($rul_avatar_link == 1) 
					{ 
						$avatars_cell = qq~<td>
									<a href="$scripturl?action=viewprofile;username=$last_username2">
									<img src="$avatar" border="0" alt="$rul_txt{'13'} $last_username" hspace="3" />
									</a>
								</td>~; 
					}
					else 
					{ 
						$avatars_cell = qq~<td>
									<img src="$avatar" border="0" alt="$last_username" hspace="3" />
								</td>~; 
					}
				}
			}
			#else we're not showing avatars, so just show the text counter
			else 
			{ 
				$avatars_cell = qq~<td valign="top"><font size="1">$counter.</font></td>~; 
			}
			$last_users_online_tbl = qq~$last_users_online_tbl<tr>$avatars_cell<td><font size="1"><a href="$scripturl?action=viewprofile;username=$last_username2">$last_username</a><br />$last_userwhen$online_now</font></td></tr>~;
		}
		$counter++;
	}
	$last_users_online_tbl = qq~$last_users_online_tbl</table>~;
	$rul_title = qq~$rul_users_display $rul_txt{'1'}~;
	#Template it
	$boardindex_template =~ s/<yabb count>/$rul_user_display/g;
	$boardindex_template =~ s/<yabb last_users_online>/$last_users_online/g;
	$boardindex_template =~ s/<yabb rul_title>/$rul_title/g;
	$boardindex_template =~ s/<yabb last_users_online_tbl>/$last_users_online_tbl/g;
#RECENT USER LIST END
</add after>

<search for>
1;
</search for>

<add before>
# RECENT USER LIST START 
sub imgsize { 
	local($file)= shift @_; 
	local($x,$y)=(0,0); 
	if ($file =~ /http:/) { 
		($x,$y,$err) = &URLsize($file); 
	} 
	elsif ( defined($file) && open(STREAM, "<$file") ) { 
		binmode( STREAM ); 
		if ($file =~ /\.jpg$/i or $file =~ /\.jpeg$/i) { 
			($x,$y,$err) = &jpegsize(STREAM); 
		} elsif ($file =~ /\.gif$/i) { 
			($x,$y,$err) = &gifsize(STREAM); 
		} else { $err = -1; } 
		close(STREAM); 
	} 
	return ($x,$y,$err); 
	} 

sub gifsize { 
	local($GIF) = @_; 
	local($type,$a,$b,$c,$d,$s)=(0,0,0,0,0,0); 
	if (defined($GIF) && read($GIF, $type, 6) && $type =~ /GIF8[7,9]a/ && read($GIF, $s, 4) == 4 ) { 
		($a,$b,$c,$d)=unpack("C"x4,$s); 
		return ($b<<8|$a,$d<<8|$c); 
	} 
	return (0,0,-5); 
} 

sub jpegsize { 
	local($JPEG) = @_; 
	local($done)=0; 
	local($c1,$c2,$ch,$s,$length, $dummy)=(0,0,0,0,0,0); 
	if (defined($JPEG) && read($JPEG, $c1, 1) && read($JPEG, $c2, 1) && ord($c1) == 0xFF && ord($c2) == 0xD8 ) { 
		while (ord($ch) != 0xDA && !$done) { 
			while (ord($ch) != 0xFF) { 
				read($JPEG, $ch, 1); 
			} 
			while (ord($ch) == 0xFF) { 
				read($JPEG, $ch, 1); 
			} 
			if ((ord($ch) >= 0xC0) && (ord($ch) <= 0xC3)) { 
				read ($JPEG, $dummy, 3); 
				read($JPEG, $s, 4); 
				($a,$b,$c,$d)=unpack("C"x4,$s); 
				return ($c<<8|$d, $a<<8|$b ); 
			} 
			else { 
				read ($JPEG, $s, 2); 
				($c1, $c2) = unpack("C"x2,$s); 
				$length = $c1<<8|$c2; 
				last if (!defined($length) || $length < 2); 
				read($JPEG, $dummy, $length-2); 
			} 
		} 
	} 
	return (0,0,-6); 
} 

sub URLsize { 
	local($five) = @_; 
	local($dummy, $dummy, $server, $url); 
	local( $x,$y) = (0,0); 
	($dummy, $dummy, $server, $url) = split(/\//, $five, 4); 
	$url=$five; 
	local($them,$port) = split(/:/, $server); 
	$port = 80 unless $port; 
	$them = 'localhost' unless $them; 
	$_=$url; 
	if (/gif/i || /jpeg/i || /jpg/i) { 
		$sockaddr = 'S n a4 x8'; 
		$hostname=hostname(); 
		($name,$aliases,$proto) = getprotobyname('tcp'); 
		($name,$aliases,$port) = getservbyname($port,'tcp') unless $port =~ /^\d+$/;
		($name,$aliases,$type,$len,$thisaddr) = gethostbyname($hostname); 
		($name,$aliases,$type,$len,$thataddr) = gethostbyname($them); 
		if (!defined($port)) { 
			$err = -2; 
		} 
		if (!defined($thataddr)) { 
			$err = -3; 
		} 
		$this = pack($sockaddr, &AF_INET, 0, $thisaddr); 
		$that = pack($sockaddr, &AF_INET, $port, $thataddr); 
		if (!((socket(S, &AF_INET, &SOCK_STREAM, $proto)) && (bind(S, $this)) && (connect(S,$that)) )) { 
			$err = -4; 
		} 
		else { 
			select(S); $| = 1; select(STDOUT); 
			print S "GET $url\n\n"; 
			if ($url =~ /\.jpg$/i || $url =~ /\.jpeg$/i) { 
				($x,$y, $err) = &jpegsize(S); 
			} 
			elsif ($url =~ /\.gif$/i) { 
				($x,$y, $err) = &gifsize(S); 
			} 
			else { 
				$err = -1; 
			} 
		} 
	} 
	else { 
		$err = -1; 
	} 
	return ($x,$y,$err); 
} 

sub resize_img { 
	local($newwidth,$newheight,$oldwidth,$oldheight) = @_; 
	$nw=$newwidth; 
	$nh=$newheight; 
	$ow=$oldwidth; 
	$oh=$oldheight; 
	
	if (($oh == 0) || ($ow == 0)) {
		return($nw, $nh);
	}

	if (($nw == 0) || ($nh == 0)) { 
		if ($nw != 0) { 
			$nh = ($oh * $nw / $ow); 
		} 
		if ($nh != 0) { 
			$nw = ($ow * $nh / $oh); 
		} 
	} 
	return($nw,$nh); 
} 
# RECENT USER LIST END

</add before>

<edit file>
Sources/Display.pl
</edit file>

<search for>
require "$templatesdir/$usedisplay/Display.template";
</search for>

<add before>
# RECENT USER LIST START
LoadLanguage("RecentUserList");
# RECENT USER LIST END
</add before>

<edit file>
Templates/default/BoardIndex.template
</edit file>

<search for>
	<td class="titlebg" align="center" colspan="2">
		$boardindex_txt{'685'}
	</td>
</search for>

<add after>
	<td class="titlebg" align="center" colspan="2"> 
		<yabb rul_title> 
	</td>
</add after>

<search for>
	<td align="left" class="catbg" colspan="2">
		<span class="catbg">$boardindex_txt{'200'}</span>
</search for>

<add after>
	<yabb last_users_online_tbl>
</add after>