#!/usr/bin/perl --
##########################################################################################
# ShoutDisplay.pl: Part of the Shoutbox 2.3.1 Mod
# Copyright:       2005 Andrew Aitken (LoonyPandora)

# Version:         Shoutbox 2.3.1 RC4.1

# Released:        5th March, 2009

# Distributed By:  http://www.boardmod.org

# 2.3.1 update by: Batchman, Derek Barnstorm, D0T-C0M, Driven, Unilat, ThM with permission
##########################################################################################

$shoutdisplayplver = 'Shoutbox Mod 231 RC4.1';

# Make sure the module path is present

# Some servers need all the subdirs in @INC too.

push(@INC, "./Modules");

push(@INC, "./Modules/Upload");

push(@INC, "./Modules/Digest");



if ($ENV{'SERVER_SOFTWARE'} =~ /IIS/) {

	$yyIIS = 1;

	$0 =~ m~(.*)(\\|/)~;

	$yypath = $1;

	$yypath =~ s~\\~/~g;

	chdir($yypath);

	push(@INC, $yypath);

}


#use Time::HiRes qw(time);
    #benchmarking
#
$START_TIME = time;


&DisplayShouts;



sub DisplayShouts {


	require "Paths.pl";

	require "$vardir/Settings.pl";

	require "$sourcedir/Subs.pl";

	require "$sourcedir/Load.pl";

	require "$vardir/Smilies.txt";

	require "$vardir/shoutsettings.txt";


	$scripturl = qq~$boardurl/YaBB.$yyext~;


	&LoadLanguage("Shoutbox");

	&LoadLanguage("Main");

	&LoadCookie;

&UserCheck($username,"position+template+timeselect+timeoffset+language+lp_shout_refresh+lp_shout_timestamp+on_load_focus+lp_shout_smileys+lp_shout_bbcode");

	# Determine guest and admin positions
	
	$iamguest = $username eq 'Guest' ? 1 : 0;
	
	if($usercheck{$username.'position'} eq 'Administrator') {$iamadmin = 1;}
	
######################################################
######################################################
#This is what you want to change if you need to
#increase the height of the bottom portion of the
#shoutbox to accommodate more lines or taller smilieys
#The code is split into 2 sections AND you have to
#change both sections.
######################################################
##########                 ###########################
##########  FIRST SECTION  ###########################
##########                 ###########################
######################################################
######################################################
$px = "px"; # DO NOT CHANGE ## stores the letters "px"
if ($shout_width < 380) {
######################################################
#if you set the shoutbox width less than 380 then do
#the following:
     $autobr = "<br />"; #used to split smileys
	                     #into 2 lines
######################################################
# Increasing the number below increases the height
#of the bottom portion of the shoutbox. The top
#portion containing the actual shouts will auto size
#accordingly.
####
    $shout_text_height = 112;
######################################################
     $shout_text_height2 = $shout_text_height;
if ($usercheck{$username.'lp_shout_bbcode'} eq "") {
######################################################
#If you disable the UBBC line then automatically
#substract 8 from the height of the bottom portion of
#the shoutbox to compensate.
	$shout_text_height2 -= 8;
######################################################
}
if ($usercheck{$username.'lp_shout_smileys'} eq "") {
######################################################
#If you disable the smileys line then automatically
#substract 27 from the height of the bottom portion
#of the shoutbox to compensate.
	$shout_text_height2 -= 27;
######################################################
}
$shout_text_height3 = ($shout_text_height2 +8);
}else {
######################################################
##########                 ###########################
##########  SECOND SECTION ###########################
##########                 ###########################
######################################################
######################################################
#if you set the shoutbox width more than 380 pixels
#then do the following:
$autobr = ""; #used to join smileys
	          #into 1 lines
######################################################
# Increasing the number below increases the height
#of the bottom portion of the shoutbox. The top
#portion containing the actual shouts will auto size
#accordingly.
####
	$shout_text_height = 92;
######################################################
$shout_text_height2 = $shout_text_height;
if ($usercheck{$username.'lp_shout_bbcode'} eq "") {
######################################################
#If you disable the UBBC buttons then automatically
#substract 8 from the height of the bottom portion
#of the shoutbox to compensate.
  $shout_text_height2 -= 8;
######################################################
}
if ($usercheck{$username.'lp_shout_smileys'} eq "") {
######################################################
#If you disable the smileys line then automatically
#substract 8 from the height of the bottom portion of
#the shoutbox to compensate.
   $shout_text_height2 -= 8;
######################################################
}$shout_text_height3 = ($shout_text_height2 +8);
}
######################################################

 
		# Figure out which template to be using.

	${$uid.$username}{'template'} = $usercheck{$username.'template'};

	&WhatTemplate;

	# Guardian Form spoofing protection
	$formsession = &cloak("$mbname$username");

	# Set guests censor language

	if ($iamguest) { our $language = $censor_lang; }
	else { $language = $usercheck{$username.'language'} }

	fopen(SHOUTS, "$vardir/shouts.txt");
	@shouts = <SHOUTS>;

	fclose(SHOUTS);


	$number_of_shouts = $#shouts;

	$skip_shouts      = ($number_of_shouts - $max_disp_shouts);

	$counter          = 0;


	if ($reverse_post) {
 @shouts = reverse @shouts;
 }


	if (!$INFO{'showall'}) {

		foreach $shoutline (@shouts) {
			if ($counter > $skip_shouts) {
				chomp @shouts;
				($shout_time, $shout_displayname, $shout_username, $shout_message) = split(/[\|]/, $shoutline);
				$delete_link = '';
				&CheckCanDelete;

			# Censor the posts, and display names
			if ($enable_censor) {
				&LoadCensorList;
				$shout_displayname = &Censor($shout_displayname);
				$shout_message     = &Censor($shout_message);
			}

			# Do UBBC on the Shout (append shout_ before vars)
			$message = $shout_message;
			&wrap;
			if ($enable_ubbc) {
				if (!$yyYaBBCloaded) {
					require "$sourcedir/YaBBC.pl";
				}
				&DoUBBC;
			}
			&my_wrap3;

			$shout_message = $message;

			$shout_time = &shout_timeformat($shout_time);

			# Set the alternating backgrounds colours
			if ($counter % 2) { $class = 'shout_windowbg'; }
			else { $class = 'shout_windowbg2'; }

			if ($usercheck{$username.'lp_shout_timestamp'}) { $timestamp = "$shout_time"; }

				$shout_rows .= qq~
		
		<script language="JavaScript1.2" type="text/javascript">

		function confirmDelete() {
 		return confirm("$shout_txt{'50'}");
		}
	
		</script>
 <tr>
	  <td class="$class" style="font-size: 10px;">
<div style="float:left;padding-right:3px;padding-left:3px;">$timestamp<b>$shout_displayname:</b></div><div 
style="float:right;padding-right:3px;padding-left:3px;">$delete_link</div><br />$shout_message</td>	   
  </tr>~;

			}
			$counter++;
		}
		$shoutform_action = "$scripturl?action=write_shouts";
		&Template;

	} else {

		foreach $shoutline (@shouts) {
			chomp @shouts;
			($shout_time, $shout_displayname, $shout_username, $shout_message) = split(/[\|]/, $shoutline);
			$delete_link = '';
			&CheckCanDelete_showall;

			if (length($message) > $max_shout_length) { $message = substr($message, 0, $max_shout_length); } 

			# Do UBBC on the Shout (append shout_ before vars)
			$message = $shout_message;
			&wrap;
			if ($enable_ubbc) {
				if (!$yyYaBBCloaded) {
					require "$sourcedir/YaBBC.pl";
				}
				&DoUBBC;
			}
			&my_wrap3;
			
			# Censor the posts, and display names
			if ($enable_censor) {
				&LoadCensorList;
				$shout_displayname = &Censor($shout_displayname);
				$shout_message     = &Censor($shout_message);
			}



			$shout_message = $message;

			$shout_time = &shout_timeformat($shout_time);

			# Set the alternating backgrounds colours
			if ($counter % 2) { $class = 'shout_windowbg'; }
			else { $class = 'shout_windowbg2'; }

			if ($usercheck{$username.'lp_shout_timestamp'}) { $timestamp = "$shout_time"; }

				$shout_rows .= qq~
				
		<script language="JavaScript1.2" type="text/javascript">

		function confirmDelete() {
 		return confirm("$shout_txt{'50'}");
		}
	
		</script>
 <tr>
	  <td class="$class" style="font-size: 10px;">
<div style="float:left;padding-right:3px;padding-left:3px;">$timestamp<b>$shout_displayname:</b></div><div 
style="float:right;padding-right:3px;padding-left:3px;">$delete_link</div><br />$shout_message</td>	   
  </tr>~;

			$counter++;
		}

		$shoutform_action = "$scripturl?action=write_shouts;showall=1";

		&Template;
		if (length($message) > $max_shout_length) { $message = substr($message, 0, $max_shout_length); }
	}
}



sub CheckCanDelete {
	if ($delete_delay == "0") { return; }
 
	if ($iamadmin || (!$iamguest && ($username eq $shout_username))) {
        	my $now_time = int(time);
		if (($now_time - $shout_time) > $delete_delay) { if (!$iamadmin || !$admin_deletion_link) {return;}}
		$delete_link = qq~<a href="$scripturl?action=useremoveshouts;shout=$shout_time;user=$shout_username" target="shouts"  onclick="return confirmDelete();"><IMG STYLE="border:none;" src="$yyhtml_root/ModImages/Shoutbox/stop.png" alt="$shout_txt{'46'}" title="$shout_txt{'47'}"></a>~;
	}
}

sub CheckCanDelete_showall {
	if ($delete_delay == "0") { return; }
 
	if ($iamadmin || (!$iamguest && ($username eq $shout_username))) {
        	my $now_time = int(time);
		if (($now_time - $shout_time) > $delete_delay) { if (!$iamadmin || !$admin_deletion_link) {return;}}
		$delete_link = qq~<a href="$scripturl?action=useremoveshouts;shout=$shout_time;user=$shout_username" target="_parent"  onclick="return confirmDelete();"><IMG STYLE="border:none;" src="$yyhtml_root/ModImages/Shoutbox/stop.png" alt="$shout_txt{'46'}" title="$shout_txt{'47'}"></a>~;
	}
}

sub my_wrap3 {
	$shout_message =~ s~(<.*>)*(\S{0,14})(\S{0,14})?(\S{0,14})?(\S{0,14})?(\S*)?(<.*>)*~$1$2 $3 $4 $5 $6$7~gi;
	$shout_message =~ s~(<.*>)?(\S{0,14})(\S{0,14})?(\S{0,14})?(\S{0,14})?(\S*)(<\/\S*>)~$1$2 $3 $4 $5 $6$7~gi;
	$shout_message =~ s~\s+~ ~gi;
}

sub shout_timeformat {
	$oldformat = $_[0];
	chomp $oldformat;
	if (!$oldformat) { return $oldformat; }
	$dontusetoday = $_[1];
	$mytimeselected = $usercheck{$username.'timeselect'} || $timeselected;
	(undef, undef, undef, undef, undef, undef, undef, undef, $newisdst) = localtime($oldformat);
	if ($newisdst > 0) { $userdst = $usercheck{$username.'dsttimeoffset'} || $dstoffset; $dst = 1; }

	# we find out what time the date of the post is according to the users timezone.
	if ($iamguest) {
		$toffs   = $timeoffset;
		$dstoffs = $dstoffset;
	} else {
		$toffs   = $usercheck{$username.'timeoffset'};
		$dstoffs = $userdst;
	}
	my ($newsecond, $newminute, $newhour, $newday, $newmonth, $newyear, $newweekday, $newyearday, $dummy) = gmtime($oldformat + (3600 * ($toffs + $dstoffs)));

	# Calculate number of full weeks this year
	$newweek = int(($newyearday + 1 - $newweekday) / 7) + 1;

	# Add 1 if today isn't Saturday
	if ($newweekday < 6) { $newweek = $newweek + 1; }
	$newweek = sprintf("%02d", $newweek);
	$newmonth++;
	$newweekday++;
	$newyear += 1900;
	$newshortyear = substr($newyear, 2, 2);
	$newmonth = sprintf("%02d", $newmonth);
	if ($mytimeselected != 4) { $newday = sprintf("%02d", $newday); }
	$newhour   = sprintf("%02d", $newhour);
	$newminute = sprintf("%02d", $newminute);
	$newsecond = sprintf("%02d", $newsecond);

	$newtime = $newhour . ":" . $newminute . ":" . $newsecond;

	($secx, $minx, $hourx, $dd, $mm, $yy, $tmpx, $yd, $tmpx) = gmtime($date + (3600 * ($toffs + $dstoffs)));

	$mm = $mm + 1;
	$yy = ($yy % 100);

	$daytxt = "";

	#the today yesterday problem was here... =(
	if (!$dontusetoday) {
		if ($yd == $newyearday && $yy == $newshortyear) {

			# today
			$daytxt = qq~$shout_txt{'28'}~;
		} elsif (($yd == $newyearday + 1 && $yy == $newshortyear) || ($yd == 1 && $dd == 31 && $yy == $newshortyear + 1)) {

			# yesterday
			$daytxt = qq~$shout_txt{'28a'}~;
		} elsif (($yd == $newyearday - 365 && $yy == $newshortyear + 1) || ($yd == $newyearday - 366 && $yy == $newshortyear + 1)) {

			# yesterday, over a year end.
			$daytxt = qq~$shout_txt{'28a'}~;
		}
	}

	if (!$maintxt{'107'}) { $maintxt{'107'} = $admin_txt{'107'}; }

	if ($mytimeselected == 7) {
		$mytimeformat = $usercheck{$username.'timeformat'};
		if ($mytimeformat =~ m/MM/) { $usefullmonth = 1; }
		if ($mytimeformat =~ m/hh/) { $hourstyle    = 12; }
		if ($mytimeformat =~ m/HH/) { $hourstyle    = 24; }
		$mytimeformat =~ s/\@/$maintxt{'107'}/g;
		$mytimeformat =~ s/mm/$newminute/g;
		$mytimeformat =~ s/ss/$newsecond/g;
		$mytimeformat =~ s/ww/$newweek/g;

		if ($mytimeformat =~ m/\+/) {
			if ($newday > 10 && $newday < 20) {
				$dayext = "$timetxt{'4'}";
			} elsif ($newday % 10 == 1) {
				$dayext = "$timetxt{'1'}";
			} elsif ($newday % 10 == 2) {
				$dayext = "$timetxt{'2'}";
			} elsif ($newday % 10 == 3) {
				$dayext = "$timetxt{'3'}";
			} else {
				$dayext = "$timetxt{'4'}";
			}
		}
		if ($hourstyle == 12) {
			$ampm = $newhour > 11 ? 'pm' : 'am';
			$newhour2 = $newhour % 12 || 12;
			$mytimeformat =~ s/hh/$newhour2/g;
			$mytimeformat =~ s/\#/$ampm/g;
		} elsif ($hourstyle == 24) {
			$mytimeformat =~ s/HH/$newhour/g;
		}
		if ($daytxt eq "") {
			$mytimeformat =~ s/YYYY/$newyear/g;
			$mytimeformat =~ s/YY/$newshortyear/g;
			$mytimeformat =~ s/DD/$newday/g;
			$mytimeformat =~ s/D/$newday/g;
			$mytimeformat =~ s/\+/$dayext/g;
			if ($usefullmonth == 1) {
				$mytimeformat =~ s/MM/$months[$newmonth-1]/g;
			} else {
				$mytimeformat =~ s/M/$newmonth/g;
			}
		} else {
			$mytimeformat =~ s/DD/$daytxt/g;
			$mytimeformat =~ s/D/$daytxt/g;
			$mytimeformat =~ s/YY//g;
			$mytimeformat =~ s/M//g;
			$mytimeformat =~ s/\+//g;
		}
		if ($newisdst && $usercheck{$username.'dsttimeoffset'} != 0) {
			$mytimeformat =~ s/\*/$maintxt{'dst'}/g;
		} else {
			$mytimeformat =~ s/\*//g;
		}
		$newformat = $mytimeformat;
	} elsif ($mytimeselected == 1) {
		$newformat = $daytxt ? qq~<b>[</b>$daytxt$shout_txt{'28b'}$newtime<b>]</b>~ : qq~<b>[</b>$newmonth/$newday$shout_txt{'28b'}$newtime<b>]</b>~;
	} elsif ($mytimeselected == 2) {
		$newformat = $daytxt ? qq~<b>[</b>$daytxt$shout_txt{'28b'}$newtime<b>]</b>~ : qq~<b>[</b>$newday.$newmonth$shout_txt{'28b'}$newtime<b>]</b>~;
	} elsif ($mytimeselected == 3) {
		$newformat = $daytxt ? qq~<b>[</b>$daytxt$shout_txt{'28b'}$newtime<b>]</b>~ : qq~<b>[</b>$newday.$newmonth$shout_txt{'28b'}$newtime<b>]</b>~;
	} elsif ($mytimeselected == 4) {
		$ampm = $newhour > 11 ? 'pm' : 'am';
		$newhour2 = $newhour % 12 || 12;
		$newmonth2 = $months[$newmonth - 1];
		if ($newday > 10 && $newday < 20) {
			$newday2 = "$timetxt{'4'}";
		} elsif ($newday % 10 == 1) {
			$newday2 = "$timetxt{'1'}";
		} elsif ($newday % 10 == 2) {
			$newday2 = "$timetxt{'2'}";
		} elsif ($newday % 10 == 3) {
			$newday2 = "$timetxt{'3'}";
		} else {
			$newday2 = "$timetxt{'4'}";
		}
		$newformat = $daytxt ? qq~<b>[</b>$daytxt$shout_txt{'28b'}$newhour2:$newminute$ampm<b>]</b>~ : qq~<b>[</b>$newmonth2 $newday$newday2$shout_txt{'28b'}$newhour2:$newminute$ampm<b>]</b>~;
	} elsif ($mytimeselected == 5) {
		$ampm = $newhour > 11 ? 'pm' : 'am';
		$newhour2 = $newhour % 12 || 12;
		$newformat = $daytxt ? qq~<b>[</b>$daytxt$shout_txt{'28b'}$newhour2:$newminute$ampm<b>]</b>~ : qq~<b>[</b>$newmonth/$newday$shout_txt{'28b'}$newhour2:$newminute$ampm<b>]</b>~;
	} elsif ($mytimeselected == 6) {
		$newmonth2 = $months[$newmonth - 1];
		$newformat = $daytxt ? qq~<b>[</b>$daytxt$shout_txt{'28b'}$newhour:$newminute<b>]</b>~ : qq~<b>[</b>$newday. $newmonth2$shout_txt{'28b'}$newhour:$newminute<b>]</b>~;
	}
	return $newformat;
}

sub Timer {
	$time_running = time - $START_TIME;
	$time_running = sprintf("%.4f", $time_running);
	print qq~

<!-- Ran for $time_running seconds  -  Accessed $file_open files-->
~;

}


sub ShowExtras {
	# Multiply by 1000, because JS uses millseconds
	if ($usercheck{$username.'lp_shout_refresh'} >= 10) {
		$refresh = ($usercheck{$username.'lp_shout_refresh'}*1000);
		$refresh_js = qq~
/* Scrolls page, and sets timer for autorefreshing */
function timer() {
	window.scrollTo(0,99999);
	setTimeout("reload_page()", $refresh);
}

/* Reloads page if message is default or blank */
function reload_page() {
	if (document.shoutbox.message.value == "") {
		window.location.reload();
	}
}
		~;
	} else {
		$refresh_js = qq~
/* Scrolls page, and sets timer for autorefreshing */
function timer() {
	window.scrollTo(0,99999);
}
		~;
	}
	if ($usercheck{$username.'on_load_focus'}) {
		$shoutbox_on_load_focus = qq~ document.shoutbox.message.focus();~;}
	else {$shoutbox_on_load_focus = "";}


	if ($usercheck{$username.'lp_shout_smileys'}) {
		$smiley_bar = qq~
<script language="JavaScript1.2" type="text/javascript">
<!--
if((navigator.appName == "Netscape" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Microsoft Internet Explorer" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Opera" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Konqueror" && navigator.appVersion.charAt(0) >= 2)) {
	HAND = "style='cursor: pointer;'";
	document.write("<img src='$imagesdir/smiley.gif' onclick='smiley();' "+HAND+" align=bottom alt='$post_txt{'287'}' border='0'> ");
	document.write("<img src='$imagesdir/wink.gif' onclick='wink();' "+HAND+" align=bottom alt='$post_txt{'292'}' border='0'> ");
	document.write("<img src='$imagesdir/cheesy.gif' onclick='cheesy();' "+HAND+" align=bottom alt='$post_txt{'289'}' border='0'> ");
	document.write("<img src='$imagesdir/grin.gif' onclick='grin();' "+HAND+" align=bottom alt='$post_txt{'293'}' border='0'> ");
	document.write("<img src='$imagesdir/angry.gif' onclick='angry();' "+HAND+" align=bottom alt='$post_txt{'288'}' border='0'> ");
	document.write("<img src='$imagesdir/sad.gif' onclick='sad();' "+HAND+" align=bottom alt='$post_txt{'291'}' border='0'> ");
	document.write("<img src='$imagesdir/shocked.gif' onclick='shocked();' "+HAND+" align=bottom alt='$post_txt{'294'}' border='0'> ");
	document.write("<img src='$imagesdir/cool.gif' onclick='cool();' "+HAND+" align=bottom alt='$post_txt{'295'}' border='0'> ");
	document.write("$autobr<img src='$imagesdir/huh.gif' onclick='huh();' "+HAND+" align=bottom alt='$post_txt{'296'}' border='0'> ");
	document.write("<img src='$imagesdir/rolleyes.gif' onclick='rolleyes();' "+HAND+" align=bottom alt='$post_txt{'450'}' border='0'> ");
	document.write("<img src='$imagesdir/tongue.gif' onclick='tongue();' "+HAND+" align=bottom alt='$post_txt{'451'}' border='0'> ");
	document.write("<img src='$imagesdir/embarassed.gif' onclick='embarassed();' "+HAND+" align=bottom alt='$post_txt{'526'}' border='0'> ");
	document.write("<img src='$imagesdir/lipsrsealed.gif' onclick='lipsrsealed();' "+HAND+" align=bottom alt='$post_txt{'527'}' border='0'> ");
	document.write("<img src='$imagesdir/undecided.gif' onclick='undecided();' "+HAND+" align=bottom alt='$post_txt{'528'}' border='0'> ");
	document.write("<img src='$imagesdir/kiss.gif' onclick='kiss();' "+HAND+" align=bottom alt='$post_txt{'529'}' border='0'> ");
	document.write("<img src='$imagesdir/cry.gif' onclick='cry();' "+HAND+" align=bottom alt='$post_txt{'530'}' border='0'> ");$moresmilieslist
} else {
	document.write("<span  class='small'>$post_txt{'215'}</span>");
}
//-->
</script>
		~;
	}

	if ($usercheck{$username.'lp_shout_bbcode'} && $enable_ubbc) {
		$bbcode_bar = qq~
<script language="JavaScript1.2" type="text/javascript">
<!--
if((navigator.appName == "Netscape" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Microsoft Internet Explorer" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Opera" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Konqueror" && navigator.appVersion.charAt(0) >= 2)) {
		HAND = "style='cursor: pointer;'";
		document.write("<img src='$imagesdir/bold.gif' onclick='bold();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'253'}' border=0>");
		document.write("<img src='$imagesdir/italicize.gif' onclick='italicize();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'254'}' border='0'>");
		document.write("<img src='$imagesdir/underline.gif' onclick='underline();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'255'}' border='0'>");
		document.write("<img src='$imagesdir/strike.gif' onclick='strike();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'441'}' border='0'>");
		document.write("<img src='$imagesdir/move.gif' onclick='move();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'439'}' border='0'>");
		document.write("<img src='$imagesdir/size.gif' onclick='size();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'532'}' border='0'>");
		document.write("<img src='$imagesdir/face.gif' onclick='font();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'533'}' border='0'>");
		document.write("<img src='$imagesdir/url.gif' onclick='hyperlink();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'257'}' border='0'>");
		document.write("<img src='$imagesdir/email2.gif' onclick='emai1();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'258'}' border='0'>");
		document.write("<img src='$imagesdir/sup.gif' onclick='superscript();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'447'}' border='0'>");
		document.write("<img src='$imagesdir/sub.gif' onclick='subscript();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'448'}' border='0'>");
} else {
	document.write("<span  class='small'>$post_txt{'215'}</span>");
}
//-->
</script>
		~;
	}
}
sub Template 	{
	&ShowExtras;
	print qq~Content-type:text/html\n\n~;
	print qq~<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>Shoutbox</title>
<meta http-equiv="Content-Type" content="text/html; charset=$yycharset" />
<meta http-equiv="pragma" content="no-cache" />
<link rel="stylesheet" href="$forumstylesurl/$usestyle.css" type="text/css" />
<script language="JavaScript1.2" src="$yyhtml_root/shoutnew.js" type="text/javascript"></script>
<script language="JavaScript1.2" type="text/javascript">
<!--
/* Opens windows for smilies and previous shouts */
function openWindow(theURL,winName,features) {
  window.open(theURL,winName,features);
}

/* clears default values from input boxes */
function clearText(thefield) {
	if (thefield.defaultValue==thefield.value)
	thefield.value = ""
}

/* Uses hidden form fields so message never disappears accidentally */


function changevalue() {
	if (document.shoutbox.message.defaultValue == document.shoutbox.message.value)
		{
		alert("$shout_txt{'45'}");
		return false;
		}
	else
		{
		document.shoutbox.shoutout.value = document.shoutbox.message.value;
		document.shoutbox.message.value = "";
		}
 }

$refresh_js
// -->
</script>

</head>

<body onload="timer(); $shoutbox_on_load_focus" style="min-width:0px;">
<div style="position:relative;bottom:$shout_text_height3$px;">
<table width="100%" cellpadding="0" cellspacing="0" border="0">
 <tr>
<td>
$shout_rows
</td>
</div><td>
<div class="shout_postarea" style="position:fixed;bottom:0px;padding-top:8px;height:$shout_text_height2$px;align:center;">
                $bbcode_bar
		<form name="shoutbox" action="$shoutform_action" method="post" onSubmit="changevalue()">
			<input type="hidden" name="shoutout" maxlength="$max_shout_length" />
			<input type="hidden" name="formsession" value="$formsession" /><br />
			<input type="text" name="message" size="30" maxlength="$max_shout_length" onfocus="clearText(this)" value="" />
			<input type="submit" name="Submit" value="$shout_txt{'31'}" />
		</form><br />
                $smiley_bar<br />
		<a href="./ShoutDisplay.pl?showall=1" target="_new">$shout_txt{'32'}</a>
		&nbsp;//&nbsp;
		<a href="javascript:openWindow('$scripturl?action=shout_smilies','smilies','scrollbars=yes,width=360,height=300')">$shout_txt{'33'}</a>
	<br />
    	<a href="javascript:window.location.reload();">$shout_txt{'34'}</a>
</div></td>

  </tr>
</table>
~;

	&Timer;

	print qq~
</body>
</html>
~;


}

1;
