#########################################################################################
# Shoutbox.pl : Part of the Shoutbox 2.3.1 Mod
# Copyright:       2005 Andrew Aitken (LoonyPandora)

# Version:         Shoutbox 2.3.1 RC4.1

# Released:        2nd March, 2009

# Distributed By:  http://www.boardmod.org

# 2.3.1 update by: Batchman, Derek Barnstorm, D0T-C0M, Driven, Unilat, ThM with permission
##########################################################################################

$shoutboxplver = 'Shoutbox Mod 2.3.1 RC4.1';


if ($action eq 'detailedversion') { return 1; }


LoadLanguage("Post");

LoadLanguage("Shoutbox");


if (!-e "$vardir/shoutsettings.txt") {
 &fatal_error("$shout_txt{'7'}");
 }
else {
 require "$vardir/shoutsettings.txt";
 }



sub WriteShouts {


	#&spam_protection;

	&CheckCanShout;


	my $shout_message  = $FORM{'shoutout'};

	my $shout_username = $username;

	my $shout_name     = ${$uid.$username}{'realname'};

	our $shout_time = &GetShoutTime;


	if ($shout_message) {

		$shout_message = &WriteSpecialChars($shout_message);


		$new_shout = qq~$shout_time|$shout_name|$shout_username|$shout_message\n~;


		fopen(SHOUTS, "+<$vardir/shouts.txt");

		@shouts = <SHOUTS>;


		push(@shouts, $new_shout);

		if ($#shouts > $maximum_shouts) { shift(@shouts); }


		seek SHOUTS, 0, 0;

		truncate SHOUTS, 0;

		print SHOUTS @shouts;


		fclose(SHOUTS);

	}


	if (!$iamguest) { &UpdateShoutCount; }


	if ($INFO{'showall'}) { $yySetLocation = qq~$boardurl/ShoutDisplay.pl?showall=1~; }

	else { $yySetLocation = qq~$boardurl/ShoutDisplay.pl~; }


	&redirectexit;

}



sub UpdateShoutCount {


	# Increment shout count

	${$uid.$username}{'lp_shoutcount'}++;

	${$uid.$username}{'lp_lastshout'} = $shout_time;

	&UserAccount($username, "update");

}



sub GetShoutTime {

	my $shout_time = int(time);

	return $shout_time;

}



sub WriteSpecialChars {

	$message = $_[0];

	&ToHTML($message);


	# Remove img tags

	$message =~ s~\[img(.*)?\](.*)\[/img\]~$2~i;

	$message =~ s~\[size=(.+?)\](.+?)\[/size\]~&my_sizefont($1,$2)~eisg;


	return $message;

}



sub my_sizefont {


	# limit minimum and maximum font pitch as CSS does not restrict it at all

	my ($tsize, $ttext) = @_;

	$fontsizemax = 20;

	$fontsizemin = 6;

	if    ($tsize < $fontsizemin) { $tsize = $fontsizemin; }

	elsif ($tsize > $fontsizemax) { $tsize = $fontsizemax; }

	my $resized = qq~\[size=$tsize]$ttext\[/size]~;

	return $resized;

}



sub UserRemoveShouts {

	$shout_name = $INFO{'user'};
	if ($username eq $shout_name || $iamadmin) { 
            $shout_to_delete = $INFO{'shout'};


		fopen(SHOUTS, "+<$vardir/shouts.txt") || &fatal_error("$shout_txt{'8'} $vardir/shouts.txt - $!", 1);

		my $buffer = 1;

		my $found  = 0;

		while ($buffer) {

			$offset = tell SHOUTS;

			$buffer = <SHOUTS>;

			if ($buffer =~ m~\A$shout_to_delete~) {

				$slice = ($. - 1);

				$found = 1;

				last;

			}

		}


		if ($found) {

			seek SHOUTS, 0, 0;

			my @contents = <SHOUTS>;

			$contents[$slice] = q~~;

			seek SHOUTS, 0, 0;

			truncate SHOUTS, 0;

			print SHOUTS @contents;

		}


		fclose(SHOUTS);


		if ($INFO{'showall'}) { $yySetLocation = qq~$boardurl/ShoutDisplay.pl?showall=1~; }

		else { $yySetLocation = qq~$boardurl/ShoutDisplay.pl~; }


		&redirectexit;


	} else {
	&fatal_error('shout_delete'); 
	}

} 


sub ShoutSmileys {

	if ($smiliestyle eq 1) { $smiliewinlink = "$scripturl?action=smilieput"; }

	else { $smiliewinlink = "$scripturl?action=smilieindex"; }


	print qq~Content-type:text/html\n\n~;

	print qq~
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>Shoutbox</title>
<meta http-equiv="Content-Type" content="text/html; charset=$yycharset" />
<link rel="stylesheet" href="$forumstylesurl/$usestyle.css" type="text/css" />
</head>
<body>
<div style="float: left; width: 360px;">
<br />
<form name="addsmileys">
~;


	&ShoutBBCode;

	&NormalSmileys;

	&AddMoreSmileys;

}



sub ShoutBBCode {
	print qq~<script language="JavaScript1.2" src="$yyhtml_root/shout.js" type="text/javascript"></script>~;
	if ($enable_ubbc && $showyabbcbutt) {
		print qq~
<table align="center">
  <tr>
     <td valign="middle" class="windowbg2">
        <script language="JavaScript1.2" type="text/javascript">
        <!--
        if((navigator.appName == "Netscape" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Microsoft Internet Explorer" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Opera" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "WebTV Plus Receiver" && navigator.appVersion.charAt(0) >= 3) || (navigator.appName == "Konqueror" && navigator.appVersion.charAt(0) >= 2)) {
          HAND = "onmouseover=this.style.cursor='hand'";
          document.write("<img src='$imagesdir/bold.gif' onclick='bold();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'253'}' border=0>");
          document.write("<img src='$imagesdir/italicize.gif' onclick='italicize();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'254'}' border='0'>");
          document.write("<img src='$imagesdir/underline.gif' onclick='underline();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'255'}' border='0'>");
          document.write("<img src='$imagesdir/strike.gif' onclick='strike();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'441'}' border='0'>");
          document.write("<img src='$imagesdir/move.gif' onclick='move();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'439'}' border='0'>");
          document.write("<img src='$imagesdir/size.gif' onclick='size();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'532'}' border='0'>");
          document.write("<img src='$imagesdir/face.gif' onclick='font();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'533'}' border='0'>");
          document.write("<img src='$imagesdir/url.gif' onclick='hyperlink();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'257'}' border='0'>");
          document.write("<img src='$imagesdir/email2.gif' onclick='emai1();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'258'}' border='0'>");
          document.write("<img src='$imagesdir/sup.gif' onclick='superscript();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'447'}' border='0'>");
          document.write("<img src='$imagesdir/sub.gif' onclick='subscript();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'448'}' border='0'>");
        }
        else { document.write("<span class='small'>$post_txt{'215'}</span>"); }
        //-->
        </script>
        </td>
      </tr>
	</table>
~;
	}

	# Change Colour section
	print qq~
<table align="center">
	<tr>
	  <td align="center">
		$shout_txt{'35'}
	  </td>
	</tr>
	<tr>
	  <td align="center">
        <select name="color" onchange="showcolor(this.options[this.selectedIndex].value)">
         <option value="Black" selected="selected">$post_txt{'262'}</option>
         <option value="Red">$post_txt{'263'}</option>
         <option value="Yellow">$post_txt{'264'}</option>
         <option value="Pink">$post_txt{'265'}</option>
         <option value="Green">$post_txt{'266'}</option>
         <option value="Orange">$post_txt{'267'}</option>
         <option value="Purple">$post_txt{'268'}</option>
         <option value="Blue">$post_txt{'269'}</option>
         <option value="Beige">$post_txt{'270'}</option>
         <option value="Brown">$post_txt{'271'}</option>
         <option value="Teal">$post_txt{'272'}</option>
         <option value="Navy">$post_txt{'273'}</option>
         <option value="Maroon">$post_txt{'274'}</option>
         <option value="LimeGreen">$post_txt{'275'}</option>
        </select>
	  </td>
	</tr>
</table><br />
~;
}

sub NormalSmileys {
	print qq~
<table align="center">
      <tr>
        <td valign="middle">
        <script language="JavaScript1.2" type="text/javascript">
        <!--
        if((navigator.appName == "Netscape" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Microsoft Internet Explorer" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Opera" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Konqueror" && navigator.appVersion.charAt(0) >= 2)) {
          HAND = "onmouseover=this.style.cursor='hand'";
          document.write("<img src='$imagesdir/smiley.gif' onclick='smiley();' "+HAND+" align=bottom alt='$post_txt{'287'}' border='0'> ");
          document.write("<img src='$imagesdir/wink.gif' onclick='wink();' "+HAND+" align=bottom alt='$post_txt{'292'}' border='0'> ");
          document.write("<img src='$imagesdir/cheesy.gif' onclick='cheesy();' "+HAND+" align=bottom alt='$post_txt{'289'}' border='0'> ");
          document.write("<img src='$imagesdir/grin.gif' onclick='grin();' "+HAND+" align=bottom alt='$post_txt{'293'}' border='0'> ");
          document.write("<img src='$imagesdir/angry.gif' onclick='angry();' "+HAND+" align=bottom alt='$post_txt{'288'}' border='0'> ");
          document.write("<img src='$imagesdir/sad.gif' onclick='sad();' "+HAND+" align=bottom alt='$post_txt{'291'}' border='0'> ");
          document.write("<img src='$imagesdir/shocked.gif' onclick='shocked();' "+HAND+" align=bottom alt='$post_txt{'294'}' border='0'> ");
          document.write("<img src='$imagesdir/cool.gif' onclick='cool();' "+HAND+" align=bottom alt='$post_txt{'295'}' border='0'> ");
          document.write("<img src='$imagesdir/huh.gif' onclick='huh();' "+HAND+" align=bottom alt='$post_txt{'296'}' border='0'> ");
          document.write("<img src='$imagesdir/rolleyes.gif' onclick='rolleyes();' "+HAND+" align=bottom alt='$post_txt{'450'}' border='0'> ");
          document.write("<img src='$imagesdir/tongue.gif' onclick='tongue();' "+HAND+" align=bottom alt='$post_txt{'451'}' border='0'> ");
          document.write("<img src='$imagesdir/embarassed.gif' onclick='embarassed();' "+HAND+" align=bottom alt='$post_txt{'526'}' border='0'> ");
          document.write("<img src='$imagesdir/lipsrsealed.gif' onclick='lipsrsealed();' "+HAND+" align=bottom alt='$post_txt{'527'}' border='0'> ");
          document.write("<img src='$imagesdir/undecided.gif' onclick='undecided();' "+HAND+" align=bottom alt='$post_txt{'528'}' border='0'> ");
          document.write("<img src='$imagesdir/kiss.gif' onclick='kiss();' "+HAND+" align=bottom alt='$post_txt{'529'}' border='0'> ");
          document.write("<img src='$imagesdir/cry.gif' onclick='cry();' "+HAND+" align=bottom alt='$post_txt{'530'}' border='0'> ");$moresmilieslist
        }
        else { document.write("<span  class='small'>$post_txt{'215'}</span>"); }
        //-->
        </script>
		</td></tr>
	</table>
~;
}

sub AddMoreSmileys {
	print qq~
	<script language="JavaScript1.2" type="text/javascript">
	<!--
		function Smiliextra() {
		AddTxt=smiliecode[document.addsmileys.smiliextra_list.value];
		AddText(AddTxt);
		}

		function smiliewin() {
		window.open("$smiliewinlink", 'list', 'width=$winwidth,height=$winheight, scrollbars=yes');
		}

		function showimage() {
		document.images.icons.src="$imagesdir/"+document.addsmileys.icon.options[document.addsmileys.icon.selectedIndex].value+".gif";
		}
    //-->
	</script>
	<noscript>Cannot use smileys, as you do not have JavaScript enabled</noscript>
	<br />
~;

	opendir(DIR, "$smiliesdir");
	@contents = readdir(DIR);
	closedir(DIR);
	$i = 0;
	foreach $line (sort { uc($a) cmp uc($b) } @contents) {
		($name, $extension) = split(/\./, $line);
		if ($extension =~ /gif/i || $extension =~ /jpg/i || $extension =~ /jpeg/i || $extension =~ /png/i) {
			if ($line !~ /banner/i) {
				$smilieslist       .= qq~           document.write("<option value='$i'>$name");\n~;
				$smilie_url_array  .= qq~"$smiliesurl/$line", ~;
				$smilie_code_array .= qq~" [smiley=$line]", ~;
				$i++;
			}
		}
	}
	$smilie_url_array  .= qq~""~;
	$smilie_code_array .= qq~""~;

	print qq~
	<script language="JavaScript1.2" type="text/javascript">
	<!--
	smilieurl = new Array($smilie_url_array)
	smiliecode = new Array($smilie_code_array)

        if((navigator.appName == "Netscape" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Microsoft Internet Explorer" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Opera" && navigator.appVersion.charAt(0) >= 4)) {

          document.write('<table height="110" width="120" border="0" cellpadding="3" cellspacing="1" align="center" class="bordercolor"><tr>');
          document.write('<td height="20" align="center" valign="top" class="windowbg2"><select name="smiliextra_list" onchange="document.images.smiliextra_image.src= smilieurl[document.addsmileys .smiliextra_list.value]" style="width:120px; font-size:7pt">');
$smilieslist
          document.write('</select></td>');
          document.write('</tr><tr>');
          document.write('<td align="center" valign="middle" class="windowbg2"><img name="smiliextra_image" src="'+smilieurl[0]+'" alt="" border="0" onclick="javascript:Smiliextra()" style="cursor:hand"></td>');
          document.write('</tr></table>');
	}
        //-->
        </script>
		</form>
		<br /><br />~;

	print qq~
	</div>
		</body>
		</html>
        ~;

}

sub CheckCanShout {
	($shout_mute_days, $shout_mute_until) = split(/\|/, ${$uid.$username}{'lp_shout_muted'});

	if ($iamguest) {
		print qq~Content-type:text/html\n\n~;
		print qq~
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>Shoutbox</title>
<meta http-equiv="Content-Type" content="text/html; charset=$yycharset" />
<meta http-equiv="pragma" CONTENT="no-cache" />
<link rel="stylesheet" href="$forumstylesurl/$usestyle.css" type="text/css" />
</head>

<span class="small">$shout_txt{'15'}<br /><br />
$shout_txt{'16'} <a href="$scripturl?action=register" target="_blank">$scripturl</a>
</span>

<br /><br />
<a href="$boardurl/ShoutDisplay.pl">$shout_txt{'11'}</a>
</body>
</html>~;

		exit;

	} elsif ($shout_mute_until > int(time)) {

		print qq~Content-type:text/html\n\n~;
		print qq~
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>Shoutbox</title>
<meta http-equiv="Content-Type" content="text/html; charset=$yycharset" />
<meta http-equiv="pragma" CONTENT="no-cache" />
<link rel="stylesheet" href="$forumstylesurl/$usestyle.css" type="text/css" />
</head>

<span class="small">$shout_txt{'9'}<br /><br />
${$uid.$username}{'lp_shout_mute_reason'}<br /><br />
$shout_txt{'10'} $shout_mute_days $shout_txt{'17'}</span>

<br /><br />
<a href="$boardurl/ShoutDisplay.pl">$shout_txt{'11'}</a>
</body>
</html>~;

		exit;

	} elsif (${$uid.$username}{'postcount'} < $min_posts) {

		print qq~Content-type:text/html\n\n~;
		print qq~
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>Shoutbox</title>
<meta http-equiv="Content-Type" content="text/html; charset=$yycharset" />
<meta http-equiv="pragma" CONTENT="no-cache" />
<link rel="stylesheet" href="$forumstylesurl/$usestyle.css" type="text/css" />
</head>

<span class="small">$shout_txt{'12'} $min_posts times $shout_txt{'13'}<br /><br />
$shout_txt{'14'}<br /><a href="$scripturl">$scripturl</a></span>

<br /><br />
<a href="$boardurl/ShoutDisplay.pl">$shout_txt{'11'}</a>
</body>
</html>~;


		exit;

	}

}


1;
