#################################################################################################
# ShoutAdmin.pl: 	Part of the Shoutbox 2.4 Mod						#
# Copyright:       	2005 Andrew Aitken (LoonyPandora)					#
# Version:         	Shoutbox RC5.5 for YaBB 2.4						#
# Released:        	13th May, 2009								#
# Distributed by:  	http://www.boardmod.org							#
# Update by:	 	Batchman, Derek Barnstorm, D0T-C0M, Driven, Unilat, ThM with permission	#
#################################################################################################

$shoutadminplver = 'Shoutbox Mod for YaBB 2.4 RC5.5';

if ($action eq 'detailedversion') { return 1; }

LoadLanguage("Post");
LoadLanguage("Shoutbox");

sub my_wrap3 {
	$message =~ s~(<.*>)*(\S{0,14})(\S*)?(<.*>)*~$1$2 $3$4~gi;
	$message =~ s~(<.*>)?(\S{0,14})(\S*)(<\/\S*>)~$1$2 $3$4~gi;
	$message =~ s~\s+~ ~gi;
}

sub RemoveShouts {

	(@delshouts) = split(/,\s*/, $FORM{'delcheckbox'});

	fopen(SHOUTS, "+<$vardir/shouts.txt");
	@shouts = <SHOUTS>;

	foreach $shout_to_delete (@delshouts) {
		if ($iamadmin || $iamgmod && $allow_mod == 1) {

			$line_count = 0;

			foreach $shoutline (@shouts) {
				chomp;
				($shout_time, $dummy, $dummy, $dummy) = split(/[\|]/, $shoutline);

				unless ($shout_time != $shout_to_delete) {
					$line_number = $line_count;
					last;
				}
				$line_count++;
			}
			$shouts[$line_number] = '';
		}
	}

	seek SHOUTS, 0, 0;
	truncate SHOUTS, 0;
	print SHOUTS @shouts;
	fclose(SHOUTS);

	$yymain .= qq~<center>$shout_txt{'42'}<br /><br /><a href="$boarddir/AdminIndex.pl?action=shoutadmin">$shout_txt{'44'}</a></center>~;
	&AdminTemplate;
}

sub ShoutSettings2 {
	&is_admin_or_gmod;

	my @onoff = qw/enable_sb enable_gr enable_ubbc enable_censor enable_limiter enable_tdmouseover enable_autoscroll as_window_resize/;

	# Set as 0 or 1 if box was checked or not
	my $fi;
	map { $fi = lc $_; ${$_} = $FORM{$fi} eq 'on' ? 1 : 0; } @onoff;

	$name_sb       	       = $FORM{'name_sb'}               || "";
	$min_posts             = $FORM{'min_posts'}             || "0";
	$maximum_shouts        = $FORM{'maximum_shouts'}        || "250";
	$max_disp_shouts       = $FORM{'max_disp_shouts'}       || "20";
	$max_shout_length      = $FORM{'max_shout_length'}      || "500";
	$max_admin_disp_shouts = $FORM{'max_admin_disp_shouts'} || "30";
	$delete_delay          = $FORM{'delete_delay'}          || "0";
	$shout_width           = $FORM{'shout_width'}           || "315";
	$shout_height          = $FORM{'shout_height'}          || "350";
	$sb_border_color       = $FORM{'sb_border_color'}       || "";
	$sb_border_style       = $FORM{'sb_border_style'}       || "";
	$sb_border_thickness   = $FORM{'sb_border_thickness'}   || "";
	$speedup               = $FORM{'speedup'}               || "";
	$speeddown             = $FORM{'speeddown'}             || "";
	$show_scrollbar        = $FORM{'show_scrollbar'}        || "";
	$sb_basecolor	       = $FORM{'sb_basecolor'}        	|| "";
	$sb_3dlightcolor       = $FORM{'sb_3dlightcolor'}      	|| "";
	$sb_arrowcolor         = $FORM{'sb_arrowcolor'}      	|| "";
	$sb_darkshadowcolor    = $FORM{'sb_darkshadowcolor'}   	|| "";
	$sb_facecolor	       = $FORM{'sb_facecolor'}        	|| "";
	$sb_highlightcolor     = $FORM{'sb_highlightcolor'}    	|| "";
	$sb_shadowcolor	       = $FORM{'sb_shadowcolor'}       	|| "";
	$sb_trackcolor	       = $FORM{'sb_trackcolor'}        	|| "";
	$mo_window_width       = $FORM{'mo_window_width'}       || "360";
	$mo_window_height      = $FORM{'mo_window_height'}      || "300";
	$as_window_width       = $FORM{'as_window_width'}       || "360";
	$as_window_height      = $FORM{'as_window_height'}      || "600";
	$censor_lang           = $FORM{'censor_lang'}           || "English";
	$admin_deletion_link   = $FORM{'admin_deletion_link'}   || "0";

	my $setfile = qq~
#################################################################################################
# shoutsettings.txt: 	Part of the Shoutbox 2.4 Mod						#
# Copyright:       	2005 Andrew Aitken (LoonyPandora)					#
# Version:         	Shoutbox RC5.5 for YaBB 2.4						#
# Released:        	13th May, 2009								#
# Distributed by:  	http://www.boardmod.org							#
# Update by: 		Batchman, Derek Barnstorm, D0T-C0M, Driven, ThM, Unilat with permission	#
#################################################################################################

\$enable_sb = "$enable_sb";
\$enable_gr = "$enable_gr";
\$name_sb = "$name_sb";
\$min_posts = "$min_posts";
\$maximum_shouts = "$maximum_shouts";
\$max_disp_shouts = "$max_disp_shouts";
\$max_shout_length = "$max_shout_length";
\$enable_limiter = "$enable_limiter";
\$max_admin_disp_shouts = "$max_admin_disp_shouts";
\$delete_delay = "$delete_delay";
\$shout_width = "$shout_width";
\$shout_height = "$shout_height";
\$sb_border_color = "$sb_border_color";
\$sb_border_style = "$sb_border_style";
\$sb_border_thickness = "$sb_border_thickness";
\$enable_tdmouseover = "$enable_tdmouseover";
\$show_scrollbar = "$show_scrollbar";
\$sb_basecolor = "$sb_basecolor";
\$sb_3dlightcolor = "$sb_3dlightcolor";
\$sb_arrowcolor = "$sb_arrowcolor";
\$sb_darkshadowcolor = "$sb_darkshadowcolor";
\$sb_facecolor = "$sb_facecolor";
\$sb_highlightcolor = "$sb_highlightcolor";
\$sb_shadowcolor = "$sb_shadowcolor";
\$sb_trackcolor = "$sb_trackcolor";
\$enable_autoscroll = "$enable_autoscroll";
\$speedup = "$speedup";
\$speeddown = "$speeddown";
\$mo_window_width = "$mo_window_width";
\$mo_window_height = "$mo_window_height";
\$as_window_width = "$as_window_width";
\$as_window_height = "$as_window_height";
\$as_window_resize = "$as_window_resize";
\$admin_deletion_link = "$admin_deletion_link";
\$enable_ubbc = "$enable_ubbc";
\$enable_censor = "$enable_censor";
\$censor_lang = "$censor_lang";

1;
~;

	fopen(FILE, ">$vardir/shoutsettings.txt");
	print FILE $setfile;
	fclose(FILE);

	$yySetLocation = qq~$boarddir/AdminIndex.pl?action=shoutadmin~;
	&redirectexit;
}

sub ShoutAdmin {
	if (-e "$vardir/shoutsettings.txt") { require "$vardir/shoutsettings.txt"; }

	if ($enable_sb)   { $enable_sb_check   = q~ checked="checked"~; }
	if ($enable_gr)   { $enable_gr_check   = q~ checked="checked"~; }
	if ($enable_ubbc)   { $enable_ubbc_check   = q~ checked="checked"~; }
	if ($enable_censor) { $enable_censor_check = q~ checked="checked"~; }
	if ($admin_deletion_link) {$admin_deletion_link_check = q~ checked="checked"~; }
	if ($as_window_resize) {$as_window_resize_check = q~ checked="checked"~; }
	if ($enable_limiter) {$enable_limiter_check = q~ checked="checked"~; }
	if ($enable_tdmouseover) {$enable_tdmouseover_check = q~ checked="checked"~; }
	if ($enable_autoscroll) {$enable_autoscroll_check = q~ checked="checked"~; }
	if ($enable_scrollbar) {$enable_scrollbar_check = q~ checked="checked"~; }

	opendir(dir, $langdir);
	my @lfilesanddirs = readdir(dir);
	close(dir);
	$drawnldirs .= qq~<option value=""></option>~;
	foreach $fld (@lfilesanddirs) {
		if (-d "$langdir/$fld" && $fld =~ m^\A[0-9a-zA-Z_\#\%\-\:\+\?\$\&\~\,\@/]+\Z^) {
			if ($censor_lang eq $fld) { $drawnldirs .= qq~<option value="$fld" selected="selected">$fld</option>~; }
			else { $drawnldirs .= qq~<option value="$fld">$fld</option>~; }
		}
	}

	$iframebs = qq~
         <option selected="selected">$sb_border_style</option>
         <option value="none">$shout_txt{'52a_1'}</option>
         <option value="dotted">$shout_txt{'52a_2'}</option>
         <option value="dashed">$shout_txt{'52a_3'}</option>
         <option value="solid">$shout_txt{'52a_4'}</option>
         <option value="double">$shout_txt{'52a_5'}</option>
         <option value="grove">$shout_txt{'52a_6'}</option>
         <option value="ridge">$shout_txt{'52a_7'}</option>
         <option value="inset">$shout_txt{'52a_8'}</option>
         <option value="outset">$shout_txt{'52a_9'}</option>~;

	$iframebt = qq~
         <option selected="selected">$sb_border_thickness</option>
         <option value="1px">1px</option>
         <option value="2px">2px</option>
         <option value="3px">3px</option>
         <option value="4px">4x</option>
         <option value="5px">5px</option>
         <option value="6px">6px</option>
         <option value="7px">7px</option>
         <option value="8px">8px</option>
         <option value="9px">9px</option>
         <option value="10px">10px</option>~;

	$scrollspeed_up = qq~
	 <option selected="selected">$speedup</option>
         <option value="-1">-1</option>
         <option value="-2">-2</option>
         <option value="-3">-3</option>
         <option value="-4">-4</option>
         <option value="-5">-5</option>~;

	$scrollspeed_down = qq~
         <option selected="selected">$speeddown</option>
         <option value="1">1</option>
         <option value="2">2</option>
         <option value="3">3</option>
         <option value="4">4</option>
         <option value="5">5</option>~;

	$scrollbar = qq~
         <option selected="selected">$show_scrollbar</option>
         <option value="auto">$shout_txt{'52a_21'}</option>
         <option value="no">$shout_txt{'52a_22'}</option>
         <option value="yes">$shout_txt{'52a_23'}</option>~;


	$yymain .= qq~

	<div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
	 <table width="100%" cellspacing="1" cellpadding="4">
     	  <tr valign="middle">
       	   <td align="left" class="titlebg" colspan="2"><b>$shout_txt{'41a'}</b></td>
          </tr>
         <tr valign="middle">
           <td align="left" class="windowbg2">$shout_txt{'54'}</td>
         </tr>
	</table>
       </div><br />

	<form action="$adminurl?action=shoutsettings2" method="post">
	<div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
	<table width="100%" cellspacing="1" cellpadding="4">
     <colgroup>
			<col width="50%" />
			<col width="50%" />
     </colgroup>
     <tr valign="middle">
       <td align="left" class="titlebg" colspan="2"><img src="$imagesdir/preferences.gif" alt="" border="0" /><b>$shout_txt{'41'}</b></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'58'}</td>
    <td align="left" class="windowbg2"><input type="checkbox" name="enable_sb" $enable_sb_check /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'58a'}</td>
    <td align="left" class="windowbg2"><input type="checkbox" name="enable_gr" $enable_gr_check /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'59'}</td>
    <td align="left" class="windowbg2"><input type="text" name="name_sb" size="30" value="$name_sb" /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'18'}</td>
    <td align="left" class="windowbg2"><input type="text" name="min_posts" size="5" value="$min_posts" /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'19'}</td>
    <td align="left" class="windowbg2"><input type="text" name="maximum_shouts" size="5" value="$maximum_shouts" /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'20'}</td>
    <td align="left" class="windowbg2"><input type="text" name="max_disp_shouts" size="5" value="$max_disp_shouts" /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'21'}</td>
    <td align="left" class="windowbg2"><input type="text" name="max_shout_length" size="5" value="$max_shout_length" /></td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'21a'}</td>
    <td align="left" class="windowbg2"><input type="checkbox" name="enable_limiter" $enable_limiter_check /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'22'}</td>
    <td align="left" class="windowbg2"><input type="text" name="max_admin_disp_shouts" size="5" value="$max_admin_disp_shouts" /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'23'}</td>
    <td align="left" class="windowbg2"><input type="text" name="delete_delay" size="5" value="$delete_delay" /></td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'48'}</td>
    <td align="left" class="windowbg2"><input type="checkbox" name="admin_deletion_link" $admin_deletion_link_check /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'24'}</td>
    <td align="left" class="windowbg2"><input type="checkbox" name="enable_ubbc" $enable_ubbc_check /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'25'}</td>
    <td align="left" class="windowbg2"><input type="checkbox" name="enable_censor" $enable_censor_check /></td>
     </tr>    
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'26'}</td>
    <td align="left" class="windowbg2"><select name="censor_lang">$drawnldirs</select></td>
     </tr>
     <tr valign="middle">
       <td align="left" class="titlebg" colspan="2"><b><img src="$imagesdir/preferences.gif" alt="" border="0" />$shout_txt{'41b'}</b></td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'51'}</td>
    <td align="left" class="windowbg2"><input type="text" name="shout_width" size="5" value="$shout_width" /> $shout_txt{'60'}</td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52'}</td>
    <td align="left" class="windowbg2"><input type="text" name="shout_height" size="5" value="$shout_height" /> $shout_txt{'60'}</td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52a'}</td>
    <td align="left" class="windowbg2">$shout_txt{'52a_10'} <select name="sb_border_style">$iframebs</select> $shout_txt{'52a_12'} <select name="sb_border_thickness">$iframebt</select> $shout_txt{'52a_11'} <input type="text" size="7" maxlength="7" name="sb_border_color" value="$sb_border_color" onkeyup="previewColor_10(this.value);" /> <span id="sb_border_color2" style="background-color:$sb_border_color">&nbsp; &nbsp; &nbsp;</span> <img align="top" src="$imagesdir/palette1.gif" style="cursor: pointer" onclick="window.open('$scripturl?action=palette;task=templ_10', '', 'height=308,width=302,menubar=no,toolbar=no,scrollbars=no')" alt="" border="0" />
			<script language="JavaScript1.2" type="text/javascript">
			<!--
			function previewColor_10(color) {
				document.getElementById('sb_border_color2').style.background = color;
				document.getElementsByName("sb_border_color")[0].value = color;
			}
			//-->
			</script></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52a_13'}</td>
    <td align="left" class="windowbg2"><input type="checkbox" name="enable_tdmouseover" $enable_tdmouseover_check /></td>
     </tr>
     <tr valign="middle">
       <td align="left" class="titlebg" colspan="2"><b><img src="$imagesdir/preferences.gif" alt="" border="0" />$shout_txt{'52a_14'}</b></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52a_15'}</td>
    <td align="left" class="windowbg2"><input type="checkbox" name="enable_autoscroll" $enable_autoscroll_check /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52a_16'}</td>
    <td align="left" class="windowbg2"> $shout_txt{'52a_17'} <select name="speedup">$scrollspeed_up</select> $shout_txt{'52a_18'} <select name="speeddown">$scrollspeed_down</select></td>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52a_19'}</td>
    <td align="left" class="windowbg2">$shout_txt{'52a_20'} <select name="show_scrollbar">$scrollbar</select></td>
     </tr>  
     </tr>
     <tr valign="middle">
       <td align="left" class="titlebg" colspan="2"><img src="$imagesdir/preferences.gif" alt="" border="0" /><b>$shout_txt{'52a_32'}</b></td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2" colspan="2">$shout_txt{'52a_33'}</td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52a_24'}</td>
    <td align="left" class="windowbg2"><input type="text" size="7" maxlength="7" name="sb_basecolor" value="$sb_basecolor" onkeyup="previewColor(this.value);" /> <span id="sb_basecolor2" style="background-color:$sb_basecolor">&nbsp; &nbsp; &nbsp;</span> <img align="top" src="$imagesdir/palette1.gif" style="cursor: pointer" onclick="window.open('$scripturl?action=palette;task=templ', '', 'height=308,width=302,menubar=no,toolbar=no,scrollbars=no')" alt="" border="0" />
			<script language="JavaScript1.2" type="text/javascript">
			<!--
			function previewColor(color) {
				document.getElementById('sb_basecolor2').style.background = color;
				document.getElementsByName("sb_basecolor")[0].value = color;
			}
			//-->
			</script></td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52a_25'}</td>
    <td align="left" class="windowbg2"><input type="text" size="7" maxlength="7" name="sb_3dlightcolor" value="$sb_3dlightcolor" onkeyup="previewColor_0(this.value);" /> <span id="sb_3dlightcolor2" style="background-color:$sb_3dlightcolor">&nbsp; &nbsp; &nbsp;</span> <img align="top" src="$imagesdir/palette1.gif" style="cursor: pointer" onclick="window.open('$scripturl?action=palette;task=templ_0', '', 'height=308,width=302,menubar=no,toolbar=no,scrollbars=no')" alt="" border="0" />
			<script language="JavaScript1.2" type="text/javascript">
			<!--
			function previewColor_0(color) {
				document.getElementById('sb_3dlightcolor2').style.background = color;
				document.getElementsByName("sb_3dlightcolor")[0].value = color;
			}
			//-->
			</script></td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52a_26'}</td>
    <td align="left" class="windowbg2"><input type="text" size="7" maxlength="7" name="sb_arrowcolor" value="$sb_arrowcolor" onkeyup="previewColor_1(this.value);" /> <span id="sb_arrowcolor2" style="background-color:$sb_arrowcolor">&nbsp; &nbsp; &nbsp;</span> <img align="top" src="$imagesdir/palette1.gif" style="cursor: pointer" onclick="window.open('$scripturl?action=palette;task=templ_1', '', 'height=308,width=302,menubar=no,toolbar=no,scrollbars=no')" alt="" border="0" />
			<script language="JavaScript1.2" type="text/javascript">
			<!--
			function previewColor_1(color) {
				document.getElementById('sb_arrowcolor2').style.background = color;
				document.getElementsByName("sb_arrowcolor")[0].value = color;
			}
			//-->
			</script></td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52a_27'}</td>
    <td align="left" class="windowbg2"><input type="text" size="7" maxlength="7" name="sb_darkshadowcolor" value="$sb_darkshadowcolor" onkeyup="previewColor_5(this.value);" /> <span id="sb_darkshadowcolor2" style="background-color:$sb_darkshadowcolor">&nbsp; &nbsp; &nbsp;</span> <img align="top" src="$imagesdir/palette1.gif" style="cursor: pointer" onclick="window.open('$scripturl?action=palette;task=templ_5', '', 'height=308,width=302,menubar=no,toolbar=no,scrollbars=no')" alt="" border="0" />
			<script language="JavaScript1.2" type="text/javascript">
			<!--
			function previewColor_5(color) {
				document.getElementById('sb_darkshadowcolor2').style.background = color;
				document.getElementsByName("sb_darkshadowcolor")[0].value = color;
			}
			//-->
			</script></td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52a_28'}</td>
    <td align="left" class="windowbg2"><input type="text" size="7" maxlength="7" name="sb_facecolor" value="$sb_facecolor" onkeyup="previewColor_6(this.value);" /> <span id="sb_facecolor2" style="background-color:$sb_facecolor">&nbsp; &nbsp; &nbsp;</span> <img align="top" src="$imagesdir/palette1.gif" style="cursor: pointer" onclick="window.open('$scripturl?action=palette;task=templ_6', '', 'height=308,width=302,menubar=no,toolbar=no,scrollbars=no')" alt="" border="0" />
			<script language="JavaScript1.2" type="text/javascript">
			<!--
			function previewColor_6(color) {
				document.getElementById('sb_facecolor2').style.background = color;
				document.getElementsByName("sb_facecolor")[0].value = color;
			}
			//-->
			</script></td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52a_29'}</td>
    <td align="left" class="windowbg2"><input type="text" size="7" maxlength="7" name="sb_highlightcolor" value="$sb_highlightcolor" onkeyup="previewColor_7(this.value);" /> <span id="sb_highlightcolor2" style="background-color:$sb_highlightcolor">&nbsp; &nbsp; &nbsp;</span> <img align="top" src="$imagesdir/palette1.gif" style="cursor: pointer" onclick="window.open('$scripturl?action=palette;task=templ_7', '', 'height=308,width=302,menubar=no,toolbar=no,scrollbars=no')" alt="" border="0" />
			<script language="JavaScript1.2" type="text/javascript">
			<!--
			function previewColor_7(color) {
				document.getElementById('sb_highlightcolor2').style.background = color;
				document.getElementsByName("sb_highlightcolor")[0].value = color;
			}
			//-->
			</script></td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52a_30'}</td>
    <td align="left" class="windowbg2"><input type="text" size="7" maxlength="7" name="sb_shadowcolor" value="$sb_shadowcolor" onkeyup="previewColor_8(this.value);" /> <span id="sb_shadowcolor2" style="background-color:$sb_shadowcolor">&nbsp; &nbsp; &nbsp;</span> <img align="top" src="$imagesdir/palette1.gif" style="cursor: pointer" onclick="window.open('$scripturl?action=palette;task=templ_8', '', 'height=308,width=302,menubar=no,toolbar=no,scrollbars=no')" alt="" border="0" />
			<script language="JavaScript1.2" type="text/javascript">
			<!--
			function previewColor_8(color) {
				document.getElementById('sb_shadowcolor2').style.background = color;
				document.getElementsByName("sb_shadowcolor")[0].value = color;
			}
			//-->
			</script></td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'52a_31'}</td>
    <td align="left" class="windowbg2"><input type="text" size="7" maxlength="7" name="sb_trackcolor" value="$sb_trackcolor" onkeyup="previewColor_9(this.value);" /> <span id="sb_trackcolor2" style="background-color:$sb_trackcolor">&nbsp; &nbsp; &nbsp;</span> <img align="top" src="$imagesdir/palette1.gif" style="cursor: pointer" onclick="window.open('$scripturl?action=palette;task=templ_9', '', 'height=308,width=302,menubar=no,toolbar=no,scrollbars=no')" alt="" border="0" />
			<script language="JavaScript1.2" type="text/javascript">
			<!--
			function previewColor_9(color) {
				document.getElementById('sb_trackcolor2').style.background = color;
				document.getElementsByName("sb_trackcolor")[0].value = color;
			}
			//-->
			</script></td>
     </tr>  
     <tr valign="middle">
       <td align="left" class="titlebg" colspan="2"><b><img src="$imagesdir/preferences.gif" alt="" border="0" />$shout_txt{'41c'}</b></td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'61'}</td>
    <td align="left" class="windowbg2"><input type="text" name="mo_window_width" size="5" value="$mo_window_width" /> $shout_txt{'60'}</td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'62'}</td>
    <td align="left" class="windowbg2"><input type="text" name="mo_window_height" size="5" value="$mo_window_height" /> $shout_txt{'60'}</td>
     </tr>
     <tr valign="middle">
       <td align="left" class="titlebg" colspan="2"><b><img src="$imagesdir/preferences.gif" alt="" border="0" />$shout_txt{'41d'}</b></td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'63'}</td>
    <td align="left" class="windowbg2"><input type="text" name="as_window_width" size="5" value="$as_window_width" /> $shout_txt{'60'}</td>
     </tr>
	 <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'64'}</td>
    <td align="left" class="windowbg2"><input type="text" name="as_window_height" size="5" value="$as_window_height" /> $shout_txt{'60'}</td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'65'}</td>
    <td align="left" class="windowbg2"><input type="checkbox" name="as_window_resize" $as_window_resize_check /></td>
     </tr>
     <tr valign="middle">
     <td align="center" class="catbg" colspan="2"><input type="submit" value="$reftxt{'4'}" /></td>
     </tr>
   </table>
  </div>
 </form>
<br /><br />
~;

	$start = $INFO{'start'} || 0;

	fopen(SHOUTS, "$vardir/shouts.txt");
	@shouts = <SHOUTS>;
	fclose(SHOUTS);

	$number_of_shouts = $#shouts;
	$skip_shouts      = $start;
	$counter          = 0;
	$displayedcounter = 0;

	$yymain .= qq~
		<script language="JavaScript1.2" type="text/javascript">
		function SelPage(pstart) {
			location.href="$adminurl?action=shoutadmin;start="+pstart;
		}
		</script>
		<script type="text/javascript">
<!--
function checkAll(delcheckbox, exby) {
 var eles=exby.form.elements;
 for (i = 0; i < eles.length; i++){
  if (eles[i].name&&eles[i].name==delcheckbox){
   eles[i].checked = exby.checked? true:false;
  }
 }
}
// -->
</script>
<form action="$adminurl?action=removeshouts" name"removeshouts" method="post">
<div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
  <table width="100%" cellspacing="1" cellpadding="4">
     <colgroup>
			<col width="92%" />
			<col width="8%" />
     </colgroup>
	<tr>
	  <td align="left" class="titlebg" colspan="1"><img src="$imagesdir/preferences.gif" alt="" border="0" /><b>$shout_txt{'27'}</b></td>
	  <td align="center" class="titlebg" colspan="1"><b>$shout_txt{'57'}</b></td>
	</tr>
~;
	foreach $shoutline (@shouts) {
		if ($counter >= $skip_shouts && $displayedcounter < $max_admin_disp_shouts) {
			chomp @shouts;
			($shout_time, $shout_displayname, $shout_username, $shout_message) = split(/[\|]/, $shoutline);

			# Censor the posts, and display names
			if ($enable_censor) {
				&LoadCensorList;
				$shout_displayname = &Censor($shout_displayname);
				$shout_message     = &Censor($shout_message);
			}

			# Do UBBC on the Shout

			$message = $shout_message;
			&wrap;
			if ($enable_ubbc) {
				if (!$yyYaBBCloaded) {
					require "$sourcedir/YaBBC.pl";
				}
				&DoUBBC;
			}
			&my_wrap3;

			$shout_message = $message;

			# Get the alternating backgrounds
			if ($counter % 2) {
				$class = 'windowbg';
			} else {
				$class = 'windowbg2';
			}

			$deletelink = qq~<input type="checkbox" name="delcheckbox" value="$shout_time" />~;
			if (!${$uid.$shout_username}{'password'}) { &LoadUser($shout_username); }

			my $lastonline;
			if ($iamadmin || $iamgmod || $lastonlineinlink) {
				$lastonline = $date - ${$uid.$shout_username}{'lastonline'};
				my $days  = int($lastonline / 86400);
				my $hours = sprintf("%02d", int(($lastonline - ($days * 86400)) / 3600));
				my $mins  = sprintf("%02d", int(($lastonline - ($days * 86400) - ($hours * 3600)) / 60));
				my $secs  = sprintf("%02d", ($lastonline - ($days * 86400) - ($hours * 3600) - ($mins * 60)));
				if (!$mins) {
					$lastonline = "00:00:$secs";
				} elsif (!$hours) {
					$lastonline = "00:$mins:$secs";
				} elsif (!$days) {
					$lastonline = "$hours:$mins:$secs";
				} else {
					$lastonline = "$days $maintxt{'11'} $hours:$mins:$secs";
				}
				$lastonline = qq~ title="$maintxt{'10'} $lastonline $maintxt{'12'}."~;
			}

			$shout_time = &shout_timeformat($shout_time);
			if (${$uid.$username}{'lp_shout_timestamp'}) { $timestamp = "$shout_time"; }

			$yymain .= qq~<tr><td class="$class" title="">$timestamp<br /><b><a href="$scripturl?action=viewprofile;username=$useraccount{$shout_username}"$lastonline target="_parent" ${$uid.$shout_username}{'realname'} : $format{$shout_username}:</a></b> $shout_message</td><td class="$class" title="$shout_time" align="center"  colspan="3">$deletelink</td></tr>~;

			$displayedcounter++;
		}
		$counter++;
		
	}

	&Paginate;

	$yymain .= qq~
	</td></tr>
       <tr>
	 <td class="titlebg" align="right"><b>$shout_txt{'53'}</b></td>
	 <td class="titlebg" align="center"><input type="checkbox" name="all" onClick="checkAll('delcheckbox',this)"></td>
       </tr>
       <tr>
	 <td class="catbg" align="left">$shout_txt{'55'} $pageindex</td>
	 <td class="catbg" colspan="1"></td>
       </tr>
     </table>
    </div>
<br />
	<div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
	<table width="100%" cellspacing="1" cellpadding="4">
	<tr>
	 <td class="titlebg" colspan="3" align="center"><input type="submit" name="Delete" value="$shout_txt{'43'}" tabindex="5" /></td>
    </tr>
  </table>
 </div>
</form>
~;
	$action_area = "shoutadmin";
	&AdminTemplate;
if (length($message) > $max_shout_length) { $message = substr($message, 0, $max_shout_length); }
}

sub Paginate {

	# Build the page links list.
	$postdisplaynum = 3;                                                                 # max number of pages to display
	$max            = $number_of_shouts + 1;
	$start          = $INFO{'start'} || 0;
	$start          = $start > $number_of_shouts ? $number_of_shouts : $start;
	$start          = (int($start / $max_admin_disp_shouts)) * $max_admin_disp_shouts;
	$tmpa           = 1;
	$tmpx           = int($max / $max_admin_disp_shouts);
	if ($start >= (($postdisplaynum - 1) * $max_admin_disp_shouts)) { $startpage = $start - (($postdisplaynum - 1) * $max_admin_disp_shouts); $tmpa = int($startpage / $max_admin_disp_shouts) + 1; }
	if ($max >= $start + ($postdisplaynum * $max_admin_disp_shouts)) { $endpage = $start + ($postdisplaynum * $max_admin_disp_shouts); }
	else { $endpage = $max }
	if ($startpage > 0) { $pageindex = qq~<a href="$adminurl?action=shoutadmin;start=0"><b>1</b></a>&nbsp;...&nbsp;~; }
	if ($startpage == $max_admin_disp_shouts) { $pageindex = qq~<a href="$adminurl?action=shoutadmin;start=0"><b>1</b></a>&nbsp;~; }

	for ($counter = $startpage; $counter < $endpage; $counter += $max_admin_disp_shouts) {
		$pageindex .= $start == $counter ? qq~<b>$tmpa</b>&nbsp;~ : qq~<a href="$adminurl?action=shoutadmin;start=$counter"><b>$tmpa</b></a>&nbsp;~;
		$tmpa++;
	}

	$tmpx    = $max - $max_admin_disp_shouts;
	$outerpn = int($tmpx / $max_admin_disp_shouts) + 0;
	$lastpn  = int($number_of_shouts / $max_admin_disp_shouts) + 1;
	$lastptn = ($lastpn - 1) * $max_admin_disp_shouts;
	if ($endpage < $max - ($max_admin_disp_shouts)) { $pageindexadd = qq~&nbsp;...&nbsp;~; }
	if ($endpage != $max) { $pageindexadd .= qq~&nbsp;<a href="$adminurl?action=shoutadmin;start=$lastptn"><b>$lastpn</b></a>~; }
	$pageindex .= $pageindexadd;
}

sub shout_timeformat {
	my $oldformat = $_[0];
	my $dontusetoday = $_[1];
	my $use_rfc = $_[2];
	my $forum_default = $_[3]; # use forum default time and format

	$mytimeselected = ($forum_default || !${$uid.$username}{'timeselect'}) ? $timeselected : ${$uid.$username}{'timeselect'};

	chomp $oldformat;
	return if !$oldformat;

	@days_rfc = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat'); # for RFC compliant feed time
	@months_rfc = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');

	# find out what timezone is to be used.
	if ($iamguest || $forum_default) {
		$toffs = $timeoffset;
		$toffs += (localtime($oldformat + (3600 * $toffs)))[8] ? $dstoffset : 0;
	} else {
		$toffs = ${$uid.$username}{'timeoffset'};
		$toffs += (localtime($oldformat + (3600 * $toffs)))[8] ? ${$uid.$username}{'dsttimeoffset'} : 0;
	}

	my ($newsecond, $newminute, $newhour, $newday, $newmonth, $newyear, $newweekday, $newyearday, undef) = gmtime($oldformat + (3600 * $toffs));
	$newmonth++;
	$newyear += 1900;

	# Calculate number of full weeks this year
	$newweek = int(($newyearday + 1 - $newweekday) / 7) + 1;

	# Add 1 if today isn't Saturday
	if ($newweekday < 6) { $newweek = $newweek + 1; }
	$newweek = sprintf("%02d", $newweek);

	if ($use_rfc){
		$shortday = $days_rfc[$newweekday];
	} else {
		$shortday = $days_short[$newweekday];
	}

	$longday = $days[$newweekday];
	$newmonth = sprintf("%02d", $newmonth);
	$newshortyear = ($newyear % 100);
	$newshortyear = sprintf("%02d", $newshortyear);
	if ($mytimeselected != 4) { $newday = sprintf("%02d", $newday); }
	$newhour   = sprintf("%02d", $newhour);
	$newminute = sprintf("%02d", $newminute);
	$newsecond = sprintf("%02d", $newsecond);

	$newtime = $newhour . ":" . $newminute . ":" . $newsecond;

	(undef, undef, undef, undef, undef, $yy, undef, $yd, undef) = gmtime($date + (3600 * $toffs));
	$yy += 1900;

	my $daytxt;
	unless ($dontusetoday) {
		if ($yd == $newyearday && $yy == $newyear) {
			# today
			$daytxt = qq~<b>$maintxt{'769'}</b>~;

		} elsif ((($yd - 1) == $newyearday && $yy == $newyear) || ($yd == 0 && $newday == 31 && $newmonth == 12 && ($yy - 1) == $newyear)) {
			# yesterday || yesterday, over a year end.
			$daytxt = qq~<b>$maintxt{'769a'}</b>~;
		}
	}

	if (!$maintxt{'107'}) { $maintxt{'107'} = $admin_txt{'107'}; }

	if ($mytimeselected == 7) {
		$mytimeformat = ${$uid.$username}{'timeformat'};
		if ($mytimeformat =~ m/hh/) { $hourstyle = 12; }
		if ($mytimeformat =~ m/HH/) { $hourstyle = 24; }
		$mytimeformat =~ s/\@/$maintxt{'107'}/g;
		$mytimeformat =~ s/mm/$newminute/g;
		$mytimeformat =~ s/ss/$newsecond/g;
		$mytimeformat =~ s/ww/$newweek/g;

		if ($mytimeformat =~ m/\+/) {
			if ($newday > 10 && $newday < 20) {
				$dayext = "<sup>$timetxt{'4'}</sup>";
			} elsif ($newday % 10 == 1) {
				$dayext = "<sup>$timetxt{'1'}</sup>";
			} elsif ($newday % 10 == 2) {
				$dayext = "<sup>$timetxt{'2'}</sup>";
			} elsif ($newday % 10 == 3) {
				$dayext = "<sup>$timetxt{'3'}</sup>";
			} else {
				$dayext = "<sup>$timetxt{'4'}</sup>";
			}
		}
		if ($hourstyle == 12) {
			$ampm = $newhour > 11 ? 'pm' : 'am';
			$newhour2 = $newhour % 12 || 12;
			$mytimeformat =~ s/hh/$newhour2/g;
			$mytimeformat =~ s/\#/$ampm/g;
		} elsif ($hourstyle == 24) {
			$mytimeformat =~ s/HH/$newhour/g;
		}
		if ($daytxt eq '') {
			$mytimeformat =~ s/YYYY/$newyear/g;
			$mytimeformat =~ s/YY/$newshortyear/g;
			$mytimeformat =~ s/SDT/$shortday/g;
			$mytimeformat =~ s/LDT/$longday/g;
			$mytimeformat =~ s/DD/$newday/g;
			$mytimeformat =~ s/D/$newday/g;
			$mytimeformat =~ s/\+/$dayext/g;
			if ($mytimeformat =~ m/MM/) {
				if ($use_rfc) { $mytimeformat =~ s/MM/$months_rfc[$newmonth-1]/g; }
				else { $mytimeformat =~ s/MM/$months[$newmonth-1]/g; }
			} elsif ($mytimeformat =~ m/M/){
				$mytimeformat =~ s/M/$newmonth/g;
			}
		} else {
			$mytimeformat =~ s/SDT/$shortday/g;
			$mytimeformat =~ s/LDT/$longday/g;
			$mytimeformat =~ s/DD/$daytxt/g;
			$mytimeformat =~ s/D/$daytxt/g;
			$mytimeformat =~ s/YY//g;
			$mytimeformat =~ s/M//g;
			$mytimeformat =~ s/\/\///g;
			$mytimeformat =~ s/\+//g;
		}
		if ($newisdst && ${$uid.$username}{'dsttimeoffset'} != 0) {
			$mytimeformat =~ s/\*/$maintxt{'dst'}/g;
		} else {
			$mytimeformat =~ s/\*//g;
		}

		# Timezones
		my $timezone = ${$uid.$username}{'timeoffset'};
		my $sign = '+';
		if($timezone < 0) {$sign = '-';}
		$timezone = $sign . sprintf("%04u", abs($timezone) * 100);
		$mytimeformat =~ s/zzz/$timezone/g;
		$mytimeformat =~ s/  / /g;
		$mytimeformat =~ s/[\n\r]//g;

		$newformat = $mytimeformat;
	} elsif ($mytimeselected == 1) {
		$newformat = $daytxt ? qq~$daytxt $maintxt{'107'} $newtime~ : qq~$newmonth/$newday/$newshortyear $maintxt{'107'} $newtime~;
	} elsif ($mytimeselected == 2) {
		$newformat = $daytxt ? qq~$daytxt $maintxt{'107'} $newtime~ : qq~$newday.$newmonth.$newshortyear $maintxt{'107'} $newtime~;
	} elsif ($mytimeselected == 3) {
		$newformat = $daytxt ? qq~$daytxt $maintxt{'107'} $newtime~ : qq~$newday.$newmonth.$newyear $maintxt{'107'} $newtime~;
	} elsif ($mytimeselected == 4) {
		$ampm = $newhour > 11 ? 'pm' : 'am';
		$newhour2 = $newhour % 12 || 12;
		if ($use_rfc) { $newmonth2 = $months_rfc[$newmonth - 1]; }
		else { $newmonth2 = $months[$newmonth - 1]; }
		if ($newday > 10 && $newday < 20) {
			$newday2 = "<sup>$timetxt{'4'}</sup>";
		} elsif ($newday % 10 == 1) {
			$newday2 = "<sup>$timetxt{'1'}</sup>";
		} elsif ($newday % 10 == 2) {
			$newday2 = "<sup>$timetxt{'2'}</sup>";
		} elsif ($newday % 10 == 3) {
			$newday2 = "<sup>$timetxt{'3'}</sup>";
		} else {
			$newday2 = "<sup>$timetxt{'4'}</sup>";
		}
		$newformat = $daytxt ? qq~$daytxt $maintxt{'107'} $newhour2:$newminute$ampm~ : qq~$newmonth2 $newday$newday2, $newyear $maintxt{'107'} $newhour2:$newminute$ampm~;
	} elsif ($mytimeselected == 5) {
		$ampm = $newhour > 11 ? 'pm' : 'am';
		$newhour2 = $newhour % 12 || 12;
		$newformat = $daytxt ? qq~$daytxt $maintxt{'107'} $newhour2:$newminute$ampm~ : qq~$newmonth/$newday/$newshortyear $maintxt{'107'} $newhour2:$newminute$ampm~;
	} elsif ($mytimeselected == 6) {
		if ($use_rfc) { $newmonth2 = $months_rfc[$newmonth - 1]; }
		else { $newmonth2 = $months[$newmonth - 1]; }
		$newformat = $daytxt ? qq~$daytxt $maintxt{'107'} $newhour:$newminute~ : qq~$newday. $newmonth2 $newyear $maintxt{'107'} $newhour:$newminute~;
	}
	$newformat;
}

1;
