#!/usr/bin/perl --

#################################################################################################
# ShoutDisplay.pl:	 Part of the Shoutbox 2.4 Mod						#
# Copyright:       	 2005 Andrew Aitken (LoonyPandora)					#
# Version:         	 Shoutbox RC5.5 for YaBB 2.4						#
# Released:        	 13th May, 2009								#
# Distributed by:  	 http://www.boardmod.org						#
# Update by: 		 Batchman, Derek Barnstorm, D0T-C0M, Driven, Unilat, ThM with permission#
#################################################################################################

$shoutdisplayplver = 'Shoutbox Mod for YaBB 2.4 RC5.5';

# Make sure the module path is present
# Some servers need all the subdirs in @INC too.

push(@INC, "./Modules");
push(@INC, "./Modules/Digest");

if ($ENV{'SERVER_SOFTWARE'} =~ /IIS/) {

	$yyIIS = 1;
	$0 =~ m~(.*)(\\|/)~;
	$yypath = $1;
	$yypath =~ s~\\~/~g;
	chdir($yypath);
	push(@INC, $yypath);
}

	$yyexec = "YaBB";
	$script_root = $ENV{'SCRIPT_FILENAME'};
	$script_root =~ s/\/$yyexec\.(pl|cgi)//ig;

#use Time::HiRes qw(time);
    #benchmarking
#
$START_TIME = time;

&DisplayShouts;

sub DisplayShouts {

	require "Paths.pl";
	require "$vardir/Settings.pl";
	require "$sourcedir/Subs.pl";
	require "$sourcedir/Load.pl";
	require "$vardir/shoutsettings.txt";

	$scripturl = qq~$boardurl/YaBB.$yyext~;

	&LoadLanguage("Shoutbox");
	&LoadLanguage("Main");
	&LoadCookie;
	&LoadUser($username);

	# Determine guest and admin positions

	$iamguest = $username eq 'Guest' ? 1 : 0;
	if(${$uid.$username}{'position'} eq 'Administrator') {$iamadmin = 1;}

######################################################
######################################################
#This is what you want to change if you need to
#increase the height of the bottom portion of the
#shoutbox to accommodate more lines or taller smilieys
#The code is split into 2 sections AND you have to
#change both sections.
######################################################
##########                 ###########################
##########  FIRST SECTION  ###########################
##########                 ###########################
######################################################
######################################################
$px = "px"; # DO NOT CHANGE ## stores the letters "px"
if ($shout_width < 380) {
######################################################
#if you set the shoutbox width less than 380 then do
#the following:
     $autobr = "<br />"; #used to split smileys
	                     #into 2 lines
######################################################
# Increasing the number below increases the height
#of the bottom portion of the shoutbox. The top
#portion containing the actual shouts will auto size
#accordingly.
####
    $shout_text_height = 130;
######################################################
     $shout_text_height2 = $shout_text_height;
if (${$uid.$username}{'lp_shout_bbcode'} eq "") {
######################################################
#If you disable the UBBC line then automatically
#substract 8 from the height of the bottom portion of
#the shoutbox to compensate.
	$shout_text_height2 -= 8;
######################################################
}
if (${$uid.$username}{'lp_shout_smileys'} eq "") {
######################################################
#If you disable the smileys line then automatically
#substract 27 from the height of the bottom portion
#of the shoutbox to compensate.
	$shout_text_height2 -= 27;
######################################################
}
$shout_text_height3 = ($shout_text_height2 +8);
}else {
######################################################
##########                 ###########################
##########  SECOND SECTION ###########################
##########                 ###########################
######################################################
######################################################
#if you set the shoutbox width more than 380 pixels
#then do the following:
$autobr = ""; #used to join smileys
	          #into 1 lines
######################################################
# Increasing the number below increases the height
#of the bottom portion of the shoutbox. The top
#portion containing the actual shouts will auto size
#accordingly.
####
	$shout_text_height = 110;
######################################################
$shout_text_height2 = $shout_text_height;
if (${$uid.$username}{'lp_shout_bbcode'} eq "") {
######################################################
#If you disable the UBBC buttons then automatically
#substract 8 from the height of the bottom portion
#of the shoutbox to compensate.
  $shout_text_height2 -= 8;
######################################################
}
if (${$uid.$username}{'lp_shout_smileys'} eq "") {
######################################################
#If you disable the smileys line then automatically
#substract 8 from the height of the bottom portion of
#the shoutbox to compensate.
   $shout_text_height2 -= 8;
######################################################
}$shout_text_height3 = ($shout_text_height2 +8);
}
######################################################

$shout_text_height4 = ($shout_text_height3 -4);
######################################################
 
	# Figure out which template to be using.

	${$uid.$username}{'template'} = ${$uid.$username}{'template'};

	&WhatTemplate;

	&LoadLanguage('Shoutbox');
	&LoadLanguage('Main');
	&LoadLanguage('Menu');

	if ($adminscreen) {
		&LoadLanguage('Admin');
		&LoadLanguage('FA');
	}

	# Guardian Form spoofing protection
	$formsession = &cloak("$mbname$username");

	# Set guests censor language

	if ($iamguest) { our $language = $censor_lang; }
	else { $language = ${$uid.$username}{'language'} }

	fopen(SHOUTS, "$vardir/shouts.txt");
	@shouts = <SHOUTS>;

	fclose(SHOUTS);

	$number_of_shouts = $#shouts;
	$skip_shouts      = ($number_of_shouts - $max_disp_shouts);
	$counter          = 0;


	if (${$uid.$username}{'reverse_post'}) {
 	@shouts = reverse @shouts; }



	if (!$INFO{'showall'}) {

		foreach $shoutline (@shouts) {
			if ($counter > $skip_shouts) {
				chomp @shouts;
				($shout_time, $shout_displayname, $shout_username, $shout_message) = split(/[\|]/, $shoutline);

				$delete_link = '';
				&LoadLanguage('Shoutbox');
				&CheckCanDelete;

			# Censor the posts, and display names
			if ($enable_censor) {
				&LoadCensorList;
				$shout_displayname = &Censor($shout_displayname);
				$shout_message     = &Censor($shout_message);
			}

			# Do UBBC on the Shout (append shout_ before vars)
			$message = $shout_message;
			&wrap;
			if ($enable_ubbc) {
				if (!$yyYaBBCloaded) {
					require "$sourcedir/YaBBC.pl";
				}
				&DoUBBC;
			}
			&my_wrap3;

			if ($enable_limiter == 1) {
			$limiter = qq~<div class="small" id="shoutlimiter"></div>~;
			}

			if ($enable_tdmouseover == 1) {
			$tdmo = qq~onmouseover="this.className='tdmouseover'" onmouseout="this.className='$class'"~;
			}

			if ($enable_scrollbar == 1) {
			$scrollbar = qq~scrolling="no"~;
			}

			$shout_message = $message;

			$shout_time = &shout_timeformat($shout_time);

			# Set the alternating backgrounds colours
			if ($counter % 2) { $class = 'shout_windowbg'; }
			else { $class = 'shout_windowbg2'; }


			if (${$uid.$username}{'lp_shout_timestamp'}) { $timestamp = "$shout_time"; }
			if (!${$uid.$shout_username}{'password'}) { &LoadUser($shout_username); }

			my $lastonline;
			if ($iamadmin || $iamgmod || $lastonlineinlink) {
				$lastonline = $date - ${$uid.$shout_username}{'lastonline'};
				my $days  = int($lastonline / 86400);
				my $hours = sprintf("%02d", int(($lastonline - ($days * 86400)) / 3600));
				my $mins  = sprintf("%02d", int(($lastonline - ($days * 86400) - ($hours * 3600)) / 60));
				my $secs  = sprintf("%02d", ($lastonline - ($days * 86400) - ($hours * 3600) - ($mins * 60)));
				if (!$mins) {
					$lastonline = "00:00:$secs";
				} elsif (!$hours) {
					$lastonline = "00:$mins:$secs";
				} elsif (!$days) {
					$lastonline = "$hours:$mins:$secs";
				} else {
					$lastonline = "$days $maintxt{'11'} $hours:$mins:$secs";
				}
				$lastonline = qq~ title="$maintxt{'10'} $lastonline $maintxt{'12'}."~;
			}

				$shout_rows .= qq~
		
		<script language="JavaScript1.2" type="text/javascript">

		function confirmDelete() {
 		return confirm("$shout_txt{'50'}");
		}
	
		</script>

<tr>
<td class="$class" $tdmo style="font-size: 10px;"><div style="float:left;padding-right:3px;padding-left:3px;">$timestamp&nbsp;<a href="$scripturl?action=viewprofile;username=$useraccount{$shout_username}"$lastonline target="_parent" ${$uid.$shout_username}{'realname'}: $format{$shout_username}:</a></div><div style="float:right;padding-right:3px;padding-left:3px;">$delete_link</div><br />$shout_message</td>
</tr>~;

			}
			$counter++;
		}
		$shoutform_action = "$scripturl?action=write_shouts";
		&Template;

	} else {

		foreach $shoutline (@shouts) {
			chomp @shouts;
			($shout_time, $shout_displayname, $shout_username, $shout_message) = split(/[\|]/, $shoutline);
			$delete_link = '';
			&CheckCanDelete_showall;

			if (length($message) > $max_shout_length) { $message = substr($message, 0, $max_shout_length); } 

			# Do UBBC on the Shout (append shout_ before vars)
			$message = $shout_message;
			&wrap;
			if ($enable_ubbc) {
				if (!$yyYaBBCloaded) {
					require "$sourcedir/YaBBC.pl";
				}
				&DoUBBC;
			}
			&my_wrap3;
			
			# Censor the posts, and display names
			if ($enable_censor) {
				&LoadCensorList;
				$shout_displayname = &Censor($shout_displayname);
				$shout_message     = &Censor($shout_message);
			}

			if ($enable_limiter == 1) {
			$limiter = qq~<div class="small" id="shoutlimiter"></div>~;
			}

			if ($enable_tdmouseover == 1) {
			$tdmo = qq~onmouseover="this.className='tdmouseover'" onmouseout="this.className='$class'"~;
			}

			$shout_message = $message;

			$shout_time = &shout_timeformat($shout_time);

			# Set the alternating backgrounds colours
			if ($counter % 2) { $class = 'shout_windowbg'; }
			else { $class = 'shout_windowbg2'; }

			if (${$uid.$username}{'lp_shout_timestamp'}) { $timestamp = "$shout_time"; }
			if (!${$uid.$shout_username}{'password'}) { &LoadUser($shout_username); }

			my $lastonline;
			if ($iamadmin || $iamgmod || $lastonlineinlink) {
				$lastonline = $date - ${$uid.$shout_username}{'lastonline'};
				my $days  = int($lastonline / 86400);
				my $hours = sprintf("%02d", int(($lastonline - ($days * 86400)) / 3600));
				my $mins  = sprintf("%02d", int(($lastonline - ($days * 86400) - ($hours * 3600)) / 60));
				my $secs  = sprintf("%02d", ($lastonline - ($days * 86400) - ($hours * 3600) - ($mins * 60)));
				if (!$mins) {
					$lastonline = "00:00:$secs";
				} elsif (!$hours) {
					$lastonline = "00:$mins:$secs";
				} elsif (!$days) {
					$lastonline = "$hours:$mins:$secs";
				} else {
					$lastonline = "$days $maintxt{'11'} $hours:$mins:$secs";
				}
				$lastonline = qq~ title="$maintxt{'10'} $lastonline $maintxt{'12'}."~;
			}

				$shout_rows .= qq~
				
		<script language="JavaScript1.2" type="text/javascript">

		function confirmDelete() {
 		return confirm("$shout_txt{'50'}");
		}
	
		</script>
<tr>
<td class="$class" $tdmo style="font-size: 10px;"><div style="float:left;padding-right:3px;padding-left:3px;">$timestamp&nbsp;<a href="$scripturl?action=viewprofile;username=$useraccount{$shout_username}"$lastonline target="_parent" ${$uid.$shout_username}{'realname'} : $format{$shout_username}:</a></div><div style="float:right;padding-right:3px;padding-left:3px;">$delete_link</div><br />$shout_message</td>
</tr>~;

			$counter++;
		}

		$shoutform_action = "$scripturl?action=write_shouts;showall=1";

		&Template;
		if (length($message) > $max_shout_length) { $message = substr($message, 0, $max_shout_length); }
	}
}

sub CheckCanDelete {
	if ($delete_delay == "0") { return; }
 
	if ($iamadmin || (!$iamguest && ($username eq $shout_username))) {
        	my $now_time = int(time);
		if (($now_time - $shout_time) > $delete_delay) { if (!$iamadmin || !$admin_deletion_link) {return;}}
		$delete_link = qq~<a href="$scripturl?action=useremoveshouts;shout=$shout_time;user=$shout_username" target="shouts"  onclick="return confirmDelete();"><IMG STYLE="border:none;" src="$yyhtml_root/ModImages/Shoutbox/stop.png" alt="$shout_txt{'46'}" title="$shout_txt{'47'}"></a>~;
	}
}

sub CheckCanDelete_showall {
	if ($delete_delay == "0") { return; }
 
	if ($iamadmin || (!$iamguest && ($username eq $shout_username))) {
        	my $now_time = int(time);
		if (($now_time - $shout_time) > $delete_delay) { if (!$iamadmin || !$admin_deletion_link) {return;}}
		$delete_link = qq~<a href="$scripturl?action=useremoveshouts;shout=$shout_time;user=$shout_username" target="_parent"  onclick="return confirmDelete();"><IMG STYLE="border:none;" src="$yyhtml_root/ModImages/Shoutbox/stop.png" alt="$shout_txt{'46'}" title="$shout_txt{'47'}"></a>~;
	}
}

sub my_wrap3 {
	$shout_message =~ s~(<.*>)*(\S{0,14})(\S{0,14})?(\S{0,14})?(\S{0,14})?(\S*)?(<.*>)*~$1$2 $3 $4 $5 $6$7~gi;
	$shout_message =~ s~(<.*>)?(\S{0,14})(\S{0,14})?(\S{0,14})?(\S{0,14})?(\S*)(<\/\S*>)~$1$2 $3 $4 $5 $6$7~gi;
	$shout_message =~ s~\s+~ ~gi;
}

sub shout_timeformat {
	my $oldformat = $_[0];
	my $dontusetoday = $_[1];
	my $use_rfc = $_[2];
	my $forum_default = $_[3]; # use forum default time and format

	$mytimeselected = ($forum_default || !${$uid.$username}{'timeselect'}) ? $timeselected : ${$uid.$username}{'timeselect'};

	chomp $oldformat;
	return if !$oldformat;

	@days_rfc = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat'); # for RFC compliant feed time
	@months_rfc = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');

	# find out what timezone is to be used.
	if ($iamguest || $forum_default) {
		$toffs = $timeoffset;
		$toffs += (localtime($oldformat + (3600 * $toffs)))[8] ? $dstoffset : 0;
	} else {
		$toffs = ${$uid.$username}{'timeoffset'};
		$toffs += (localtime($oldformat + (3600 * $toffs)))[8] ? ${$uid.$username}{'dsttimeoffset'} : 0;
	}

	my ($newsecond, $newminute, $newhour, $newday, $newmonth, $newyear, $newweekday, $newyearday, undef) = gmtime($oldformat + (3600 * $toffs));
	$newmonth++;
	$newyear += 1900;

	# Calculate number of full weeks this year
	$newweek = int(($newyearday + 1 - $newweekday) / 7) + 1;

	# Add 1 if today isn't Saturday
	if ($newweekday < 6) { $newweek = $newweek + 1; }
	$newweek = sprintf("%02d", $newweek);

	if ($use_rfc){
		$shortday = $days_rfc[$newweekday];
	} else {
		$shortday = $days_short[$newweekday];
	}

	$longday = $days[$newweekday];
	$newmonth = sprintf("%02d", $newmonth);
	$newshortyear = ($newyear % 100);
	$newshortyear = sprintf("%02d", $newshortyear);
	if ($mytimeselected != 4) { $newday = sprintf("%02d", $newday); }
	$newhour   = sprintf("%02d", $newhour);
	$newminute = sprintf("%02d", $newminute);
	$newsecond = sprintf("%02d", $newsecond);

	$newtime = $newhour . ":" . $newminute . ":" . $newsecond;

	(undef, undef, undef, undef, undef, $yy, undef, $yd, undef) = gmtime($date + (3600 * $toffs));
	$yy += 1900;

	my $daytxt;
	unless ($dontusetoday) {
		if ($yd == $newyearday && $yy == $newyear) {
			# today
			$daytxt = qq~<b>$maintxt{'769'}</b>~;

		} elsif ((($yd - 1) == $newyearday && $yy == $newyear) || ($yd == 0 && $newday == 31 && $newmonth == 12 && ($yy - 1) == $newyear)) {
			# yesterday || yesterday, over a year end.
			$daytxt = qq~<b>$maintxt{'769a'}</b>~;
		}
	}

	if (!$maintxt{'107'}) { $maintxt{'107'} = $admin_txt{'107'}; }

	if ($mytimeselected == 7) {
		$mytimeformat = ${$uid.$username}{'timeformat'};
		if ($mytimeformat =~ m/hh/) { $hourstyle = 12; }
		if ($mytimeformat =~ m/HH/) { $hourstyle = 24; }
		$mytimeformat =~ s/\@/$maintxt{'107'}/g;
		$mytimeformat =~ s/mm/$newminute/g;
		$mytimeformat =~ s/ss/$newsecond/g;
		$mytimeformat =~ s/ww/$newweek/g;

		if ($mytimeformat =~ m/\+/) {
			if ($newday > 10 && $newday < 20) {
				$dayext = "<sup>$timetxt{'4'}</sup>";
			} elsif ($newday % 10 == 1) {
				$dayext = "<sup>$timetxt{'1'}</sup>";
			} elsif ($newday % 10 == 2) {
				$dayext = "<sup>$timetxt{'2'}</sup>";
			} elsif ($newday % 10 == 3) {
				$dayext = "<sup>$timetxt{'3'}</sup>";
			} else {
				$dayext = "<sup>$timetxt{'4'}</sup>";
			}
		}
		if ($hourstyle == 12) {
			$ampm = $newhour > 11 ? 'pm' : 'am';
			$newhour2 = $newhour % 12 || 12;
			$mytimeformat =~ s/hh/$newhour2/g;
			$mytimeformat =~ s/\#/$ampm/g;
		} elsif ($hourstyle == 24) {
			$mytimeformat =~ s/HH/$newhour/g;
		}
		if ($daytxt eq '') {
			$mytimeformat =~ s/YYYY/$newyear/g;
			$mytimeformat =~ s/YY/$newshortyear/g;
			$mytimeformat =~ s/SDT/$shortday/g;
			$mytimeformat =~ s/LDT/$longday/g;
			$mytimeformat =~ s/DD/$newday/g;
			$mytimeformat =~ s/D/$newday/g;
			$mytimeformat =~ s/\+/$dayext/g;
			if ($mytimeformat =~ m/MM/) {
				if ($use_rfc) { $mytimeformat =~ s/MM/$months_rfc[$newmonth-1]/g; }
				else { $mytimeformat =~ s/MM/$months[$newmonth-1]/g; }
			} elsif ($mytimeformat =~ m/M/){
				$mytimeformat =~ s/M/$newmonth/g;
			}
		} else {
			$mytimeformat =~ s/SDT/$shortday/g;
			$mytimeformat =~ s/LDT/$longday/g;
			$mytimeformat =~ s/DD/$daytxt/g;
			$mytimeformat =~ s/D/$daytxt/g;
			$mytimeformat =~ s/YY//g;
			$mytimeformat =~ s/M//g;
			$mytimeformat =~ s/\/\///g;
			$mytimeformat =~ s/\+//g;
		}
		if ($newisdst && ${$uid.$username}{'dsttimeoffset'} != 0) {
			$mytimeformat =~ s/\*/$maintxt{'dst'}/g;
		} else {
			$mytimeformat =~ s/\*//g;
		}

		# Timezones
		my $timezone = ${$uid.$username}{'timeoffset'};
		my $sign = '+';
		if($timezone < 0) {$sign = '-';}
		$timezone = $sign . sprintf("%04u", abs($timezone) * 100);
		$mytimeformat =~ s/zzz/$timezone/g;
		$mytimeformat =~ s/  / /g;
		$mytimeformat =~ s/[\n\r]//g;

		$newformat = $mytimeformat;
	} elsif ($mytimeselected == 1) {
		$newformat = $daytxt ? qq~<b>[</b>$daytxt $maintxt{'107'} $newtime~ : qq~<b>[</b>$newmonth/$newday $maintxt{'107'} $newtime]<b>]</b>~;
	} elsif ($mytimeselected == 2) {
		$newformat = $daytxt ? qq~<b>[</b>$daytxt $maintxt{'107'} $newtime~ : qq~<b>[</b>$newday.$newmonth. $maintxt{'107'} $newtime<b>]</b>~;
	} elsif ($mytimeselected == 3) {
		$newformat = $daytxt ? qq~<b>[</b>$daytxt $maintxt{'107'} $newtime~ : qq~<b>[</b>$newday.$newmonth. $maintxt{'107'} $newtime<b>]</b>~;
	} elsif ($mytimeselected == 4) {
		$ampm = $newhour > 11 ? 'pm' : 'am';
		$newhour2 = $newhour % 12 || 12;
		if ($use_rfc) { $newmonth2 = $months_rfc[$newmonth - 1]; }
		else { $newmonth2 = $months[$newmonth - 1]; }
		if ($newday > 10 && $newday < 20) {
			$newday2 = "<sup>$timetxt{'4'}</sup>";
		} elsif ($newday % 10 == 1) {
			$newday2 = "<sup>$timetxt{'1'}</sup>";
		} elsif ($newday % 10 == 2) {
			$newday2 = "<sup>$timetxt{'2'}</sup>";
		} elsif ($newday % 10 == 3) {
			$newday2 = "<sup>$timetxt{'3'}</sup>";
		} else {
			$newday2 = "<sup>$timetxt{'4'}</sup>";
		}
		$newformat = $daytxt ? qq~<b>[</b>$daytxt $maintxt{'107'} $newhour2:$newminute$ampm~ : qq~<b>[</b>$newmonth2 $newday$newday2 $maintxt{'107'} $newhour2:$newminute$ampm<b>]</b>~;
	} elsif ($mytimeselected == 5) {
		$ampm = $newhour > 11 ? 'pm' : 'am';
		$newhour2 = $newhour % 12 || 12;
		$newformat = $daytxt ? qq~<b>[</b>$daytxt $maintxt{'107'} $newhour2:$newminute$ampm~ : qq~<b>[</b>$newmonth/$newday $maintxt{'107'} $newhour2:$newminute$ampm<b>]</b>~;
	} elsif ($mytimeselected == 6) {
		if ($use_rfc) { $newmonth2 = $months_rfc[$newmonth - 1]; }
		else { $newmonth2 = $months[$newmonth - 1]; }
		$newformat = $daytxt ? qq~<b>[</b>$daytxt $maintxt{'107'} $newhour:$newminute~ : qq~<b>[</b>$newday. $newmonth2 $maintxt{'107'} $newhour:$newminute<b>]</b>~;
	}
	$newformat;
}

sub Timer {
	$time_running = time - $START_TIME;
	$time_running = sprintf("%.4f", $time_running);
	print qq~

<!-- Ran for $time_running seconds  -  Accessed $file_open files-->
~;

}

sub ShowExtras {
	# Multiply by 1000, because JS uses millseconds
	if (${$uid.$username}{'lp_shout_refresh'} >= 10) {
		$refresh = (${$uid.$username}{'lp_shout_refresh'}*1000);
		$refresh_js = qq~
/* Scrolls page, and sets timer for autorefreshing */
function timer() {
	window.scrollTo(0,99999);
	setTimeout("reload_page()", $refresh);
}

/* Reloads page if message is default or blank */
function reload_page() {
	if (document.shoutbox.message.value == "") {
		window.location.reload();
	}
}
		~;
	} else {
		$refresh_js = qq~
/* Scrolls page, and sets timer for autorefreshing */
function timer() {
	window.scrollTo(0,99999);
}
		~;
	}
	if (${$uid.$username}{'on_load_focus'}) {
		$shoutbox_on_load_focus = qq~ document.shoutbox.message.focus();~;}
	else {$shoutbox_on_load_focus = "";}


	if (${$uid.$username}{'lp_shout_smileys'}) {
		$smiley_bar = qq~
<script language="JavaScript1.2" type="text/javascript">
<!--
if((navigator.appName == "Netscape" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Microsoft Internet Explorer" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Opera" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Konqueror" && navigator.appVersion.charAt(0) >= 2)) {
	HAND = "style='cursor: pointer;'";
	document.write("<img src='$imagesdir/smiley.gif' onclick='smiley();' "+HAND+" align=bottom alt='$post_txt{'287'}' border='0'> ");
	document.write("<img src='$imagesdir/wink.gif' onclick='wink();' "+HAND+" align=bottom alt='$post_txt{'292'}' border='0'> ");
	document.write("<img src='$imagesdir/cheesy.gif' onclick='cheesy();' "+HAND+" align=bottom alt='$post_txt{'289'}' border='0'> ");
	document.write("<img src='$imagesdir/grin.gif' onclick='grin();' "+HAND+" align=bottom alt='$post_txt{'293'}' border='0'> ");
	document.write("<img src='$imagesdir/angry.gif' onclick='angry();' "+HAND+" align=bottom alt='$post_txt{'288'}' border='0'> ");
	document.write("<img src='$imagesdir/sad.gif' onclick='sad();' "+HAND+" align=bottom alt='$post_txt{'291'}' border='0'> ");
	document.write("<img src='$imagesdir/shocked.gif' onclick='shocked();' "+HAND+" align=bottom alt='$post_txt{'294'}' border='0'> ");
	document.write("<img src='$imagesdir/cool.gif' onclick='cool();' "+HAND+" align=bottom alt='$post_txt{'295'}' border='0'> ");
	document.write("$autobr<img src='$imagesdir/huh.gif' onclick='huh();' "+HAND+" align=bottom alt='$post_txt{'296'}' border='0'> ");
	document.write("<img src='$imagesdir/rolleyes.gif' onclick='rolleyes();' "+HAND+" align=bottom alt='$post_txt{'450'}' border='0'> ");
	document.write("<img src='$imagesdir/tongue.gif' onclick='tongue();' "+HAND+" align=bottom alt='$post_txt{'451'}' border='0'> ");
	document.write("<img src='$imagesdir/embarassed.gif' onclick='embarassed();' "+HAND+" align=bottom alt='$post_txt{'526'}' border='0'> ");
	document.write("<img src='$imagesdir/lipsrsealed.gif' onclick='lipsrsealed();' "+HAND+" align=bottom alt='$post_txt{'527'}' border='0'> ");
	document.write("<img src='$imagesdir/undecided.gif' onclick='undecided();' "+HAND+" align=bottom alt='$post_txt{'528'}' border='0'> ");
	document.write("<img src='$imagesdir/kiss.gif' onclick='kiss();' "+HAND+" align=bottom alt='$post_txt{'529'}' border='0'> ");
	document.write("<img src='$imagesdir/cry.gif' onclick='cry();' "+HAND+" align=bottom alt='$post_txt{'530'}' border='0'> ");$moresmilieslist
} else {
	document.write("<span  class='small'>$post_txt{'215'}</span>");
}
//-->
</script>
		~;
	}

	if (${$uid.$username}{'lp_shout_bbcode'} && $enable_ubbc) {
		$bbcode_bar = qq~
			<script language="JavaScript1.2" type="text/javascript">
			<!--
			HAND = "style='cursor: pointer;'";
			document.write("<img src='$imagesdir/bold.gif' onclick='bold();' "+HAND+" align='top' width='23' height='22' alt='$post_txt{'253'}' title='$post_txt{'253'}' border='0' />");
			document.write("<img src='$imagesdir/italicize.gif' onclick='italicize();' "+HAND+" align='top' width='23' height='22' alt='$post_txt{'254'}' title='$post_txt{'254'}' border='0' />");
			document.write("<img src='$imagesdir/underline.gif' onclick='underline();' "+HAND+" align='top' width='23' height='22' alt='$post_txt{'255'}' title='$post_txt{'255'}' border='0' />");
			document.write("<img src='$imagesdir/strike.gif' onclick='strike();' "+HAND+" align='top' width='23' height='22' alt='$post_txt{'441'}' title='$post_txt{'441'}' border='0' />");	
			document.write("<img src='$imagesdir/move.gif' onclick='move();' "+HAND+" align='top' width='23' height='22' alt='$post_txt{'439'}' title='$post_txt{'439'}' border='0' />");
			document.write("<img src='$imagesdir/tele.gif' onclick='teletype();' "+HAND+" align='top' width='23' height='22' alt='$post_txt{'440'}' title='$post_txt{'440'}' border='0' />");
			document.write("<img src='$imagesdir/url.gif' onclick='hyperlink();' "+HAND+" align='top' width='23' height='22' alt='$post_txt{'257'}' title='$post_txt{'257'}' border='0' />");
			document.write("<img src='$imagesdir/email2.gif' onclick='emai1();' "+HAND+" align='top' width='23' height='22' alt='$post_txt{'258'}' title='$post_txt{'258'}' border='0' />");
			// Palette
			var thistask = 'post';
			function tohex(i) {
				a2 = ''
				ihex = hexQuot(i);
				idiff = eval(i + '-(' + ihex + '*16)')
				a2 = itohex(idiff) + a2;
				while( ihex >= 16) {
					itmp = hexQuot(ihex);
					idiff = eval(ihex + '-(' + itmp + '*16)');
					a2 = itohex(idiff) + a2;
					ihex = itmp;
				} 
				a1 = itohex(ihex);
				return a1 + a2 ;
			}

			function hexQuot(i) {
				return Math.floor(eval(i +'/16'));
			}

			function itohex(i) {
				if( i == 0) { aa = '0' }
				else { if( i == 1 ) { aa = '1' }
				else { if( i == 2 ) { aa = '2' }
				else { if( i == 3 ) { aa = '3' }
				else { if( i == 4 ) { aa = '4' }
				else { if( i == 5 ) { aa = '5' }
				else { if( i == 6 ) { aa = '6' }
				else { if( i == 7 ) { aa = '7' }
				else { if( i == 8 ) { aa = '8' }
				else { if( i == 9 ) { aa = '9' }
				else { if( i == 10) { aa = 'a' }
				else { if( i == 11) { aa = 'b' }
				else { if( i == 12) { aa = 'c' }
				else { if( i == 13) { aa = 'd' }
				else { if( i == 14) { aa = 'e' }
				else { if( i == 15) { aa = 'f' }
				}}}}}}}}}}}}}}}
				return aa;
			}

			function ConvShowcolor(color) {
				if ( c=color.match(/rgb\\((\\d+?)\\, (\\d+?)\\, (\\d+?)\\)/i) ) {
					var rhex = tohex(c[1]);
					var ghex = tohex(c[2]);
					var bhex = tohex(c[3]);
					var newcolor = '#'+rhex+ghex+bhex;
				}
				else {
					var newcolor = color;
				}
				if(thistask == "post") showcolor(newcolor);
				if(thistask == "templ") previewColor(newcolor);
			}
			//-->
			</script>
				<img src="$imagesdir/palette1.gif" style="cursor: pointer" width='23' height='22' onclick="window.open('$scripturl?action=palette;task=post', '', 'height=308,width=302,menubar=no,toolbar=no,scrollbars=no')" alt="" border="0" />
			<noscript>
			<span class="small">$maintxt{'noscript'}</span>
			</noscript>
</script>
		~;
	}
}

sub Template 	{

	if ($iamguest && $enable_gr == 0) {
		print qq~Content-type:text/html\n\n~;
		print qq~<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>$name_sb</title>
<meta http-equiv="Content-Type" content="text/html; charset=$yycharset" />
<meta http-equiv="pragma" CONTENT="no-cache" />
<link rel="stylesheet" href="$forumstylesurl/$usestyle.css" type="text/css" />
</head>
<table width="35%">
<tr>
<td>
<span class="small">$shout_txt{'15a'}<br /><br />
$shout_txt{'16'} <a href="$scripturl?action=register" target="_blank">$scripturl</a>
</td>
</tr>
</table>
</span>
</body>
</html>~;

		exit;

	} else {

	&ShowExtras;
	print qq~Content-type:text/html\n\n~;
	print qq~<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<style type="text/css">
html, body {
  scrollbar-base-color:$sb_basecolor;
  scrollbar-3d-light-color:$sb_3dlightcolor;
  scrollbar-arrow-color:$sb_arrowcolor;
  scrollbar-darkshadow-color:$sb_darkshadowcolor;
  scrollbar-face-color:$sb_facecolor;
  scrollbar-highlight-color:$sb_highlightcolor;
  scrollbar-shadow-color:$sb_shadowcolor;
  scrollbar-track-color:$sb_trackcolor;
}
</style>
<title>$name_sb</title>
<meta http-equiv="Content-Type" content="text/html; charset=$yycharset" />
<meta http-equiv="pragma" content="no-cache" />
<link rel="stylesheet" href="$forumstylesurl/$usestyle.css" type="text/css" />
<script language="JavaScript1.2" src="$yyhtml_root/shoutnew.js" type="text/javascript"></script>
<script language="JavaScript1.2" type="text/javascript">
<!--
/* Opens windows for smilies and previous shouts */
function openWindow(theURL,winName,features) {
  window.open(theURL,winName,features);
}

/* clears default values from input boxes */
function clearText(thefield) {
	if (thefield.defaultValue==thefield.value)
	thefield.value = ""
}

/* Uses hidden form fields so message never disappears accidentally */


function changevalue() {
	if (document.shoutbox.message.defaultValue == document.shoutbox.message.value)
		{
		alert("$shout_txt{'45'}");
		return false;
		}
	else
		{
		document.shoutbox.shoutout.value = document.shoutbox.message.value;
		document.shoutbox.message.value = "";
		}
 }

$refresh_js
// -->
</script>

<script type="text/javascript">
//** Form field Limiter v2.0- (c) Dynamic Drive DHTML code library: http://www.dynamicdrive.com
//** Feb 25th, 09'- Script creation date
//** This notice must stay intact for legal use

var fieldlimiter={

defaultoutput: "$shout_txt{'65a'} <b>[int]</b> $shout_txt{'66'}",
uncheckedkeycodes: /(8)|(13)|(16)|(17)|(18)/,

limitinput:function(e, config){
	var e=window.event || e
	var thefield=config.thefield
	var keyunicode=e.charCode || e.keyCode
	if (!this.uncheckedkeycodes.test(keyunicode)){
		if (thefield.value.length>=config.maxlength){
			if (e.preventDefault)
				e.preventDefault()
			return false
		}
	}
},

showlimit:function(config){
	var thefield=config.thefield
	var statusids=config.statusids
	var charsleft=config.maxlength-thefield.value.length
	if (charsleft<0)
		thefield.value=thefield.value.substring(0, config.maxlength) //trim input
	for (var i=0; i<statusids.length; i++){
		var statusdiv=document.getElementById(statusids[i])
		if (statusdiv) //if status DIV defined
			statusdiv.innerHTML=this.defaultoutput.replace("[int]", Math.max(0, charsleft))
	}
	config.onkeypress.call(thefield, config.maxlength, thefield.value.length)
},

cleanup:function(config){
	for (var prop in config){
		config[prop]=null
	}
},


addEvent:function(targetarr, functionref, tasktype){
	if (targetarr.length>0){
		var target=targetarr.shift()
		if (target.addEventListener)
			target.addEventListener(tasktype, functionref, false)
		else if (target.attachEvent)
			target.attachEvent('on'+tasktype, function(){return functionref.call(target, window.event)})
		this.addEvent(targetarr, functionref, tasktype)
	}
},

setup:function(config){
	if (config.thefield){ //if form field exists
		config.onkeypress=config.onkeypress || function(){}
		config.thefield.value=config.thefield.value
		this.showlimit(config)
		this.addEvent([window], function(e){fieldlimiter.showlimit(config)}, "load")
		this.addEvent([window], function(e){fieldlimiter.cleanup(config)}, "unload")		
		this.addEvent([config.thefield], function(e){return fieldlimiter.limitinput(e, config)}, "keypress")
		this.addEvent([config.thefield], function(){fieldlimiter.showlimit(config)}, "keyup")
	}
}

}
</script>

<script language="JavaScript1.2">

//Scrollable content III- By http://www.dynamicdrive.com

var speed, currentpos=curpos1=0,alt=1,curpos2=-1

function initialize(){
if (window.parent.scrollspeed!=0){
speed=window.parent.scrollspeed
scrollwindow()
}
}

function scrollwindow(){
temp=(document.all)? document.body.scrollTop : window.pageYOffset
alt=(alt==0)? 1 : 0
if (alt==0)
curpos1=temp
else
curpos2=temp

window.scrollBy(0,speed)
}

setInterval("initialize()",10)

</script>


</head>

<body onload="timer(); $shoutbox_on_load_focus"; style="min-width:0px;">
<div style="position:relative;bottom:$shout_text_height3$px;padding-top:$shout_text_height4$px;">
<table width="100%" cellpadding="0" cellspacing="0" border="0">
 <tr>
<td>
$shout_rows
</td>
</div><td>
<div class="shout_postarea" style="position:fixed;bottom:0px;padding-top:6px;height:$shout_text_height2$px;align:center;">
                $bbcode_bar
		<form name="shoutbox" action="$shoutform_action" method="post" onSubmit="changevalue()">
			<input type="hidden" name="shoutout" maxlength="$max_shout_length" />
			<input type="hidden" name="formsession" value="$formsession" /><br />
			<input type="text" name="message" size="33" maxlength="$max_shout_length" onfocus="clearText(this)" value="" /><br />
		$limiter
			<input type="submit" name="Submit" value="$shout_txt{'31'}" /> <input type="reset" value="$shout_txt{'31a'}" />
		</form><br />
		$smiley_bar<br />
		<div class="small"><a href="javascript:openWindow('./ShoutDisplay.pl?showall=1','shoutbox','toolbar=no,scrollbars=yes,locationbar=0,directories=no,status=no,resizable=$as_window_resize,menubar=no,width=$as_window_width,height=$as_window_height')">$shout_txt{'32'}</a>
		&nbsp;|&nbsp;
		<a href="javascript:openWindow('$scripturl?action=shout_smilies','smilies','toolbar=no,locationbar=0,directories=no,status=no,resizable=no,menubar=no,width=$mo_window_width,height=$mo_window_height')">$shout_txt{'33'}</a>
		&nbsp;|&nbsp;
    		<a href="javascript:window.location.reload();">$shout_txt{'34'}</a></div>
</div></td>
  </tr>

	<script type="text/javascript">
	fieldlimiter.setup({
	thefield: document.shoutbox.message,
	maxlength: $max_shout_length,
	statusids: ["shoutlimiter"],
	onkeypress:function(maxlength, curlength){
		if (curlength<maxlength)
			this.style.border="0px solid gray"
		else
			this.style.border="2px solid red"
	}
})
	</script>

</table>
~;

	&Timer;

	print qq~
</body>
</html>
~;
	}
}
1;
