<id>
Unread Topics for YaBB 2.6.11
</id>

<version>
0.2
</version>

<mod info>
This mod places an 'Unread Topics' link on the menu and in the Forumjump dropdown and creates a list of the member's Unread Topics.

Version History
---------------
0.1 - First release - September 19, 2014
0.2 - 2.6.11  - Jan 15, 2015
Instructions:

Apply the mod and upload (in ASCII mode):

cgi-bin/yabb2/Admin/Modlist.pm
cgi-bin/yabb2/Languages/English/Main.lng
cgi-bin/yabb2/Languages/Menu.lng
cgi-bin/yabb2/Sources/AdvancedTabs.pm
cgi-bin/yabb2/Sources/Recent.pm
cgi-bin/yabb2/Sources/SubList.pm
cgi-bin/yabb2/Sources/TabMenu.pm
cgi-bin/Templates/default/Display.template
cgi-bin/Variables/Settings.pm

Note: If new Settings are saved to Settings.pm, this mod will not be removable via BoardMod unless you remove the section of the mod that edits Settings.pm. Settings.pm will also need to be hand edited to removed 'unreadtopics' from the @AdvancedTabs list. 
</mod info>

<author>
Dandello
</author>

<homepage>
http://www.yabbforumsoftware.com/cgi-bin/yabb2/YaBB.pl
</homepage>

<edit file>
Admin/ModList.pm
</edit file>

<search for>
### END BOARDMOD ANCHOR ###
</search for>

<add before>
      $unreadtopics = q~Unread Topics YaBB 2.6.11|Dandello|This mod places an 'Unread Topics' link on the menu and in the Forumjump dropdown and creates a list of the member's Unread Topics.|0.2|01/15/2015~;
      push @installed_mods, $unreadtopics;
</add before>

<edit file>
Languages/English/Main.lng
</edit file>

<search for>
1;
</search for>

<add before>
$maintxt{'unread'} = 'Unread Topics';
$maintxt{'170b'} = 'No unread Topics found.';
$recent_txt{'unread'} = ' &raquo; Unread Topics';
</add before>

<edit file>
Languages/English/Menu.lng
</edit file>

<search for>

require Sources::Menu;
</search for>

<add before>
$img_txt{'unreadtopics'} = 'Unread Topics';
</add before>

<edit file>
Sources/AdvancedTabs.pm
</edit file>

<search for>
## End Mod hook tablist ##
</search for>

<add before>
    push @tablist, 'unreadtopics'; ### Unread topics ###
</add before>

<search for>
## End Mod Hook GetTextTab ##
</search for>

<add before>
    $texttab{'unreadtopics'}            = $img_txt{'unreadtopics'}; ### unreadtopics ###
</add before>


<edit file>
Sources/Recent.pm
</edit file>

<search for>
sub recursive_check {
</search for>

<add before>
sub RecentTopicsMem {
    spam_protection();
    LoadLanguage('MessageIndex');

    $recent_topics = $action eq 'recenttopicsmem' ? 1 : 0;
    my $dmax = $date - ( 365 * 86400 );
    if ( $max_log_days_old ) {
        $dmax = $date - ( $max_log_days_old * 86400 );
    }
    $numfound = 0;
    get_forum_master();
    foreach my $catid (@categoryorder) {
        my ( $catname, $catperms ) = split /\|/xsm, $catinfo{$catid};
        if ( !CatAccess($catperms) ) { next; }
        (@bdlist) = split /\,/xsm, $cat{$catid};
        recursive_check(@bdlist);
    }

    @data = reverse sort { $a cmp $b } @data;
    getlog();
    $numfound = 0;
    for my $i ( 0 .. $#data ) {
        ( $mtime, $curboard, $tnum, $treplies, $tusername, $tname, $tstate ) =
          split /\|/xsm, $data[$i];
        my $dlp = 0;
        if ( int( $yyuserlog{$tnum} ) > int( $yyuserlog{"$curboard--mark"} ) ) {
            $dlp = int( $yyuserlog{$tnum} )
        }
        else { $dlp = int $yyuserlog{"$curboard--mark"}; }
        if (
               $yyuserlog{"$tnum--unread"}
                || ( !$dlp && $mtime > $dmax )
                || ( $dlp > $dmax && $dlp < $mtime )
         ) {
            fopen( REC_THRETXT, "$datadir/$tnum.txt" );
            @mess = <REC_THRETXT>;
            fclose(REC_THRETXT);
        }
        else { next; }

        for my $c ( $#mess .. @mess ) {
            chomp $mess[$c];
            if ( $mess[$c] ) {
                (
                    $msub,  $mname,    $memail, $mdate,   $musername,
                    $micon, $mreplyno, $mip,    $message, $mns
                ) = split /\|/xsm, $mess[$c];
                $messages[$numfound] =
"$mdate|$curboard|$tnum|$c|$tusername|$tname|$msub|$mname|$memail|$mdate|$musername|$micon|$mreplyno|$mip|$message|$mns|$tstate|$mtime";
                $numfound++;
            }
        }
        if ( $recent_topics && $numfound == $display ) { last; }
    }

    @messages = reverse sort { $a cmp $b } @messages;

    if ( $numfound > 0 ) {
        $display = $numfound - 1;
        LoadCensorList();
        $icanbypass = checkUserLockBypass();
        $yymain .= $myunreadindex;
    }
    else {
        $yymain .= qq~<hr class="hr" /><b>$maintxt{'170b'}</b><hr />~;
    }

    $datanum = @messages;
    if ( @messages > 0 ) {
        my $newstart = $INFO{'newstart'} || 0;

        $postdisplaynum = 8;
        $max            = $datanum;
        $dnprpage = $maxdisplay;
        $tmpa           = 1;
        if ( $newstart >= ( ( $postdisplaynum - 1 ) * $dnprpage ) ) {
            $startpage =
              $newstart - ( ( $postdisplaynum - 1 ) * $dnprpage );
            $tmpa = int( $startpage / $dnprpage ) + 1;
        }
        if ( $max >= $newstart + ( $postdisplaynum * $dnprpage ) ) {
            $endpage = $newstart + ( $postdisplaynum * $dnprpage );
        }
        else { $endpage = $max }
        if ( $startpage > 0 ) {
            $pageindex =
qq~<a href="$scripturl?action=$action;newstart=0" class="norm">1</a>&nbsp;...&nbsp;~;
        }
        if ( $startpage == $dnprpage ) {
            $pageindex =
qq~<a href="$scripturl?action=$action;newstart=0" class="norm">1</a>&nbsp;~;
        }
        foreach my $counter ( $startpage .. ( $endpage - 1 ) ) {
            if ( $counter % $dnprpage == 0 ) {
                $pageindex .=
                  $newstart == $counter
                  ? qq~<b>[$tmpa]</b>&nbsp;~
                  : qq~<a href="$scripturl?action=$action;newstart=$counter" class="norm small">$tmpa</a>&nbsp;~;
                $tmpa++;
            }
        }
        $lastpn  = int( $logcount / $dnprpage ) + 1;
        $lastptn = ( $lastpn - 1 ) * $dnprpage;
        if ( $endpage < $max - ($dnprpage) ) {
            $pageindexadd = q~...&nbsp;~;
        }
        if ( $endpage != $max ) {
            $pageindexadd .=
qq~<a href="$scripturl?action=$action;newstart=$lastptn">$lastpn</a>~;
        }
        $pageindex .= $pageindexadd;

        $pageindex = qq~<span class="small" style="float: left;">$messageindex_txt{'139'}: $pageindex</span>~;

        $numbegin = ( $newstart + 1 );
        $numend   = ( $newstart + $dnprpage );
        if   ( $numend > $logcount ) { $numend  = $logcount; }
        if   ( $logcount == 0 )      { $numshow = q{}; }
        else                         { $numshow = qq~($numbegin - $numend)~; }
        @messages = splice @messages, $newstart, $dnprpage;
    }

    for my $i ( 0 .. $#messages ) {
        (
            $dummy,   $board, $tnum,    $c,     $tusername, $tname,
            $msub,    $mname, $memail,  $mdate, $musername, $micon,
            $mattach, $mip,   $message, $mns,   $tstate,    $trstart
        ) = split /\|/xsm, $messages[$i];
        $displayname = $mname;

        if ( $tusername ne 'Guest' && -e ("$memberdir/$tusername.vars") ) {
            LoadUser($tusername);
        }
        if ( ${ $uid . $tusername }{'regtime'} ) {
            $registrationdate = ${ $uid . $tusername }{'regtime'};
        }
        else {
            $registrationdate = $date;
        }

        if ( ${ $uid . $tusername }{'regdate'} && $trstart > $registrationdate )
        {
            if ( $iamguest ) {
                $tname = qq~$format_unbold{$tusername}~;
            }
            else {
                $tname =
qq~<a href="$scripturl?action=viewprofile;username=$useraccount{$tusername}" rel="nofollow">$format_unbold{$tusername}</a>~;
            }
        }
        elsif ( $tusername !~ m{Guest}sm && $trstart < $registrationdate ) {
            $tname = qq~$tname - $maintxt{'470a'}~;
        }
        else {
            $tname = "$tname ($maintxt{'28'})";
        }

        if ( $musername ne 'Guest' && -e ("$memberdir/$musername.vars") ) {
            LoadUser($musername);
        }
        if ( ${ $uid . $musername }{'regtime'} ) {
            $registrationdate = ${ $uid . $musername }{'regtime'};
        }
        else {
            $registrationdate = $date;
        }

        if ( ${ $uid . $musername }{'regdate'} && $mdate > $registrationdate ) {
            if ( $iamguest ) {
                $mname = qq~$format_unbold{$tusername}~;
            }
            else {
                $mname =
qq~<a href="$scripturl?action=viewprofile;username=$useraccount{$musername}" rel="nofollow">$format_unbold{$musername}</a>~;
            }
        }
        elsif ( $musername !~ m{Guest}sm && $mdate < $registrationdate ) {
            $mname = qq~$mname - $maintxt{'470a'}~;
        }
        else {
            $mname = "$mname ($maintxt{'28'})";
        }

        wrap();
        $movedflag = q{};
        ( $message, $movedflag ) = Split_Splice_Move( $message, $tnum );
        if ($enable_ubbc) {
            $ns = $mns;
            enable_yabbc();
            DoUBBC();
        }
        wrap2();
        ToChars($message);
        $message = Censor($message);

        ( $msub, undef ) = Split_Splice_Move( $msub, 0 );
        ToChars($msub);
        $msub = Censor($msub);

        if ($iamguest) {
            $notify = q{};
        }
        else {
            if ( ${ $uid . $username }{'thread_notifications'} =~
                /\b$tnum\b/xsm )
            {
                $notify =
qq~$menusep<a href="$scripturl?action=notify3;num=$tnum/$c;oldnotify=1">$img{'del_notify'}</a>~;
            }
            else {
                $notify =
qq~$menusep<a href="$scripturl?action=notify2;num=$tnum/$c;oldnotify=1">$img{'add_notify'}</a>~;
            }
        }
        $mdate = timeformat($mdate);

        # generate a sub board tree
        my $boardtree   = q{};
        my $parentboard = $board;
        while ($parentboard) {
            my ( $pboardname, undef, undef ) =
              split /\|/xsm, $board{"$parentboard"};
            if ( ${ $uid . $parentboard }{'canpost'}
                || !$subboard{$parentboard} )
            {
                $pboardname =
qq~<a href="$scripturl?board=$parentboard"><span class="under">$pboardname</span></a>~;
            }
            else {
                $pboardname =
qq~<a href="$scripturl?boardselect=$parentboard&subboards=1"><span class="under">$pboardname</span></a>~;
            }
            $boardtree = qq~ / $pboardname$boardtree~;
            $my_cat    = ${ $uid . $parentboard }{'cat'};
            ( $my_catname, undef ) = split /\|/xsm, $catinfo{$my_cat};
            $parentboard = ${ $uid . $parentboard }{'parent'};
        }
        $counter = $i + 1;

        if ( $tstate != 1 && ( !$iamguest || $enable_guestposting ) ) {
            $my_tstate = $myrecent_mess;
            $my_tstate =~ s/{yabb tnum}/$tnum/gsm;
            $my_tstate =~ s/{yabb c}/$c/gsm;
        }

        $yymain .= $myunread;
        $yymain =~ s/{yabb counter}/$counter/sm;
        $yymain =~ s/{yabb catbrd}/$my_cat/sm;
        $yymain =~ s/{yabb catname}/$my_catname/sm;
        $yymain =~ s/{yabb boardtree}/$boardtree/sm;
        $yymain =~ s/{yabb tnum}/$tnum\/$c#$c/sm;
        $yymain =~ s/{yabb msub}/$msub/sm;
        $yymain =~ s/{yabb mdate}/$mdate/sm;
        $yymain =~ s/{yabb tname}/$tname/sm;
        $yymain =~ s/{yabb mname}/$mname/sm;
        $yymain =~ s/{yabb my_tstate}/$my_tstate/sm;
        $yymain =~ s/{yabb message}/$message/sm;
        $yymain =~ s/{yabb pageindex}/$pageindex/sm;
    }

    $yynavigation = qq~&rsaquo; $numfound $maintxt{'unread'} (${ $uid . $username }{'realname'} ) ~;
    $yytitle      = qq~$maintxt{'unread'} (${ $uid . $username }{'realname'})~;
    template();
    return;
}

</add before>

<search for>
        @buffer = <REC_BDTXT>;
</search for>

<add after>
        if ( !$display ) {
            $display = scalar @buffer;
        }
</add after>

<edit file>
Sources/Subs.pm
</edit file>

<search for>
    $selecthtml .= qq~
                    <option value="action=recent;display=10">$recent_txt{'recentposts'}</option>
                    <option value="action=recenttopics;display=10">$recent_txt{'recenttopic'}</option>\n~;
</search for>

<add after>

    if ( !$iamguest ) {
        $selecthtml .= qq~
                    <option value="action=recenttopicsmem;">$recent_txt{'unread'}</option>\n~;
    }
</add after>

<edit file>
Sources/SubList.pm
</edit file>

<search for>
1;
</search for>

<add after>
$director{'recenttopicsmem'} = 'Recent.pm&RecentTopicsMem';
</add after>

<edit file>
Sources/TabMenu.pm
</edit file>

<search for>
## Tab Mod Hook ##
</search for>

<add before>
     if ( !$iamguest ) {
        $tab{'unreadtopics'} = qq~$tabhtml_l"$scripturl?action=recenttopicsmem" title="$img_txt{'unreadtopics'}">$img_txt{'unreadtopics'}</a>$tabhtml_r~;
     }

</add before>

<edit file>
Templates/default/Display.template
</edit file>

<search for>
$mymove_output_a = qq~<tr>
</search for>

<add before>
$myunreadindex = qq~<table class="tabtitle">
    <tr>
        <td style="padding-left:1%">{yabb pageindex}</td>
    </tr>
</table>~;

$myunread = qq~
<table class="catbg">
    <tbody>
    <tr>
        <td class="h_30px;" style="padding-left:1%">&nbsp;<a href="$scripturl?catselect={yabb catbrd}"><span class="under">{yabb catname}</span></a>{yabb boardtree} / <a href="$scripturl?num={yabb tnum}"><span class="under">{yabb msub}</span></a><br />
        &nbsp;<span class="small">$maintxt{'30'}: {yabb mdate}</span>&nbsp;</td>
    </tr>
    </tbody>
</table>
<table style="table-layout: fixed; margin-bottom:.5em">
    <tr>
        <td>
            <table class="titlebg">
                <tr class="search">
                    <td style="padding-left:5px">$maintxt{'109'} {yabb tname} | $maintxt{'197'} {yabb mname}</td>
                    {yabb my_tstate}
                </tr>
            </table>
        </td>
    </tr><tr>
        <td class="windowbg2 vtop h_80px" style="padding:5px">
            <div class="message" style="float: left; width: 99%; overflow: auto;">{yabb message}</div>
        </td>
    </tr>
</table>~;

</add before>

<edit file>
Variables/Settings.pm
</edit file>

<search for>
1;
</search for>

<add before>
push @AdvancedTabs, 'unreadtopics';

</add before>