#################################################################################
# users_today.pl (Users Today Perl Script)                                      #
#################################################################################
# Written for YaBB 2.x                                                          #
# Author: Brian Longo (aka, Mongo)                                              #
# email: webamster@eyeontoccoa.com                                              #
# http://www.eyeontoccoa.com/mods/                                              #
# Version: 1.8                                                                  #
# Date: January 17, 2006                                                        #
# Version History:                                                              #
# 1.0 - Original Release                                                        #
# 1.1 - Added switch to show show guests' IP addresses                          #
# 1.2 - Added a few enhancements like log viewing, "max stats", etc.            #
# 1.3 - Added spot for input value for number of days to see log                #
# 1.4 - Added an option to make this mod into a "Log Only" mod where the Users  #
#       Today block will not be show in the Board Index.                        #
# 1.5 & 1.6 - Nothing done to this file - only upped version to match mod       #
#       version.                                                                #
# 1.7 - Added capability to view log in three different ways:                   #
#       - Full log (all entries)                                                #
#       - "X" amount of days from the last log entry                            #
#       - From "A" date to "B" date                                             #
# 1.8 - Fixed a few bugs from last version and also added a "Clean Log" option  #
#       and a "Recover Log" option.                                             #
#################################################################################

if($action eq 'detailedversion') { return 1; }

LoadLanguage("users_today");

if(!-e("$vardir/usrtodayconfig.txt"))  {
	$fm = 0; $fd = 0; $fy = 0;
	$lm = 0; $ld = 0; $ly = 0;
    $sm = 0; $sd = 0; $sy2 = 0; $sy4 = 0;
	$em = 0; $ed = 0; $ey2 = 0; $ey4 = 0;
	$baddates = 0; $baddatee = 0; $run = -1;
	&users_today_set_2;
}

require "$vardir/usrtodayconfig.txt";

sub users_today_set {
    &check_dates;
  
	if ($date_style == 0) {$datestyle1 = ' selected="selected"'; }
	elsif ($date_style == 1) {$datestyle2 = ' selected="selected"'; }
	elsif ($date_style == 2) {$datestyle3 = ' selected="selected"'; }
	elsif ($date_style == 3) {$datestyle4 = ' selected="selected"'; }
	if ($log_only) { $log_only_checked = ' checked'; }
	if ($guest_view) { $guest_view_checked = ' checked'; }
	if ($show_guest_today) { $s_g_t_checked = ' checked'; }
	if ($guest_ip) { $g_ip_checked = ' checked'; }
	if ($user_today_hidden_show) {$usr_hid_tod_checked = ' checked';}
	if ($show_utlog) { $show_utlog_checked = ' checked'; }
	if ($show_max_stats) { $show_max_stats_checked = ' checked'; }
	if ($view_ips) { $view_ips_checked = ' checked'; }
	if ($link_guest) { $link_guest_checked = ' checked'; }
	if ($logopt == 0) {$lo1 = ' selected="selected"'; }
	elsif ($logopt == 1) {$lo2 = ' selected="selected"'; }
	elsif ($logopt == 2) {$lo3 = ' selected="selected"'; }
	if ($plogopt) { $plogopt_checked = ' checked'; }
    if ($plogopt2 == 0) {$plo1 = ' selected="selected"'; }
	elsif ($plogopt2 == 1) {$plo2 = ' selected="selected"'; }
	elsif ($plogopt2 == 2) {$plo3 = ' selected="selected"'; }
	elsif ($plogopt2 == 3) {$plo4 = ' selected="selected"'; }
	if ($recover_log) { $recover_log_checked = ' checked'; }
	if ($delete_old) { $delete_old_checked = ' checked'; }
	if ($clean_log) { $clean_log_checked = ' checked'; }
	if ($clear_log_method == 1) { $clear_log_method1 = ' selected="selected"'; }
	elsif ($clear_log_method == 2) { $clear_log_method2 = ' selected="selected"'; }
	$yymain .= qq~

<form action="$adminurl?action=users_today2" method="post">
 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="titlebg">
		 <img src="$imagesdir/preferences.gif" alt="" border="0" /><b>$uttxt{'100'}</b>
	   </td>
     </tr>
     <tr align="center" valign="middle">
       <td align="left" class="catbg"><span class="small">$uttxt{'101'} <i>$uttxt{'102'}</i></span>
	   </td>
     </tr>
	 <tr align="center" valign="middle">
       <td align="center" class="windowbg2" style="background-color: navy;"><span style="color: white; font-weight: bold;">$uttxt{'40'}</span></td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2">
       <div class="setting_cell">$uttxt{'4b'}</div>
       <div class="setting_cell2"><input type="checkbox" name="log_only" $log_only_checked /></div>
       <br />~;
	   if($log_only ne 1){
	   $yymain .= qq~
       <div class="setting_cell">$uttxt{'5'}</div>
       <div class="setting_cell2"><input type="checkbox" name="guest_view" $guest_view_checked /></div>
       <br />
       <div class="setting_cell">$uttxt{'6'}</div>
       <div class="setting_cell2"><input type="checkbox" name="show_guest_today" $s_g_t_checked /></div>
       <br />
       <div class="setting_cell">$uttxt{'12'}</div>
       <div class="setting_cell2"><input type="checkbox" name="show_hidden_users_today" $usr_hid_tod_checked /></div>
       <br />
       <div class="setting_cell">$uttxt{'11'}</div>
       <div class="setting_cell2"><input type="checkbox" name="view_ips" $view_ips_checked /></div>
       <br />~;
	   }
       if($guest_ip eq 1 && $log_only eq 0){
          $yymain .= qq~
          <div class="setting_cell">$uttxt{'10'}</div>
          <div class="setting_cell2"><input type="checkbox" name="link_guest" $link_guest_checked /></div>
          <br />~;
       }
       $yymain .= qq~
       </td>
	 </tr>
	 <tr align="center" valign="middle">
       <td align="center" class="windowbg2" style="background-color: green;"><span style="color: white; font-weight: bold;">$uttxt{'41'}</span></td>
     </tr>
     <tr valign="middle">
	   <td align="left" class="windowbg2">~;
       if(($guest_ip || $show_utlog || $show_max_stats) eq 1){
	      $yymain .= qq~
	      <div class="setting_cell">$uttxt{'34'}</div>
          <div class="setting_cell2">
	         <select name="datestyle" size="1">
  	            <option value="0"$datestyle1>$uttxt{'30'}</option>
  	            <option value="1"$datestyle2>$uttxt{'31'}</option>
  	            <option value="2"$datestyle3>$uttxt{'32'}</option>
	            <option value="3"$datestyle4>$uttxt{'33'}</option>
		      </select>
          </div>~;
       }
       $yymain .= qq~
       <div class="setting_cell">$uttxt{'9'}</div>
       <div class="setting_cell2"><input type="checkbox" name="guest_ip" $g_ip_checked /></div>
       <br />
       <div class="setting_cell">$uttxt{'9a'}</div>
       <div class="setting_cell2"><input type="checkbox" name="stats" $show_utlog_checked /></div>
       <br />
       <div class="setting_cell">$uttxt{'9b'}</div>
       <div class="setting_cell2"><input type="checkbox" name="max_stats" $show_max_stats_checked /></div>
       <br />
	   </td>
     </tr>
	 <tr align="center" valign="middle">
       <td align="center" class="windowbg2" style="background-color: black;"><span style="color: white; font-weight: bold;">$uttxt{'42'}</span></td>
     </tr>
	 <tr valign="middle">
	   <td align="left" class="windowbg2">~;
	 ## Delete old files after recovery ##
	   if(-e ("$vardir/uttotal-old.txt" || "$vardir/utstats-old.txt")){
	      $yymain .= qq~
	      <div class="setting_cell">$uttxt{'71'}</div>
          <div class="setting_cell2"><input type="checkbox" name="delete_old" $delete_old_checked /></div>
          <br />~;
	   }
	 ## Log Recovery Option ##
	   if(-e ("$vardir/ut_clean_log_date.txt")){
	   fopen(UTCLD, "$vardir/ut_clean_log_date.txt");
	   @log_dates=<UTCLD>;
	   fclose(UTCLD);
	   $clean_log_files = @log_dates;
	   chomp @log_dates;
	   $utcld = $clean_log_files -1;
	   $last_log_date = $log_dates[$utcld];
	   ($utcldyear, $utcldmo, $utcldday) = split(/\-/, $log_dates[$utcld]);
	   for($checkday=1;$checkday < 10;$checkday++){
	      $checkday2 = "0$checkday";
	      if($utcldmo eq $checkday2){$utcldmo = $checkday;}
	      if($utcldday eq $checkday2){$utcldday = $checkday;}
	   }
	   if($date_style eq 0){$rec_log_date = qq~$utcldmo/$utcldday/$utcldyear~;}
       elsif($date_style eq 1){$utcldyear = $utcldyear - 2000; $rec_log_date = qq~$utcldmo/$utcldday/0$utcldyear~;}
       elsif($date_style eq 2){$rec_log_date = qq~$utcldday.$utcldmo.$utcldyear~;}
       elsif($date_style eq 3){$utcldyear = $utcldyear - 2000; $rec_log_date = qq~$utcldday.$utcldmo.0$utcldyear~;}
	   $yymain .= qq~
	   <div class="setting_cell">$uttxt{'64'}</div>
       <div class="setting_cell2"><input type="checkbox" name="recover_log" $recover_log_checked /></div>
       <br />
	   <span style="display: block; font-style: italic; padding: 0px 0px 5px 5px;">$uttxt{'65'}$rec_log_date.&nbsp;&nbsp;$uttxt{'66'}<b>$last_log_date</b>$uttxt{'69'}$uttxt{'68'}$uttxt{'67'}<b>$last_log_date</b>$uttxt{'69'}</span>~;
	   }
	 ## Clean Log Option ##
	   if ($fm ne 0) {
	   $yymain .= qq~
	   <div class="setting_cell">$uttxt{'60'}</div>
       <div class="setting_cell2"><input type="checkbox" name="clean_log" $clean_log_checked /></div>
       <br />~;
	   }
	  ## Public Log Option ##
	   $yymain .= qq~
	   <div class="setting_cell">$uttxt{'59'}</div>
       <div class="setting_cell2"><input type="checkbox" name="plogopt" $plogopt_checked /></div>
       <br />~;
	   if($plogopt eq 1){
	      $yymain .= qq~
	      <div class="setting_cell">$uttxt{'54'}</div>
          <div class="setting_cell2">
	         <select name="plogopt2" size="1">
  	            <option value="0"$plo1>$uttxt{'55'}</option>
  	            <option value="1"$plo2>$uttxt{'56'}</option>
  	            <option value="2"$plo3>$uttxt{'57'}</option>
			    <option value="3"$plo4>$uttxt{'58'}</option>
		     </select>
          </div>
	      <br />~;
	   }
	  ## Admin Log Option ##
	   $yymain .= qq~
	   <div class="setting_cell">$uttxt{'50'}</div>
       <div class="setting_cell2">
	      <select name="logopt" size="1">
  	         <option value="0"$lo1>$uttxt{'51'}</option>
			 <option value="1"$lo2>$uttxt{'52'}</option>
			 <option value="2"$lo3>$uttxt{'53'}</option>
		  </select>
       </div>~;
	   if($logopt eq 0){$days_show=0;}
	   if($logopt eq 1){
	     if ($fm ne 0){
	      $yymain .= qq~
	      <div class="setting_cell">$uttxt{'9c'}</div>
	      <div class="setting_cell2"><input type="text" name="days_show" size="5" value="$days_show" /></div>
	      <br />~;
		 }
		 else {
		  $yymain .= qq~
		  <br /><br />
		  <div><span style="display: block; color: red; font-weight: bold; font-size: 12px; padding-top: 20px; padding: 20px 5px 0px 5px;">$uttxt{'29a'}</span></div>~;
	     }
	   }
	   if($logopt eq 2){
	     if ($fm ne 0){
		  $sy2 = "0$sy2" if($sy2 < 10);
		  $ey2 = "0$ey2" if($ey2 < 10);
	      if($date_style eq 0){
		     $df = $uttxt{'30'};
			 $date_boxes_start = qq~<input type="text" name="sm" size="2" value="$sm" />/<input type="text" name="sd" size="2" value="$sd" />/<input type="text" name="sy4" size="4" value="$sy4" />~;
			 $date_boxes_end = qq~<input type="text" name="em" size="2" value="$em" />/<input type="text" name="ed" size="2" value="$ed" />/<input type="text" name="ey4" size="4" value="$ey4" />~;
		  }
		  elsif($date_style eq 1){
		     $df = $uttxt{'31'};
			 $date_boxes_start = qq~<input type="text" name="sm" size="2" value="$sm" />/<input type="text" name="sd" size="2" value="$sd" />/<input type="text" name="sy2" size="2" value="$sy2" />~;
			 $date_boxes_end = qq~<input type="text" name="em" size="2" value="$em" />/<input type="text" name="ed" size="2" value="$ed" />/<input type="text" name="ey2" size="2" value="$ey2" />~;
		  }
		  elsif($date_style eq 2){
		     $df = $uttxt{'32'};
			 $date_boxes_start = qq~<input type="text" name="sd" size="2" value="$sd" />.<input type="text" name="sm" size="2" value="$sm" />.<input type="text" name="sy4" size="4" value="$sy4" />~;
			 $date_boxes_end = qq~<input type="text" name="ed" size="2" value="$ed" />.<input type="text" name="em" size="2" value="$em" />.<input type="text" name="ey4" size="4" value="$ey4" />~;
		  }
		  elsif($date_style eq 3){
		     $df = $uttxt{'33'};
			 $date_boxes_start = qq~<input type="text" name="sd" size="2" value="$sd" />.<input type="text" name="sm" size="2" value="$sm" />.<input type="text" name="sy2" size="2" value="$sy2" />~;
			 $date_boxes_end = qq~<input type="text" name="ed" size="2" value="$ed" />.<input type="text" name="em" size="2" value="$em" />.<input type="text" name="ey2" size="2" value="$ey2" />~;
		  }
		 }
		 else{
		  $date_boxes_start = qq~<!--No log entries-->~;
		  $date_boxes_end = qq~<!--No log entries-->~;
		 }
		  &datestyle;
		  if ($fm ne 0){$date_range = qq~$uttxt{'20'}$df$uttxt{'21'}<br/><br />$uttxt{'27'}<span style="color: red; font-weight: bold; text-decoration: underline;">$datelogopt21</span>$uttxt{'28'}<span style="color: red; font-weight: bold; text-decoration: underline;">$datelogopt22</span>~;}
		  else {$no_date_range = qq~<span style="display: block; color: red; font-weight: bold; font-size: 12px; padding: 20px 5px 0px 5px;">$uttxt{'29'}</span>~;}
		  if ($fm ne 0){
	      $yymain .= qq~
		  <div class="setting_cell">$date_range</div>
		  <div class="setting_cell2">
		  <table width="100%">
		    <tr valign="middle">
	          <td align="left" width="100">$uttxt{'22'}</td>
			  <td align="left">$date_boxes_start</td>
		    </tr>
			<tr valign="middle">
			  <td align="left" width="100">$uttxt{'23'}</td>
			  <td align="left">$date_boxes_end</td>
		    </tr>
		  </table>
		  </div>~;
		  }
		  else{
	      $yymain .= qq~
		  <br /><br />
		  <div>$no_date_range</div>~;
		  }
		  if(($baddates || $baddatee) eq 1){
		     if(($baddates eq 1) && ($baddatee eq 0)){$badtxt = qq~$uttxt{'24'}~;}
		     elsif(($baddates eq 0) && ($baddatee eq 1)){$badtxt = qq~$uttxt{'25'}~;}
		     elsif(($baddates && $baddatee) eq 1){$badtxt = qq~$uttxt{'26'}~;}
		     $yymain .= qq~
			 <tr valign="middle">
			   <td align="left" style="background-color: yellow;"><span style="font-weight: bold; color: red;">$badtxt</span></td>
		     </tr>~;
		  }
		  $yymain .= qq~
	      <br />~;
	   }
	   $yymain .= qq~
	   </td>
	 </tr>~;
   ## Recover Log Note ##
	 if(-e ("$vardir/ut_clean_log_date.txt")){
	 $yymain .= qq~
	 <tr>
	   <td class="windowbg2">$uttxt{'70'}</td>
	 <tr>~;
	 }
	 if($clean_log eq 1){
	 $yymain .= qq~
	    <tr align="center" valign="middle">
          <td align="center" class="windowbg2" style="background-color: brown;"><span style="color: white; font-weight: bold;">$uttxt{'43'}</span></td>
        </tr>
	    <tr valign="middle">
	      <td align="left" class="windowbg2">
	      <div class="setting_cell">$uttxt{'60a'}</div>
          <div class="setting_cell2">
	      <select name="clear_log_method" size="1">
  	         <option value="1"$clear_log_method1>$uttxt{'61'}</option>
  	         <option value="2"$clear_log_method2>$uttxt{'62'}</option>
	      </select>
          </div>
	    </tr>
	    <tr>
	      <td class="windowbg2">$uttxt{'63'}</td>
	    </tr>~;
     }
   $yymain .= qq~
   </table>
 </div>

<br />

 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="center" class="catbg">
		 <input type="submit" value="$admin_txt{'10'}" />
	   </td>
     </tr>
   </table>
 </div>
</form>~;

## Set up divisions for Statistics and/or Guest IP List ##
if(($show_utlog || $show_max_stats) && $guest_ip eq 1){
   $yymain .= qq~
   <br /><br />
   <div style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
     <div class="bordercolor" style="float: left; padding: 0px; width: 49%; margin-left: 0px; margin-right: auto;">~;
     &statistics;
     $yymain .= qq~
     </div>
     <div class="bordercolor" style="float: right; padding: 0px; width: 49%; margin-right: 0px; margin-left: auto;">~;
     &guest_ip_list;
     $yymain .= qq~
     </div>
   </div>~;
}

elsif(($show_utlog || $show_max_stats) eq 1 && $guest_ip eq 0){
   $yymain .= qq~
   <br /><br />
   <div class="bordercolor" style="padding: 0px; width: 50%; margin-left: auto; margin-right: auto;">~;
     &statistics;
     $yymain .= qq~
   </div>~;
}

elsif(($show_utlog || $show_max_stats) eq 0 && $guest_ip eq 1){
   $yymain .= qq~
   <br /><br />
   <div class="bordercolor" style="padding: 0px; width: 50%; margin-left: auto; margin-right: auto;">~;
     &guest_ip_list;
     $yymain .= qq~
   </div>~;
}
   
else {
   $yymain .= qq~<!--Nothing selected -->~;
}
	$yytitle = $admin_txt{'222'};
	$action_area = "users_today";
	&AdminTemplate;
	exit;

}
	
sub users_today_set_2 {

    &is_admin_or_gmod;

	$log_only = $FORM{'log_only'} ? 1 : 0;
	$date_style = $FORM{'datestyle'} || 0;
	$guest_view = $FORM{'guest_view'} ? 1 : 0;
	$show_guest_today = $FORM{'show_guest_today'} ? 1 : 0;
	$user_today_hidden_show = $FORM{'show_hidden_users_today'} ? 1 :0;
	$view_ips = $FORM{'view_ips'} ? 1 : 0;
	$guest_ip = $FORM{'guest_ip'} ? 1 : 0;
	$show_utlog = $FORM{'stats'} ? 1 : 0;
    $show_max_stats = $FORM{'max_stats'} ? 1 : 0;
	$days_show = $FORM{'days_show'} || 0;
	$link_guest = $FORM{'link_guest'} ? 1 : 0;
	$logopt = $FORM{'logopt'} || 0;
	$plogopt = $FORM{'plogopt'} ? 1 : 0;
	$plogopt2 = $FORM{'plogopt2'} || 0;
	$recover_log = $FORM{'recover_log'} ? 1 : 0;
	$delete_old = $FORM{'delete_old'} ? 1 : 0;
	$clean_log = $FORM{'clean_log'} ? 1 : 0;
	$clear_log_method = $FORM{'clear_log_method'} || 0;
	$sm = $FORM{'sm'} || 0;
	$sd = $FORM{'sd'} || 0;
	$sy2 = $FORM{'sy2'} || 0;
	$sy4 = $FORM{'sy4'} || 0;
	$em = $FORM{'em'} || 0;
	$ed = $FORM{'ed'} || 0;
	$ey2 = $FORM{'ey2'} || 0;
	$ey4 = $FORM{'ey4'} || 0;

	&recover_log;
	&delete_old;
	&check_dates;

	for($checkut=1;$checkut < 10;$checkut++){
	   $checkut2 = "0$checkut";
	   if($sd eq $checkut2){$sd = $checkut;}
	   if($sm eq $checkut2){$sm = $checkut;}
	   if($ed eq $checkut2){$ed = $checkut;}
	   if($em eq $checkut2){$em = $checkut;}
	   if($sy2 eq $checkut2){$sy2 = $checkut;}
	   if($ey2 eq $checkut2){$ey2 = $checkut;}
	   if($fm eq $checkut2){$fm = $checkut;}
	   if($fd eq $checkut2){$fd = $checkut;}
	   if($fy eq $checkut2){$fy = $checkut;}
	   if($lm eq $checkut2){$lm = $checkut;}
	   if($ld eq $checkut2){$ld = $checkut;}
	   if($ly eq $checkut2){$ly = $checkut;}
	}
	
	&clear_log_method;
	
	my $setfile = << "EOF";
###############################################################################
# usrtodayconfig.txt (Users Today configurations)                             #       
###############################################################################

\$log_only = $log_only; # set to 1 to only use the log function in the Admin Center and not show Users Today block in Board Index
\$date_style = $date_style; # set individual users' date style preference
\$guest_view = $guest_view; # set to 1 to allow guests to see the Guests/Members Online Today list
\$show_guest_today = $show_guest_today; # set to 1 to show number of guests in Online Today list
\$user_today_hidden_show = $user_today_hidden_show; # set to 1 to keep hidden users off of the Users Today listing
\$view_ips = $view_ips; # set to 1 to view guest IP addresses in the Users Today block
\$show_utlog = $show_utlog; # set to 1 to see the Users Today Statistical Log in the Users Today Administration area
\$show_max_stats = $show_max_stats; #set to 1 to see the most, total and average user/guest stats
\$guest_ip = $guest_ip; # set to 1 to view the Guest IP Log in the Users Today Administration area
\$days_show = $days_show; # Number of days to show log
\$link_guest = $link_guest; # set to 1 to link the number of guests who've visited the board to view the Guest IP Log in the Users Today Administration area 
\$logopt = $logopt; # determines how the log will be viewed - either full, X days from today, or between two dates
\$plogopt = $plogopt; # set to 1 to enable the public log
\$plogopt2 = $plogopt2; # determines who is allowed to view the public log
\$clean_log = $clean_log; # set to 1 to clean the statistical logs
\$clear_log_method = $clear_log_method; # if value equals 2, log will be cleaned on a yearly basis
\$sm = $sm; # starting log month
\$sd = $sd; # starting log day
\$sy2 = $sy2; # starting log year (2 digit)
\$sy4 = $sy4; # starting log year (4 digit)
\$em = $em; # ending log month
\$ed = $ed; # ending log day
\$ey2 = $ey2; # ending log year (2 digit)
\$ey4 = $ey4; # ending log year (4 digit)
\$baddates = $baddates; # if at 1, indicates a bad starting date was entered
\$baddatee = $baddatee; # if at 1, indicates a bad ending date was entered
\$run = $run; # just a counter
\$fm = $fm;
\$fd = $fd;
\$fy = $fy;
\$lm = $lm;
\$ld = $ld;
\$ly = $ly;

1;
EOF

	fopen(FILE, ">$vardir/usrtodayconfig.txt");
	print FILE $setfile;
	fclose(FILE);
	
	if ($action eq "users_today2") {
		$yySetLocation = qq~$adminurl?action=users_today~;
		&redirectexit;
	}

}

## Create Guest IP List ##
sub guest_ip_list {
&datestyle;
$yymain .= qq~
<table class="bordercolor" width="100%" cellspacing="1" style="margin-left: auto; margin-right: auto;">
   <tr valign="middle">
      <td align="center" class="titlebg"><b>$uttxt{'7'}<span style="color: black;">$dateformat_guest</span></b>
	  </td>
   </tr>
   <tr valign="middle">
           <td>~;
## start link IP mod - define $iplink ##
		if($iputil eq 0){$iputil = 'ptr';}
		if($iputil eq 1){$iputil = 'whois';}
		if($iputil eq 2){$iputil = 'city';}
		if($iputil eq 3){$iputil = 'tracert';}
## end link IP mod ##
   if (-e ("$vardir/guesttoday.txt")) {
      open(GUESTFILE,"$vardir/guesttoday.txt");
	  @gtoday=<GUESTFILE>;
	  close(GUESTFILE);
	  $yymain .= qq~
		   <div class="windowbg2" style="width: 100%; overflow: auto; height: 200px; padding: 2px 0px 2px 2px; margin: -1px 0px -1px -1px;">~;
	    $guesttodaycount = @gtoday;
	    for($g=1;$g < $guesttodaycount;$g++){
	       $gtoday[$g] =~ s/\n//gi;
	       $g_ip = $gtoday[$g];
		   $iplink = qq~<a href="http://www.dnsstuff.com/tools/$iputil.ch?ip=$g_ip" target="_blank" style="text-decoration: underline;">$g_ip</a>~; ## Link IP for Users Today ##
	       $yymain .= qq~
	       <span style="padding: 0px 5px; font-size: 12px;">$iplink</span><br />~; ## $iplink inserted for Link IP Mod ##
		}
		$guesttodaycount = $guesttodaycount - 1;
		$yymain .= qq~
		   </div>
		   </td>
		</tr>	
		<tr align="center" valign="middle">
          <td align="left" class="catbg">$uttxt{'8'}<span style="color: red; font-weight: bold;">$guesttodaycount</span></td>
	    </tr>
	  </table>~;
   }
}
## End Guest IP List ##

## Create Statistics Table ##
sub statistics {
## Show "Max Stats" table ##
   $yymain .= qq~
   <table class="bordercolor" width="100%" cellspacing="1" style="margin-left: auto; margin-right: auto;">~;
   if($show_max_stats eq 1){
      fopen(UTSTATS, "$vardir/utstats.txt");
      @utstats = <UTSTATS>;
      fclose(UTSTATS);
      ($utmostuser, $utmumo, $utmuday, $utmuyr) = split(/\|/, $utstats[0]);
      ($utmostguest, $utmgmo, $utmgday, $utmgyr) = split(/\|/, $utstats[1]);
      ($uttotaluser) = $utstats[2];
      ($uttotalguest) = $utstats[3];
	  ($utlogdays) = $utstats[4];
      ($utavguser) = $utstats[5];
      ($utavgguest) = $utstats[6];
      chomp $utmuyr;
      chomp $utmgyr;
      chomp $uttotaluser;
      chomp $uttotalguest;
	  chomp $utlogdays;
      chomp $utavguser;
      chomp $utavgguest;
      &datestyle;
	  if($utmumo ne ''){$mostuser = qq~<b>$utmostuser</b><br /><span style="color: red; font-style: italic;">($dateformat_user_stats)</span>~;}
	  else{$mostuser = qq~<!--No Data-->~;}
	  if($utmgmo ne ''){$mostguest = qq~<b>$utmostguest</b><br /><span style="color: red; font-style: italic;">($dateformat_guest_stats)</span>~;}
	  else{$mostguest = qq~<!--No Data-->~;}
	  $yymain .= qq~
      <tr valign="middle">
         <td align="center" class="titlebg" colspan="3"><b>$uttxt{'17'}</b></td>
	  </tr>
	  <tr valign="middle">
	     <td width="40%" align="left" class="catbg">&nbsp;</td>
	     <td width="30%" align="center" class="catbg"><b>$uttxt{'14'}</b></td>
	     <td width="30%" align="center" class="catbg"><b>$uttxt{'15'}</b></td>
      </tr> 
	  <tr valign="middle">
	     <td width="40%" align="left" class="windowbg2"><b>$uttxt{'18'}</b></td>
	     <td width="30%" align="center" class="windowbg2">$mostuser</td>
	     <td width="30%" align="center" class="windowbg2">$mostguest</td>
      </tr>
	  <tr valign="middle">
	     <td width="40%" align="left" class="windowbg2">$uttxt{'19b'}</td>
	     <td width="30%" align="center" class="windowbg2">$uttotaluser</td>
	     <td width="30%" align="center" class="windowbg2">$uttotalguest</td>
      </tr>
	  <tr valign="middle">
	     <td width="40%" align="left" class="windowbg2">$uttxt{'19a'}</td>
	     <td width="30%" align="center" class="windowbg2">$utavguser</td>
	     <td width="30%" align="center" class="windowbg2">$utavgguest</td>
      </tr>
	  <tr valign="middle">
	     <td width="40%" align="left" class="windowbg2">$uttxt{'19c'}</td>
	     <td width="60%" align="center" colspan="2" class="windowbg2">$utlogdays</td>
      </tr>~;
   }
   if($show_utlog eq 1){
   $yymain .= qq~
      <tr valign="middle">
         <td align="center" class="titlebg" colspan="3"><b>$uttxt{'16'}</b></td>
	  </tr>
      <tr valign="middle">
	     <td width="40%" align="left" class="windowbg2"><b>$uttxt{'13'}</b></td>
	     <td width="30%" align="center" class="windowbg2"><b>$uttxt{'14'}&nbsp;$uttxt{'14a'}</b></td>
	     <td width="30%" align="center" class="windowbg2"><b>$uttxt{'15'}</b></td>
      </tr>~;
     if (-e ("$vardir/uttotal.txt")) {
       fopen(TOTUSER,"$vardir/uttotal.txt");
	   @totusers=<TOTUSER>;
	   fclose(TOTUSER);
	   $countlog = @totusers;
	   if($logopt eq 2){
		  $days_show = 0;
	      $count_log = 0;
		  $start_pos = -1;
		  $finish_pos = -1;
		  $sm = "0$sm" if($sm < 10);
		  $sd = "0$sd" if($sd < 10);
		  $em = "0$em" if($em < 10);
		  $ed = "0$ed" if($ed < 10);
		  $endoflog = $count_log-1;
		  while($count_log < $countlog) {
		     ($logmonth, $logday, $logyear, $blank, $blank, $blank, $blank) = split(/\|/, $totusers[$count_log]); 
			 if($date_style eq 0 || $date_style eq 2){
			    $logyear = "20$logyear";
			    if(($logmonth eq $sm)&&($logday eq $sd)&&($logyear eq $sy4)){$start_pos = $count_log;}
			    if(($logmonth eq $em)&&($logday eq $ed)&&($logyear eq $ey4)){$finish_pos = $count_log;}
		     }
			 else{
			 	if(($logmonth eq $sm)&&($logday eq $sd)&&($logyear eq $sy2)){$start_pos = $count_log;}
			    if(($logmonth eq $em)&&($logday eq $ed)&&($logyear eq $ey2)){$finish_pos = $count_log;}				
			 }
			 $count_log++;
		  }
		  if(($start_pos && $finish_pos) > -1){
	         $ut = $start_pos;
			 $countlog = $finish_pos+1;
		  }
		  elsif($start_pos > -1){$ut = $start_pos;}
		  elsif($finish_pos > -1){$countlog = $finish_pos+1;}
		  else {$ut=$countlog-$days_show;}
	   }
	   else {$ut=$countlog-$days_show;}
	   if(($ut eq $countlog) || ($ut < 0)){$ut=0;}
	      for($t=$ut;$t < $countlog;$t++){
	         chomp $userstat;
	         ($utmonth, $utday, $utyear, $utdow, $totuser, $mempercent, $totguest) = split(/\|/, $totusers[$t]);
		     &datestyle;
		     $yymain .= qq~
		     <tr valign="middle">
		        <td width="40%" align="left" class="windowbg2">$dateformat_log</td>
		        <td width="30%" align="center" class="windowbg2">$totuser&nbsp;<span style="color: red; font-style: italic;">($mempercent)</span></td>
		        <td width="30%" align="center" class="windowbg2">$totguest</td>
		     </tr>~;
		  }
	 }
	 $yymain .= qq~
	 </table>~;
   } 
}

## End Statistics Table ##

## define $dateformat ##
sub datestyle {
   if($date_style eq 0){
      $fy = $fy+2000;
	  $ly = $ly+2000;
      $dateformat_guest = qq~, $mon_num/$mday/$year~;
	  $dateformat_log = qq~$utmonth/$utday/20$utyear~;
	  $dateformat_user_stats = qq~$utmumo/$utmuday/20$utmuyr~;
	  $dateformat_guest_stats = qq~$utmgmo/$utmgday/20$utmgyr~;
	  $datelogopt21 = qq~$fm/$fd/$fy~;
	  $datelogopt22 = qq~$lm/$ld/$ly~;
   }
   elsif($date_style eq 1){
      $iplogyear = $year-2000;
	  $iplogyear = "0$iplogyear" if ($iplogyear < 10); 
	  $dateformat_guest = qq~, $mon_num/$mday/$iplogyear~;
	  $dateformat_log = qq~$utmonth/$utday/$utyear~;
	  $dateformat_user_stats = qq~$utmumo/$utmuday/$utmuyr~;
	  $dateformat_guest_stats = qq~$utmgmo/$utmgday/$utmgyr~;
	  $datelogopt21 = qq~$fm/$fd/0$fy~;
	  $datelogopt22 = qq~$lm/$ld/0$ly~;
   }
   elsif($date_style eq 2){
      $fy = $fy+2000;
	  $ly = $ly+2000;
      $dateformat_guest = qq~, $mday.$mon_num.$year~;
	  $dateformat_log = qq~$utday.$utmonth.20$utyear~;
	  $dateformat_user_stats = qq~$utmuday.$utmumo.20$utmuyr~;
	  $dateformat_guest_stats = qq~$utmgday.$utmgmo.20$utmgyr~;
	  $datelogopt21 = qq~$fd.$fm.$fy~;
	  $datelogopt22 = qq~$ld.$lm.$ly~;
   }
   elsif($date_style eq 3){
      $iplogyear = $year-2000;
	  $iplogyear = "0$iplogyear" if ($iplogyear < 10);
      $dateformat_guest = qq~, $mday.$mon_num.$iplogyear~;
      $dateformat_log = qq~$utday.$utmonth.$utyear~;
	  $dateformat_user_stats = qq~$utmuday.$utmumo.$utmuyr~;
	  $dateformat_guest_stats = qq~$utmgday.$utmgmo.$utmgyr~;
	  $datelogopt21 = qq~$fd.$fm.0$fy~;
	  $datelogopt22 = qq~$ld.$lm.0$ly~;
   }
}

sub check_dates {
   if ($fm < 1 || $recover_log eq 1) {
     if (-e ("$vardir/uttotal.txt")) {
       fopen(UTLOG,"$vardir/uttotal.txt");
	   @utentries=<UTLOG>;
	   fclose(UTLOG);
	   $utlines = @utentries;
	   $skip = 0;
	   $start_good = -1; 
	   $finish_good = -1;
	   $sm = "0$sm" if($sm < 10);
	   $sd = "0$sd" if($sd < 10);
	   $em = "0$em" if($em < 10);
	   $ed = "0$ed" if($ed < 10);
	   $endoflog = $count_log-1;
	   ($logms, $logds, $logys, $blank, $blank, $blank, $blank) = split(/\|/, $utentries[0]);
	   ($logme, $logde, $logye, $blank, $blank, $blank, $blank) = split(/\|/, $utentries[$utlines-1]);
	   while($skip < $utlines) {
	      ($logmonth, $logday, $logyear, $blank, $blank, $blank, $blank) = split(/\|/, $utentries[$skip]); 
		  if($date_style eq 0 || $date_style eq 2){
			 $logyear = "20$logyear";
			 if(($logmonth eq $sm)&&($logday eq $sd)&&($logyear eq $sy4)){$start_good = $skip;}
			 if(($logmonth eq $em)&&($logday eq $ed)&&($logyear eq $ey4)){$finish_good = $skip;}
		  }
		  else{
			 if(($logmonth eq $sm)&&($logday eq $sd)&&($logyear eq $sy2)){$start_good = $skip;}
			 if(($logmonth eq $em)&&($logday eq $ed)&&($logyear eq $ey2)){$finish_good = $skip;}				
		  }
		  $skip++;
	   }
	   if($logopt eq 2){
	      if($start_good > -1){$baddates = 0;}
	      else{$baddates = 1; &set_start_date;}
	      if($finish_good > -1){$baddatee = 0;}
	      else{$baddatee = 1; &set_end_date;}
	   }
	   if($logopt ne 2){$baddates = 0; $baddatee = 0; &set_start_date; &set_end_date; $run = -1;}
	   if($logopt eq 2){$run++;}    
	   if($run < 1){$baddates = 0; $baddatee = 0;}
	   $fm = $logms; $fd = $logds; $fy = $logys;
	   $lm = $logme; $ld = $logde; $ly = $logye;
	 }
   }
}

sub set_start_date {
	$sm = $logms; 
	$sd = $logds;
	$sy4 = 2000+$logys;
	$sy2 = $logys;
}

sub set_end_date {
    $em = $logme; 
    $ed = $logde;
	$ey4 = 2000+$logye;
	$ey2 = $logye;
}

sub clear_log_method {
  if ($fm ne 0){
    if($clean_log eq 1){
	  if(!-e ("$vardir/ut_clean_log_date.txt")){
	     fopen(UTCLD, ">$vardir/ut_clean_log_date.txt");
		 fclose(UTCLD);
	  }
	  if($clear_log_method eq 1){
	    $ly = $ly+2000;
	    $lm = "0$lm" if($lm < 10);
	    $ld = "0$ld" if($ld < 10);
	    fopen(UTCLD, ">>$vardir/ut_clean_log_date.txt");
	    print UTCLD "$ly-$lm-$ld\n";
	    fclose(UTCLD);
	    rename("$vardir/uttotal.txt", "$vardir/uttotal-$ly-$lm-$ld.txt");
	    rename("$vardir/utstats.txt", "$vardir/utstats-$ly-$lm-$ld.txt");
	    fopen(UTTOTAL,">$vardir/uttotal.txt");
	    fclose(UTTOTAL);
	    fopen(UTSTATS, ">$vardir/utstats.txt");
	    fclose(UTSTATS);
		$sm = 0; $sd = 0; $sy2 = 0; $sy4 = 0;
		$em = 0; $ed = 0; $ey2 = 0; $ey4 = 0;
	    $fm = 0; $fd = 0; $fy = 0;
	    $lm = 0; $ld = 0; $ly = 0;
	    $baddates = 0; $baddatee = 0; $run = -1;
		$clean_log = 0;
		$clear_log_method = 0;
	  }
	  if($clear_log_method eq 2) {
	    if(($lm eq 12) && ($ld eq 31)){
	      fopen(UTCLD, ">>$vardir/ut_clean_log_date.txt");
          $ly = $ly+2000;
	      $lm = "0$lm" if($lm < 10);
	      $ld = "0$ld" if($ld < 10);
	      print UTCLD "$ly-$lm-$ld\n";
	      fclose(UTCLD);
	      rename("$vardir/uttotal.txt", "$vardir/uttotal-$ly-$lm-$ld.txt");
	      rename("$vardir/utstats.txt", "$vardir/utstats-$ly-$lm-$ld.txt");
	      fopen(UTTOTAL,">$vardir/uttotal.txt");
	      fclose(UTTOTAL);
	      fopen(UTSTATS, ">$vardir/utstats.txt");
	      fclose(UTSTATS);
		  $sm = 0; $sd = 0; $sy2 = 0; $sy4 = 0;
		  $em = 0; $ed = 0; $ey2 = 0; $ey4 = 0;
  	      $fm = 0; $fd = 0; $fy = 0;
	      $lm = 0; $ld = 0; $ly = 0;
	      $baddates = 0; $baddatee = 0; $run = -1;
	    }
	  }
    }
  }
}

sub recover_log {
   if($recover_log eq 1){
	  if(-e ("$vardir/ut_clean_log_date.txt")){
	     fopen(UTCLD, "$vardir/ut_clean_log_date.txt");
	     @log_dates=<UTCLD>;
	     fclose(UTCLD);
	     $clean_log_files = @log_dates;
	     chomp @log_dates;
	     $utcld = $clean_log_files -1;
	     $last_log_date = $log_dates[$utcld];
         rename("$vardir/uttotal.txt", "$vardir/uttotal-old.txt");
	     rename("$vardir/utstats.txt", "$vardir/utstats-old.txt");
	     rename("$vardir/uttotal-$last_log_date.txt", "$vardir/uttotal.txt");
	     rename("$vardir/utstats-$last_log_date.txt", "$vardir/utstats.txt");
		 unlink "$vardir/ut_clean_log_date.txt";
      }
   }
}

sub delete_old {
   if($delete_old eq 1){
      unlink "$vardir/uttotal-old.txt";
	  unlink "$vardir/utstats-old.txt";
   }
}

1;