###############################################################################
# ViewGroups.pm                                                               #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.6.11                                                 #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2014 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Mod written by Derek Barnstorm, updated to 2.6.0 by Dandello                #
###############################################################################
# use strict;
#use warnings;
#no warnings qw(uninitialized once redefine);
our $VERSION = '2.6.11';
$viewgroupspmver = 'YaBB 2.6.11  $Revision: 0.5 $';

sub ViewGroups {

    if (   !$INFO{'title'}
        || !$allow_view_groups
        || ( $iamguest && $allow_view_groups != 1 )
        || ( $allow_view_groups == 3 && !$staff )
        || ( $allow_view_groups == 4 && !$iamadmin && !$iamgmod )
        || ( $allow_view_groups == 5 && !$iamadmin ) )
    {
        fatal_error('no_access');
    }

    LoadLanguage('MemberList');
    get_micon();
    get_template('Mods/ViewGroups');

    $group_title = $INFO{'title'};
    $no_post_id  = $INFO{'gid'};
    if   ( !$INFO{'start'} ) { $start = 0; }
    else                     { $start = "$INFO{'start'}"; }
    $group_title =~ s/_/ /gsm;

    if ( ( !exists $Group{$group_title} ) && ( !exists $NoPost{$no_post_id} ) )
    {
        fatal_error('no_group_exists');
    }

    ManageMemberinfo('load');
    my $show_group = q{};
    $member_count = 0;
    $colspan      = 2;
    my @grplst = ();

    foreach my $membername (
        sort { lc $memberinf{$a} cmp lc $memberinf{$b} }
        keys %memberinf
      )
    {
        ( undef, undef, $memposition, undef, $memaddgroups ) = split /[|]/xsm,
          $memberinf{$membername};
        my $add_group_title = 0;
        foreach my $addgrptitle ( split /,/xsm, $memaddgroups ) {
            if (   ( $addgrptitle eq $group_title )
                || ( $addgrptitle eq $no_post_id ) )
            {
                $add_group_title = 1;
            }
        }
        if (   ( $memposition eq $group_title )
            || ( $memposition eq $no_post_id )
            || $add_group_title )
        {
            push @grplst, $membername;
        }
        elsif ( $group_title eq 'Moderator' ) {
            *get_subboards = sub {
                my @x = @_;
                foreach my $board (@x) {
                    ( $boardname, $boardperms, $boardview ) =
                    split /\|/xsm, $board{"$board"};
                    if (   ${ $uid . $board }{'ann'} == 1
                        || ${ $uid . $board }{'rbin'} == 1 )
                    {
                        next;
                    }
                    $moderators = ${ $uid . $board }{'mods'};
                    my @BoardModerators = split /, ?/sm, $moderators;
                    push @grplst, @BoardModerators;
                    if ( $subboard{$board} ) {
                        get_subboards( split /\|/xsm, $subboard{$board} );
                    }
                }
            };
            foreach my $catid (@categoryorder) {
                (@bdlist) = split /\,/xsm, $cat{$catid};
                get_subboards(@bdlist);
            }
        }
        my %seen = ( );
        my @uniq = ( );
        for my $item (@grplst) {
            if ( !$seen{$item} ) {
                # if we get here, we have not seen it before
                $seen{$item} = 1;
                push @uniq, $item;
            }
        }
        @grplst = @uniq;
    }
    undef %memberinf;

    $member_count = @grplst;

    $show_group = q{};
    if ( $member_count == 0 ) {
        $colspan        = 1;
        $show_group_num = $show_group_num_a;
    }
    else {
        $show_group_num = $show_group_num_b;
        $show_group_num =~ s/{yabb colspan}/$colspan/gsm;
        $show_group_num =~ s/{yabb member_count}/$member_count/gsm;
    }
    $bb       = $start;
    $numshown = 0;
    $numgrp   = @grplst;
    while ( $numshown < $TopAmmount && $bb < $numgrp ) {
        $show_group .= showrow( $grplst[$bb] );
        $numshown++;
        $bb++;
    }

    $pageindexlnk = q{};
    $pageindex1 =
qq~<span class="small pgindex"><img src="$index_togl{'index_togl'}" alt="" />$ml_txt{'139'}: 1</span> &nbsp; &nbsp; ~;
    if ( $numgrp > $TopAmmount ) {
        $numpages = int( $numgrp / $TopAmmount ) + 1;
        for my $i ( 1 .. $numpages ) {
            $startpage = ( $i - 1 ) * $TopAmmount;
            if ( $start == $startpage ) {
                $pageindexlnk .= qq~[$i] ~;
            }
            else {
                $pageindexlnk .=
qq~<a href="$scripturl?action=groups;title=$group_title;gid=$no_post_id;start=$startpage;"><span class="small">$i</span></a> ~;
            }
        }
        $pageindex1 =
qq~<span class="small pgindex"><img src="$index_togl{'index_togl'}" alt="$ml_txt{'19'}" title="$ml_txt{'19'}" /> $ml_txt{'139'}: $pageindexlnk</span> &nbsp; &nbsp; ~;
    }

    if ($no_post_id) {
        ( $grptitle, $starnum, $starimg, $groupcol ) =
          split /[|]/xsm, $NoPost{$no_post_id};
    }
    else {
        ( $grptitle, $starnum, $starimg, $groupcol ) = split /[|]/xsm,
          $Group{$group_title};
    }
    my $starnums       = $starnum;
    my $memberstartemp = q{};
    if ( $starimg !~ /\//xsm ) { $starimg = "$imagesdir/$starimg"; }
    while ( $starnums-- > 0 ) {
        $memberstartemp .= qq~<img src="$starimg" alt="" />~;
    }
    $group_stars = $memberstartemp;

    $grptitle .= qq~ <span style="float: right;">$group_stars</span>~;
    $yymain = $show_grp;
    $yymain =~ s/{yabb pageindex1}/$pageindex1/gsm;
    $yymain =~ s/{yabb grptitle}/$grptitle/gsm;
    $yymain =~ s/{yabb show_group_num}/$show_group_num/gsm;
    $yymain =~ s/{yabb show_group}/$show_group/gsm;

    $tabsep = q{};
    $yynavback =
      qq~$tabsep <a href="$scripturl">&#171; $img_txt{'103'}</a> $tabsep~;
    $numbegin = ( $start + 1 );
    $numend   = ( $start + $TopAmmount );
    if ( $numend > $numgrp ) { $numend  = $numgrp; }
    if ( $numgrp == 0 )      { $numshow = q{}; }
    else { $numshow = qq~($numbegin - $numend $ml_txt{'309'} $numgrp)~; }
    $yytitle      = qq~$ml_txt{'view_member_groups'} $numshow~;
    $yynavigation = qq~&rsaquo; $ml_txt{'view_member_groups'} $numshow~;

    template();
    exit;
}

sub showrow {
    my ($membername) = @_;
    LoadUser($membername);
    if ($allowpics) {
        ${ $uid . $membername }{'userpic'} = isempty( ${ $uid . $membername }{'userpic'}, $my_blank_avatar );
        my $mypic =
            ${ $uid . $membername }{'userpic'} =~ m/\A[\s\n]*https?:\/\//ism
          ? ${ $uid . $membername }{'userpic'}
          : ( $default_avatar
              && ${ $uid . $membername }{'userpic'} eq $my_blank_avatar )
          ? "$imagesdir/$default_userpic"
          : "$facesurl/${ $uid.$membername}{'userpic'}";
        if ( $iamguest ) {
            $userpic = $userpic_a;
        }
        else {
            $userpic = $userpic_b;
        }
        $userpic =~ s/{yabb mypic}/$mypic/gsm;
        $userpic =~ s/{yabb user}/$useraccount{$membername}/gsm;
    }
    else {
        $userpic = q{};
        $colspan = 1;
    }
    my $show_add_groups;
    if ( ${ $uid . $membername }{'addgroups'} ) {
        $show_add_group = $addmembergroup{$membername};
        $show_add_group =~ s/<br \/>/\, /gsm;
        $show_add_group =~ s/\A, //sm;
        $show_add_group =~ s/, \Z//sm;
        $show_add_groups = $show_add;
        $show_add_groups =~ s/{yabb show_add_group}/$show_add_group/gsm;
    }
    $member_position = q{};
    $member_title    = $memberinfo{$membername};
    $member_title =~ s/<b>//xsm;
    $member_title =~ s/<\/b>//xsm;
    if ($add_group_title) {
        $member_position = $member_pos;
        $member_position =~ s/{yabb member_title}/$member_title/gsm;
    }
    $show_group = $show_group_a;
    $show_group =~ s/{yabb userpic}/$userpic/gsm;
    $show_group =~ s/{yabb member_position}/$member_position/gsm;
    $show_group =~ s/{yabb show_add_groups}/$show_add_groups/gsm;
    $show_group =~ s/{yabb memlink}/$link{$membername}/gsm;

    return $show_group;
}

1;
