<id>
View Member Groups for YaBB 2.6.11
</id>

<version>
0.6
</version>

<mod info>
Description
-----------
This Mod will allow you to view which members are in which member group by clicking on the group names in the legend on the board index.

Installation
------------
1) Modify YaBB files using BoardMod or manually.
2) Upload modified files to your server in ASCII mode.
3) Upload ViewGroups.pm to Sources/Mods directory in ASCII mode. Upload ViewGroups.template to Templates/default/Mods
4) Go to Admin Center => Forum Settings => Members tab => MemberList to enable the setting.

Files to edit
-------------
Admin/ModList.pm
Admin/NewSettings.pm
Admin/Settings_Main.pm
Languages/English/Admin.lng
Languages/English/Error.lng
Languages/English/MemberList.lng
Sources/BoardIndex.pm
Sources/SubList.pm

Version History
---------------
0.6 - typo 1/21/2015
0.5 - updated for 2.6.11
0.4 - updated for 2.6.1
0.3 - Lists Board Moderators.
0.2 - Updated for 2.6.0 with added memberlist pagination- June 22, 2014
0.1 - First Release - 9th May 2012
</mod info>

<author>
Derek Barnstorm, updated for 2.6.11 by Dandello
</author>

<homepage>
http://boardmod.org
</homepage>

<edit file>
Admin/ModList.pm
</edit file>

<search for>
### END BOARDMOD ANCHOR ###
</search for>

<add before>
    $view_member_groups_mod = q~View Member Groups|Derek Barnstorm|This Mod will allow you to view which members are in which member group by clicking on the group names in the legend on the board index.|0.6|Jan 21, 2015~;
    push @installed_mods, $view_member_groups_mod;
</add before>

<edit file>
Admin/NewSettings.pm
</edit file>

<search for>
1;
EOF
</search for>

<add before>
\$allow_view_groups = $allow_view_groups;    # Select who is allowed to view the member group list
</add before>

<edit file>
Admin/Settings_Main.pm
</edit file>

<search for>
            name => 'barmaxdepend',
            validate => 'boolean',
        },
</search for>

<add after>
        {
            description => qq~<label for="allow_view_groups">$admin_txt{'member_group_view'}</label>~,
            input_html => qq~
<select name="allow_view_groups" id="allow_view_groups">
  <option value="0" ${isselected($allow_view_groups == 0)}>$userlevel_txt{'none'}</option>
  <option value="1" ${isselected($allow_view_groups == 1)}>$userlevel_txt{'all'}</option>
  <option value="2" ${isselected($allow_view_groups == 2)}>$userlevel_txt{'members'}</option>
  <option value="3" ${isselected($allow_view_groups == 3)}>$userlevel_txt{'modgmodadmin'}</option>
  <option value="4" ${isselected($allow_view_groups == 4)}>$userlevel_txt{'gmodadmin'}</option>
  <option value="5" ${isselected($allow_view_groups == 4)}>$userlevel_txt{'admin'}</option>
</select>~,
            name => 'allow_view_groups',
            validate => 'number',
        },
</add after>

<edit file>
Languages/English/Admin.lng
</edit file>

<search for>
1;
</search for>

<add before>
$admin_txt{'member_group_view'} = 'Select who is allowed to view the Member Group list:';

</add before>

<edit file>
Languages/English/Error.lng
</edit file>

<search for>
1;
</search for>

<add before>
## View MemberGroups Mod ##
$error_txt{'no_group_exists'} = 'The Member Group you are trying to view does not exist.';
</add before>

<edit file>
Languages/English/MemberList.lng
</edit file>

<search for>
1;
</search for>

<add before>
## View MemberGroups Mod ##
$ml_txt{'view_member_groups'} = 'View Member Groups';
$ml_txt{'add_groups'} = 'Additional Groups:';
$ml_txt{'total_members'} = 'Total members in this group:';
$ml_txt{'no_members'} = 'There are no members in this group yet.';

</add before>

<edit file>
Sources/BoardIndex.pm
</edit file>

<search for>
        foreach my $stafgrp ( sort keys %Group ) {
            ( $title, undef, undef, $color, $noshow, undef ) =
              split /\|/xsm, $Group{$stafgrp}, 6;
            if ( $color && $noshow != 1 ) {
                $tmpcnt++;
</search for>

<add after>
                $group_title = $stafgrp;
                $group_title =~ s/ /_/gsm;
                if (
                    $group_title ne 'Moderator'
                    && (   $allow_view_groups == 1
                        || ( !$iamguest && $allow_view_groups == 2 )
                        || ( $allow_view_groups == 3 && $staff )
                        || ( $allow_view_groups == 4 && $iamadmin || $iamgmod )
                        || ( $allow_view_groups == 5 && $iamadmin ) )
                  )
                {
                    $title =
qq~<a href="$scripturl?action=groups;title=$group_title">$title</a>~;
                }
</add after>

<search for>
        foreach (@nopostorder) {
            ( $title, undef, undef, $color, $noshow, undef ) =
              split /\|/xsm, $NoPost{$_}, 6;
            if ( $color && $noshow != 1 ) {
                $tmpcnt++;
</search for>

<add after>
                $group_title = $_;
                $group_title =~ s/ /_/gsm;
                if (   $allow_view_groups == 1
                    || ( !$iamguest && $allow_view_groups == 2 )
                    || ( $allow_view_groups == 3 && $staff )
                    || ( $allow_view_groups == 4 && $iamadmin || $iamgmod )
                    || ( $allow_view_groups == 5 && $iamadmin ) )
                {
                    $title =
qq~<a href="$scripturl?action=groups;title=$group_title;gid=$_">$title</a>~;
                }
</add after>

<edit file>
Sources/SubList.pm
</edit file>

<search for>
1;
</search for>

<add after>
$director{'groups'} = 'Mods/ViewGroups.pm&ViewGroups';
</add after>
