###############################################################################
# Security.pl                                                                 #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$securityplver = "1 Gold - SP 1.1";

sub is_admin {
	if($settings[7] ne 'Administrator') { &fatal_error($txt{'1'}); }
}

sub is_admin2 {
	if($settings[7] ne 'Administrator') { &fatal_error($txt{'134'}); }
}
sub is_global {
	if($settings[7] ne 'Global Moderator' || $allow_mod != 1) { &fatal_error($txt{'1'}); }
}

sub mod_check{
	fopen(FILE, "$vardir/cat.txt");
	@categories = <FILE>;
	fclose(FILE);

	foreach $curcat (@categories) 
	{
 		$curcat =~ s/[\n\r]//g;
		fopen(CAT, "$boardsdir/$curcat.cat");
		@catinfo = <CAT>;
		fclose(CAT);
		foreach $curboard (@catinfo) 
		{
			if($curboard ne "$catinfo[0]" && $curboard ne "$catinfo[1]") 
			{
				$curboard =~ s/[\n\r]//g;
				fopen(BOARD, "$boardsdir/$curboard.dat");
				@boardinfo = <BOARD>;
				fclose(BOARD);
				chomp @boardinfo;
		
				foreach(split(/\|/,$boardinfo[2])) 
				{
					fopen(MODERATOR, "$memberdir/$_.dat");
					@modprop = <MODERATOR>;
					fclose(MODERATOR);
					$modprop[1] =~ s/[\n\r]//g;
					$mods{$_} .= $modprop[1];
					}
				}
			}
		}
}

sub banning {
	# IP BANNING
	fopen(BAN, "$vardir/ban.txt" );
	@entries = <BAN>;
	fclose(BAN);
	foreach $ban_ip (@entries) {
   		chomp $ban_ip;
   		$str_len = length($ban_ip);
   		$comp_ip = substr($user_ip,0,$str_len);
   		if ($comp_ip eq $ban_ip) {
      			fopen(LOG, ">>$vardir/ban_log.txt" );
      			print LOG "$user_ip\n";
     			fclose(LOG);
     			$username = "Guest";
     			&fatal_error("$txt{'678'}$txt{'430'}!");
      			exit;
      		}
	}
	# EMAIL BANNING
	if ($username ne 'Guest') {
	fopen(BAN, "$vardir/ban_email.txt" );
	@entries = <BAN>;
	fclose(BAN);
	foreach $ban_email (@entries) {
		chomp $ban_email;
   		if (lc $ban_email eq lc $settings[2]) {
      			fopen(LOG, ">>$vardir/ban_log.txt" );
      			print LOG "$ban_email ($user_ip)\n";
     			fclose(LOG);
     			$username = "Guest";
      			&fatal_error("$txt{'678'}$txt{'430'}!");
      			exit;
      		}
	}
	# USERNAME BANNING
	if ($username ne 'Guest') {
	fopen(BAN, "$vardir/ban_memname.txt" );
	@entries = <BAN>;
	fclose(BAN);
	foreach $ban_memname (@entries) {
		chomp $ban_memname;
   		if (lc $ban_memname eq lc $settings[1]) {
      			fopen(LOG, ">>$vardir/ban_log.txt" );
      			print LOG "$ban_memname ($user_ip)\n";
     			fclose(LOG);
     			$username = "Guest";
      			&fatal_error("$txt{'678'}$txt{'430'}!");
      			exit;
                        }
      		}
	}
	}
}

sub CheckIcon
{
$icon =~ s/[^A-Za-z|\/]//g;
$icon_found=0;
if ($icon eq "xx" || $icon eq "thumbup" || $icon eq "thumbdown" || $icon eq "exclamation" || $icon eq "question" || $icon eq "lamp" || $icon eq "smiley" || $icon eq "angry" || $icon eq "cheesy" || $icon eq "laugh" || $icon eq "sad" || $icon eq "wink")
{
	$icon_found=1;
}
else
{
	$i=0;
	while($MIconURL[$i] && !$icon_found)
  {
		if ($icon eq $MIconURL[$i])
		{
			$icon_found=1;
		}
		$i++;
	}
}
}}
sub AccessCheck{
	my ($curboard, $checktype) = @_;
#	&LoadBoard;
	if ($curboard ne $currentboard && -e "$boardsdir/$curboard.mbo" ) { require "$boardsdir/$curboard.mbo"; }

	fopen(FILE, "$memberdir/$username.dat");
		@memsettings=<FILE>;
	fclose(FILE);

	if(!$MemStatAdmin) {
		fopen(FILE, "$vardir/membergroups.txt");
		@membergroups = <FILE>;
		fclose(FILE);
	}

	# Load Membergroups
	chomp $memsettings[7];
	if ($username eq "Guest"){ $memberinfo = ""; }
	elsif ($memsettings[7] ne "") { $memberinfo = $memsettings[7]; }
	else {
		if ($MemStatAdmin) {
			$msstatcount = "0";
			if( $tmp_posts >= $MemPostNewbie) {$memberinfo = "$MemStatNewbie";}
			while($MemStat[$msstatcount]) {
				if( $tmp_posts >= $MemPostNum[$msstatcount] && $MemPostNum[$msstatcount] ne "x") {$memberinfo = "$MemStat[$msstatcount]";}
				++$msstatcount;
			}
		} else {
			if($memsettings[6] > $GodPostNum) { $memberinfo = $membergroups[6]; }
			elsif($memsettings[6] > $SrPostNum) { $memberinfo = $membergroups[5]; }
			elsif($memsettings[6] > $FullPostNum) { $memberinfo = $membergroups[4]; }
			elsif($memsettings[6] > $JrPostNum) { $memberinfo = $membergroups[3]; }
			else { $memberinfo = $membergroups[2]; }
		}
	}

	my $access = "denied";
	if ($checktype == 1){ # Post access check
		@allowed_users = split(/,/,$start_users{$curboard});
		@allowed_groups = split(/,/,$start_groups{$curboard});
		if ($start_users{$curboard} eq "" && $start_groups{$curboard} eq "") {$access = "granted";}  
	} elsif ($checktype == 2){ # Reply access check
		@allowed_users = split(/,/,$reply_users{$curboard});
		@allowed_groups = split(/,/,$reply_groups{$curboard});
		if ($reply_users{$curboard} eq "" && $reply_groups{$curboard} eq "") {$access = "granted";}  
	} else { # Board access check
		@allowed_users = split(/,/,$view_users{$curboard});
		@allowed_groups = split(/,/,$view_groups{$curboard});
		if ($view_users{$curboard} eq "" && $view_groups{$curboard} eq "") {$access = "granted";}  
	}

	unless ($access eq "granted") {
 		foreach $user (@allowed_users) {
			chomp $user;
  			if ($user eq $username) {$access = "granted"; last;}  
 		} 
	}
	unless ($access eq "granted") {
 		foreach $element (@allowed_groups) {
			chomp $element;
		if ($element eq "all") {$access = "granted"; last;} 
		if ($element eq "members" && $username ne "Guest"){$access = "granted"; last;}
		if ($element eq $memberinfo) {$access = "granted"; last;} 
		if ($element eq "moderator" && ($memsettings[7] eq 'Administrator' || $memsettings[7] eq 'Global Moderator' || exists $moderators{$username})) {$access = "granted"; last;}
	  }
	}

	return ($access);
}
1;