###############################################################################
# Poll.pl                                                                     #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 1 Gold - SP 1.3                                        #
# Released:       December 2001; Updated April 6, 2003                        #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2003 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
# =========================================================================== #
# Mod Name:    Polls for SP1-1.3 - version 3.0                                #
# Written by:  BHRA Webmaster, Omario, based on the mod by Samm (Sam Holman)  #
###############################################################################

$pollmod = "Polls v3.0";

sub DoVote {
	$pollnum = $INFO{'num'};
	$start = $INFO{'start'};
	$scpoll = $INFO{'scp'};
	unless (-e "$datadir/$pollnum.poll") {&fatal_error("$polltxt{'14'}: $pollnum");}
	
	$novote = 0;
	$vote = "";
	fopen (FILE, "$datadir/$pollnum.poll");
	$poll_question = <FILE>;
	@poll_data = <FILE>;
	fclose (FILE);
	chomp $poll_question;
	($dummy, $poll_locked, $dummy, $dummy, $dummy, $dummy, $guest_vote, $dummy, $multi_vote, $dummy, $dummy) = split(/\|/, $poll_question);
	for(my $i = 0; $i < @poll_data; $i++) {
		chomp $poll_data[$i];
		($votes[$i], $options[$i]) = split(/\|/, $poll_data[$i]);
		$tmp_vote = qq~$FORM{"option$i"}~; 
		if ($multi_vote && $tmp_vote ne "") {
			$votes[$i]++;
			$novote = 1;
			if ($vote ne "") {$vote .= ",";}
			$vote .= "$tmp_vote";
		}
	}
	$tmp_vote = "$FORM{'option'}"; 
	if (!$multi_vote && $tmp_vote ne "") { $vote = $tmp_vote; $votes[$tmp_vote]++; $novote = 1; }

	if ($novote == 0 || $vote eq "") { &fatal_error("$polltxt{'12'}"); }
	if ($username eq "Guest" && !$guest_vote) { &fatal_error("$polltxt{'8'}"); }
	if ( $poll_locked ) {&fatal_error("$polltxt{'11'}");}

	fopen(FILE, "$datadir/$pollnum.polled");
	@polled = <FILE>;
	fclose(FILE);

	for(my $i = 0; $i < @polled; $i++) {
		($voters_ip, $voters_name, $voters_vote, $vote_time) = split(/\|/, $polled[$i]);
		chomp $voters_vote;
		   if ($username eq "Guest" && $voters_name eq "Guest" && lc $voters_ip eq lc $user_ip) { &fatal_error("$polltxt{'51'}"); }
		elsif ($username eq "Guest" && $voters_name ne "Guest" && lc $voters_ip eq lc $user_ip) { &fatal_error("$polltxt{'52'}"); }
		elsif ($username ne "Guest" && $voters_name ne "Guest" && lc $username eq lc $voters_name) { &fatal_error("$polltxt{'50'}"); }
		elsif ($username ne "Guest" && $voters_name eq "Guest" && lc $voters_ip eq lc $user_ip) { 
			foreach $oldvote (split(/\,/, $voters_vote)) {
				$votes[$oldvote]--;
			}
			$polled[$i] = "";
			last;
		}
	}
		
	fopen (FILE, ">$datadir/$pollnum.poll");
	print FILE "$poll_question\n";
	for(my $i = 0; $i < @poll_data; $i++) { print FILE "$votes[$i]|$options[$i]\n"; }
	fclose (FILE);
			
	fopen (FILE, ">$datadir/$pollnum.polled");
	print FILE "$user_ip|$username|$vote|$date\n";
	print FILE @polled;
	fclose (FILE);
			
	if ($start) { $start = ";start=$start"; }
	if ($scpoll == 1){
		$yySetLocation = qq~$scripturl~;
	} else {
		$yySetLocation = qq~$cgi;action=display;num=$pollnum$start~;
	}
	&redirectexit;

}

###############################################################################

sub UndoVote {
	$pollnum = $INFO{'num'};
	$scpoll = $INFO{'scp'};
	unless (-e "$datadir/$pollnum.poll") {&fatal_error("$polltxt{'14'}: $pollnum");}
	
	fopen (FILE, "$datadir/$pollnum.poll");
	$poll_question = <FILE>;
	@poll_data = <FILE>;
	fclose (FILE);
	chomp $poll_question;
	($dummy, $poll_locked, $dummy) = split(/\|/, $poll_question);
	my @options;
	my @votes;
	for(my $i = 0; $i < @poll_data; $i++) {
		chomp $poll_data[$i];
		($votes[$i], $options[$i]) = split(/\|/, $poll_data[$i]);
	}

	fopen(FILE, "$datadir/$pollnum.polled");
	@polled = <FILE>;
	fclose(FILE);

	if ($FORM{'multidel'} eq "1") {
		&is_admin;
		for(my $i = 0; $i < @polled; $i++) {
			($voters_ip, $voters_name, $voters_vote, $vote_date) = split(/\|/, $polled[$i]);
			chomp $voters_vote;
			$id = $FORM{"$voters_ip-$voters_name"};
			if ($id eq "1") {
				foreach $oldvote (split(/\,/, $voters_vote)) {
					$votes[$oldvote]--;
				}
				$polled[$i] = "";
			}
		}
	} else {
		if ( $username eq "Guest" ) {&fatal_error("$polltxt{'13'}");}
		if ( $poll_lock ) {&fatal_error("$polltxt{'10'}");}
		$found = 0;
		for(my $i = 0; $i < @polled; $i++) {
			($voters_ip, $voters_name, $voters_vote, $vote_date) = split(/\|/, $polled[$i]);
			chomp $voters_vote;
			if ($voters_name eq $username) {
				$found = 1;
				foreach $oldvote (split(/\,/, $voters_vote)) {
					$votes[$oldvote]--;
				}
				$polled[$i] = "";
				last;
			}
		}
		if (!$found) {&fatal_error("$polltxt{'9'}");}
	}
		
	fopen (FILE, ">$datadir/$pollnum.poll");
	print FILE "$poll_question\n";
	for(my $i = 0; $i < @poll_data; $i++) { print FILE "$votes[$i]|$options[$i]\n"; }
	fclose (FILE);
			
	fopen (FILE, ">$datadir/$pollnum.polled");
	print FILE @polled;
	fclose (FILE);
			
	if ($start) { $start = ";start=$start"; }
	if ($scpoll == 1){
		$yySetLocation = qq~$scripturl~;
	} else {
		$yySetLocation = qq~$cgi;action=display;num=$pollnum$start~;
	}
	&redirectexit;

}

###############################################################################

sub LockPoll {
	$pollnum = $INFO{'num'};
	$scpoll = $INFO{'scp'};
	unless (-e "$datadir/$pollnum.poll") {&fatal_error("$polltxt{'14'}: $pollnum");}

	fopen (FILE, "$datadir/$pollnum.poll");
	$poll_question = <FILE>;
	@poll_data = <FILE>;
	fclose (FILE);
	chomp $poll_question;
	($poll_question, $poll_locked, $poll_uname, $poll_stuff) = split(/\|/, $poll_question, 4);
	unless ($username eq $poll_uname || $settings[7] eq "Administrator" || $settings[7] eq "Global Moderator" || exists $moderators{$username}) {&fatal_error("$polltxt{'13'}");}

	if ($poll_locked) { $poll_locked = 0; } else {$poll_locked = 1;}

	fopen (FILE, ">$datadir/$pollnum.poll");
	print FILE "$poll_question|$poll_locked|$poll_uname|$poll_stuff\n";
	print FILE @poll_data;
	fclose (FILE);

	if ($start) { $start = ";start=$start"; }
	if ($scpoll == 1){
		$yySetLocation = qq~$scripturl~;
	} else {
		$yySetLocation = qq~$cgi;action=display;num=$pollnum$start~;
	}
	&redirectexit;
	
}

###############################################################################

sub votedetails{
	&is_admin;

	$pollnum = $INFO{'num'};
	unless (-e "$datadir/$pollnum.poll") {&fatal_error("$polltxt{'14'}: $pollnum");}
	if ($start) { $start = ";start=$start"; }

	&LoadCensorList;

	# Determine what category we are in.
	fopen(FILE, "$boardsdir/$currentboard.ctb") || &fatal_error("300 $txt{'106'}: $txt{'23'} $currentboard.ctb");
	$cat = <FILE>;
	fclose(FILE);
	fopen(FILE, "$boardsdir/$cat.cat") || &fatal_error("300 $txt{'106'}: $txt{'23'} $cat.cat");
	@curcat = <FILE>;
	fclose(FILE);

	fopen (FILE, "$datadir/$pollnum.poll");
	$poll_question = <FILE>;
	@poll_data = <FILE>;
	fclose (FILE);
	chomp $poll_question;
	($poll_question, $poll_locked, $poll_uname, $poll_name, $poll_email, $poll_date, $guest_vote, $hide_results, $multi_vote, $poll_mod, $poll_modname, $poll_comment) = split(/\|/, $poll_question);

	# Censor the options.
	foreach (@censored) {
		($tmpa,$tmpb) = @{$_};
		$poll_question =~ s~\Q$tmpa\E~$tmpb~gi;
	}
	if($ubbcpolls) { 
		if(!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; }
		$message = $poll_question;
		&DoUBBC;
		$poll_question = $message;
	}

	my @options;
	my @votes;
	my $totalvotes = 0; 
	my $maxvote = 0;
	for(my $i = 0; $i < @poll_data; $i++) {
		chomp $poll_data[$i];
		($votes[$i], $options[$i]) = split(/\|/, $poll_data[$i]);
		$totalvotes += int($votes[$i]); 
		if (int($votes[$i]) >= $maxvote) { $maxvote = int($votes[$i]); }
		foreach (@censored) {
			($tmpa,$tmpb) = @{$_};
			$options[$i] =~ s~\Q$tmpa\E~$tmpb~gi;
		}
	} 

	fopen(FILE, "$datadir/$pollnum.polled");
	@polled = <FILE>;
	fclose(FILE);

	if($poll_modname ne "" && $poll_mod ne "") {
		$poll_mod = &timeformat($poll_mod);
		fopen (FILE, "$memberdir/$poll_modname.dat");
		@info = <FILE>;
		fclose(FILE);
		chomp $info[1];
		$displaydate = qq~<font size="1">&#171; $polltxt{'45a'}: <a href="$cgi;action=viewprofile;username=$poll_modname">$info[1]</a> $polltxt{'46'}: $poll_mod &#187;</font>~;
	}
	if ($poll_uname ne "" && $poll_date ne "") {
		$poll_date = &timeformat($poll_date);
		if($poll_uname ne 'Guest' && -e "$memberdir/$poll_uname.dat") {
			fopen (FILE, "$memberdir/$poll_uname.dat");
			@info = <FILE>;
			fclose(FILE);
			chomp $info[1];
			$displaydate = qq~<font size="1">&#171; $polltxt{'45'}: <a href="$cgi;action=viewprofile;username=$poll_uname">$info[1]</a> $polltxt{'46'}: $poll_date &#187;</font>~;
		} else {
			$displaydate = qq~<font size="1">&#171; $polltxt{'45'}: $poll_name $polltxt{'46'}: $poll_date &#187;</font>~;
		}
	}

	$yytitle = $polltxt{'42'};
	$yymain .= qq~
<table width="90%" align="center" cellpadding=0 cellspacing=0>
  <tr>
    <td valign=bottom colspan="2">
    <font size="2" class="nav"><b><img src="$imagesdir/open.gif" border="0">&nbsp;&nbsp;
    <a href="$scripturl" class="nav">$mbname</a><br>
    <img src="$imagesdir/tline.gif" border="0"><img src="$imagesdir/open.gif"  border="0">&nbsp;&nbsp;
    <a href="$scripturl#$cat" class="nav">$curcat[0]</a><br>
    <img src="$imagesdir/tline2.gif" border="0"><img src="$imagesdir/open.gif" border="0">&nbsp;&nbsp;
    <a href="$cgi" class="nav">$boardname</a><br>
    <img SRC="$imagesdir/tline3.gif" border="0"><img src="$imagesdir/open.gif" border="0">&nbsp;&nbsp;
    $polltxt{'42'}</b></font></td>
  </tr>
</table>
<form action="$cgi;action=undovote;num=$pollnum$start" method="POST" style="display:inline">
<input type="hidden" name="multidel" value="1">
<table cellpadding="0" cellspacing="0" border="0" width="90%" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
  <tr>
    <td>
      <table cellpadding="3" cellspacing="1" border="0" width="100%">
        <tr>
          <td bgcolor="$color{'titlebg'}" class="titlebg" colspan="5">$img{'pollicon'} <font size="2" class="text1" color="$color{'titletext'}"><b>$polltxt{'42'}</b></font></td>
        </tr><tr>
          <td bgcolor="$color{'windowbg2'}" class="windowbg2" colspan="5"><br><font size="2"><b>$polltxt{'16'}:</b> $poll_question</font><br><br></td>
        </tr><tr>
          <td bgcolor="$color{'catbg'}" class="catbg" align="center"><font size="2"><b>&nbsp;</b></font></td>
          <td bgcolor="$color{'catbg'}" class="catbg" align="center"><font size="2"><b>$txt{'35'}</b></font></td>
          <td bgcolor="$color{'catbg'}" class="catbg" align="center"><font size="2"><b>$polltxt{'30'}</b></font></td>
          <td bgcolor="$color{'catbg'}" class="catbg" align="center"><font size="2"><b>$polltxt{'31'}</b></font></td>
          <td bgcolor="$color{'catbg'}" class="catbg" align="center"><font size="2"><b>$polltxt{'24'}</b></font></td>
        </tr><tr>~;

		foreach $entry (@polled) {
			chomp $entry;
			$voted = "";
			($voters_ip, $voters_name, $voters_vote, $vote_date) = split(/\|/, $entry);
			$id = qq~$voters_ip-$voters_name~;
			if ($voters_name ne 'Guest' && -e "$memberdir/$voters_name.dat") {
				fopen (FILE, "$memberdir/$voters_name.dat");
				@info = <FILE>;
				fclose(FILE);
				chomp $info[1];
				$voters_name = qq~<a href="$cgi;action=viewprofile;username=$voters_name">$info[1]</a>~;
			}
			foreach $oldvote (split(/\,/, $voters_vote)) {
				$voted .= qq~$options[$oldvote]<br>~;
			}

			$vote_date = &timeformat($vote_date);
			$yymain .= qq~
          <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center"><input type="checkbox" name="$id" value="1"></td>
          <td bgcolor="$color{'windowbg2'}" class="windowbg2">$voters_name</td>
          <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">$voters_ip</td>
          <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">$vote_date</td>
          <td bgcolor="$color{'windowbg2'}" class="windowbg2">$voted</td>
        </tr><tr>~;
		}

		$yymain .= qq~
          <td bgcolor="$color{'titlebg'}" class="titlebg" align="center" colspan="5"><input type="submit" value="$polltxt{'49'}"></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
</form>~;
	&template;
	exit;
	
}

###############################################################################

sub display_poll{
	$pollnum = @_[0];
########showcase poll
	$brdpoll = @_[1];
	$brdpid = @_[2];
	$scp = '';
	$vthread = '';
	$boardpoll = '';
	if($brdpoll){
		$scp = ";scp=$brdpoll";
		$vthread = qq~<a href="$cgi$scboard;action=display;num=$pollnum" class="altlink">$img{'viewthread'}</a>$menusep~;
	}

# Look for a showcase.poll file.
if (-e "$datadir/showcase.poll") {
	fopen (FILE, "$datadir/showcase.poll");
		@showdata = <FILE>;
	fclose (FILE);
	$showcasepoll = $showdata[0];
	$showcasepoll =~ s~\n~~g;
	($scboard, $scviewnum) = split(/\|/, $showcasepoll);
}
	if ($scviewnum == $pollnum && ( $brdpoll != 1 )){
		$boardpoll = qq~<i>$scpolltxt{'3'}</i>&nbsp;&nbsp;~;
	}
	if ($settings[7] eq "Administrator") {
		if ($scviewnum != $pollnum && ( $brdpoll != 1 )) {
			$boardpoll = qq~<a href="$cgi;action=scpoll;num=$pollnum" class="altlink">$scpolltxt{'4'}</a>&nbsp;&nbsp;~;
		} elsif ($scviewnum == $pollnum && ( $brdpoll == 1 )){
			$boardpoll = qq~<a href="$cgi;action=scpolldel" class="altlink">$scpolltxt{'2'}</a>&nbsp;&nbsp;~;
		}
	}
########showcase poll

	&LoadCensorList;	# Load Censor List

	fopen (FILE, "$datadir/$pollnum.poll");
	$poll_question = <FILE>;
	@poll_data = <FILE>;
	fclose (FILE);
	chomp $poll_question;
	($poll_question, $poll_locked, $poll_uname, $poll_name, $poll_email, $poll_date, $guest_vote, $hide_results, $multi_vote, $poll_mod, $poll_modname, $poll_comment) = split(/\|/, $poll_question);

	$has_voted = 0;
	if (!$guest_vote && $username eq "Guest") { $has_voted = 4; }
	else {
		fopen(FILE, "$datadir/$pollnum.polled");
		@polled = <FILE>;
		fclose(FILE);
		foreach $tmpLine (@polled){
			chomp $tmpline;
			($voters_ip, $voters_name, $voters_vote, $vote_date) = split(/\|/, $tmpLine);
			   if ($username eq "Guest" && $voters_name eq "Guest" && lc $voters_ip eq lc $user_ip) { $has_voted = 1; last; }
			elsif ($username eq "Guest" && $voters_name ne "Guest" && lc $voters_ip eq lc $user_ip) { $has_voted = 2; last; }
			elsif ($username ne "Guest" && lc $username eq lc $voters_name) { $has_voted = 3; last; }
		}
	}

	my @options;
	my @votes;
	my $totalvotes = 0; 
	my $maxvote = 0;
	for(my $i = 0; $i < @poll_data; $i++) {
		chomp $poll_data[$i];
		($votes[$i], $options[$i]) = split(/\|/, $poll_data[$i]);
		$totalvotes += int($votes[$i]); 
		if (int($votes[$i]) >= $maxvote) { $maxvote = int($votes[$i]); }
	} 

	$endedtext = "";
	if ($username ne "Guest" && ($username eq $poll_uname || $settings[7] eq "Administrator" || $settings[7] eq "Global Moderator" || exists $moderators{$username})) {
		if ($poll_locked) {
			$lockpoll = qq~<a href="$cgi;action=lockpoll;num=$pollnum$scp" class="altlink">$img{'openpoll'}</a>~;
		} else {
			$lockpoll = qq~<a href="$cgi;action=lockpoll;num=$pollnum$scp" class="altlink">$img{'closepoll'}</a>~;
		}
		$modifypoll = qq~$menusep<a href="$cgi$brdpid;action=modify;message=$polltxt{'15'};thread=$pollnum" class="altlink">$img{'modifypoll'}</a>~;
		$deletepoll = qq~$menusep<a href="$cgi;action=modify2;thread=$pollnum;id=$polltxt{'15'};d=1" onclick="return confirm('$polltxt{'44'}')" class="altlink">$img{'deletepoll'}</a>~;
		if ($settings[7] eq "Administrator") { $displayvoters = qq~<a href="$cgi$brdpid;action=showvoters;num=$pollnum">$img{'viewvotes'}</a>~;}
		if ($hide_results) {
			$endedtext = qq~<tr>
                  <td colspan="2" align="center"><font size="2"><b>$polltxt{'53'}</b></font><br><br></td>
                </tr>~;
			$hide_results = 0;
		}
	}

	if($poll_modname ne "" && $poll_mod ne "" && $showmodify) {
		$poll_mod = &timeformat($poll_mod);
		fopen (FILE, "$memberdir/$poll_modname.dat");
		@info = <FILE>;
		fclose(FILE);
		chomp $info[1];
		$displaydate = qq~<font size="1">&#171; $polltxt{'45a'}: <a href="$cgi;action=viewprofile;username=$poll_modname">$info[1]</a> $polltxt{'46'}: $poll_mod &#187;</font>~;
	} elsif ($poll_uname ne "" && $poll_date ne "") {
		$poll_date = &timeformat($poll_date);
		if($poll_uname ne 'Guest' && -e "$memberdir/$poll_uname.dat") {
			fopen (FILE, "$memberdir/$poll_uname.dat");
			@info = <FILE>;
			fclose(FILE);
			chomp $info[1];
			$displaydate = qq~<font size="1">&#171; $polltxt{'45'}: <a href="$cgi;action=viewprofile;username=$poll_uname">$info[1]</a> $polltxt{'46'}: $poll_date &#187;</font>~;
		} elsif ($poll_name ne "") {
			$displaydate = qq~<font size="1">&#171; $polltxt{'45'}: $poll_name $polltxt{'46'}: $poll_date &#187;</font>~;
		} else {
			$displaydate = "";
		}
	} else {
		$displaydate = "";
	}

	if ($poll_locked) {
		$endedtext = qq~<tr>
                  <td colspan="2" align="center"><font size="2"><b>$polltxt{'22'}</b></font><br><br></td>
                </tr>~;
		$poll_icon = qq~$img{'polliconclosed'}~;
		$has_voted = 5;
	} else {
		$poll_icon = qq~$img{'pollicon'}~;
	}

	# Censor the question.
	foreach (@censored) {
		($tmpa,$tmpb) = @{$_};
		$poll_question =~ s~\Q$tmpa\E~$tmpb~gi;
		$poll_comment =~ s~\Q$tmpa\E~$tmpb~gi;
	}
	if($ubbcpolls) { 
		if(!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; }
		$message = $poll_question;
		&DoUBBC;
		$poll_question = $message;
	}

	$deletevote = "";
	if ($has_voted) {
		$footer = qq~$polltxt{'17'}: $totalvotes~;
		$width = qq~~;
		$deletevote = qq~<a href="$cgi;action=undovote;num=$pollnum$scp">$img{'deletevote'}</a>~;
		if ($settings[7] eq "Administrator") { $deletevote = $deletevote.$menusep; }
	} else {
		$footer = qq~<input type="submit" value="$polltxt{'18'}">~;
		$width = qq~ width="80%"~;
	}
	if ($username eq "Guest") { $deletevote = ""; }
	if ($poll_locked) { $deletevote = ""; }

	$yymain .= qq~
<table cellpadding="0" cellspacing="0" border="0" width="100%" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
  <tr>
    <td>
      <table cellpadding="3" cellspacing="1" border="0" width="100%">
        <tr>
          <td align="left" class="titlebg" bgcolor="$color{'titlebg'}" width="100%">
            <table cellpadding="0" cellspacing="0" border="0" width="100%">
              <tr>
                <td valign="middle" align="left" width="35%"><font size="2" class="text1" color="$color{'titletext'}">$poll_icon <b>$polltxt{'15'}</b></font></td>
                <td valign="middle" align="center" width="30%">$boardpoll</td>
                <td valign="middle" align="right" width="35%"><font size="1" color="$color{'titletext'}">$lockpoll$modifypoll$deletepoll</font></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td valign="top" align="center" bgcolor="$color{'windowbg2'}" class="windowbg2">
            <form name="poll" method="post" action="$cgi;action=vote;num=$pollnum$scp" style="display:inline">
              <table border="0" width="100%" cellspacing="0" cellpadding="0">
                <tr>
                  <td colspan="2"><font size="2"><b>$polltxt{'16'}:</b> $poll_question</font><br><br></td>
                </tr>$endedtext<tr>
                  <td colspan="2" align="center">~;

	if ($has_voted && $hide_results && !$poll_locked) {

		# Display Poll Hidden Message
		$yymain .= qq~<font size="2">$polltxt{'47'}</font><br><font size="1">($polltxt{'48'})</font><br>~;

	} else {

		$yymain .= qq~
                     <table$width border="0" cellspacing="2" cellpadding="0">~;

		for($i = 0; $i < @options; $i++) {

			unless ($options[$i]) {next;};

			# Censor the options.
			foreach (@censored) {
				($tmpa,$tmpb) = @{$_};
				$options[$i] =~ s~\Q$tmpa\E~$tmpb~gi;
			}
			$options[$i] =~ s~[\n\r]~~g;

			if($ubbcpolls) {
				if(!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; }
				$message = $options[$i];
				&DoUBBC;
				$options[$i] = $message;
			}

			if ($has_voted) {

				# Display Poll Results

				$pollpercent = 0;
				$pollbar = 0;
				if ($totalvotes ne 0 && $maxvote ne 0) {
					$pollpercent = int(1000 * $votes[$i] / $totalvotes);
					$pollpercent = $pollpercent / 10;
					$pollbar = int( 150 * $votes[$i] / $maxvote);
				}

				$yymain .= qq~
                      <tr>
                        <td valign="middle"><font size="2"><b>$options[$i]&nbsp;&nbsp;</b></font></td>
                        <td valign="middle" width="250"><font size="2">&nbsp;<img src="$imagesdir/poll_left.gif" align="absmiddle"><img src="$imagesdir/poll_middle.gif" height="12" width="$pollbar" align="absmiddle"><img src="$imagesdir/poll_right.gif" align="absmiddle"> $votes[$i] ($pollpercent%)</font></td>
                      </tr>~;

			} else {

				# Display Poll Options
				if ($multi_vote) { $input = qq~<input type="checkbox" name="option$i" value="$i">~; } else { $input = qq~<input type="radio" name="option" value="$i">~; }

				$yymain .= qq~
                      <tr>
                        <td valign="middle" width="25">$input</td>
                        <td valign="middle"><font size="2"><b>$options[$i]</b></font></td>
                      </tr>~;

			}
		} 
		$yymain .= qq~
                    </table>~;
	} 

	$yymain .= qq~
                  </td>
                </tr><tr>
                  <td colspan="2" align="center"><br><font size="2"><b>$footer</b></font></td>
                </tr><tr>~;
		if ($poll_comment ne "") {
			$message = $poll_comment;
			if($enable_ubbc) { if(!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; } &DoUBBC; }
			$poll_comment = $message;
			$yymain .= qq~
                  <td colspan="2"><br><font size="2">$poll_comment</font></td>
                </tr><tr>~;}
		$yymain .= qq~
                  <td valign="bottom"><br><font size="1">$displaydate</font></td>
                  <td valign="bottom" align="right"><br><font size="1">$vthread$deletevote$displayvoters</font></td>
                </tr>
              </table>
            </form>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>~;

}

sub showcasepoll{
	if (-e "$datadir/showcase.poll") {
		fopen (FILE, "$datadir/showcase.poll");
		@showdata = <FILE>;
		fclose (FILE);
		$showcasepoll = $showdata[0];
		$showcasepoll =~ s~\n~~g;
		($tmpa, $tmpb) = split(/\|/, $showcasepoll);
	}
	my $brdid = $INFO{'board'};
	my $thrdid = $INFO{'num'};
	fopen (FILE, ">$datadir/showcase.poll");
	print FILE "$brdid|$thrdid";
	fclose (FILE);
	$yySetLocation = qq~$scripturl~;
	&redirectexit;
	exit;
}

sub delshowcasepoll{
	if (-e "$datadir/showcase.poll") { unlink("$datadir/showcase.poll"); }
	$yySetLocation = qq~$scripturl~;
	&redirectexit;
	exit;
}

1;
